/*
 * pattern.c - RasterPattern SUN graphics primitive
 *
 *   Take a region on the frame buffer and update it using the 16x16 mask
 * pattern in memory, under the operation specified by the FUNCTION register
 * in the framebuffer.
 *   This routine simply moves the 16x16 pattern into FB locations, carrying 
 * out the operation pre-specified by the user (which should have already be set)
 *
 */

#include <rasterops.h>
#include <framebuf.h>

RasterPattern(dst, msk)
    struct fb_raster	*dst;
    MASK		msk;
{
    register short	h = dst->height,		/* d7, d6 */
    			w = dst->width;


        if (h==0 || w==0) return;       /* return if raster has zero size */

/*
 * Perform W/16 iterations of a full-width (16 bit) Vertical fill of height h
 */

    {
    register short	*Mask = msk;			/* a5 */

    register short					/* a4, a3 */
    	*Y_Address =
	    (short *)(GXBase|GXmask|GXupdate|GXselectY+((dst->y)<<1)),
	*X_Address =
	    (short *)(GXBase|GXselectX+((dst->x)<<1));

    register short	*reset = Mask;			/* a2 */

    register		i,j;				/* d5, d4 */
    register		offset;				/* d3 */
    register		firstpart;			/* d2 */

       GXwidth = 16;

   /**********************************************************************
    * The outer loop fills width/16 word-wide columns.  Then if w mod 16 *
    * is non-zero, one iteration of a special narrow-width fill is done  *
    *
    * The inner loop consists of three parts.  The first is done to align
    * the mask on a 16-bit vertical boundary.  The second part is
    * completely unwound and should therefore go really fast.
    * the third part is for the last mod 16 words in the column.
    */
    
    offset = dst->y & 15;
    firstpart = 16 - offset;
    firstpart &= 15;
    if (firstpart>h) firstpart = h;
    h -= firstpart;

Outer:	for (i=w>>4 ; i>0; i--)
	{
            *X_Address = j;	/* establish the X coordinate in Framebuf */
                                /* by accessing the appropriate address   */

   /************************************************************************
    * The following code linearizes the inner loop of the Fill routine     *
    * in order to optimize the speed with which the operation is performed *
    ************************************************************************/

    /* First perform h/16 iterations of fill16 */
    /* if h/16 == 0 then skip the div16 loop */

#ifdef debug
	puts("about to do Inner");
	getchar();
#endif

Inner:      
	    Mask = reset+offset;
            switch (firstpart)
	      {
                case 15:	asm("	movw a5@+, a4@+");
                case 14:	asm("	movw a5@+, a4@+");
                case 13:	asm("	movw a5@+, a4@+");
                case 12:	asm("	movw a5@+, a4@+");
                case 11:	asm("	movw a5@+, a4@+");
                case 10:	asm("	movw a5@+, a4@+");
                case 9:		asm("	movw a5@+, a4@+");
                case 8:		asm("	movw a5@+, a4@+");
                case 7:		asm("	movw a5@+, a4@+");
                case 6:		asm("	movw a5@+, a4@+");
                case 5:		asm("	movw a5@+, a4@+");
                case 4:		asm("	movw a5@+, a4@+");
                case 3:		asm("	movw a5@+, a4@+");
                case 2:		asm("	movw a5@+, a4@+");
                case 1:		asm("	movw a5@+, a4@+");
            }

	    Mask = reset;
	    j = h>>4;			/* remember j is d4 */
            asm("	andw d4,d4");   /* if it's zero, do no loops of 16 */
            asm("	beq mod16");
	    j--;

            asm("fill16: movl a5@+,a4@+");
            asm("	movl a5@+, a4@+");
            asm("	movl a5@+, a4@+");
            asm("	movl a5@+, a4@+");
            asm("	movl a5@+, a4@+");
            asm("	movl a5@+, a4@+");
            asm("	movl a5@+, a4@+");
            asm("	movl a5@+, a4@+");
/*            asm("djb:");	/*	*/
            Mask = reset;
/*            asm("	movea a2, a5");	/* point to beginning of mask again */
            asm("	dbf d4,fill16");

            /* now case on h%16 (low order 4 bits of h) */
            /* and fill the appropriate number of words */

            asm("mod16:");
            switch(h & 0xf){
                case 15:	asm("	movw a5@+, a4@+");
                case 14:	asm("	movw a5@+, a4@+");
                case 13:	asm("	movw a5@+, a4@+");
                case 12:	asm("	movw a5@+, a4@+");
                case 11:	asm("	movw a5@+, a4@+");
                case 10:	asm("	movw a5@+, a4@+");
                case 9:		asm("	movw a5@+, a4@+");
                case 8:		asm("	movw a5@+, a4@+");
                case 7:		asm("	movw a5@+, a4@+");
                case 6:		asm("	movw a5@+, a4@+");
                case 5:		asm("	movw a5@+, a4@+");
                case 4:		asm("	movw a5@+, a4@+");
                case 3:		asm("	movw a5@+, a4@+");
                case 2:		asm("	movw a5@+, a4@+");
                case 1:		asm("	movw a5@+, a4@+");
            }

            Y_Address -= h;	/* reset to Y pointer to proper column	*/
            Y_Address -= firstpart;
	    X_Address += 16;    /* update the Framebuffer X address */
	}

   /***********************************************************************
    *   Now, if there's any leftover width, perform one special iteration
    * with a narrow width setting.
    *
    *   The following bit of code is a real hack to save space (note the use
    * of the dreaded GOTO).  
    *
    *   It sets things up so that when we get back to this point again, 
    *  1) the condition will be false (i.e. low order 4 bits are zero)
    *  2) the value of w is modified such that exactly one iteration of
    *	Outer (above) is performed.
    *
    ***********************************************************************/

	if (w &= 0xf){		/* is there any leftover width ?? */
	    GXwidth = w;	/* if so this is the width to fill */
            /*
             * set up w for exactly one iteration when we get back to  Outer
             * (above).  Also clear the low order bits so that next time
             * we get here, the condition above will be false (hack, hack...)
             */
            w = 16;
            goto Outer;
        }

	}
}
