/*
 * decode.c - decode the frame buffer addressing scheme
 *
 * Copyright (c) William I. Nowicki 1982
 */
# include <framebuf.h>

char *GXdecode(n)
  {
     static char buf[128];
     
     strcpy( buf, "");
     
     if ( (n&GXupdate) )       strcat( buf, "GXupdate ");
     if ( (n&GXpat)==GXothers) strcat( buf, "GXothers ");
     if ( (n&GXpat)==GXsource) strcat( buf, "GXsource ");
     if ( (n&GXpat)==GXpat)    strcat( buf, "GXpat ");
     if ( (n&GXset3)==GXset1 ) strcat( buf, "GXset1 ");
     if ( (n&GXset3)==GXset2 ) strcat( buf, "GXset2 ");
     if ( (n&GXset3)==GXset3 ) strcat( buf, "GXset3 ");
     if (n&GXselectY) strcat( buf, "GXselectY ");
                 else strcat( buf, "GXselectX ");
     sprintf( buf, "%s%d", buf, (n>>1)&1023 );
     return(buf);
  }
