/*
 * clearscreen.c
 *
 * Clears Sun Frame Buffer screen
 *
 * Jeffrey Mogul @ Stanford	30 June 1981
 *	after code by Bill Nowicki
 *
 * Bill Nowicki		April 11, 1982
 *	- Added GXvideo enable
 *
 */

#include "framebuf.h"

extern int GXBase;

/* erase display */
clearscreen()
{
	register int x;

	GXfunction = GXclear;
	GXwidth = 16;

	for (x = 0; x < 1024; x += 16) {
	    register short *p = (short *)(GXBase|GXupdate|GXselectY);
	    register short *q = &(p[1024]);
	    
	    GXsetX(x);		/* set current x address */
	    
	    while (p <= q)
	    	*p++ = 1;
	}

	GXfunction = GXset;	/* reset things to "normal" */
	GXwidth = 1;
        GXcontrol = GXvideoEnable;
}
