/*
 * Distributed V Kernel - Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 *
 *  Manifests and constants relating to distributed ipc.
 */

#ifndef IKCDEF
#define IKCDEF

#include "Vethernet.h"

/* Random constants */

#define RETRANSMISSION_PERIOD	8
#define	MAXTRANS		3*RETRANSMISSION_PERIOD
#define KERNEL_PACKET		0320  	/* Ethernet kernel packet type */
#define NEW_KERNEL_PACKET	0323  	/* x Ethernet kernel packet type */
#define MAX_DATA_PACKET		1024	/* maximum data words in a kernel packet */

/* Packet types */

#define remoteSend		1
#define remoteReply		2
#define remoteForward		3
#define remoteReceiveSpecific	4
#define breathOfLife		5
#define remoteGetPid		6
#define remoteGetPidReply	7
#define remoteMoveFromReq	8
#define remoteMoveFromReply	9
#define remoteMoveToReq		10
#define remoteMoveToReply	11
#define nAck			12
#define remoteQueryProcessStateReq 13
#define remoteQueryProcessStateRep 14
#define remoteWriteProcessStateReq 15
#define remoteWriteProcessStateRep 16
#define remoteWakeupReq		17
#define remoteWakeupRep		18
#define remoteDestroyProcessReq 19
#define remoteDestroyProcessRep	20
#define remoteSetTeamPriorityReq 21
#define remoteSetTeamPriorityRep 22
#define remoteSetTeamSizeReq	23
#define remoteSetTeamSizeRep	24

/* Indexes in messages and masks used for segment definitions */

#define OPCODE_INDEX		0
#define SEGMENTPTR_INDEX	6
#define SEGMENTSIZE_INDEX	7

#define IDEMPOTENT_MASK		0x20000000
#define SEGMENT_MASK		0x10000000
#define READ_MASK		0x08000000
#define WRITE_MASK		0x04000000

#define READ_ACCESS		0x08
#define WRITE_ACCESS		0x04

/* Packet definition */

typedef struct

  {
    NetAddress	dstHost;
    NetAddress	srcHost;
    short	ethertype;
    short	packetType;
    Process_id	srcPid;
    Process_id	dstPid;
    Process_id  forwarder;
    unsigned	length;
    Unspec	*localaddress;	/* local always refers to the sender */
    Unspec	*remoteaddress;
    unsigned short sequenceNo;
    long	data[8];
  }
     kPacket;

#define WORDS_PER_PACKET	(sizeof(kPacket)/2)/* control words in a kernel packet */
#endif
