/*
 * error.c - A table of error message strings
 *
 * Bill Nowicki January 1983
 */

# include <Venviron.h>

# define ReplyBit 	0x8000
# define SystemBit	0x4000
# define SegmentBit	0x2000
# define ReadBit	0x1000
# define WriteBit	0x0800
# define CodeMask	0x07FF

struct codeEntry
  {
    SystemCode code;
    char *string;
  }
    CodeTable[] =
  {
	0xC001,	"Illegal request",
	0xC002,	"No reply",
	0xC003, "Retry",
	0xC004, "Bad args",
	0xC005, "Bad address",
	0xC006, "Bad buffer",
	0xC007, "No server resources",
	0xC008, "No memory",
	0xC009, "No permission",
	0xC00A, "Power failure",
	0xC00B, "Not found",
	0xC00C, "Busy",
	0xC00D, "Timeout",
	0xC00E, "Bad state",
	0xC00F, "Aborted",
	0xC010, "Nonexistent process",
	0xC011, "Not awaitingreply",
	0xC012, "Bad process priority",
	0xC013, "No pds",
	0xC014, "Invalid file id",
	0xC015, "Not readable",
	0xC016, "Not writeable",
	0xC017, "End of file",
	0xC018, "Invalid mode",
	0xC019, "Mode not supported",
	0xC01A, "Bad byte count",
	0xC01B, "Bad block no",
	0xC01C, "Io break",
	0xC01D, "Internal error",
	0xC01E, "Device error",
	0xC01F, "Request not supported",
	0xC020, "Nonexistent session",
	0xC021, "Duplicate session name",
	0xC022, "Server not responding",

/* System Standard Request Codes: to be used requesting all standard
 * system services.
 *
 */
	0x5801, "Create instance",
	0x6002, "Query instance",
	0x6003, "Release instance",
	0x7404, "Read instance",
	0x7805, "Write instance",
	0x6005, "Write short instance",
	0x6006, "Set break process",
	0x6007, "Set instance owner",
	0x6008, "Query file",
	0x6009, "Modify file",
	0x600A, "Set prompt",
	0x5C0B, "Exception request",
	0x600C, "Register handler",
	0x580D, "Get user number",
	0x580E, "Create session",
	0x780F, "Terminate session",
	0x6010, "Get time",
	0x5811, "Change directory",
	0x6012, "Terminate team",
	0x7813, "Lookup server",
	0x7414, "Read and forward",
	0x5815, "Remove File",
	0x5816, "Add Name",
	0x7817, "Delete Name",
	0x7818, "Change Name",
	0x5819, "Create Context",
	0x401A, "Remove Context",
	0x781B, "Lookup Name",

/* Kernel opcodes */
	0x4020, "Create Process",
	0x6021, "Destroy Process",
	0x7422, "Query Process",
	0x7823, "Modify Process",
	0x4024, "Create Team",
	0x6025, "Set Team Priority",
	0x6026, "Set Team Size",
	0x4027, "Delay",
	0x6028, "Wakeup",
	0x6029, "Gettime",
	0x602a, "Settime",
	0x602b, "Setpid",

	0, "OK",
	0, 0
 };

char *ErrorString(err)
  SystemCode err;
  {
    static char buf[256];
    register struct codeEntry *p = CodeTable;
    for (;p->string;p++)
      if (p->code==err)
	return(p->string);
	
    sprintf(buf,"Strange code(0x%x)=",err&0xFFFF);
    if (err&ReplyBit)
      strcat(buf,"Reply+");
    else 
      strcat(buf,"Request+");
    if (err&SystemBit)
      strcat(buf,"System+");
    else 
      strcat(buf,"User+");
    if (err&SegmentBit)
      {
        strcat(buf,"Segment+");
        if (err&ReadBit)
          strcat(buf,"Read+");
        if (err&WriteBit)
          strcat(buf,"Write+");
      }
     sprintf(buf,"%s0x%x",buf,err&CodeMask);
     return(buf);
  }


PrintError(err, msg)
  SystemCode err;
  char *msg;
  {
    /*
     * print the message corresponding to the indicated code
     */
    printf("%s: %s\n", msg, ErrorString(err) );
  }
