/*
 * enwatch.c - record data on Internet Datagrams
 *
 * Bill Nowicki September 1982
 *
 * Copyright (c) 1983 Stanford University
 *
 * This source code can be copied ONLY if all changes and improvements
 * are promptly sent back to the Author.
 *
 * Updated October 1982
 *	- Mask keyboard with 0177
 *	- Add time to packets
 *	- improved command prompt
 *
 * February 1983 (WIN)
 *	- Print first 16 data words, or all of them on "other" packets
 *	- Added "OR" mode
 *
 * October 1983
 *	- Split out device-dependent parts
 *	- Added XNS protocol
 *
 */

# define fopen foo
# define freopen bar
# define ENET3MEG

/*
 * Luckily, the PUP and XNS packet types are the same on both 10 and 3Mbit 
 * Ethernet.  Some of the others are different, so watch out!
 */

# include <Venviron.h>
# include "ip.h"
# include "ikc.h"
# include "xns.h"

# undef getc
# undef putc
# undef getchar
# undef putchar
# undef FILE
# undef ETHERNET
# undef EOF
# undef fopen
# undef freopen
# undef stdin
# undef stdout
# undef stderr

# include <m68enet.h>
# include <stdio.h>
# include <puplib.h>
# include <pupconstants.h>

# define MaxBuffers 128		/* number of Network buffers */
# define BufferSize 1024	/* size in bytes of each buffer */

char FileName[256];		/* name of file to write */

char Buffers[MaxBuffers] [BufferSize];


int FirstBuffer = 0;		/* index of firrst buffer */
int LastBuffer = 0;		/* index of next usable buffer */

int TickFlag = 1;		/* print exclamation on each packet */
int PupFlag = 1;		/* listen to PUPs */
int IPFlag = 1;			/* listen to IPs */
int VFlag = 1;			/* listen to V kernel packets */
int XNSFlag = 1;		/* listen to XNS packets */
int OtherFlag = 0;		/* listen to other random types */
int OrFlag = 0;			/* OR source and dest filters instead of AND */
int PrintData = 0;		/* do not print data in packets */
int StartTime = 0;		/* emt_ticks when we started */
int HitFlag;			/* a key was hit */

unsigned char SourceFilter[256];/* software source filter */
unsigned char DestFilter[256];	/* hardware destination filter */

# undef getchar


EnetSetFilter()
  {
  	/*
	 * Set the Ethernet hardware receive filter
	 * to be desired watch settings.
	 * First turn them all off, then turn requested ones on.
	 */
    register short address;
    
    EIStatus = Init1+FilterData0+Loopback0;
    for (address=0; address<256; address++)
      EIAddress = address;
    EIStatus = Init1+FilterData1+Loopback0;
    for (address=0; address<256; address++)
      if (DestFilter[address] || OrFlag) EIAddress = address;
    EIStatus = Init0+Loopback0;
  }


EnetNormalFilter()
  {
  	/*
	 * reset the Ethernet hardware receive filter
	 * to be normal (broadcasts plus my host)
	 */
    register short address;
    
    EIStatus = Init1+FilterData0+Loopback0;
    for (address=0; address<256; address++)
      EIAddress = address;
    address = EIAddress;
    EIStatus = Init1+FilterData1+Loopback0;
    EIAddress = address;
    EIAddress = 0;
    EIStatus = Init0+Loopback0;
  }
  


ReadPacket()
  {
    /*
     * Read a packet into the next buffer.
     * returns true if we one matched the filter.
     */
     
    register short *buf = (short *)Buffers[LastBuffer];
    register short count;
    short *end = (short *)(Buffers[LastBuffer+1]);
    short blackHole;

    *(int *)buf = emt_ticks() - StartTime;
    buf += 2;
    while ( (count=EIData0) & QueueEmptyBit)
      if (KeyHit()) return(0);
    *buf++ = count;
    count &= CountMask;
    if (count==0) return(0);

    while (count-->0 && buf<end)
      *buf++ = EIData0;
    while (count-->0)
      blackHole = EIData0;
    buf = (short *)Buffers[LastBuffer];
    buf += 4;
      /*
       * now we have read the packet, throw away Ethernet types
       * that we do not want.
       */
    switch (*buf)
      {
        case PUP:	if (!PupFlag)	return(0);	break;
        case IP:	if (!IPFlag)	return(0);	break;
        case XNS:	if (!XNSFlag)	return(0);	break;
        case NSToPup:	if (!XNSFlag)	return(0);	break;
	case KERNEL_PACKET:
	case NEW_KERNEL_PACKET:
			if (!VFlag)	return(0);	break;
	default:	if (!OtherFlag)	return(0);
      }
      	/*
	 * check that the sending host is in our software filter 
	 */
    buf--;
    if (SourceFilter[ (*buf & 0377) ]==0 && 
         ( !OrFlag || DestFilter[ (*buf >> 8) & 0377 ]==0) ) return(0);
    LastBuffer++;
    if (LastBuffer>=MaxBuffers) LastBuffer %= MaxBuffers;
    if (LastBuffer==FirstBuffer) 
      {
        FirstBuffer++;
	FirstBuffer %= MaxBuffers;
      }
    if (TickFlag) printf("!");
    return(1);
  }


WriteToFile(name)
 char *name;
  {
    /*
     * write the accumulated buffers to the indicated file name
     */
    FILE *out;
    out = fopen( name, "w" );
    if (out==NULL)
      {
        printf( "Unable to open %s for output\n", name );
        return;
      }
    while (FirstBuffer!=LastBuffer)
      {
        PrintBuffer( Buffers[FirstBuffer], out );
	printf(".");
        FirstBuffer++;
	FirstBuffer %= MaxBuffers;
      }
    fclose(out);
  }


PrintBuffer( buf, out )
 register short *buf;
  {
    /*
     * Decode and print the buffer indicated on the
     * given file.
     */
    short rxStatus;
    unsigned char source, dest;
    int count = rxStatus & CountMask;    
    
    fprintf( out, "\n%d.%02d ",
    	(*(int *)buf)/1000, ( (*(int *)buf)/10)%100 );
    buf += 2;
    rxStatus = *buf++;
    source = *buf & 0377;
    dest = *buf >>8;
    fprintf( out, "[0%o --> 0%o] ", source, dest );
    buf++;

    if ( (rxStatus & CRCerrorBit) || (rxStatus & OverflowBit) ||
         (*buf != PUP && *buf != IP && *buf != XNS && *buf != PupToNS &&
	  *buf != KERNEL_PACKET && *buf != NEW_KERNEL_PACKET ) )
      {
	int i = 0;

    	fprintf( out, "Ethernet Status: ");
    	if (rxStatus & CRCerrorBit) fprintf( out, "CRC Error, ");
    	if (rxStatus & OverflowBit) fprintf( out, "Overflow, ");
    	fprintf( out, "%d words, ", rxStatus & CountMask );
	if (!PrintData && count > 16) count = 16;
	fprintf( out, " %04x", buf[-1] & 0xFFFF );
	while (++i < count)
	    {
	      if (i % 16 == 0) fprintf( out, "\n");
	      fprintf( out, " %04x", *buf++ & 0xFFFF );
	    }
	fprintf( out, "\n");
	return;
      }

      	/*
	 * Subtract off the Ethernet encapsulation overhead.
	 * One word for source and Destination.
	 * One word for Ethernet packet type.
	 * One word for Ethernet CRC
	 */
    count = (rxStatus & CountMask) - 3;
    if (*buf == PUP) 			PupPrint( ++buf, out, count);
    if (*buf == XNS) 			XNSPrint( ++buf, out, count);
    if (*buf == NSToPup) 		NSToPupPrint( ++buf, out, count);
    if (*buf == IP)  			IPPrint(  ++buf, out, count);
    if (*buf == KERNEL_PACKET)  	VPrint(  ++buf, out, count);
    if (*buf == NEW_KERNEL_PACKET)  	xVPrint(  ++buf, out, count);
   }



HostSpecify()
  {
	/*
	 * specify hosts to watch
	 */
    register short host;
    int inputHost;

    while (1)
      {
        printf("\n Host specification\n");
	if (OrFlag)
	      printf("c - Conjuctive mode - Currently OR (Disjuctive mode)\n");
	 else
	      printf("o - OR (Disjuctive) mode - Currently AND (Conjuctive mode)\n");
	printf("e - Look at Everybody\n");
	printf("2 - Look at two hosts\n");
	printf("n - Look at nobody\n");
	printf("a - Add host to filter\n");
	printf("d - Delete host from filter\n");
	printf("p - Print out filters\n");
	printf("Return or space goes back to main menu\n");
	
	printf("Enter suboption: ");
	switch(getchar())
	  {
	    case 'e':
	        printf("\nSelecting EVERYbody\n");
    		for (host=0; host<256; host++)
		  {
        	    SourceFilter[host] = 1;
		    DestFilter[host] = 1;
		  }
		break;
		
	    case 'n':
	        printf("\nSelecting Nobody\n");
    		for (host=0; host<256; host++)
		  {
        	    SourceFilter[host] = 0;
		    DestFilter[host] = 0;
		  }
		break;
		
		
	    case 'a':
	        printf("\nAdd host (octal):");
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 1;
		DestFilter[inputHost] = 1;
		break;		
		

	    case 'o':
	        printf("\nOR mode, or disjuctive,  source OR dest\n");
		OrFlag = 1;
		break;
		

	    case 'c':
	        printf("\nAND mode, or conjuctive, source AND dest\n");
		OrFlag = 0;
		break;

	    case 'd':
	        printf("\nDelete host (octal):");
	        fflush(stdin);
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 0;
		DestFilter[inputHost] = 0;
		break;		
		
	    case '2':
	        printf("\nSelecting Two hosts (and nobody else!)\n");
    		for (host=0; host<256; host++)
		  {
        	    SourceFilter[host] = 0;
		    DestFilter[host] = 0;
		  }
	        printf("First host (octal):");
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 1;
		DestFilter[inputHost] = 1;
	        printf("Second host (octal):");
		scanf( "%o", &inputHost );
        	SourceFilter[inputHost] = 1;
		DestFilter[inputHost] = 1;
		break;		
		
	    case 'p':
	        printf("\nReceiving packets from: ");
    		for (host=0; host<256; host++)
        	    if (SourceFilter[host]) printf("0%o ", host);
		printf("\n %s to: ", OrFlag ? "OR" : "AND");
    		for (host=0; host<256; host++)
        	    if (DestFilter[host]) printf("0%o ", host);
		printf("\n");
		break;
	    
	    case ' ':
	    case '\n':
	    case '\r':
	        printf( "\nBack to main menu\n");
	    	return;

    
	    default:
	        printf("\nUnknown option!\n");
		break;
	  }
      }
    
  }

main()
  {
    register short host;
    extern int sp;		/* stack pointer */

    sp = emt_getmemsize()-4;
    for (host=0; host<256; host++)
      {
        SourceFilter[host] = 1;
	DestFilter[host] = 1;
      }
    putchar('\f');
    while (1)
      {
        short address = EIAddress;
 printf("\nEthernet Watch Version 2.0 (local Ethernet address is 0%o, %d.)\n",
		address, address);
	
if (PupFlag)	printf("p - Ignore PUP packets (currently printing)\n");
else		printf("p - Print PUP packets (currently ignoring)\n");
if (IPFlag)	printf("i - Ignore IP packets (currently printing)\n");
else		printf("i - Print IP packets (currently ignoring)\n");
if (VFlag)	printf("v - Ignore Vkernel packets (currently printing)\n");
else		printf("v - Print Vkernel packets (currently ignoring)\n");
if (XNSFlag)	printf("x - Ignore XNS packets (currently printing)\n");
else		printf("x - Print XNS packets (currently ignoring)\n");
if (OtherFlag)	printf("o - Ignore other packets (currently printing)\n");
else		printf("o - Print other packets (currently ignoring)\n");
if (PrintData)  printf("d - Do not print packet data (currently printing)\n");
else		printf("d - Print packet all data (curently sumarizing)\n");
if (TickFlag) 	printf("r - No report on packet received (currently on)\n");
else		printf("r - Report ! on packet received (currently silent)\n");

	printf("t - Type out packets on terminal\n");
	printf("h - host specification\n");
	printf("w - write a file\n");
	printf("q - quit the program\n");
        printf("return or space starts reading\n");
	printf("Enter option: ");
	switch (getchar() )
	 {
	  case 'p':
	    if (PupFlag)	printf("\nIgnore PUP packets\n");
	    else		printf("\nPrint PUP packets\n");
	    PupFlag = !PupFlag;
	    break;

	  case 'i':
	    if (IPFlag) 	printf("\nIgnore IP packets\n");
	    else		printf("\nPrint IP packets\n");
	    IPFlag = !IPFlag;
	    break;

	  case 'v':
	    if (VFlag) 	printf("\nIgnore Vkernel packets\n");
	    else		printf("\nPrint Vkernel packets\n");
	    VFlag = !VFlag;
	    break;

	  case 'x':
	    if (XNSFlag) 	printf("\nIgnore XNS packets\n");
	    else		printf("\nPrint XNS packets\n");
	    XNSFlag = !XNSFlag;
	    break;

	  case 'd':
	    PrintData = !PrintData;
	    break;

	  case 'r':
	    TickFlag = !TickFlag;
	    break;

	  case 'o':
	    if (OtherFlag)	printf("\nIgnore other packets\n");
	    else		printf("\nPrint other packets\n");
	    OtherFlag = !OtherFlag;
	    break;
	    
	  case 'h':
	    HostSpecify();
	    break;

	  case 'q':
	    printf("\nQuit the program\n");
	    exit();

	  case 'w':
	    fflush(stdin);
	    strcpy( FileName, "");
	    if (FirstBuffer==LastBuffer)
	      {
	        printf("\nBuffer is empty -- you must read something first\n");
		continue;
	      }
	    for (; strlen(FileName)==0;)
	      {
	        printf("\nWrite to file:");
	        if (gets(FileName)==NULL) continue;
	      }
	    WriteToFile(FileName);
	    break;

	  case ' ':
	  case '\n':
	  case '\r':
	    EnetSetFilter();
	    printf("\nStarting to read...\n");
	    StartTime = emt_ticks();
	    HitFlag = 0;
            while (!KeyHit()) ReadPacket();
	    EnetNormalFilter();
	    HitFlag = 0;
	    printf("\n");
	    break;

	  case 't':
	    EnetSetFilter();
	    printf("\nStarting to read in immediate mode...\n");
	    StartTime = emt_ticks();
	    HitFlag = 0;
            while (!KeyHit()) 
	      if (ReadPacket() )
		{
	          PrintBuffer( Buffers[FirstBuffer], stdout );
	          FirstBuffer++;
		  FirstBuffer %= MaxBuffers;
		}  
	    EnetNormalFilter();
	    HitFlag=0;
	    printf("\n");
	    break;

	  default:
	    printf( "\nIllegal option!\n");
	    continue;
	 }
      }
    
  }
