/*
 * ecdriver.c - 3com Multibus Ethernet driver
 */

# include "m68000.h"
# include "3com.h"

char *EtherKind()
	/*
	 * return a string identifying what kind of interface we are
	 */
  { return("3Com"); }


char *PrintEtherStatus(status)
    short status;
  {
  	/*
	 * Return a Human-readable string for the Ethernet status
	 */
    char buf[80];
    
    if (status==0)
      return("OK");

    strcpy(buf,"");
    if (status & FrameError)
        strcat(buf, "Frame Error ");
    if (status & OurAddress)
        strcat(buf, "Our Address ");
    if (status & RangeError)
        strcat(buf, "Range Error ");
    if (status & BroadPacket)
        strcat(buf, "Broadcast ");
    if (status & FcsError)
        strcat(buf, "Fcs Error ");
    sprintf(buf,"%s Count=%d.", status & RVMSK);
    return(buf);
  }


EtherBadStatus(status)
    short status;
  {
  	/*
	 * returns TRUE if the status indicates any kind of errors
	 */
    return( status & (FrameError+RangeError+FcsError) );
  }

EtherReady()
  {
  	/*
	 * returns True if there is a packet waiting in either  hardware buffer
	 */
    register short *csr= MECSR;			/* control status pointer */
    short status;
    
    status = *csr;		
    return( (status & (csABSW1+csBBSW1)) != BothActive); 
  }



EtherRead(buf)
      register short *buf;
  {
  	/*
	 * reads the frame into the buffer, starting with status,
	 * then byte count, then source & dest and rest of frame
	 */
    short status, count;
    short which;				/* 0=A, 1=B */
    register short *from;
    register short *csr= MECSR;			/* control status pointer */
    
    status = *csr;				/* get status */
    if ( (status &(csABSW1+csBBSW1)) == 0)
      {
      	/*
	 * Both buffers have data; determine which is older.
	 */
	which = (status & csRBBA);
      }
    else which = (status & csBBSW1) == 0;
    from = which ? MERCVB : MERCVA;
    
    status = *from++;
    *buf++ = status;
    count = status & RVMSK;
    *buf++ = count;
    count = (count/2);
    while (count-- > 0) *buf++ = *from++;	/* read packet buffer */

    if (which)
          setCSR(csr,(csBBSW1));		/* give B back to Ether */
    else
          setCSR(csr,(csABSW1));		/* give A back to Ether */
  }


/*
 *
 *	Initialize the 3com board
 * Return the local Ethernet address
 */
EtherInit(stationAdd) 
    short *stationAdd;
  {
    register short *csr = MECSR;
    register short *rom, *ram;

    /* first reset the board */

    *csr = csRESET;
    /* set up address ram */
    rom = MEROM;		/* burned address */
    ram = MERAM;
    *ram++ = *rom;				/* 16 bits */
    *stationAdd++ = *rom++;			/* for encapsulation */
    *ram++ = *rom;				/* 16 bits */
    *stationAdd++ = *rom++;			/* for encapsulation */
    *ram = *rom;				/* 16 bits */
    *stationAdd = *rom;				/* for encapsulation *
    *csr |= csAMSW1;				/* Give to controller */
    *csr |= paALL;				/* receive ALL for this test*/
    setCSR(csr,(csABSW1+csBBSW1));  		/* (both free) */
    return;
  }


EnetSetFilter()
  {
  	/*
	 * set our temporary filter, so we can watch.
	 */
  }


EnetNormalFilter()
  {
  	/*
	 * restore the "normal" filter, so we can write to a file.
	 */
  }
