/*
 * common.c - utility routines for all ipwatch versions
 *
 * Bill Nowicki September 1983
 *
 * Copyright (c) 1983 Stanford University
 *
 * This source code can be copied ONLY if all changes and improvements
 * are promptly sent back to the Author.
 *
 */

# include "stdio.h"

# undef getchar
	/*
	 * The normal getchar buffers input lines
	 */
getchar() {return emt_getchar()&0177; }

int HitFlag = 0;		/* true if a key was ever hit */

KeyHit()
  {
	/*
	 * return true if a key was hit, handling
	 * both SMI suns and serial line interfaces
	 */
    int c = emt_mayget();

    if (HitFlag) return(1);
    if (c != -1) return(++HitFlag);
    if (linereadyrx(0)==0) return(0);
    getchar();
    return(++HitFlag);
  }



PrettyPutchar( ch, fp)
 char ch;
 FILE *fp;
  {
    /*
     * print out a character avoiding control codes
     */
      if (ch>=040 && ch<0177) putc( ch, fp);
      else fprintf( fp, "<0%o>", ch&0377 );
  }

