#include "m68enet.h"
#include "m68000.h"
#include "reentrant.h"
#include "vectors.h"
#include "globram.h"
#include "/ps/s/yeager/68000/pup/10MB/version.h"
#include "/ps/s/yeager/68000/pup/10MB/3comEther.h"
#include "/ps/s/yeager/68000/pup/10MB/iterate.h"
#define waittime 10				/* 10 milli second wait */
#define inEther 1
#define outEther 2
#define minsize 60				/* bytes in min packet */
#define maxsize 1514				/* bytes in max packet */
#define minlen (minsize >> 1)			/* length in words */
#define maxlen (maxsize >> 1)
 	
ushort Fbuf[800],Sbuf[800];			/* a couple of buffers  */
ushort *ABbuf[2]= {Fbuf, Sbuf};			/* a short pointer table */
int whichbuf;					/* 0,1,2 for Fbuf,Sbuf,both */
ushort OutBuf[800];				/* outPut buffer */
ushort ErroredPak[800];				/* saved bad packet */
ErroredWordIndex;				/* the first errored word */
int AbufUsed,BbufUsed,ABbufUsed;		/* counters */
int IOdone,nchars;				/* finito flag */
int pinx,paklen;
int timingON;
char *patts[3]= {"zeros","ones","alternating"};
ushort pattern[3]= {0,-1,0125252};
int nframeErrors,nrangeErrors,nfcsErrors;
int ncollisions,spuriousInterrupt;
int inputBeforeOutput;
int bufferErrors;
int sentPacket,inputActive;			/* =1 if packet is sent 
						 *    or input is expected.
						 *    These are Software flags
						 *    to insure REAL inter'pts
						 */
#define maxHist 20
int history[maxHist];				/* histogram */
short newInStatus,atStart,lastInStatus;
int elapsedtime,Npasses;
int ncollisions1,spuriousInterrupt1;
int inputBeforeOutput1;
int sentPacket1,inputActive1;
int nsent,nreceived;				/* counters for debugging */
int Ntimeouts;					/* number of time outs */
int bothBusy;					/* both Busy after input */
ushort host1[3],host2[3];			/* local host addresses */
int firstPass;
/*
 *
 *	A 2 board 3com diagnostic. The initial configuration
 *	has one board jumpered to level2 and the other to level3
 * 	and a 3mb board at level1 for the booting of this stuff.
 *	
 */
main()
  {
    printf("\n 3com 2 board diagnostic - Sends from board 1 to board 2\n");
    timingON = 1;
    initit();					/* init locals */
    while (1)
      {
	if (askUser()) break;			/* get user input */
        initEther_3com(MEBASE,2,&host1[0]);	/* board at level 2 */
        initEther_3com(MEBASE1,3,&host2[0]);	/* board at level 3 */
	initcounters();				/* the counters */
	dotest();				/* now hop along... */
        printsummary();				/* print summary */
        timerstuff();				/* give times */
      }
  }
/*
 *	timerstuff
 */
timerstuff()
  {
    float totalmills= (float)elapsedtime;
    float passcount= (float)Npasses;
    float nbytes;
    float bytespersec;
    register i,max1,max2,v;
    register nmax1,nmax2;
    int first,last;
    float a,n;
    int guess= 0;
    
    if (!timingON && totalmills == 0) return;
    nbytes= passcount*(float)paklen*2.0;
    bytespersec= (nbytes*1000.0)/totalmills;
    max1 = 0; max2 = 0; nmax1 = 0; nmax2 = 0;
    first = -1; last = 0;
    for (i=0; i<maxHist; ++i)
      {
	v = history[i];
        if (v != 0)
	  {
	    last = i;
	    if (first == -1) first = i;
	  }        
        if (v > max1) 
	  { 
	   max2 = max1; nmax2 = nmax1; 
	   max1 = v; nmax1 = i;
	  }
	else
	  if (v > max2) { max2 = v; nmax2 = i; };	
      }
    n = 0.0; a = 0.0;
    printf("\n HISTOGRAM of times :\n");
    for (i=first; i<=last; ++i)
      { 
	v = history[i];
	if (v == 0) continue;
        a = (n*a + (float)(v*i))/(n+v);
        n = n + v;
	printf("%d[%d]",i,history[i]);
        if (i == nmax1) printf("M ");
        else
	  if (i == nmax2) printf("m ");
	  else 
	      printf(" ");
      }
    printf("\n Histogramic average time= %6.2f\n",a);    
    printf("\nN-passes= %d, Total Bytes= %10.0f, Ave. Time/pass= %6.2f\n Baud Rate= %d",Npasses,nbytes,totalmills/passcount,(int)(bytespersec*8.0));
    if (guess) printf(" GUESSED time\n"); else printf("\n");
  }

/*
 *	printsummary		print pass summary
 */
printsummary()
  {
    printf("\n N-sent= %d, N-rcvd= %d, timeouts= %d\n",
	    nsent,nreceived,Ntimeouts);
    printf("\n Error summary:\n");
    printf("   Framing= %d, range= %d, fcs= %d\n", nframeErrors,nrangeErrors,
	    nfcsErrors);
    printf("   Board1: colls= %d, spur-int= %d, inBEFOREout= %d\n",
	    ncollisions,spuriousInterrupt,inputBeforeOutput);
    printf("   Board2: colls= %d, spur-int= %d, inBEFOREout= %d\n",
	    ncollisions1,spuriousInterrupt1,inputBeforeOutput1);
    printf("   Buff. Errs: %d Errd. Word#%d\n",bufferErrors,ErroredWordIndex);
    printf("   Abuf used: %d Bbuf used: %d ABbuf used: %d",
	    AbufUsed,BbufUsed,ABbufUsed);
    printf("\n  Input Status: Before= %4x AT.Int= %4x After= %4x\n",(ushort)newInStatus&0xffff,(ushort)lastInStatus&0xffff,(ushort)atStart);
    if (bothBusy)
      printf("BOTH input buffers BUSY after interrupt= %d\n",bothBusy);

    nchars = 80;			/* force new line */		
  }

/*
 *	initcounters		initialize some counters
 */
initcounters()
  {
    register i;

    for (i=0; i<maxHist; ++i) history[i] = 0;
    nframeErrors = 0;
    nrangeErrors = 0;
    nfcsErrors = 0;
    ncollisions = 0;
    spuriousInterrupt = 0;
    inputBeforeOutput = 0;
    sentPacket = 0;
    inputActive = 0;
    ncollisions1 = 0;
    spuriousInterrupt1 = 0;
    inputBeforeOutput1 = 0;
    sentPacket1 = 0;
    inputActive1 = 0;
    nsent = 0;
    nreceived = 0;
    bothBusy = 0;
    bufferErrors = 0;
    AbufUsed = 0;
    BbufUsed = 0;
    ABbufUsed = 0;
    elapsedtime = 0;
    Npasses = 0;
  }

/*
 *	dotest	the tester.
 */
dotest()
  {
    register GlobDes *GP= GlobPtr;		/* SUN MON refresh counter */
    register timeperpass;			/* pass timer */
    register wallclock;
    printf("\n Starting test, sending %d bytes.\n   Type <cr> to stop...\n", paklen << 1);
    nchars = 0;
    firstPass = 1;
    Npasses = 0;
    timeperpass = 0;
    if (timingON) wallclock = GP->RefrCnt;
    else
	wallclock = 0;
    while(1)
      { int timedOut;
        register timeout;
	register passtime;
	register TIC;

	IOdone = 0;
	timedOut = 0;				/* our flag */

	TIC = GP->RefrCnt;			/* unbias the clock */
	if (!wallclock) while (TIC == GP->RefrCnt);/* wait for new tick */
	passtime = GP->RefrCnt;			/* start of pass */
	startinput2();				/* input on board 2 */
	if (firstPass) makePacket();		/* make a packet */	
	startoutput1();				/* send it from 1 */
        firstPass = 0;				/* need only copy once */
	timeout = GP->RefrCnt+waittime;		/* our timer */
	while (IOdone != (inEther+outEther))
	  if (timeout < GP->RefrCnt) { timedOut = 1; break;} 
	if (timedOut) { ++Ntimeouts; result('T'); }
        else
	  {
	     register dtime = (GP->RefrCnt - passtime);
	     timeperpass += dtime;
	     if (dtime > maxHist) dtime = maxHist;
	     ++history[dtime];
	     ++Npasses;
	     buffercheck();
	     if (!timingON) result('!'); 
	     else
	        if (((Npasses+1) & 1023) == 0) result('.');
	  }
        if (USERexit()) break;
      }
    if (wallclock) elapsedtime = GP->RefrCnt - wallclock;
    else
        elapsedtime = timeperpass;
  }
/*
 *  buffercheck: make sure received packet is accurate
 */
buffercheck()
  {
    register ushort *obuf= &OutBuf[0];
    register ushort *ibuf;
    register i,binx,both;

    switch(whichbuf)
      {
	case 0: 
	    binx = 0; both = 0; ++AbufUsed; break;
	case 1:
	    binx = 0; both = 0; ++BbufUsed; break;
        case 2: 
	    binx = 0; both = 1; ++ABbufUsed; break;
      }
    if (timingON) return;
    ibuf= ABbuf[binx++];
    while(both-- >= 0)
      { register kissoff= 0;
        for (i=0; i<paklen; ++i) 
	  if (*obuf++ != *ibuf++) 
	    { register ushort *ebuf= &ErroredPak[0];
	      obuf = &OutBuf[0];
	      ErroredWordIndex= i;

	      for (i=0; i<paklen; ++i) *ebuf++ = *obuf++;
	      ++bufferErrors; kissoff = 1;
	      break; 
	    }
	  if (kissoff) break;
	  ibuf = ABbuf[binx];
      }
  }
/*
 * 	result			nitty gritty for pass end
 */
result(c) int c;
  {
    if (++nchars >= 76) { putchar('\n'); nchars = 0; }
    putchar(c);					/* type char */
  }

/*
 * 	USERexit		Listens for user input
 */
#define ncmds 5
char *help[ncmds]=
    {
	"\n E to print most recent errored packet",
	"\n H to hold screen. Anything after to continue",
	"\n P to print current packet",
	"\n S for error summary",
        "\n ? prints this.\n"
    };
USERexit()
  {
    register i;

    if (linereadyrx(0) == 0) return(0);
    nchars = 80;
    switch(getchar())
      {
        case 'H': case 'h':
	    while (linereadyrx(0) == 0);
	    getchar();
	    return(0);
	case 'e': case 'E':
	    if (bufferErrors) printpacket(ErroredPak,ErroredWordIndex);
	    else
	        printf("\n NO buffer errors! \n");
	    return(0);
	case 'p': case 'P':
	    printpacket(OutBuf,-1);
	    return(0);
	case 's': case 'S': 
	    printsummary(); return(0);
	case '?':
	    for (i=0; i<ncmds; ++i) printf("%s",help[i]);
	    return(0);
	default: return(1);
      }
  }
/*
 * 	printpacket		
 */
printpacket(p,f) register ushort *p; register f;
  {
    register i;

    printf("\n");
    if (f < 0) printf(" Most recent OUTPUT packet of length %d\n",paklen);
    else
        printf(" Most recent ERRORED packet of length %d\n",paklen);
    for (i=0; i<paklen; ++i)
      {
	printf(" %04x",*p++);
        if (i == f) printf("*"); else printf(" ");
        if (((i+1) % 13) == 0) printf("\n");        
      }    
  }
/* 
 *	makePacket		makes output packet
 */
makePacket()
  {
    register i;
     
    /* store source and destination addresses */
    for (i=0; i<3; ++i) OutBuf[i] = host2[i];	/* dest host */
    for (i=3; i<6; ++i) OutBuf[i] = host1[i-3]; /* source host */
    for (i=6; i<paklen; ++i) OutBuf[i] = pattern[pinx]; /* data */
  }

/* 
 * 	startoutput1		Start output on board 1
 */
startoutput1()
  {
    register short *txhdr= METRNX, *data;
    register offset, i;
    register ushort *packet= &OutBuf[0];
    register short *csreg= MEBASE;

    offset= 0x800 - (paklen << 1);		/* bytes into buffer */ 
    if (firstPass)
      { /* only on first pass */
        data = (short *)((int)METRNX+offset);	/* points to data */
        iterate(paklen, *data++ = *packet++);	/* store the packet */
      }
    *txhdr = offset & TXMSK;			/* store header */   
    sentPacket = 1;
    ++nsent;					/* another up up and away */
    setCSR(csreg,csTBSW1);			/* give to controller */
    setCSR(csreg,(csJINTEN1+csTINTEN1));	/* tx and jam enable */
  }

/*
 *	startinput2		startinput on board2 
 */
startinput2()
  {
    register short *cs= MECSR1;			/* a5 - control/status */
    register ushort status= *cs;		/* the bits */
    register ushort inputbits= status&(csABSW1+csBBSW1);
    register ushort enablebits;
    /*
     * if both buffers are free, then start them both,
     * else start the one that is free.
     * If neither are free, something is AMOK. reset the world.
     * A buffer is active if it's bit is SET.
     */
    intlevel(6);				/* the world is ours */
    atStart = status;
    if (inputbits == (csABSW1+csBBSW1)) 
      { inputbits = 0; *cs = csRESET; ++bothBusy; } /* err-start over */
    if (inputbits == 0) 
      {
        setCSR(cs,(csABSW1+csBBSW1));  		/* (both free) */
	enablebits = csAINTEN1+csBINTEN1;
      }
    else
      if (inputbits == csABSW1) 
        {
	  setCSR(cs,csBBSW1);			/* (B was free - A active)*/
	  enablebits = csBINTEN1;
 	}
      else
	{
	  setCSR(cs,csABSW1);			/* (A was free - B active) */
	  enablebits = csAINTEN1;
	}
    setCSR(cs,enablebits);			/* enable the interrupts */
    newInStatus = *cs;				/* save the sucker */
    inputActive1 = 1;				/* input is active on board */
    intlevel(0);				/* back to the pits */
  }

/*
 *	init variables
 */
initit()
  {
    pinx = 0; paklen = minlen;
  }

/*
 *	command processor
 */
askUser()
  {
    char cbuf[100];

    while (1)
      { 
	int done;
	int value;

	done = 0;
	printf("\nL: Data Length in words          (%d)",paklen);
	printf("\nP: Pattern                  (%s)",patts[pinx]);
	printf("\nQ: to quit program");
	printf("\nT: packet Timing ON");
        if (timingON) printf("  (ON)"); else printf("  (OFF)");
        printf("\n<cr> or space to proceed");
	switch (getchar() & 0177)
	  {
	    case 015: case ' ': done = 1; break; 
	    case 'L': case 'l':
		printf("\n set length in words to "); scanf("%d",&value);
		if (value <= minlen) value = minlen;
		else
		  if (value > maxlen) value = maxlen;
		paklen = value;
		break;
	    case 'p': case 'P':
		printf("\n Enter Zeros, Ones, Alternating(Z, O, A): ");
		switch(getchar() & 0177)
		  {
		    case 'z': case 'Z': pinx = 0; break;
		    case 'o': case 'O': pinx = 1;  break;
		    case 'a': case 'A': pinx = 2; break;
		    default: pinx = 0; break;

		  }
		break;
	    case 'q': case 'Q':	printf("\n"); return(1);/* exit this world */
	    case 't': case 'T':
		printf("\n Want packet timing?(Yes,No): ");
		switch(getchar() & 0177)
		  {
		    case 'y': case 'Y': timingON = 1; break;
		    case 'n': case 'N': timingON = 0; break;
		    default: timingON = 1; break;
		  }
	    default: 
		printf("\n ? mumble..."); break;
	  }

	if (done) return(0);			/* do the test */
      }			
  }
/*
 *   (level3 3com board driver - board 1)
 *
 *   This is a test driver for the 3com 10MB board.
 *   It has two input buffers, Abuf, and Bbuf.
 *   And one output buffer Obuf
 *   
 *                                           */

reentrant(EtherInterruptLEV3_3com)
  {
    register short status;			/* d7 */
    register inputBits;				/* input bits */
    register i= 0;				/* d5 */
    register short iostatus;			/* iostatus */
    register short disable;			/* int. disable mask */
    unsigned short *bptr[2];			/* for input buffers */
    unsigned short **nextbuf, **dbuf;		/* a5 a4 for data moves */
    unsigned short *dataIn,*dataOut;		/* a3 a2 */
    register short *csr= MECSR1;		/* control status pointer */
    
    status = *csr;				/* get status */
    inputBits = status & (csABSW1+csBBSW1); 	/* d6 input bits */
    /* check input first: bit = 0 means data available */
    if (inputActive1 == 0 && sentPacket1 == 0)	/* spurious interrupt */
      {
	++spuriousInterrupt1; return; 	
      }
    lastInStatus = status;
    if ((inputBits != (csABSW1+csBBSW1)) && inputActive1)
      { /* we have at least 1 buffer with data */
	if (!sentPacket) ++inputBeforeOutput1;	/* Sent from board 0 */
	inputActive1 = 0;
        IOdone |= inEther;			/* flag it */
	i = 1;					/* 1 buffer */
	if (inputBits == 0)			/* both have data */
	  {
	    resetCSR(csr,(csAINTEN1+csBINTEN1));/* clear enable bits */
	    i = 2;				/* two buffers */
	    whichbuf = 2;			/* both buffers have data */
	    if (status & csRBBA)		/* B is older if set */
	      { 
		bptr[0] = (ushort *)MERCVB1; 
	        bptr[1] = (ushort *)MERCVA1;
	      }
	    else
	      { 
		bptr[1] = (ushort *)MERCVB1;
	        bptr[0] = (ushort *)MERCVA1;
	      }
	  }
	else		
	  {			/* just one buffer */
	    whichbuf = 0;
	    if (inputBits == csBBSW1)		/* A has data  */
	      { 
	        bptr[0] = (ushort *)MERCVA1; disable = csAINTEN1;
	        whichbuf = 0;
	      }
	    else				/* B has data  */
	      { 
	        bptr[0] = (ushort *)MERCVB1; disable = csBINTEN1;
	        whichbuf = 1;
	      }
	    resetCSR(csr,disable);			/* clear enable bit */
          }
	nreceived += i;				/* count receptions */
        nextbuf = &bptr[0];			/* source buffer ADDRESSES */
        dbuf = &ABbuf[0];			/* dest. buffer ADDRESSES */
        while (i--)				/* process input data */
	  { /* move the data */
	    dataIn = *nextbuf++;		/* input buffer pointer */
	    iostatus = *dataIn++;		/* first word is status */
	    if (iostatus & (frameErr+RangeErr+fcsErr))
	      { /* an input error of some sort */
		if (iostatus & RangeErr) ++nrangeErrors;
		if (iostatus & frameErr) ++nframeErrors;
		if (iostatus & frameErr) ++nfcsErrors;
	      }
	    else
	      {
	        dataOut = *dbuf++;		/* destination buffer */
	        /* NOTE: iterate needs 2 registers */
	        if (!timingON)	/* dont read if timing is going on */
	          iterate(((iostatus & RVMSK) >> 1),*dataOut++ = *dataIn++);
	      }
	  }
      }
      /* CHECK output now */
     if ((!(status & csTBSW1) && sentPacket1) || status & csJAM0)
	{
	  if (status & csJAM0)
	    {
	      ++ncollisions1;
	      setCSR(csr,csJAM0);			/* clear JAM */
	    }
	  IOdone |= outEther;			/* flag it */
	  sentPacket1 = 0;			/* clear start flag */
	  resetCSR(csr,(csJINTEN1+csTINTEN1));	/* clear enables */
	}
  }

/*
 *   level2 3com board driver (board 0)
 *
 *   This is a test driver for a second 3com 10MB board.
 *   We could use just one driver since all of this stuff
 *   is rentrant, but, since this is a diagnostic, it is
 *   better to separate the boards from the software as
 *   well as hardware perspective.
 *
 *   It has two input buffers, Abuf, and Bbuf.
 *   And one output buffer OutBuf
 *   
 *                                           */


reentrant(EtherInterruptLEV2_3com)
  {
    register short status;			/* d7 */
    register inputBits;				/* input bits */
    register i= 0;				/* d5 */
    register short iostatus;			/* iostatus */
    register short disable;			/* int. disable mask */
    unsigned short *bptr[2];			/* for input buffers */
    unsigned short **nextbuf, **dbuf;		/* a5 a4 for data moves */
    unsigned short *dataIn,*dataOut;		/* a3 a2 */
    register short *csr= MECSR;		/* control status pointer */
    
    status = *csr;				/* get status */
    inputBits = status & (csABSW1+csBBSW1); 	/* d6 input bits */
    /* check input first: bit = 0 means data available */
    if (inputActive == 0 && sentPacket == 0)	/* spurious interrupt */
      {
	++spuriousInterrupt; return; 	
      }
    if ((inputBits != (csABSW1+csBBSW1)) && inputActive)
      { /* we have at least 1 buffer with data */
	if (!sentPacket1) ++inputBeforeOutput; 	/* got wrong iterrupt first */
	inputActive = 0;
        IOdone |= inEther;			/* flag it */
	i = 1;					/* 1 buffer */
	if (inputBits == 0)			/* both have data */
	  {
	    resetCSR(csr,(csAINTEN1+csBINTEN1));/* clear enable bits */
	    i = 2;				/* two buffers */
	    whichbuf = 2;
	    if (status & csRBBA)		/* B is older if set */
	      { bptr[0] = (ushort *)MERCVB; bptr[1] = (ushort *)MERCVA; }
	    else
	      { bptr[1] = (ushort *)MERCVB; bptr[0] = (ushort *)MERCVA; }
	  }
	else		
	  {			/* just one buffer */
	    if (inputBits == csBBSW1)		/* A has data  */
	      { 
	        bptr[0] = (ushort *)MERCVA; disable = csAINTEN1; 
		whichbuf = 0;
 	      }
	    else				/* B has data  */
	      { 
	        bptr[0] = (ushort *)MERCVB; disable = csBINTEN1;
	        whichbuf = 1;
	      }
	    resetCSR(csr, disable);		/* clear enable bit */
          }
        nextbuf = &bptr[0];			/* source buffer ADDRESSES */
        dbuf = &ABbuf[0];			/* dest. buffer ADDRESSES */
	nreceived += i;				/* count receptions */
        while (i--)				/* process input data */
	  { /* move the data */
	    dataIn = *nextbuf++;		/* input buffer pointer */
	    iostatus = *dataIn++;		/* first word is status */
	    if (iostatus & (frameErr+RangeErr+fcsErr))
	      { /* an input error of some sort */
		if (iostatus & RangeErr) ++nrangeErrors;
		if (iostatus & frameErr) ++nframeErrors;
		if (iostatus & frameErr) ++nfcsErrors;
	      }
	    else
	      {
	        dataOut = *dbuf++;		/* destination buffer */
	        /* NOTE: iterate needs 2 registers */
	        iterate(((iostatus & RVMSK) >> 1),*dataOut++ = *dataIn++);
	      }
	  }
      }
      /* CHECK output now */
     if ((!(status & csTBSW1) && sentPacket) || status & csJAM0)
	{
	  if (status & csJAM0)
	    { /* NO retransmission */
	      ++ncollisions;
	      setCSR(csr,csJAM0);			/* clear JAM */
	    }
	  IOdone |= outEther;			/* flag it */
	  sentPacket = 0;			/* clear start flag */
	  resetCSR(csr,(csJINTEN1+csTINTEN1));	/* clear enables */
	}
  }


/*
 *
 *	Initialize the 3com board
 *		csadd is address of cs register, INTlevel is interrupt
 *		level at which the board is JUMPERED.
 *
 */
initEther_3com(csadd,INTlevel,stationAdd) 
short *csadd; int INTlevel;
short *stationAdd;
  {
    register short *csr= csadd;
    register short *ROM, *RAM;
    register unsigned short SR;
    register xit;
    ushort *savedadd= (ushort *)stationAdd;

    /* first reset the board */
    SR = sr;					/* save old sr */
    intlevel(6);				/* do at level 6 */
    *csr = csRESET;
    /* set up address RAM */
    ROM = (short *)((int)csadd+0x400);		/* burned address */
    RAM = (short *)((int)csadd+0x600);
    *RAM++ = *ROM;				/* 16 bits */
    *stationAdd++ = *ROM++;			/* for encapsulation */
    *RAM++ = *ROM;				/* 16 bits */
    *stationAdd++ = *ROM++;			/* for encapsulation */
    *RAM = *ROM;				/* 16 bits */
    *stationAdd = *ROM;				/* for encapsulation *
    *csr |= csAMSW1;				/* Give to controller */
    *csr |= paALL;				/* receive ALL for this test*/

    switch (INTlevel)				/* set vector */
      {
	case 1: printf("\n WARNING - attempt to Init 3com board at LEVEL1\n");
		xit = 0; break;
	case 2: IRQ2Vect = (int)EtherInterruptLEV2_3com; xit = 1; break;
	case 3: IRQ3Vect = (int)EtherInterruptLEV3_3com; xit = 1; break;
	default:
		printf("\n ILLEGAL vector assignment level");
		xit = 0; break;
      }
    printf("\nInited board at level%d @%x",INTlevel,csadd);
    printf(" Host addr= %o[x%x]",*savedadd,*savedadd); 
    ++savedadd;
    printf(" %o[x%x]",*savedadd,*savedadd); ++savedadd;
    printf(" %o[x%x]\n",*savedadd,*savedadd);
    sr = SR;					/* back to prev level */
    return(xit);
  }

