/*
 * gx.c - a short little test of the version one frame buffer board
 *
 * Copyright (c) 1982 by William I. Nowicki
 *
 * NOTE: Permission to copy this program is given ONLY
 *	 if all improvements and bug fixes are promptly returned
 *	 to the Author.
 *
 * Bill Nowicki June 1981
 *
 * Bill Nowicki November 1981
 *	- Added Memory test
 *
 * April 1982 (WIN)
 *	- Added GXProbe, GXBase
 *	- Added ability to select multiple units
 *
 * May 15, 1982 (WIN)
 *	- Bit boundary rotation testing
 *	- Copy test added
 *	- Longword test added
 */


# include "framebuf.h"
# include "m68000.h"
# include "vectors.h"

int GXBase;			/* frame buffer base address */
int StartingX = 0;		/* initial X offset for 16-bit alignment */
int UseLongs = 0;		/* use longs instead of words for Memory Test */
int NumberBusErrors = 0;
int PrintBusErrors = 1;
int HitFlag = 0;		/* true if a key was ever hit */

short SavedIR;
long  SavedPC;


BusError()
 {
 	/*
	 * Routine that handles bus errors.
	 * A lot of 68000isms in this code.
	 */

    NumberBusErrors++;
    asm("	movw	sp@(6),SavedIR" );

     if (SavedIR != 0x33fc)
       {
         asm(" subql	#2,sp@(10)" );
       }

     if (SavedIR == 0x33ee)
       {
         asm(" addql	#4,sp@(10)" );
       };

    asm("	movl	sp@(10),SavedPC" );
      
    sp += 2;
    asm("	rte");
 }




HitKey()
  {
	/*
	 * return true if a key was hit, handling
	 * both SMI suns and serial line interfaces
	 */
    int c = emt_mayget();

    if (HitFlag) return(1);
    if (c != -1) return(++HitFlag);
    if (linereadyrx(0)==0) return(0);
    getchar();
    return(++HitFlag);
  }

gethex()
  {
    register short value = 0;
    register char chr;

    /*
     * had to write this little decoder since there is none in the
     * library!!
     */ 
     while (1)
       {
          chr = getchar() & 0177;
          if ( chr >= '0' && chr <= '9' )
	    {
	       value = (value << 4) + (chr - '0');
	       continue;
	    }
          if ( chr >= 'A' && chr <= 'F' )
	    {
	       value = (value << 4) + (chr - 'A' + 10);
	       continue;
	    }
          if ( chr >= 'a' && chr <= 'f' )
	    {
	       value = (value << 4) + (chr - 'a' + 10);
	       continue;
	    }
	  printf( "\n" );
	  return( value );
       }
  }


CheckBusErrors()
 {
   /*
    * Print message for bus errors
    */
  if (NumberBusErrors==0 || PrintBusErrors==0) return;

  if (NumberBusErrors==1)
      printf( "There was a Bus Error\n" );
    else  printf( "There were %d Bus Errors\n", NumberBusErrors);
  NumberBusErrors = 0;
  printf( "IR = %x, PC = %x\n", SavedIR, SavedPC );
 }


main()
 {
   register int i, x, y;  /* d7, d6, d5 */
   short func = 0, mask = 0;

   GXBase  = GXProbe();
   if (GXBase == 0) 
     {
       printf( "No Frame Buffer found!\n" );
       GXBase = GXDefaultBase;
     }
	/*
	 * Watch this magic 10.  It is used to skip  around the
	 * link and moveml instructions that C puts at the begining of
	 * every function
	 */

   BusErrorVector = ( (int) BusError ) +10;
      
   GXcontrol = GXvideoEnable;
   putchar( '\f' );

   while (1) 
     {
	GXcontrol = GXvideoEnable;
	printf( "Graphics board test program.\n" );
	printf( "Testing Unit number %d\n", (GXBase - GXUnit0Base)>> 17 );
   	printf( "Type control C to exit any test.\n" );
   	GXcontrol = GXvideoEnable;
        CheckBusErrors();
	printf( "0-7 Select given unit number\n" );
	printf( "a - Access test\n" );
	printf( "c - Copy test\n" );
        if (PrintBusErrors)
 		printf( "b - Ignore Bus Errors\n");
	 else   printf( "b - Print Bus Errors\n");
        printf( "d - Data Test\n" );
        printf( "f - Function Unit\n" );
        printf( "m - Memory Test\n" );
	printf( "q - Quit\n" );
	printf( "r - Repeat test\n" );
        printf( "s - Shifter\n" );
        printf( "Select test:" );
	switch ( getchar() & 0177)
	  {
	   
	    case 'q':
	    case 'Q':
	    case '\003':
	        printf( "\nExiting to monitor.\n" );
	        return;
		
	    case '0': Select(0);	continue;
	    case '1': Select(1);	continue;
	    case '2': Select(2);	continue;
	    case '3': Select(3);	continue;
	    case '4': Select(4);	continue;
	    case '5': Select(5);	continue;
	    case '6': Select(6);	continue;
	    case '7': Select(7);	continue;

	    case 'a':
	    case 'A':
	        printf( "\nTrying to access the Frame buffer.\n" );
		DoAccess();
	        continue;
		
	    case 'b':
	    case 'B':
		if (PrintBusErrors)
		  {
		    printf( "\n Will Ignore Bus Errors\n" );
		    PrintBusErrors = 0;
		  }
		 else
		  {
		    printf( "\n Will Print Bus Errors\n" );
		    PrintBusErrors = 1;
		    CheckBusErrors();
		  }
		continue;
		
	    case 'c':
	    case 'C':
	        CopyTest();
		break;

	    case 'f':
	    case 'F':
	        DoFunction();
		break;


	    case 'm':
	    case 'M':
	        DoMemory();
		break;

	    case 'd':
	    case 'D':
	        DoData();
		break;

	    case 's':
	    case 'S':
	        DoShift();
		break;

	    case 'r':
	    case 'R':
	        DoRepeat();
		break;
		
	    default:
	       printf( "\n No such test!!!\n" );
	       continue;	        
	  }
	putchar( '\f' );
     }
   
}


Select(n)
  {
  	/*
	 * Select a frame buffer address
	 */
    GXBase = GXUnit0Base + (n<<17);
    printf( "\nSelecting Unit number %d at address %x\n", n, GXBase );
  }


DoAccess()
 {
    int count=0;

     for ( ; !HitKey(); count++ )
       GXcontrol = GXvideoEnable;
      
      printf( "Accessed %d times\n" );
      CheckBusErrors();
 }


DoRepeat()
   {
    register short *xLocation = (short *)(GXBase|GXselectX); /* a5 */
    register short *yLocation = (short *)
	          (GXBase | GXupdate | GXsource | GXselectY ); /* a4 */

    int x=8, y=8, func = GXinvert, width=15, data = 0xffff;
    char chr;


     printf( "\nRepeat test" );
     
     do {
           printf( "\nx = %x, y = %x, func = %x, width = %x, data = %x\n",
	       x, y, func, width, data );
	   printf( "Type 'g' to go, 'q' to quit, or value to change: ");
	   chr = getchar() & 0177;
	   putchar( '\n' );
	   switch (chr)
	     {
	       case 'q': return;
	       case 'x':
	            printf( "Enter x: " );
		    x = gethex();
		    break;

	       case 'y':
	            printf( "Enter y: " );
		    y = gethex();
		    break;

	       case 'f':
	            printf( "Enter function: " );
		    func = gethex();
		    break;

	       case 'w':
	            printf( "Enter width: " );
		    width = gethex();
		    break;

	       case 'd':
	            printf( "Enter data: " );
		    data = gethex();
		    break;
	     }
        } while (chr != 'g');

     GXfunction = func;
     GXwidth    = width;

     xLocation += x;
     yLocation += y;

     while (!HitKey() )
        {
	   *xLocation = 1;
	   *yLocation = data;
        }
   }



DoShift()
  {
      /*
       * Test the shift unit by trying to draw a diagonal line
       */
   register int x, y;  /* d7, d6 */
   short func = 0, mask = 0;
   
   printf( "\nShifter test\n" );


     while (!HitKey() )
        {

	  Clear();	     
          for ( x=1; x<=16; x++ )
             {
               register short *xLocation = (short *)(GXBase|GXselectX); /* a5 */
	       register short *yLocation = (short *)
	          (GXBase | GXupdate | GXsource | GXselectY ); /* a4 */

	     printf( "Width = %d\n", x);

             GXfunction = GXcopy;
	     GXwidth    = x;
	
  	       for ( y=0; y < 1024; y++)
	         {
		    *xLocation++ = 1;
		    *yLocation++ = 0xFFFF;

                 }
   	      }
	  }
 }


CopyTest()
  {
      /*
       * Copy one swath to another
       */
   register int x, y;  /* d7, d6 */
   short func = 0, mask = 0;
   
   printf( "\nCopy test\n" );


     while (!HitKey() )
        {
               register short *xSource = (short *)(GXBase|GXset1|GXselectX); /* a5 */
	       register short *ySource = (short *)
	          (GXBase | GXset1 | GXsource | GXselectY ); /* a4 */
               register short *xDest = (short *)(GXBase|GXselectX|800); /* a3 */
	       register short *yDest = (short *)
	          (GXBase | GXupdate | GXselectY ); /* a2 */

             GXfunction = GXcopy;
	     GXwidth    = 16;
	
	     *xSource = x;
	     *xDest   = x;
  	       for ( y=0; y < 1024; y++)
	         {
                   *yDest++ = *ySource++;
                 }
   	      }
 }



Clear()
  {
     /*
      * clear the screen
      */
     register x, y;
     register short *xLocation = (short *)(GXBase|GXselectX);  /* a5 */

     GXfunction = GXclear;
     GXwidth    = 16;
	
     for ( x=0; x < 1024; x += 16)
        {
	   register short *yLocation = (short *)
	         (GXBase | GXupdate  | GXselectY + 2048); /* a4 */
	
   	   GXsetX(x);
  	   for ( y=0; y < 1024; y += 32)
	     {
	       asm( "moveml	#/ffff,a4@-");
             }
        }
}


DoFunction()   
 {
      /*
       * test the function unit by asking for a function value
       * and repeatedly performing the function to the entire screen
       */
   register int i, x, y;  /* d7, d6, d5 */
   short func = 0, mask = 0;
   
   printf( "\nFunction unit test\n" );
   while (1)
    {
     register short *xLocation = (short *)(GXBase|GXselectX); /* a5 */

	printf( "Function (in hex)= "); 
 	func = gethex();
	printf( "Function will be %x\n", func ); 

     GXwidth    = 16;
      while (!HitKey() )
       {	
        GXfunction = func;
	mask += 128;
        GXsetMask = mask;

        for ( x=0; x < 1024; x += 16)
         {
	   register short *yLocation = (short *)
	         (GXBase | GXupdate | GXsource | GXselectY + 2048); /* a4 */
	
   	   GXsetX(x);
  	   for ( y=0; y < 1024; y += 32)
	     {
	       asm( "moveml	#/ffff,a4@-");
             }
	    d3++; d4++;
   	  }
	  }
	CheckBusErrors();
	if ( (getchar()&0177) < ' ' ) return;
   }
}


int PrintBad = 1;	/* true to print differences */

MemoryPass( start, next, cycleX )
 short start;
 short (* next)();
  {
  	/*
	 * Do a pass through the frame buffer, setting words to values
	 * starting with "start", with the "next" function returning
	 * the next value.
	 * If cycleX is true, we increment the starting X values
	 */
   register short value;	/* d7 */
   register short x;		/* d6 */
   register short y;		/* d5 */
   register short got;		/* d4 */


   if (UseLongs) return( LongMemoryPass( start, next, cycleX) );
   if (HitKey() ) return;
   GXwidth    = 16;
   GXfunction 	= GXcopy;
   value = start;

     for ( x=StartingX; x < 1024; x += 16)
         {
	   register short *yLocation = (short *)
	         (GXBase | GXupdate | GXsource | GXselectY ); /* a5 */
	
   	   GXsetX(x);
  	   for ( y=0; y < 1024; y++)
	     { *yLocation++ = value; value = next(value); }
	  } /* x loop */

     value = start;
     for ( x=StartingX; x < 1024; x += 16)
         {
	 	/*
		 * this loop reads back, checking against what should be there
		 */
	   register short *yLocation = (short *)
	         (GXBase | GXsource | GXselectY ); /* a5 */
	
   	   GXsetX(x);
	   got = *yLocation++;
  	   for ( y=0; y < 1024; y++)
	    {
		got = *yLocation++;
		if (got != value)
		 if (PrintBad && !HitKey() )
		  printf( "Expected %d (%x) but got %d (%x), Xor is %x, x=%d, y=%d\n",
# define W 0xFFFF
		     value&W, value&W, got&W, got&W, (value^got)&W, x, y );
		value = next(value);
	    }
	  } /* x loop */
	CheckBusErrors();
	if (cycleX)  if (StartingX++ > 15) StartingX = 0;
  }


LongMemoryPass( start, next, cycleX )
 short start;
 short (* next)();
  {
  	/*
	 * Same as above but uses Longs instead of words
	 */
   register long value;		/* d7 */
   register short x;		/* d6 */
   register short y;		/* d5 */
   register long got;		/* d4 */


   if (HitKey() ) return;
   GXwidth    = 16;
   GXfunction 	= GXcopy;
   value = start;

     for ( x=StartingX; x < 1024; x += 16)
         {
	   register long *yLocation = (long *)
	         (GXBase | GXupdate | GXsource | GXselectY ); /* a5 */
	
   	   GXsetX(x);
  	   for ( y=0; y < 512; y++)
	     { *yLocation++ = value; value = next(value); }
	  } /* x loop */

     value = start;
     for ( x=StartingX; x < 1024; x += 16)
         {
	 	/*
		 * this loop reads back, checking against what should be there
		 */
	   register long *yLocation = (long *)
	         (GXBase | GXsource | GXselectY ); /* a5 */
	
   	   GXsetX(x);
	   got = *(short *)yLocation;
	   yLocation = (long *)( (int)yLocation + 2 );
  	   for ( y=0; y < 1024; y += 2)
	    {
		got = *yLocation++;
		if (got != value)
		 if (PrintBad && !HitKey() )
		  printf( "Expected %d (%x) but got %d (%x), Xor is %x, x=%d, y=%d\n",
		     value, value, got, got, (value^got), x, y );
		value = next(value);
	    }
	  } /* x loop */
	CheckBusErrors();
	if (cycleX)  if (StartingX++ > 15) StartingX = 0;
  }

Same(x) { return(x); }
Xor(x)  { return( ~x ); }
Increment(x) { return(x+1); }
Decrement(x) { return(x-1); }
RotateLeft(x) { return( (x<<1) | ( (x>>15)&1) ); }
RotateRight(x) { x&=W; return( (x>>1) | ((x&1)<<15) ); }

DoMemory()   
 {
      /*
       * test the Memory in the frame buffer by reading back
       * some random patterns after we write them.
       * We rotate through the bit boundaries to test this as well.
       */
    int cycleX = 1;
   
   printf( "\nMemory Test\n" );
   printf( "Repeat or Print Errors? (r, y or n): ");
   switch (getchar())
     {
        case 003:
	case 'q':
	case 'Q':
		 return;

	case 'n':
	case 'N':
		PrintBad = 0;
		printf( "o\n" );
		break;

	case 'r':
	case 'R':
		printf( "epeat\n" );
		DoMemRepeat();
		return;

	case '\r':
		putchar('\n' );
	default:
		printf( " Assuming Y" );
		
	case 'y':
	case 'Y':
		PrintBad = 1;
		printf( "es\n" );
		break;
     }

   HitFlag = 0;
   while (!HitKey() )
       {
          MemoryPass( 0, Same, 0 );
          MemoryPass( -1, Same, 0 );	
          MemoryPass( 0x5555, Same, 0 );	
          MemoryPass( 0x5555, Xor, 0 );	
          MemoryPass( 0xAAAA, Same, 0 );	
          MemoryPass( 0, Xor, 0 );	
          MemoryPass( 0xAAAA, Xor, 0 );
	  MemoryPass( 0x1111, RotateLeft, 0 );
	  MemoryPass( 0x1111, RotateRight, 0 );
          MemoryPass( 0, Increment, 0 );
          MemoryPass( -1, Decrement, 0 );
          MemoryPass( 1, Increment, 0 );
          MemoryPass( 0, Decrement, cycleX );
       }
}


DoMemRepeat()
 {
   int start = 0;
   int cycleX = 1;
    /*
     * Repeatedly perform a specific memory test
     */
   while (1)
     {
       printf( "Select one of:\n");
       if (cycleX) printf("c - Disable cyclic starting X values\n" );
	else       printf("c - Cycle starting X values (bit boundary test)\n" );
       if (UseLongs) printf("w - use Words instead of Longs\n" );
	else       printf("w - use Longs instead of Words\n" );
       printf( "z - Always zero\n");
       printf( "o - Always one\n");
       printf( "i - Increment\n");
       printf( "d - decrement\n");
       printf( "x - Alternating 5555 and AAAA\n");
       printf( "f - flickering pattern\n");
       printf( "s - specify a value, always same\n");
       printf( "a - specify a value and alternate\n");
       printf( "r - specify a value and rotate right\n");
       printf( "l - specify a value and rotate left\n");
       if (PrintBad)
        printf( "p - Do not print errors\n" );
       else
       	printf( "p - Print errors\n" );
       printf( "q - quit to main menu\n");
       
       printf( "select: ");
       
       HitFlag = 0;
       switch (getchar() )
         {
	   default:
	   	printf( " - No such option!\n");
		continue;
		
	   case 'q':
	   case 'Q':
	   	printf(  "uit\n");
	   	return;

	   case 'c':
	   case 'C':
	   	if (cycleX)
		  {
		     printf( "yclical X values disbaled.\n");
		     printf( "Enter new constant starting X value:" );
		     StartingX = gethex(); printf( "\n" );
		     cycleX = 0;
		  }
		else
		  {
		    printf( "ycle X values, testing all bit boundaries.\n");
		    cycleX = 1;
		  }
		continue;


	   case 'w':
	   case 'W':
	   	if (UseLongs)
		  {
		     printf( "ords instead of longs.\n");
		     UseLongs = 0;
		  }
		else
		  {
		    printf( " - Long instead of word references\n" );
		    UseLongs = 1;
		  }
		continue;

	   case 'z':
	   case 'Z':
	   	printf( " - Always zero\n");
    		while (!HitKey() ) MemoryPass( 0, Same, cycleX );
		break;

	   case 'o':
	   case 'O':
	   	printf( " - Always ones\n");
    		while (!HitKey() ) MemoryPass( -1, Same, cycleX );
		break;

	   case 'i':
	   case 'I':
	   	printf( " - Increment\n");
    		while (!HitKey() ) MemoryPass( 0, Increment, cycleX );
		break;

	   case 'd':
	   case 'D':
	   	printf( " - Decrement\n");
    		while (!HitKey() ) MemoryPass( 0, Decrement, cycleX );
		break;

	   case 'f':
	   case 'F':
	   	printf( " - Flickering\n");
    		while (!HitKey() ) MemoryPass( 0, Xor, cycleX );
		break;

	   case 'x':
	   case 'X':
	   	printf( " - Xoring, 5555 and AAAA\n");
    		while (!HitKey() ) MemoryPass( 0x5555, Xor, cycleX );
		break;


	   case 'p':
	   case 'P':
	   	if (PrintBad)
		  {
		    printf( " - Do not print errors\n");
		    PrintBad = 0;
		  }
		else
		  {
		    printf( " - Print errors\n");
		    PrintBad = 1;
		  }
		continue;

	   case 'r':
	   case 'R':
	   	printf( " - Specify a value and rotate right\n");
		printf( "Enter starting value in hex: ");
		start = gethex(); printf( "\n" );
    		while (!HitKey() ) MemoryPass( start, RotateRight, cycleX );
		break;

	   case 'l':
	   case 'L':
	   	printf( " - Specify a value and rotate left\n");
		printf( "Enter starting value in hex: ");
		start = gethex(); printf( "\n" );
    		while (!HitKey() ) MemoryPass( start, RotateLeft, cycleX );
		break;

	   case 's':
	   case 'S':
	   	printf( " - specify a constant value\n");
		printf( "Enter starting value in hex: ");
		start = gethex(); printf( "\n" );
    		while (!HitKey() ) MemoryPass( start, Same, cycleX );
		break;

	   case 'a':
	   case 'A':
	   	printf( " - specify and Alternate\n");
		printf( "Enter starting value in hex: ");
		start = gethex(); printf( "\n");
    		while (!HitKey() ) MemoryPass( start, Xor, cycleX );
		break;
	 }
       printf( "\n" );
       }
 }


DoData()   
 {
      /*
       * test the data shifter by moving single pixel bars accross the screen
       */
   register int value, x, y;  /* d7, d6, d5 */
   register short *xLocation = (short *)(GXBase|GXselectX); /* a5 */
   short start, column;
   
   printf( "\nData test\n" );
   Clear();

  while (1)
   {
   printf( "Enter Start (between 0 and 16): " );
   start = gethex();
   printf( "Start = %d\n", start );
   Clear();
   GXfunction 	= GXcopy;
   GXsetMask 	= 0;
   GXwidth  	= 16;

   while (!HitKey() )
       {
        for ( x=start; x < 1024; x += 16)
         {
	   register short *yLocation = (short *)
	         (GXBase | GXupdate | GXsource | GXselectY); /* a4 */
	   value = 0x8000;
	   for ( column=0; column < 16; column++)
	    {
	     GXsetX(x);
	     for (y=0; y<64; y++) *yLocation++ = value;
	     value = value >> 1;
    	    } /* column loop */
	   } /* x loop */

	  } /* while linereadyrx */
	CheckBusErrors();
  } /* infinite loop */
}
