/*
 * missing \n fixed by Bill Nowicki December 1981
 *
 * Merged Stanford and LFL versions July 1982
 */

# include "mfile2"

# define TSCALAR TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT
# define EA SNAME|SOREG|SCON|STARREG|SAREG|SBREG
# define EAA SNAME|SOREG|SCON|STARREG|SAREG
# define EB SBREG

struct optab  table[] = {

ASSIGN,	INAREG|FOREFF|FORCC,
	EAA,	TSCALAR|TFLOAT,
	SZERO,	TANY,
		0,	RLEFT|RRIGHT|RESCC,
		"	clrZB	AL\n",

ASSIGN,	INAREG|FOREFF|FORCC,
	EAA,	TDOUBLE,
	SZERO,	TANY,
		0,	RLEFT|RRIGHT|RESCC,
		"	clrl	AL\n	clrl	UL\n",

ASSIGN,	INAREG|FOREFF|FORCC,
	SAREG|STAREG,	TSCALAR,
	SCCON,	TSCALAR,
		0,	RLEFT|RRIGHT|RESCC,
		"	moveq	AR,AL\n",

ASSIGN,	INAREG|FOREFF|FORCC,
	EAA,	TSCALAR|TFLOAT,
	EA,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT|RESCC,
		"	movZB	AR,AL\n",

ASSIGN,	INAREG|FOREFF,
	EAA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	movl	AR,AL\n	movl	UR,UL\n",

ASSIGN,	INAREG|FOREFF,
	EAA,	TFLOAT,
	EA,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	movl	AR,AL\n",

ASSIGN,	INBREG|FOREFF,
	EB,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT|RRIGHT|RESCC,
		"	movZB	AR,AL\n",

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	SZERO,	TANY,
		0,	RRIGHT,
		"	andY	#N,AL\n",

ASSIGN, INTAREG|INAREG|FOREFF,
	SFLD,	TANY,
	STAREG,	TANY,
		NAREG,	RRIGHT,
		"F\tmovl\tAR,sp@-\n\tmovl\t#H,A1\n\tlslY\tA1,AR\n\tandY\t#M,AR\n\tandY\t#N,AL\n\torY\tAR,AL\nF\tmovl\tsp@+,AR\n",

ASSIGN, INAREG|FOREFF,
	SFLD,	TANY,
	EA,	TANY,
		2*NAREG,	RRIGHT,
		"\tmovZB\tAR,A1\n\tmovl\t#H,A2\n\tlslY\tA2,A1\n\tandY\t#M,A1\n\tandY\t#N,AL\n\torY\tA1,AL\n",

/* put this here so UNARY MUL nodes match OPLTYPE when appropriate */
UNARY MUL,	INTAREG|INAREG|FORCC,
	SBREG,	TSCALAR,
	SANY,	TANY,
		NAREG|NASR,	RESC1|RESCC,
		"	movZB	AL@,A1\n",

OPLTYPE,	FOREFF,
	SANY,	TANY,
	EA,	TANY,
		0,	RRIGHT,
		"",   /* this entry throws away computations which don't do anything */

OPLTYPE,	FORCC,
	SANY,	TANY,
#ifndef Stanford
	EAA,	TSCALAR|TFLOAT|TDOUBLE,
#else Stanford
	  /*
	   * You really need to compare all 64 bits for doubles.
	   * But if you don't have this, the code in local2.c does not
	   * work.
	   */
	EAA,	TSCALAR|TFLOAT,
#endif Stanford
		0,	RESCC,
		"	tstZB	AR\n",

OPLTYPE,	FORCC,
	SANY,	TANY,
	EB,	TSCALAR,
		0,	RESCC,
		"	cmpZB	#0,AR\n",

OPLTYPE,	INTAREG|INAREG|FORCC,
	SANY,	TANY,
	SZERO,	TSCALAR,
		NAREG|NASR,	RESC1|RESCC,
		"	clrZB	A1\n",

OPLTYPE,	INTAREG|INAREG|FORCC,
	SANY,	TANY,
	SCCON,	TSCALAR,
		NAREG|NASR,	RESC1|RESCC,
		"	moveq	AR,A1\n",

OPLTYPE,	INTAREG|INAREG|FORCC,
	SANY,	TANY,
	EA,	TSCALAR,
		NAREG|NASR,	RESC1|RESCC,
		"	movZB	AR,A1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TDOUBLE,
		NAREG|NASR,	RESC1,
		"	movl	AR,A1\n	movl	UR,U1\n",

OPLTYPE,	INTAREG|INAREG,
	SANY,	TANY,
	EA,	TFLOAT,
		NAREG|NASR,	RESC1,
		"	movl	AR,A1\n",

OPLTYPE,	INTBREG|INBREG|FORCC,
	SANY,	TANY,
	EA,	TSCALAR,
		NBREG|NBSR,	RESC1|RESCC,
		"	movZB	AR,A1\n",

/* Old template */
/*
 * LFL commented this out, but then it seems to create a bug in which
 * a movl is used instead of a movw.
 * If you comment it out, the cmpZL's must be changed to cmpZB's
 */
OPLTYPE,	INTEMP|FORCC,
	SANY,	TANY,
	EA,	TSCALAR,
		NTEMP,	RESC1|RESCC,
		"	movZB	AR,A1\n",

# ifndef Stanford
/* New templates */
OPLTYPE,	INTEMP|FORCC,
	SANY,	TANY,
	EA,	TINT|TUNSIGNED|TPOINT,
		NTEMP,	RESC1|RESCC,
		"	movl	AR,A1\n",
# endif Stanford

/*
 * Bill Nowicki August 1982
 * This has to make sure AR is a d register!
 */
OPLTYPE,	INTEMP|FORCC,
	SANY,	TANY,
	SCON|STARREG|SAREG|SBREG,	TSHORT,
		NTEMP,	RESC1|RESCC,
		"	extl	AR\n	movl	AR,A1\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	EA,	TFLOAT,
		NTEMP,	RESC1,
		"	movl	AR,A1\n",

OPLTYPE,	INTEMP,
	SANY,	TANY,
	EA,	TDOUBLE,
		NTEMP,	RESC1,
		"	movl	AR,A1\n	movl	UR,U1\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	SBREG,	TINT|TUNSIGNED|TPOINT,
		0,	RNULL,
		"	pea	AR@\nZP",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TINT|TUNSIGNED|TPOINT,
		0,	RNULL,
		"	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TSHORT,
		NBREG|NBSR,	RNULL,
		"	movw	AR,A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TUSHORT,
		NAREG|NASR,	RNULL,
		"	clrl	A1\n	movw	AR,A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TCHAR,
		NAREG|NASR,	RNULL,
		"	movb	AR,A1\n	extw	A1\n	extl	A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TUCHAR,
		NAREG|NASR,	RNULL,
		"	clrl	A1\n	movb	AR,A1\n	movl	A1,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TFLOAT,
		0,	RNULL,
		"	clrl	Z-\n	movl	AR,Z-\n",

OPLTYPE,	FORARG,
	SANY,	TANY,
	EA,	TDOUBLE,
		0,	RNULL,
		"	movl	UR,Z-\n	movl	AR,Z-\n",

OPLOG,	FORCC,
	SAREG|STAREG|SBREG|STBREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RESCC,
		"	cmpZL	AR,AL\nZI",

/*
 * Added by Bill Nowicki August 1982
 * and next template also fixed to not compare two constants.
 */
OPLOG,	FORCC,
	SAREG|STAREG|SBREG|STBREG,	TFLOAT,
	EA,	TFLOAT,
		0,	RESCC,
		"	cmpZL	AR,AL\nZI",

OPLOG,	FORCC,
	SNAME|SOREG|STARREG|SAREG,	TSCALAR,
	SCON,	TSCALAR,
		0,	RESCC,
		"	cmpZL	AR,AL\nZI",

#ifdef Stanford
OPLOG,	FORCC,
	EA,	TDOUBLE,
	EA,	TDOUBLE,
		0,	RESCC,
		"\tmovl\tUR,Z-\n\tmovl\tAR,Z-\n\tmovl\tUL,Z-\n\tmovl\tAL,Z-\n\tjbsr\tfcmp\n\taddl\t#16,sp\n\ttstl\td0\nZ0ZI",

#endif Stanford
CCODES,	INTAREG|INAREG,
	SANY,	TANY,
	SANY,	TANY,
		NAREG,	RESC1,
		"	moveq	#1,A1\nZN",

UNARY MINUS,	INTAREG|INAREG,
	STAREG,	TSCALAR,
	SANY,	TANY,
		0,	RLEFT,
		"	negZB	AL\n",

COMPL,	INTAREG|INAREG,
	STAREG,	TSCALAR,
	SANY,	TANY,
		0,	RLEFT,
		"	notZB	AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		NAREG,	RESC1,
		"F	movZB	AL,A1\n	addqZB	AR,AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		NAREG,	RESC1,
		"F	movZB	AL,A1\n	subqZB	AR,AL\n",

INCR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		NAREG,	RESC1,
		"F	movZB	AL,A1\n	addZB	AR,AL\n",

DECR,	INTAREG|INAREG|FOREFF,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		NAREG,	RESC1,
		"F	movZB	AL,A1\n	subZB	AR,AL\n",

INCR,	INTBREG|INBREG|FOREFF,
	EB,	TSCALAR,
	S8CON,	TSCALAR,
		NBREG,	RESC1,
		"F	movZB	AL,A1\n	addqZB	AR,AL\n",

DECR,	INTBREG|INBREG|FOREFF,
	EB,	TSCALAR,
	S8CON,	TSCALAR,
		NBREG,	RESC1,
		"F	movZB	AL,A1\n	subqZB	AR,AL\n",

INCR,	INTBREG|INBREG|FOREFF,
	EB,	TSCALAR,
	SCON,	TSCALAR,
		NBREG,	RESC1,
		"F	movZB	AL,A1\n	addZB	AR,AL\n",

DECR,	INTBREG|INBREG|FOREFF,
	EB,	TSCALAR,
	SCON,	TSCALAR,
		NBREG,	RESC1,
		"F	movZB	AL,A1\n	subZB	AR,AL\n",

PLUS,		INBREG|INTBREG,
	SBREG,	TPOINT,
	SICON,	TANY,
		NBREG|NBSL,	RESC1,
		"	lea	AL@(ZO),A1\n",

PLUS,		FORARG,
	SBREG,	TPOINT,
	SICON,	TANY,
		0,	RNULL,
		"	pea	AL@(ZO)\nZP",

MINUS,		INBREG|INTBREG,
	SBREG,	TPOINT,
	SICON,	TANY,
		NBREG|NBSL,	RESC1,
		"	lea	AL@(ZM),A1\n",

MINUS,		FORARG,
	SBREG,	TPOINT,
	SICON,	TANY,
		0,	RNULL,
		"	pea	AL@(ZM)\nZP",

ASG PLUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	addqZB	AR,AL\n",

ASG PLUS,	INBREG|FORCC,
	EB,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	addqZB	AR,AL\n",

ASG PLUS,	INAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT|RESCC,
		"	addZB	AR,AL\n",

ASG PLUS,	INBREG,
	SBREG|STBREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT,
		"	addZB	AR,AL\n",

ASG PLUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,
		"	addZB	AR,AL\n",

ASG MINUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	subqZB	AR,AL\n",

ASG MINUS,	INBREG|FORCC,
	EB,	TSCALAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	subqZB	AR,AL\n",

ASG MINUS,	INAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT|RESCC,
		"	subZB	AR,AL\n",

ASG MINUS,	INBREG,
	SBREG|STBREG,	TSCALAR,
	EA,	TSCALAR,
		0,	RLEFT,
		"	subZB	AR,AL\n",

ASG MINUS,	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,
		"	subZB	AR,AL\n",

ASG ER, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	eorZB	AR,AL\n",

ASG ER, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,
		"	eorZB	AR,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	EAA,	TSCALAR,
		0,	RLEFT|RESCC,
		"	OIZB	AR,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SCON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	OIZB	AR,AL\n",

ASG OPSIMP, 	INAREG|FORCC,
	EAA,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RESCC,
		"	OIZB	AR,AL\n",

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TSHORT,
		0,	RLEFT|RESCC,
		"	muls	AR,AL\n",

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TUSHORT,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT|RESCC,
		"	mulu	AR,AL\n",

ASG MUL,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TUSHORT,
		0,	RLEFT|RESCC,
		"	mulu	AR,AL\n",

ASG MUL,	INAREG,
	SAREG|STAREG,	TCHAR,
	EAA,	TCHAR,
		NAREG,	RLEFT,
		"\textw	AL\n\tmovb	AR,A1\n\textw	A1\n\tmuls	A1,AL\n",

ASG MUL,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG,	RLEFT,
		"\tandw	#255,AL\n\tclrw	A1\n\tmovb	AR,A1\n\tmuls	A1,AL\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TSHORT,
		0,	RLEFT|RESCC,
		"	extl	AL\n	divs	AR,AL\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TUSHORT,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT|RESCC,
		"	andl	#65535,AL\n	divu	AR,AL\n",

ASG DIV,	INAREG|FORCC,
	SAREG|STAREG,	TSHORT,
	EAA,	TUSHORT,
		0,	RLEFT|RESCC,
		"	andl	#65535,AL\n	divu	AR,AL\n",

ASG DIV,	INAREG,
	SAREG|STAREG,	TCHAR,
	EAA,	TCHAR,
		NAREG,	RLEFT,
		"\textw	AL\n\tmovb	AR,A1\n\textw	A1\n\tdivs	A1,AL\n",

ASG DIV,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG,	RLEFT,
		"\tandw	#255,AL\n\tclrw	A1\n\tmovb	AR,A1\n\tdivs	A1,AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TSHORT,
	EAA,	TSHORT,
		0,	RLEFT,
		"	extl	AL\n	divs	AR,AL\n	swap	AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TUSHORT,
	EAA,	TUSHORT|TSHORT,
		0,	RLEFT,
		"	andl	#65535,AL\n	divu	AR,AL\n	swap	AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TSHORT,
	EAA,	TUSHORT,
		0,	RLEFT,
		"	andl	#65535,AL\n	divu	AR,AL\n	swap	AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TCHAR,
	EAA,	TCHAR,
		NAREG,	RLEFT,
		"\textw	AL\n\tmovb	AR,A1\n\textw	A1\n\tdivs	A1,AL\n	swap	AL\n",

ASG MOD,	INAREG,
	SAREG|STAREG,	TUCHAR,
	EAA,	TUCHAR|TCHAR,
		NAREG,	RLEFT,
		"\tandw	#255,AL\n\tclrw	A1\n\tmovb	AR,A1\n\tdivs	A1,AL\n	swap	AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TINT|TSHORT|TCHAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	aOIZB	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SNAME|SOREG,	TSHORT,
	SONE,	TSCALAR,
		0,	RLEFT|RESCC,
		"	aOIw	AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TINT|TSHORT|TCHAR,
	SAREG,	TSCALAR,
		0,	RLEFT|RESCC,
		"	aOIZB	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TUNSIGNED|TUSHORT|TUCHAR,
	S8CON,	TSCALAR,
		0,	RLEFT|RESCC,
		"	lOIZB	AR,AL\n",

ASG OPSHFT, 	INAREG|FORCC|RESCC,
	EA,	TUSHORT,
	SONE,	TSCALAR,
		0,	RLEFT,
		"	lOIw	AL\n",

ASG OPSHFT, 	INAREG|FORCC,
	SAREG,	TUNSIGNED|TUSHORT|TUCHAR,
	SAREG,	TSCALAR,
		0,	RLEFT|RESCC,
		"	lOIZB	AR,AL\n",

UNARY CALL,	INTAREG,
	SBREG|SNAME|SOREG|SCON,	TANY,
	SANY,	TANY,
		NAREG|NASL,	RESC1, /* should be register 0 */
		"ZC\n",

SCONV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"",

SCONV,	INTAREG,
	STAREG,	TSCALAR,
	SANY,	TUCHAR,
		0,	RLEFT,
		"	andl	#255,AL\n",

SCONV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TUSHORT,
		0,	RLEFT,
		"	andl	#65535,AL\n",

SCONV,	INTAREG,
	STAREG,	TINT|TUNSIGNED|TPOINT,
	SANY,	TSHORT|TCHAR,
		0,	RLEFT,
		"",

SCONV,	INTAREG,
	STAREG,	TCHAR,
	SANY,	TSHORT|TUSHORT,
		0,	RLEFT,
		"	extw	AL\n",

SCONV,	INTAREG,
	STAREG,	TCHAR,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	extw	AL\n	extl	AL\n",

SCONV,	INTAREG,
	STAREG,	TSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	extl	AL\n",

SCONV,	INTAREG,
	STAREG,	TUCHAR,
	SANY,	TSCALAR,
		0,	RLEFT,
		"	andl	#255,AL\n",

SCONV,	INTAREG,
	STAREG,	TUSHORT,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RLEFT,
		"	andl	#65535,AL\n",

SCONV,	INAREG|INTAREG,
#ifndef Stanford
	  /*
	   * SU adds in STAREG and SBREG; which is correct???
	   */
	SNAME|SOREG|SCON|SAREG,	TINT|TUNSIGNED|TPOINT|TSHORT|TUSHORT,
#else Stanford
	EA,	TINT|TUNSIGNED|TPOINT|TSHORT|TUSHORT,
#endif Stanford
	SANY,	TSHORT|TUSHORT|TCHAR|TUCHAR,
		0,	RLEFT,
		"ZT",

SCONV,	INAREG|INTAREG,
	EA,	TDOUBLE,
	SANY,	TFLOAT,
		0,	RLEFT,
		"",

SCONV,	INAREG|INTAREG,
	EA,	TFLOAT,
	SANY,	TDOUBLE,
		NAREG|NASR,	RESC1,
		"	movl	AL,A1\n	clrl	U1\n",

SCONV,  FORARG,
	EA,	TFLOAT,
	SANY,	TDOUBLE,
		0,	RNULL,
		"	clrl	Z-\n	movl	AL,Z-\n",

STASG,	FOREFF,
	SNAME|SOREG,	TANY,
#ifndef Stanford
	SCON|SBREG,	TANY,
#else Stanford
	SCON|SOREG|SBREG,	TANY,
#endif Stanford
		0,	RNOP,
		"ZS",

STASG,	INTBREG|INBREG,
	SNAME|SOREG,	TANY,
	STBREG,	TANY,
		0,	RRIGHT,
		"ZS",

STASG, INBREG|INTBREG,
	SNAME|SOREG,	TANY,
	SCON|SBREG,	TANY,
		NBREG,	RESC1,
		"ZS	movl	AR,A1\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TINT|TUNSIGNED|TPOINT,
		0,	RNOP,
		"	.long	CL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TSHORT|TUSHORT,
		0,	RNOP,
		"	.word	CL\n",

INIT,	FOREFF,
	SCON,	TANY,
	SANY,	TCHAR|TUCHAR,
		0,	RNOP,
		"	.byte	CL\n",

	/* Default actions for hard trees ... */

# define DF(x) FORREW,SANY,TANY,SANY,TANY,REWRITE,x,""

UNARY MUL, DF( UNARY MUL ),

INCR, DF(INCR),

DECR, DF(INCR),

ASSIGN, DF(ASSIGN),

STASG, DF(STASG),

OPLEAF, DF(NAME),

OPLOG,	FORCC,
	SANY,	TANY,
	SANY,	TANY,
		REWRITE,	BITYPE,
		"",

OPLOG,	DF(NOT),

COMOP, DF(COMOP),

INIT, DF(INIT),

OPUNARY, DF(UNARY MINUS),


ASG OPANY, DF(ASG PLUS),

OPANY, DF(BITYPE),

FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	"help; I'm in trouble\n" };
