# include <am9513.h>

/* Timer addresses on the SUN system */
/* This is for the PC board version 1 (win October 1981) */

#define ADTimCom	*(unsigned short*)0x800002	/* for Commands */
#define ADTimReg	*(unsigned short*)0x800000	/* for Registers */

/* Input frequency is 4MHz */

/*  Channel Assignment is */

#define	TIMRefresh	3	/* for refresh task */
#define TSCountR	TSCount3
#define TIMAClk		4	/* Ch.A clock */
#define TSCountA	TSCount4
#define TIMBClk		5	/* Ch.B clock */
#define TSCountB	TSCount5
#define TIMInter	2	/* Interrupt Clock, Level 6 */
#define TSInter		TSCount2
#define TIMClock	1	/* Counter Clock */
#define TSClock		TSCount1

#define ResTIMER \
	TCReset;		/* Master Reset */\
	TCLdCnt(TSAll);		/* Reset All counters */\
	TC16Bus			/* Enter 16 bit Bus mode */

/* Uart Timing:  the timer functions in "MODE D"... */
#define TMODuart (unsigned short)(TCMFall+TCMNoGa+TCMF1+TCMDiSpG+\
			TCMRldLd+TCMCntRp+TCMBinCt+TCMDwnCt+TCMTCTog)
	/* with a square wave of 16 * 9615.4Hz */
#define TFRQuart 13

/* Refresh Timing: also "MODE D" */
#define TMODrefr TMODuart
	/* frequency: 500Hz */
#define TFRQrefr 8000

#define initREFR \
	TCSetGrp(TIMRefresh,TMODrefr,TFRQrefr);\
	TCArmCnt(TSCountR)

/* Counter clock Timing:  it counts at any of the available frequencies */
#define TMODcclk (unsigned short)(TCMFall+TCMNoGa+TCMDiSpG+\
			TCMRldLd+TCMCntRp+TCMBinCt+TCMUpCt+TCMOutLo)

/* Setting up the counting clock: the parameter 'freq' must be 
	1 to 5 to select F1 to F5 */
#define TCSetClk(freq) \
	TCLoDaPo(TSModeRg+TIMClock);\
	TRLoad(TMODcclk+TCMF/**/freq);\
	TCDisDP;\
	TCLoDaPo(TSHoldRg+TIMClock)

/* Reading the counting clock */
#define TIMRdClk	(TCSavCnt(TSAll),ADTimReg)

/* Resetting the counting clock */
#define TIMClkRs	TCLdArCnt(TSClock)


