/*		Header file for 68000 Systems Programs 

				V.R. Pratt
				Jan., 1981
*/

#include "m68000.h"

/* Macro to define storage allocation routines for n objects of type T, where
sizeof(T)>=4.

All aspects of the space, including declaration of its storage and its
avail pointer, are handled automatically by the macro.  The initialization
process aligns objects on boundaries that are a multiple of their size; the
method used may waste up to one object's worth of storage.

Usage:
allocator(T,n)  declare array of n T's; defines the following three functions:

T *allocT();	allocate a type T object, return pointer to it
freeT(q) T *q;	return to free storage the object *q of type T
initT();	initialize free storage to contain n objects of type T
*/

#define allocator(T,n)							\
									\
T *avail/**/T;								\
char space/**/T[n+1][sizeof(T)];					\
									\
T *alloc/**/T()								\
 {d0 = (int)avail/**/T;							\
  if (d0) avail/**/T = *(T**)d0;					\
  return (T*)d0;							\
 }									\
									\
free/**/T(q) T *q;							\
 {*(T**)q = avail/**/T;							\
  avail/**/T = q; /* a0 holds q */  					\
 }									\
									\
init/**/T()								\
 {register T *i = (T*)((int)(space/**/T[1])-1 & -sizeof(T));		\
  avail/**/T = i;							\
  while (i < (T*)space/**/T[n-1]) *(T**)i++ = i+1;			\
  *(T**)i = 0;								\
 }

