/*================  Motorola 6850 ACIA Specifications ================

Author:  V. Pratt 
Date:    August, 1980

Use as a #include file in C programs

Synopsis.

	The Motorola 6850 Asynchronous Communications Interface Accessory
contains a receiver and a transmitter connected to a full duplex line to
the outside world.  Though both on the same chip, the two components act
almost entirely independently, sharing only the interrupt request line that
signals the 68000 that the ACIA needs attention.

	The 6850 appears to the 68000 as two bytes in memory, at addresses given
below.  The first byte is the status register, the second the data register. 
Fetching the status byte yields information about the ACIA such as whether
it is ready to accept another character for transmission, has another
character from outside, etc.  Storing into the status byte programs the
device for speed, bit configuration within the byte (number of data bits,
even odd or no parity, and number of stop bits), and independent enabling
of the receiver and transmitter interrupts.

	A more detailed account can be found in the Motorola 6850
specifications.
*/

#define M6850

/* Status symbols */

#define ACIA1RcReady	(ACIA1Status&(unsigned char)1)
#define ACIA1TrReady	(ACIA1Status&(unsigned char)2)
#define ACIA1DaCarDet	(ACIA1Status&(unsigned char)4)
#define ACIA1ClrToSend	(ACIA1Status&(unsigned char)8)
#define ACIA1FramErr	(ACIA1Status&(unsigned char)16)
#define ACIA1RcOverun	(ACIA1Status&(unsigned char)32)
#define ACIA1ParityErr	(ACIA1Status&(unsigned char)64)
#define ACIA1IntReq	(ACIA1Status&(unsigned char)128)

#define ACIA2RcReady	(ACIA2Status&(unsigned char)1)
#define ACIA2TrReady	(ACIA2Status&(unsigned char)2)
#define ACIA2DaCarDet	(ACIA2Status&(unsigned char)4)
#define ACIA2ClrToSend	(ACIA2Status&(unsigned char)8)
#define ACIA2FramErr	(ACIA2Status&(unsigned char)16)
#define ACIA2RcOverun	(ACIA2Status&(unsigned char)32)
#define ACIA2ParityErr	(ACIA2Status&(unsigned char)64)
#define ACIA2IntReq	(ACIA2Status&(unsigned char)128)

/* Programming symbols */

#define	Div16		1
#define	Div64		2
#define	ACReset		3

#define Da7EvSt2	0
#define Da7OdSt2	4	
#define Da7EvSt1	8	
#define Da7OdSt1	12
#define Da8St2		16
#define Da8St1		20
#define Da8EvSt1	24
#define Da8OdSt1	28

#define	TrIntEnable	32
#define RTSHi		64
#define TrBreak		96

#define RecIntEnable	128


