/* Lisp header file */
/* V. R. Pratt			October 1981 */

/*	This is the header file for a simple Lisp for the 68000.  The Lisp is
still under development, and not yet available for general use.  */

#define NUMCELLS 24000

struct List {
	struct List *head;
	struct List *tail;
};

typedef struct List *list;

#define NIL (list)0

#define car(x) ((x)->head)
#define cdr(x) ((x)->tail)
#define caar(x) car(car(x))
#define cadr(x) car(cdr(x))
#define cdar(x) cdr(car(x))
#define cddr(x) cdr(cdr(x))
#define caaar(x) car(car(car(x)))
#define caadr(x) car(car(cdr(x)))
#define cadar(x) car(cdr(car(x)))
#define caddr(x) car(cdr(cdr(x)))
#define cdaar(x) cdr(car(car(x)))
#define cdadr(x) cdr(car(cdr(x)))
#define cddar(x) cdr(cdr(car(x)))
#define cdddr(x) cdr(cdr(cdr(x)))
#define caaaar(x) car(car(car(car(x))))
#define caaadr(x) car(car(car(cdr(x))))
#define caadar(x) car(car(cdr(car(x))))
#define caaddr(x) car(car(cdr(cdr(x))))
#define cadaar(x) car(cdr(car(car(x))))
#define cadadr(x) car(cdr(car(cdr(x))))
#define caddar(x) car(cdr(cdr(car(x))))
#define cadddr(x) car(cdr(cdr(cdr(x))))
#define cdaaar(x) cdr(car(car(car(x))))
#define cdaadr(x) cdr(car(car(cdr(x))))
#define cdadar(x) cdr(car(cdr(car(x))))
#define cdaddr(x) cdr(car(cdr(cdr(x))))
#define cddaar(x) cdr(cdr(car(car(x))))
#define cddadr(x) cdr(cdr(car(cdr(x))))
#define cdddar(x) cdr(cdr(cdr(car(x))))
#define cddddr(x) cdr(cdr(cdr(cdr(x))))

#define list1(a)		(ncons(a))
#define list2(a,b)		(cons((a),list1(b)))
#define list3(a,b,c)		(cons((a),list2(b,c)))
#define list4(a,b,c,d)		(cons((a),list3(b,c,d)))
#define list5(a,b,c,d,e)	(cons((a),list4(b,c,d,e)))
#define list6(a,b,c,d,e,f)	(cons((a),list5(b,c,d,e,f)))

#define rplaca(a,b) car(a) = b
#define rplacd(a,b) cdr(a) = b

#define setq(a,b) a = b

#define null(x)	((x) == NIL)
#define atom(x) ((x) < conscells || &conscells[NUMCELLS] < (x))
#define numberp(x) ((x) < NIL)

extern struct List conscells[];
extern list cons(), ncons(), append(), mapcar(), mapc(), mapcan(),
A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,
OR,AND,NOT,PLUS,DIFFERENCE,TIMES,QUOTIENT;

#define _E(x) (list)((x)-(1<<30))	/* encode number */
#define _N(x) ((int)(x)+(1<<30))	/* decode number */

