/* Data structure for general bitmaps in memory, for Sun workstation.
 * The structure is compatible with character bitmaps used by <sfont.h>;
 * Also, you can refer to sub-sets of raster.
 * Basically an extension of mem_raster (see <rasterops.h>),
 * in that a raster is stored in columns of 16-bit words.
 * Per Bothner - Mar 1983
 */

/* various codes for types of rasters */

#define	IsNullRaster 0	/* nothing */
#define MemoryRaster 0x04
#define LinkedRaster 0x02
     /* LinkedRaster implies that the 'next' field is used */
#define HeadRaster 0x1
#define	IsHeadRaster (MemoryRaster|LinkedRaster|HeadRaster)
#define	IsSubRaster (MemoryRaster|LinkedRaster)
#define	IsFbRaster 9
#define SpecialRaster 0x40
#define InverseRaster 0x80 /* 1 is "white" instead of as normal "black" */
#define HiddenHeadRaster (MemoryRaster|LinkedRaster|HeadRaster|SpecialRaster)

typedef struct _MemRaster
  {
    /* the next 3 remaining fields are as in struct mem_raster in <rasterops.h> */
    short height;	/* of raster, in pixels */
    short width;	/* of raster, in pixels */
    short *start;	/* address of first word of raster */
    unsigned char where;
    char bitOffset;	/* 0..15 - number of bits to skip in first column */
    short stride;	/* height of each column of words.Always <= height.
			 * If the raster is a sub-raster, this will be the
			 * height of the ancestor raster. */
    struct _MemRaster *next; /* link together subrasters in a circular list */
  } MemRaster;

#define GenToFbRaster(p) ((struct fb_raster *) p)

/* scale factors that may be passed to DisplayRaster */
/* scale should be an unsigned char, where only the left two bits can be flags */
#define Scale1  0
#define Scale2  1
#define Scale4  2
#define Scale8  3
#define Scale16 4
#define ScaleFramed 0x80	/* this can be or'ed with Scale8 or Scale 16 */

/* code to pass to ChangeBit */
typedef enum _ChangeBitCode
  {
    ClearBit,
    SetBit,
    InvertBit,
    CopyBit
   } ChangeBitCode;
