/*
 * V Copyright (c) 1982 by David Cheriton, all rights reserved.
 * (Transliterated from Zed and Verex)
 *
 * V team interface manifests and message formats.
 */

#ifndef VTEAM
#define VTEAM
#include "Vio.h"


/*
 * Stdio defns.
 */

typedef struct
  {
    ProcessId	stdinserver;
    ProcessId	stdoutserver;
    ProcessId	stderrserver;
    InstanceId	stdinfile;
    InstanceId  stdoutfile;
    InstanceId	stderrfile;
    short	rootflags;
    ProcessId	nameserver;
    ContextId	contextid;
    ProcessId	kernelpid;
  } RootMessage;

/* Root flags - bit assignments */

#define STDOUT_APPEND		0x0001 	/* Open std output in append mode */
#define STDIN_REDIRECTED	0x0002	/* Std input has been redirected */
#define STDOUT_REDIRECTED	0x0004	/* Std output has been redirected */
#define STDERR_REDIRECTED	0x0008	/* Std error output redirected */
#define RELEASE_INPUT		0x0010	/* Release std input on close */
#define RELEASE_OUTPUT		0x0020  /* Release std output on close */
#define RELEASE_ERR		0x0040	/* Release err output on close */
#define STDERR_APPEND		0x0080	/* Open std err output for append */


/*
 * Team server defns.
 */

/* Request codes.
*/  
#define TeamLoadRequest 0x1800

/* Request types.
*/
#define SpecificTeam 0
#define AllTeams 1
#define RequestorTeams 2

/*
 * Request & Reply Message Formats
 */

typedef struct				/* Team load request message */
  {
    SystemCode requestcode;
    ProcessId fileserver;	/* Server to load from. */
    InstanceId fileid;		/* Server file instance to load from. */
    int noOwner;		/* True if the loaded team should be owned by
				   the system rather than the requestor. */
    unsigned unspecified[3];
    char *bufferptr;		/* Points to additional load parameters such
				   as the io file instances. */
    unsigned bytecount;
  } LoadTeamRequest;

typedef struct				/* Team load reply message */
  {
    SystemCode replycode;
    ProcessId rootPid;		/* Pid of root process of loaded team. */
  } LoadTeamReply;

typedef struct				/* Team termination request message */
  {
    SystemCode requestcode;
    short requestType;		/* Specifies whether to terminate a specific
				   team, all the requestor's teams, or all
				   teams. */
    ProcessId rootPid;		/* Root process pid of specific team to
				   terminate. */
    int status;			/* Status code associated with the
				   termination. */
  } ExitTeamRequest;

typedef LoadTeamReply ExitTeamReply;

typedef struct				/* Team information request message */
  {
    SystemCode requestcode;
    short requestType;		/* Specifies if info. is desired for a
				   specific team, all the requestor's teams,
				   or all teams. */
    ProcessId ownerPid;		/* Pid of owner of teams for which info.
				   should be returned. */
    ProcessId rootPid;		/* Pid of root process of a team if a
				   specific team is designated. */
    unsigned unspecified[3];
    char *bufferptr;		/* Ptr to a segment to use for returning
				   additional information.  In the case of a
				   specific team, the file name is returned.
				   In the case of a request for all the
				   requestor's teams or all teams, the pids
				   of the root processes of all the
				   designated teams are returned.  In these
				   cases, the other fields of the message are
				   returned with meaningless values. */
    unsigned bytecount;
  } QueryTeamRequest;

typedef struct				/* Team information reply message */
  {
    SystemCode replycode;
    short numTeams;		/* Specifies how many teams information is
				   being returned on.  If only 1, then the
				   following 3 msg fields have meaning;
				   otherwise bufferptr is used to return the
				   root pids of all the teams. */
    ProcessId ownerPid;		/* Pid of owner of a specified team. */
    ProcessId rootPid;		/* Pid of root process of a specified team. */
    ProcessId loadServer;	/* Pid of file server from which a specified
				   team was loaded. */
    unsigned unspecified[2];
    char *bufferptr;		/* Ptr to a segment to use for returning
				   additional information.  In the case of a
				   specific team, the file name is returned.
				   In the case of a request for all the
				   requestor's teams or all teams, the pids
				   of the root processes of all the
				   designated teams are returned.  In these
				   cases, the other fields of the message are
				   returned with meaningless values. */
    unsigned bytecount;
  } QueryTeamReply;

#endif
