/*
 * V Copyright (c) 1982 by David Cheriton, all rights reserved.
 * (Transliterated from Zed and Verex)
 *
 * V session interface manifests and message formats.
 */

#ifndef VSESSION
#define VSESSION
#include "Venviron.h"
#include "Vio.h"

typedef struct
  {
    SystemCode	requestcode;
    short	fill[11];
    char	*username;
    unsigned	namelength;
  } GetUserNumberRequest;

typedef struct
  {
    SystemCode	replycode;
    short	fill;
    int		usernumber;
    int		gid;
  } GetUserNumberReply;

typedef struct
  {
    SystemCode	requestcode;
    short	fill[11];
    char	*hostname;
    unsigned	namelength;
  } LookupServerRequest;

typedef struct
  {
    SystemCode	replycode;
    short	fill[3];
    ProcessId	serverpid;
  } LookupServerReply;

typedef struct
  {
    SystemCode		requestcode;
    short unsigned	filenameindex;	/* First byte of filename to use */
    short unsigned	type;		/* The type of file to create */
    short unsigned	filemode;
    ProcessId		sessionowner;	/* who will own this session */
    unsigned		fill[2];	
    ContextId		contextid;	/* Context used to interpret name */
    char		*filename;
    unsigned		filenamelen;
  } CreateSessionRequest;

#define sessionpw sessionname
#define sessionpwlen sessionnamelen

typedef struct
  {
    SystemCode		replycode;
    InstanceId		fileid;		/* File instance identifier */
    ProcessId		fileserver;	/* Server process for I/O requests */
    unsigned		blocksize;	/* Maximum block size for I/O */
    unsigned short	filetype;	/* Instance type attributes */
    unsigned short	filelastbytes;  /* Number of bytes in last block */
    unsigned		filelastblock;	/* Laxt block in file */
    unsigned		filenextblock;	/* Next block to read if READABLE STREAM */
  } CreateSessionReply;

#endif VSESSION
