/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, All Rights reserved.
 * (Transliterated from Zed and Verex)
 *
 * V Kernel Process Manifests and Structs
 */

#ifndef VPROCESS

#include "Venviron.h"

/* Values for state field of process descriptor */

#define READY		1	/* Eligible for execution */
#define RECEIVE_BLKED	2	/* Blocked waiting for a message */
#define AWAITING_REPLY	3	/* Blocked until reply is received */
#define SEND_BLKED	4	/* Blocked sending a message */
#define AWAITING_INT	5	/* Awaiting device interrupt */
#define DELAYING	6	/* Blocked for clicks given by blocked_on */
#define GETPID_BLKED	7	/* Blocked for a remote GetPid */
#define MOVEFROM_BLKED  8	/* Blocked for remote MoveFrom */
#define MOVETO_BLKED	9	/* Blocked for remote MoveTo */
#define REPLIED_TO	10	/* Alien replied to */
#define FORWARDED_TO	11	/* Alien forwarded to */

/* Processor State as stored in the process descriptor */
typedef struct
  {
	/* Machine dependent fields */
	Unspec	regs[16];	/* 8 data + 8 address registers */
				/* Supervisory stack ptr not stored */
	short	sr;		/* Status register for rte */
	Unspec	pc;		/* Pc register for rte */
	short	context;	/* Context of associated team */

	/* Machine independent fields */
        Unspec	*perProcess;	 /* Pointer to per process area */
        Unspec	**perProcessLoc; /* perProcess pointer stored at
				  * this address on a process switch */
  } Processor_state;

#define USER_STACK_POINTER regs[15]		/* User Stack pointer in A7 */

/* Bits in status register */
#define TRACE_MODE		(1<<15)
#define SUPERVISOR_STATE	(1<<13)
#define INTERRUPT_MASK		(7<<8)
#define EXTEND_BIT		(1<<4)
#define NEGATIVE_BIT		(1<<3)
#define ZERO_BIT		(1<<2)
#define OVERFLOW_BIT		(1<<1)
#define CARRY_BIT		(1<<0)


/* Structure returned by QueryProcessState */
typedef struct
  {
    /* team fields */
    Process_id	team_root;
    short	team_priority;
    short	team_user;
    char	*team_size;
    /* process fields */
    Process_id  link;
    Process_id	father;
    Process_id  brother;
    Process_id	son;
    short	state;
    short	priority;
    Process_id	blocked_on;
    Process_id	forwardedby;
    char	msg[MSG_SIZE];
    Process_id  msg_queue;
    Process_id	msg_queue_end;
    Processor_state proc_state;
  } 
    ProcessBlock;


/* Pointers for use in debugging */
#define P_Pd_bundle (*(Process ***) 0xC0)
#define P_Active (*(Process ***) 0xC4)
#define P_Readyq_head (*(Process ***) 0xC8)
#define P_Delayq_head (*(Process ***) 0xCC)

#endif VPROCESS
