/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * V-System naming manifests, types and structures.
 */

#ifndef VNAMING

#define VNAMING

#include "Venviron.h"
#include "Vio.h"

/* Structures defining the template structure of standard name request
 * and reply messages.
 */
typedef struct
  {
    SystemCode		requestcode;
    short unsigned	nameindex;	/* First byte of segment to use as name */
    unsigned		unspecified[4];	/* Name server-dependent */
    ContextId		namecontextid;	/* Context used to interpret name */
    char		*nameptr;
    unsigned		namelength;
  } NameRequest;

/* Structures defining the template structure of context request
 * and reply messages.
 */
typedef struct
  {
    SystemCode		requestcode;
    short unsigned	nameindex;	/* First byte of name to use */
    ProcessId		serverpid;	/* Server pid to assign to name */
    ContextId		contextid;	/* Context to assign to name */
    short unsigned	entrytype;	/* Name type information */
    InstanceId		instanceid;	/* Associated instance if any */
    unsigned		otherinfo;	/* Other info associated with name */
    ContextId		namecontextid;	/* Context used to interpret name */
    char		*nameptr;
    unsigned		namelength;
  } ContextRequest;

typedef struct
  {
    SystemCode		replycode;
    short		blat;		/* unused */
    ProcessId		serverpid;
    ContextId		contextid;
    short unsigned	entrytype;	/* Name type information */
    InstanceId		instanceid;	/* Associated instance if any */
    unsigned		otherinfo;	/* Other info associated with name */
    unsigned		unused;
    char		*nameptr;
    unsigned		namelength;	/* length of name returned */
  } ContextReply;

/* Well known context manifests */
#define MAX_WELL_KNOWN_CONTEXTS	4
#define DEFAULT_CONTEXT		0
#define PUBLIC_CONTEXT		1
#define LOGIN_CONTEXT		2
#define ANY_CONTEXT		3

/* Bits in the entrytype field, used with local name server */
#define LOGICAL_PID	0x0100
#define SESSION		0x0200

#endif VNAMING
