/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * MC68000 Exceptions
 */

#include "Venviron.h"

/* MC 68000 exception types and addresses */

#define BUSERROR	0x008
#define ADDRERROR	0x00c
#define ILLINST		0x010
#define ZERODIV		0x014
#define CHKINST		0x018
#define TRAPVINST	0x01c
#define PRIVVIOL	0x020
#define TRACETRAP	0x024
#define EMU1010		0x028
#define EMU1111		0x02c
#define SPURINT		0x060
#define INT1		0x064
#define INT2		0x068
#define INT3		0x06c
#define INT4		0x070
#define INT5		0x074
#define INT6		0x078
#define INT7		0x07c
#define TRAP0		0x080
#define TRAP1		0x084
#define TRAP2		0x088
#define TRAP3		0x08c
#define TRAP4		0x090
#define TRAP5		0x094
#define TRAP6		0x098
#define TRAP7		0x09c
#define TRAP8		0x0a0
#define TRAP9		0x0a4
#define TRAP10		0x0a8
#define TRAP11		0x0ac
#define TRAP12		0x0b0
#define TRAP13		0x0b4
#define TRAP14		0x0b8
#define TRAP15		0x0bc


/* Further information about bus errors */
#define OUT_OF_RANGE	0
#define SPURIOUS	1
#define SYSTEM_SPACE	2
#define PROTECTION	3
#define PAGE_INVALID	4
#define SEG_INVALID	5
#define MB_TIMEOUT	6
#define PARITY		7

/*
 * Bits in the "code" field below
 */
#define RW_BIT		(1<<4)
#define IN_BIT		(1<<3)
#define SUPER_BIT	(1<<2)
#define PROGRAM_BIT	(1<<1)
#define DATA_BIT	(1<<0)
#define INT_ACK		(DATA_BIT|PROGRAM_BIT|SUPER_BIT)

/* Format of message received from a kernel exception,
 * as sent to the exception server
 */
typedef struct
  {
    SystemCode		requestcode;	/* EXCEPTION_REQUEST */
    unsigned short	type;		/* Machine-specific exception type */
    unsigned short	buserrortype;	/* Additional detail on bus errors */
    unsigned short	code;		/* Type of memory reference */
    unsigned		accaddr;	/* Access address for bus and address errors */
    unsigned		instruction;	/* First word of instruction causing fault */
    unsigned		status;		/* status register */
    unsigned		errpc;		/* Program counter */
    char		*segment;	/* Beginning of team segment */
    unsigned		segmentsize;	/* Team segment size */
  } ExceptionRequest;

/* Format of message used to register an exception handler.
 */
typedef struct
  {
    SystemCode	requestcode;		/* REGISTER_HANDLER */
    int regFlag;			/* Indicates whether to register (1)
					   or unregister (0) handler. */
    ProcessId handlerPid;		/* Pid of exception handler */
    ProcessId regPid;			/* Pid of process registering for */
  } RegHandlerRequest;
