.xlist
	include	biosdata.asm
.list
cgroup	group	code
code	segment byte public 'code'
	extrn	initialize:near
	public	memtest
	assume	cs:code
;External Peripherals
;--------------------

;Serial Communications port





;
;
;  2681 EQUATES
;
;
uart_base	equ	80h
mode_rega	equ	uart_base
stat_reg	equ	2
stat_rega	equ	uart_base+stat_reg
clock_reg	equ	2
command_reg	equ	4
command_rega	equ	uart_base+command_reg
clock_rega	equ	uart_base+clock_reg
tx_rega		equ	6+uart_base
rx_rega		equ	6+uart_base
aux_cr		equ	8+uart_base
int_reg		equ	0ah+uart_base
mode_regb	equ	mode_rega+10h
stat_regb	equ	stat_rega+10h
command_regb	equ	command_rega+10h
clock_regb	equ	clock_rega+10h
tx_regb		equ	tx_rega+10h
rx_regb		equ	rx_rega+10h
out_cr		equ	uart_base+1ah
in_reg		equ	uart_base+1ah
sio_out_set	equ	uart_base+1ch
sio_out_clr	equ	uart_base+1eh
;
reset_rx	equ	00100000b
reset_tx	equ	00110000b
disable_channel	equ	00001010b
enable_channel	equ	00000101b
reset_mr_ptr	equ	00010000b
mode1		equ	10010011b
mode2		equ	00011111b
auxa		equ	10000000b
enable_all	equ	00100010b
enable_1	equ	00000010b
enable_2	equ	00100000b
rx_rdy		equ	1b
tx_rdy		equ	100b
enable_ctsa	equ	1b
enable_ctsb	equ	10b
enable_dtra	equ	100b
enable_dtrb	equ	1000b
out_config	equ	0
xoff		equ	13h

baudb		equ	66h		;1200 baud
;
;
run_monitor	equ	4
jump96		equ	40h

MEMTEST:
	CLI
	MOV	AX,0
	MOV	DS,AX
	MOV	SS,AX
	JMP	SIGNON1


;Text Output to Console
; pointed to by si, text terminated by 80h or control character

TXTOUT:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	TXTOUT	;not ready?

	MOV	AL,CS: [SI] ;get character
	OUT	tx_rega,AL ;print it
	AND	AL,80H	;test it
	JZ	TXTOT1	;not the last?
	JMP	DI	;all done, return
TXTOT1:	INC	SI	;point to next character
	jmp	short	TXTOUT



;Input from Console
;  character returned in al converted to upper case

CHRIN:	IN	AL,stat_rega
	AND	AL,rx_rdy
	JZ	CHRIN	;not ready?

	IN	AL,rx_rega
	AND	AL,7FH
	CMP	AL,'A'
	JB	CHRNXT
	CMP	AL,'z'
	JA	CHRNXT
	AND	AL,5FH	;convert to upper case
CHRNXT:	JMP	DI 	;return with character



;Enter Data into BP

WRD:	MOV	AH,0
	MOV	BP,0
	MOV	DI,OFFSET WRD2

WRD1:	JMP	CHRIN
WRD2:	MOV	CH,AL
	CMP	AL,0DH
	JNE	WRD3	;not done?
	JMP	SP	;return
WRD3:	SUB	AL,'0'
	JS	WRD1	;not hex?
	CMP	AL,10
	JB	WRD4	;10>entry?
	CMP	AL,'A'-'0'
	JB	WRD1	;not hex?
	SUB	AL,'A'-10-'0'
	CMP	AL,0FH
	JA	WRD1	;not hex?

WRD4:	MOV	CL,4
	SHL	BP,CL
	OR	BP,AX

WRD5:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	WRD5
	MOV	AL,CH
	OUT	tx_rega,AL
	JMP	WRD1



;Print Word in SI

PWRD:	MOV	CH,4	;print 4 nibbles

PWRD1:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	PWRD1	;port not ready?

	MOV	CL,4
	ROL	SI,CL	;get the right nibble
	MOV	AX,SI
	AND	AL,0FH
	ADD	AL,'0'
	CMP	AL,'9'
	JBE	PWRD2	;ascii ok?
	ADD	AL,7
PWRD2:	OUT	tx_rega,AL
	DEC	CH
	JNZ	PWRD1	;more to do?

;now print a space
PWRD3:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	PWRD3
	MOV	AL,' '
	OUT	tx_rega,AL
	JMP	DI


SIGNON1:
	MOV	SI,OFFSET MESG1
PROMPT:	MOV	DI,OFFSET CMNDS
	JMP	TXTOUT

MESG1 	DB	0CH,0AH,0DH
	DB	'         SLICER memory test',0ah,0ah,0dh
	DB      '   Ddddd<CR> enter data dddd',0dh,0ah
	DB	'   Aaaaa<CR> enter address aaaa',0ah,0dh
	DB	'   Sssss<CR> set segment register to ssss',0dh,0ah
	DB	'   R  read from location ssss:aaaa',0dh,0ah
	DB	'   W  Write dddd to location ssss:aaaa',0dh,0ah
	DB	'   T  test memory segment ssss',0dh,0ah
	DB	'   E  exit to main monitor',0ah,0dh
MESG2	DB	0DH,0AH,'>'+80h


PROMPT1:
	JMP PROMPT
CMNDS:
	MOV	DI,OFFSET CMDTST
	JMP	CHRIN

CMDTST:	MOV	AH,AL
CMND0:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	CMND0
	MOV	AL,AH
	OUT	tx_rega,AL 	;echo character back to terminal

	CMP	AL,'A'		;command option ?
	JZ	GETADR
	CMP	AL,'D'
	JZ	GETDAT
	CMP 	AL,'E'
	JNZ	NOTEE
	mov	ax,data
	mov	ds,ax
	assume	ds:data
	mov	reset_location,1234h
	jmp	initialize
	assume	ds:nothing
NOTEE:
	CMP	AL,'R'
	JZ	DRAMRD
	CMP	AL,'S'
	JZ	DTSEG
	CMP	AL,'T'
	JZ	DRAMTST
	CMP	AL,'W'
	jmp	short	DRAMWR

CMND1:	MOV	SI,OFFSET MESG2
	jmp	short	PROMPT1



;D RAM write cycle
DRAMWR:	MOV	AX,DX
	MOV	[BX],AX
	IN	AL,stat_rega
	AND	AL,rx_rdy
	JZ	DRAMWR
	jmp	short	CMND1

;D RAM read cycle
DRAMRD:	MOV	AX,DX
	MOV	[BX],AX
RDCYCL:	MOV	AX,[BX]
	IN	AL,stat_rega
	AND	AL,rx_rdy
	JZ	RDCYCL
	jmp	short	CMND1


;Get Address into bx
GETADR:	MOV	SP,OFFSET ADR1
	JMP	WRD
ADR1:	MOV	BX,BP
	jmp	short	CMND1


;GET Data into dx
GETDAT:	MOV	SP,OFFSET DAT1
	JMP	WRD
DAT1:	MOV	DX,BP
	jmp	short	CMND1


;Set data segment register
DTSEG:	MOV	SP,OFFSET DTSEG1
	JMP	WRD
DTSEG1:	MOV	DS,BP
	jmp	short	CMND1



;D RAM test
DRAMTST:
	MOV	CX,SS
	XOR	CX,-1
	MOV	SS,CX
	MOV	BX,0
	MOV	BP,BX

MTST1:	MOV	AX,CS:[BX]
	XOR	AX,CX
	MOV	DS:[BP],AX	;move data to ram

	CMP	BX,4000h ;0FFFEH AND OFFSET MONTOP
	JNE	MTST2	;not at end of test pattern?
	MOV	BX,-2	;restart test pattern
MTST2:	INC	BX
	INC	BX
	INC	BP
	INC	BP
	JNZ	MTST1	;ram not full?


MTST6:	MOV	BX,BP

MTST3:	MOV	AX,DS:[BP]
	XOR	AX,CX
	CMP	AX,CS:[BX]
	JNZ	MERROR

MTST4:	CMP	BX,4000h	;0FFFEH AND OFFSET MONTOP
	JNE	MTST5	;not at end of test pattern?
	MOV	BX,-2	;restart test pattern
MTST5:	INC	BX
	INC	BX
	INC	BP
	INC	BP
	JNZ	MTST3	;not all tested?

MTST9:	IN	AL,stat_rega
	TEST	AL,tx_rdy
	JZ	MTST9
	MOV	AL,'.'
	OUT	tx_rega,AL



	IN	AL,stat_rega
	AND	AL,rx_rdy
	JZ	MTSTA
	IN	AL,rx_rega
	CMP	AL,0DH
	JNZ	MTST8
	JMP	CMND1


MTST8:
	CMP	AL,'S'-40H
	JNZ	MTSTA	;Continue testing?

;no, suspend test until console sends a ^S
MTST7:
	IN	AL,stat_rega
	AND	AL,rx_rdy
	JZ	MTST7
	IN	AL,rx_rega
	CMP	AL,'S'-40H
	JNZ	MTST7	;no ^S?

MTSTA:	IN	AL,in_reg ;read sense inputs on duart
	TEST	AL,JUMP96
	JZ	MTST6	;write once, then read only?
	jmp	short	DRAMTST	;write each cycle




;Show D Ram Error
MERROR:	XOR	AX,CX
	MOV	DX,AX	;save ref data

MERR1:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	MERR1
	MOV	AL,0DH	;carriage return
	OUT	tx_rega,AL

MERR2:	IN	AL,stat_rega
	AND	AL,tx_rdy
	JZ	MERR2
	MOV	AL,0AH	;line feed
	OUT	tx_rega,AL

MERR3:	MOV	DI,OFFSET MERR4
	MOV	SI,BP	;ram address
	JMP	PWRD
MERR4:	MOV	DI,OFFSET MERR5
	MOV	SI,DX	;bad data
	JMP	PWRD
MERR5:	MOV	AX,CS:[BX]
	MOV	CX,SS
	XOR	AX,CX
	MOV	SI,AX	;bad data
	MOV	DI,OFFSET MERR6
	JMP	PWRD
MERR6:	MOV	CX,SS
	IN	AL,stat_rega
	AND	AL,rx_rdy
	JNZ	MERRA
	JMP	MTST4	;continue
MERRA:	IN	AL,rx_rega
	CMP	AL,0DH
	JNZ	MERR7
	JMP	CMND1
MERR7:	MOV	DI,OFFSET MERR8
	JMP	CHRIN
MERR8:	MOV	CX,SS
	CMP	AL,0DH
	JNZ	MERR9
	JMP	CMND1
MERR9:	JMP	MTST4


code	ends
	end


