		if2
		%out	Pass 2.
		endif
		.286c
		page	60,132
		name	ibm
		title	Slicer BIOS Version 2.0A (IBM emulation)
.xlist
		subttl	Data Areas
		page	+
		include	biosdata.asm
		page	+
.list
;--------------------------------------------------------------------------------
;	      BIOS for the Slicer. (C) Slicer Computers Inc.,  1985
;
;             Version 2.0                 April 4, 1985 
;	      By David Daney 1985
;
;
;--------------------------------------------------------------------------------
		subttl	Equates
		page
;----------------------------------------------------------------
;      E Q U A T E S
;----------------------------------------------------------------
b		equ	byte ptr  
w		equ	word ptr 
;		byte definition
;		disk type
uninitialized	equ	10000000b
mini		equ	00010000b
double_density	equ	00100000b
double_track	equ	01000000b
sector_size_m	equ	00001100b
step_rate_m	equ	00000011b
disk_read_cmd	equ	10011000b
disk_write_cmd	equ	10111000b
;
console		equ	6
output		equ	1
function_call	equ	0f8h
;----------------------------------------------------------------
;  S T R U C T U R E S
;----------------------------------------------------------------
dpb11		struc
		db	?
		db	?
		db	?
ibm_sector_size	db	?
dpb11		ends


		subttl	Externals and Publics
		page	+
;----------------------------------------------------------------
; Externals and Publics
;----------------------------------------------------------------
		public	ibm_call_init
		public	rs_232_send		
		public	print

		extrn	disk_read:near
		extrn	disk_write:near
		extrn	disk_reset:near
		extrn	port1_write:near,port2_write:near
		extrn	moninit:near

		subttl	Initialization Code
		page	+
boot_seg	segment	at 0
		org	7c00h
boot_location	label	far
boot_seg	ends

cgroup		group	code

code		segment byte public 'code'
		assume	cs:cgroup,ds:data
ibm_call_init	proc	near
;
set		macro	num,val
		mov	w num,offset val
		mov	w num+2,seg val
		endm
;
		mov	ax,vectors
		mov	es,ax
		assume	es:vectors
		set	vector_10,vidio_io
		set	vector_16,keyboard_io
		set	vector_11,equipment_check
		set	vector_12,memory_size_d
		set	vector_14,rs_232
		set	vector_15,cassette_io
		set	vector_17,printer
		set	vector_19,bootstrap
		mov	ax,offset kb_buffer
		mov	buffer_head,ax
		mov	buffer_tail,ax
		set	vector_1a,time_of_day
		set	vector_1e,disk_base
		set	vector_fc,disk_io
		mov	al,uninitialized
		mov	d_type_0,al
		mov	d_type_1,al
		mov	d_type_2,al
		mov	d_type_3,al
		mov	ax,day
		mov	day1,ax
		ret
		assume	es:nothing
ibm_call_init	endp
number_table	db	'0123456789ABCDEF'

print		proc	near
		cld
		mov	dx,cs
		mov	es,dx
		mov	di,si
		mov	al,0
		mov	cx,0ffffh
	repne	scas	b [di]
		not	cx
		dec	cx
		mov	ah,console
		mov	al,output
		int	function_call
		ret
print		endp
		assume	ds:nothing,es:data
keyboard_io	proc	far
		sti
		push	es
		push	si
		mov	si,data
		mov	es,si
		or	ah,ah
		jz	get_char
		cmp	ah,-1
		je	get_char
		dec	ah
		jz	keyboard_status
		dec	ah
		jz	shift_atatus2
		pop	si
		pop	es
		iret
get_char:	mov	si,offset ibm_temp_char
		push	cx
		mov	cx,1
		mov	ax,600h			;read one char
		int	0f8h
		mov	al,es:[si]
		xor	ah,ah
		pop	cx   
		pop	si
		pop	es
		iret
keyboard_status:
		mov	si,offset ibm_temp_char
		mov	ax,602h			;read status
		int	0f8h
		or	al,al			;set zero flag
		lahf
		xor	ah,40h
		sahf				;invert zero flag
		mov	al,es:[si]
		mov	ah,0
		pop	si
		pop	es
		ret	2
shift_atatus2:
		mov	al,shift_status
		pop	si
		pop	es
		iret
keyboard_io	endp
vidio_io	proc	far
		sti
		push	si
		push	es
		push	cx
		mov	cx,data
		mov	es,cx
		cmp	ah,14
		je	vi1
		cmp	ah,-1
		jne	viend
vi1:		mov	si,offset ibm_temp_char
		mov	es:[si],al
		mov	cx,1
		mov	ax,601h			;write 1 char
		int	0f8h
viend:		pop	cx
		pop	es
		pop	si
		iret
vidio_io	endp
cassette_io	proc	far
		mov	ah,080h
		stc
		ret	2
cassette_io	endp
		assume	ds:data
;----------------------------------------------------------------
;Diskette i/o
;
;input
; (ah)=0   reset disk system
; (ah)=1   read status of disk system into (al)
; (ah)=2   read sectors into memory
; (ah)=3   write sectors to disk
; (ah)=4   verify sectors on disk
;
;   (dl) - drive number (0-3)
;   (dh) - head number
;   (ch) - track number
;   (cl) - sector number
;   (al) - number of sectors to transfer
;   (es:bx) - data buffer
;
;output
; (ah) - status of operation
; (cy)=0 no error
; (cy)=1 error
;
;----------------------------------------------------------------
disk_io		proc	far
		sti
		push	ds
		push	es
		push	bx
		push	cx
		push	dx
		push	bp
		push	si
		push	di
		mov	si,data
		mov	ds,si
		cmp	dl,3
		ja	hd_io
		mov	drive_number,dl
		mov	head_number,dh
		mov	disk_track,ch
		mov	sector_number,cl
		mov	num_of_sectors,al
		push	es
		mov	si,vectors
		mov	es,si
		assume	es:vectors
		les	si,vector_1e
		mov	al,es:[si].ibm_sector_size
		and	al,011b
		shl	al,2
		mov	si,dx
		and	si,3
		and	d_type_0[si],not sector_size_m
		or	d_type_0[si],al			;set sector size
		pop	es
		assume	es:nothing
		or	ah,ah
		jnz	dio1
		call	disk_reset
		mov	ah,0
		jmp	dio2
dio1:		dec	ah
		jnz	dio3
		mov	ah,diskette_status
		jmp	dio2
dio3:		dec	ah
		jnz	dio4
		mov	al,settle
		and	al,4
		or	al,disk_read_cmd
		int	0fdh				;file bios.asm disk_read
		mov	al,num_of_sectors
		mov	ah,diskette_status
		jmp	dio2
dio4:		dec	ah
		jnz	dio5
		mov	al,settle
		and	al,4
		or	al,disk_write_cmd
		int	0fdh				;file bios.asm disk_write
		mov	al,num_of_sectors
		mov	ah,diskette_status
		jmp	dio2
dio5:		
hd_io:		mov	ax,100h
dio2:
		cmp	ah,1
		cmc
		pop	di
		pop	si
		pop	bp
		pop	dx
		pop	cx
		pop	bx
		pop	es
		pop	ds
		ret	2		;kill the flags
disk_io		endp
disk_base	dpb11	<0,0,0,2>
memory_size_d	proc	far
		sti
		push	ds
		mov	ax,data
		mov	ds,ax
		mov	ax,memory_size
		pop	ds
		iret
memory_size_d	endp
equipment_check	proc	far
		sti
		push	ds
		mov	ax,40h
		mov	ds,ax
		mov	ax,equip_flag
		pop	ds
		iret
equipment_check	endp
rs_232		proc	far
		sti
		push	bx
		push	cx
		push	dx
		push	si
		push	es
		push	ds
		mov	bx,data
		mov	ds,bx
		mov	es,bx
		cmp	ah,0
		je	rs_232_setup
		cmp	ah,3
		je	rs_232_status
		push	dx
		cmp	ah,1
		je	rs_232_send
		mov	ah,dl
		add	ah,0ah
		xor	al,al
		mov	si,offset ibm_temp_char
		mov	cx,1
		int	0f8h
		mov	al,ibm_temp_char
		xor	ah,ah
		pop	dx
		jmp	rs_232_exit
rs_232_send:	mov	ibm_temp_char,al
		mov	si,offset ibm_temp_char
		mov	cx,1
		mov	ah,dl
		add	ah,0ah
		mov	al,1
		int	0f8h
		pop	dx	    
		mov	ah,61h
		jmp	rs_232_exit

rs_232_setup:	push	ax
		mov	bl,al			;set up incoded in al
		mov	ah,dl
		add	ah,0ah			;port 1-4 newcall.asm
		mov	al,5			;write setup call
		int	0f8h
		pop	ax			;only thing that could have changed

rs_232_status:	mov	ah,dl
		add	ah,0ah			;port to ah
		push	ax
		mov	al,2			;read status
		int	0f8h
		mov	si,ax
		pop	ax
		mov	al,3			;write status
		int	0f8h
		xor	ah,ah
		or	al,al
		jnz	rs_232s1
		mov	ah,01100000b
rs_232s1:	and	si,0ffh
		jnz	rs_232s2
		or	ah,1
rs_232s2:	mov	al,11110000b
rs_232_exit:		
		pop	ds
		pop	es
		pop	si
		pop	dx
		pop	cx
		pop	bx
		iret
rs_232		endp
printer		proc	far
		sti
		push	bx
		push	cx
		push	dx
		push	si
		push	es
		push	ds
		mov	bx,data
		mov	ds,bx
		mov	es,bx
		mov	si,offset ibm_temp_char
		or	ah,ah
		jz	prn_out
		dec	ah
		jz	prn_init
		mov	ah,7			;prn
		or	dx,dx
		jz	po1
		inc	ah			;aux
po1:		mov	al,3			;status
		int	0f8h
		xor	ah,ah
		test	al,80h
		jnz	prn_bad
		mov	ah,80h
		jmp	short prn_good
prn_out:	mov	cx,1
		mov	ibm_temp_char,al
		mov	ah,7			;prn
		or	dx,dx
		jz	po2
		inc	ah			;aux
po2:
		mov	al,1			;out put a char
		int	0f8h
		mov	ah,bl			;al
		test	ah,80h
		jz	prn_good
prn_bad:	mov	ah,1			;time out
		jmp	short prn_done
prn_init:	mov	ah,0
prn_good:	or	ah,90h
prn_done:	pop	ds
		pop	es
		pop	si
		pop	dx
		pop	cx
		pop	bx
		iret
printer		endp
time_of_day	proc	far
		sti
		push	ds
		push	dx
		push	cx
		push	bx
		push	si
		mov	bx,data			;returns seconds*18
		mov	ds,bx
		or	ah,ah
		jz	tod2
		dec	al
		jz	tod3
		jmp	tod4
tod2:		cli
		mov	al,hours
		xor	ah,ah
		mov	bx,64800		;3600*18
		mul	bx
		mov	si,dx
		mov	cx,ax
		mov	al,min
		xor	ah,ah
		mov	bx,1080
		mul	bx
		add	cx,ax
		adc	si,0
		mov	al,seconds
		xor	ah,ah
		mov	bl,18
		mul	bl
		add	cx,ax
		adc	si,0
		mov	dx,cx
		mov	cx,si 
		xor	al,al
		mov	bx,day
		sti
		cmp	bx,day1
		je	tod1
		inc	al
tod1:		mov	day1,bx
		jmp	tod4
tod3:		mov	ax,dx
		mov	dx,cx
		mov	bx,1080		;60*18
		div	bx
		mov	cx,dx
		mov	bl,60
		div	bl
		cli
		mov	min,ah
		mov	hours,al
		mov	ax,cx
		mov	bl,18
		div	bl
		mov	seconds,al
		mov	bx,day
		sti
		mov	day1,bx

tod4:		pop	si
		pop	bx		
		pop	cx
		pop	dx
		pop	ds
		iret
time_of_day	endp
bootstrap	proc	far
		xor	ax,ax		;drive 0
		mov	al,84h
		int	0f8h		;getparameters from drive
		or	al,al
		je	boot2
		jmp	boot_error
boot2:		mov	bl,1
		mov	cl,1
		xor	ax,ax
		mov	al,82h
		int	0f8h		;set parameters
boot3:
		mov	cx,1
		xor	dx,dx
		xor	bx,bx
		mov	si,boot_seg
		mov	es,si
		mov	si,offset boot_location
		xor	ax,ax
		mov	al,0
		int	0f8h		;read first sector
		or	al,al
		jnz	boot_error
		xor	dx,dx		;drive 0
		jmp	boot_location
boot_error:	jmp	moninit
bootstrap	endp


code		ends
		end


