/* undef.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Mark symbols that might be used before they are defined
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: undef.c,v 5.5 89/05/12 12:53:32 pcc Rel-3_0 $";
/* static char ID[] = "@(#)undef.c	15.1	of 86/09/25"; */
#endif

/*	Import
 */

# include <assert.h>
# include <undef.h>
# include <dag.h>
# include <bool.h>
# include <identifier.h>
# include <dagsymbol.h>
# include <longset.h>
# include <udchain.h>
# include <duchain.h>
# include <blocks.h>
# include <flow.h>
# include <erroro.h>

/*
 *	Private variables
 */

/*
 *	Forward
 */

static Boolean UsedBeforeSet();

void
MarkUndefined()
{
	BasicBlock b;
	DAG_Node d;
	FlowIndex index;
	Identifier id;

	/* First, set up all UDCHAIN information and put flow graph
	 * indices on Dag nodes so we can avoid unreachable code.
	 * Then cycle through the symbol table marking things that are
	 * used before they are defined.
	 * Finally, destroy all the UDCHAIN information.
	 */

	for( b = FirstBlock; b != NULL; b = b->next )
	{
		if( b->reachable )
		{
			UDSecondWalk(b,True);
			index = b->FGindex;
		}
		else
			index = NullFlow;

		for( d = b->Dag; d != NULL; d = d->next )
			d->FGindex = index;
	}

	for( id = FirstId; id <= MaxIdentifier; id++ )
		if(UsedBeforeSet(id))
			SetUsedFirst(id);

	for( b = FirstBlock; b != NULL; b = b->next )
		for( d = b->Dag; d != NULL; d = d->next )
			if( d->In != NULL )
			{
				DestroySet(d->In);
				d->In = NULL;
			}
}

static Boolean
UsedBeforeSet(id)	/* Is id used before it is set? */
	Identifier id;
{
	DAG_Node dagp;
	LongSet suses;
	LongSet sdefs;
	int undef;	/* index of the phony "undefined" definition for id */
	int ns;
	int i;

	ns = IdOp(id);
	switch(ns)
	{
	default:	/* not nice to call with something we dont know about */
		InternalFault("Bad UseBefore Set: id %d ns %d\n", id, ns);

	case LTEMP:	/* We have insufficient information for these, but */
	case TNAME:	/* since we created them, they should be O.K. */
	case TREG:
	case NAME:	/* might be set elsewhere */
	case PNAME:
		return False;

	case ICON:	/* These don't count */
	case LABCON:
#ifndef MPX
	case TCON:	/* (MEY) added TCON and HCON for Alpha C */
	case HCON:
	case CADDR:
#endif
	case ADDR:
	case LADDR:
	case PADDR:
	case STADDR:
		return False;

	case STATNAME:
	case LNAME:
	case REG:
		/* Find the index of the initial phony definition supplied
		 * for "id".  This code knows that the phony definition is
		 * the first one.
		 */
		sdefs = GetDefs(id);
		assert(sdefs != NULL);
		undef = FirstElement(sdefs);
		suses = GetUses(id);
		assert(suses != NULL && undef != NoElement);
		for( i = FirstElement(suses); i != NoElement; i = NextElement(i,suses) )
		{
			/* Check that this dag node is an occurrence of this
			 * identifier as a leaf, an indirect store or a call.
			 * Ignore things that have been constant folded, etc.
			 * Also ignore things in unreachable blocks.
			 */
			dagp = DUDagPtrs[i];
			if( dagp->FGindex != NullFlow &&
			    (dagp->op == ns || callop(dagp->op) ||
			     (dagp->op == UNARY MUL && !dagp->is_fetch)) )
			{
				assert(dagp->In != NULL);
				if( IsElement(undef, dagp->In) )
				{
					/* This use of the identifier really
					 * might be reached by the initial
					 * def.  In the future, might want to
					 * issue diagnostic here - perhaps
					 * after checking the number of defs
					 * of id that reach here.
					 * Need to be cautious if dagp->op!=ns
					 * since a call or UMUL might not
					 * change the symbol we are looking at.
					 */
					return True;
				}
			}
		}
		return False;
	}
	/*NOTREACHED*/
}
