/* udchain.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
#ifndef UDCHAIN

#define UDCHAIN

#include <dag.h>

#ifndef lint
/*	@(#) (Gould) $Header: udchain.h,v 5.5 89/05/12 12:53:29 pcc Rel-3_0 $		  */
/* static char UDCH_SCCSID[] = "@(#)	udchain.h	15.1	of 86/10/10"; */
#endif

/*
 *	Export
 */

/*
 *	Note: If sets automatically expand, then inserting a BadDef
 *	into a set will cause it to dramatically expand.  This would be,
 *	of course, an error.
 */

#define	BadDef	DefsMax		/* Illegal "def" index */
#define BadUse	UsesMax		/* Illegal "use" index */

extern DAG_Node *UDDagPtrs;	/* array of pointers to DAG nodes that are
				 * definitions.  All UD information is stored
				 * as subsets of this set
				 */
extern int UDSetSize;		/* current size of UD Sets */
extern int UDInitSetSize;	/* initial size of same */

/*
 *	Exported Operations
 */

extern void InitUDInfo();	/* Set up data structures for UD chains */
extern void UDFirstWalk();	/* First walk over DAG to set up UD chains */
extern int Gen1Def();		/* Internal routine also used by loop invar
				 * code */
extern void UDNewBlock();	/* Initialization routine used by loop invar
				 * code */
extern void UDSecondWalk();	/* Second walk over DAG to set up UD chains */
extern void UDDataFlow();	/* Solve data flow equations */
extern void UDChains();		/* Compute UD chains */
extern void PUDInfo();		/* Debug printing */
#endif
