/* option.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Option  and argument processing
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: option.c,v 5.5 89/05/12 12:52:12 pcc Rel-3_0 $";
/* static char ID[] = "@(#)option.c	15.4	of 86/10/25"; */
#endif

#include <option.h>
#include <dag.h>
#include <daghash.h>
#include <udchain.h>
#include <duchain.h>
#include <erroro.h>
#include <pcc.h>
#ifdef INLINER
/* get decl of InlinerRequest() */
#include <inliner.h>
#endif	/* INLINER */

static int
optinit( argc, argv )
	int argc;
	char *argv[];
{
	/* set the values of the optimizer arguments */

	register int c;
	register char *cp;
	register files;
	register int i;

	files = 0;

	for( c=1; c<argc; ++c ){
		if( *(cp=argv[c]) == '-' ){
			while( *++cp ){
				switch( *cp ){

				case 'C':	/* Constant folding */
					++cfdebug;
					break;

				case 'D':
					++DelayDebug;
					break;

				case 'F':	/* Facts and Figures */
					++Statistics;
					break;

				case 'G':
					GoodGlobals = True;
					break;

#ifdef	INLINER
				case 'H':
					InlinerRequest(cp+1);
					cp = "H";	/* skip rest of this */
					break;
#endif	/* INLINER */

				case 'L':	/* gLobal common subexprs */
					++GlComdebug;
					break;

				case 'N':  /* turn off optimizations */
					while( *++cp )
					switch(*cp)
					{
						case 'c':
							NoConstantProp++;
							break;

						case 'f':
							NoFloatConstFolding++;
							break;

						case 'g':
							NoGlobalCommon++;
							break;

						case 'i':
							NoIdioms++;
							break;

						case 'l':
							NoLoopInvariants++;
							break;

						case 'r':
							++NoRegAlloc;
							break;

						case 'u':
							NoUnusedVars++;
							break;

#						ifdef FORT
						case 'w':
							NoOutput++;
							break;

#						endif /* FORT */
#						ifdef FILLSPILL
						case 'F':
							++NoFillSpill;
							break;
#						endif /* FILLSPILL */

						default:
							UserError( "Bad option: N%c", *cp );
					}
					--cp;
					break;

				case 'P':	/* Debug tree pruning */
					PrunDebug++;
					break;

				case 'S':  /* Change Table sizes */
					switch(*++cp)
					{
					case 'd':
						i = atoi(cp+1);
						if( i <= 0 )
							UserError("DU chain set size invalid");
						DUInitSetSize = i;
						break;

					case 'h':
						i = atoi(cp+1);
						if( i <= 0 )
							UserError("Hash size invalid");
						HashSize = i;
						break;

					case 'u':
						i = atoi(cp+1);
						if( i <= 0 )
							UserError("UD chain set size invalid");
						UDInitSetSize = i;
						break;

					default:
						UserError("bad option: S%c", *cp);
					}
					while( *++cp ) { /* VOID */ }
					--cp;
					break;

				case 'T':	/* temporaries */
					++TempDebug;
					break;

				case 'V':
					GoodGlobals = False;	/* volatile */
					break;

				case 'v':	/* aVailable exprs */
					++AvExprdebug;
					break;

				case 'W':	/* No Warnings */
					WarningOption = False;
					break;

				case 'a':	/* allocation */
					++AllocDebug;
					break;

				case 'b':	/* Basic Blocks */
					++bdebug;
					break;

				case 'd':  /* DAG debug */
					++ddebug;
					break;

#				ifdef FILLSPILL
				case 'f':  /* Fill Spill debug */
					++fdebug;
					break;

#				endif /* FILLSPILL */

				case 'g':	/* Flow Graph */
					++gdebug;
					break;

				case 'i':	/* idioms */
					++idebug;
					break;

				case 'l':	/* Loops */
					++ldebug;
					break;

				case 'p':	/* the input program */
					++pdebug;
					break;

				case 'r':	/* Rewrite trees */
					++rdebug;
					break;

				case 's':	/* Subexpressions */
					++sdebug;
					break;

				case 't':	/* building trees */
					++tdebug;
					break;

				case 'u':	/* stores into unused vars */
					++DSDebug;
					break;

				case 'w':	/* During writing */
					++wdebug;
					break;

				case 'x':  /* general machine-dependent debugging flag */
					++xdebug;
					break;

				default:
					if (!LocalOption(cp))
						UserError( "bad option: %c", *cp );
				}
			}
		}
		else
			++files;  /* assumed to be a filename */
	}

	return( files );

}

void
ProcessArgs(argc, argv)			/* Process optimizer arguments */
	int argc;
	char *argv[];
{
	int files;		/* number files specified */
	int file_no;		/* which one we are processing */
	int i;

	files = optinit( argc, argv );

	if( files > 0 ){
		if (files > 2) ExternalFault("too many files for optimizer");
		file_no = 0;
		for (i = 1; i < argc && file_no < files; ++i) {
			if (argv[i][0] != '-') {	/* it's not a flag */
				FILE * f;

				++file_no;
				if (file_no == 1)
					f = freopen(argv[i], "r", stdin);
				else
					f = freopen(argv[i], "w", stdout);
				if (f == NULL)
					ExternalFault("can't open file");
				
			}
		}
	}
}
