/* longset.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	This implements long sets
 */


#ifndef LONGSET

#ifndef lint
/*	@(#) (Gould) $Header: longset.h,v 5.5 89/05/12 12:51:37 pcc Rel-3_0 $		  */
/* static char LNGSET_SCCSID[] = "@(#)longset.h	15.1	of 86/11/24"; */
#endif

#include <bool.h>

#define NoElement (-1)	/* Returned by FirstElement and NextElement if no
			 * element can be found
			 */

typedef struct LSet {
	int words;		/* Number of words in this set */
	union {
		unsigned long *v;	/* The bit vector */
		struct LSet *next;	/* Free list pointer */
	} u;
} SetDescriptor, *LongSet;

extern void    InitSets();	/* Initialize the set module */
extern void    DestroySet();	/* Throw away storage for S */
extern Boolean SetEq();		/* Does a == b? */
extern LongSet CreateSet();	/* Create a new set */
extern Boolean IsElement();	/* Is e in S? */
extern Boolean Subset();	/* Is a a subset of b? */
extern Boolean Disjoint();	/* Are a and b disjoint? */
extern void    Insert();	/* Insert e into S */
extern void    DelMember();	/* Delete e from S */
extern void    NullSet();	/* Make S the empty set */
extern void    Intersection();	/* r = a intersect b */
extern void    Union();		/* r = a union b */
extern void    Difference();	/* r = a - b */
extern void    CopySet();	/* a = b by copying */
extern void    ExpandSet();	/* Make S larger */
extern int     FirstElement();	/* Find the first element of S */
extern int     NextElement();	/* Find the next element of S */
extern void    DumpSet();	/* Print out a set */

#define LONGSET

#endif
