/* labels.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Symbol Table for Labels
 */

/*	The table is kept as an expandable array of BasicBlocks,
 *	indexed by the label number.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: labels.c,v 5.5 89/05/12 12:51:17 pcc Rel-3_0 $";
/* static char ID[] = "@(#)labels.c	14.1	of 86/06/11"; */
#endif

/*	Imported Objects
 */

# include <labels.h>
# include <blocks.h>
# include <storage.h>
# include <erroro.h>

/*	Private Objects
 */

#define MinSize	10
#define SizeInc	10

typedef struct {
	int current_size;		/* length in entries of array */
	BasicBlock *blocks;		/* array of BasicBlock (expands) */
} LabelTable;

static LabelTable p1_labels = 	/* labels from pass 1 */
		{0, NULL};

static LabelTable opt_labels =	/* labels created by opt */
		{0, NULL};

#define ChooseTable(l)	(((l) > LAST_P2_LABEL) ? &opt_labels : &p1_labels)
#define MapLabel(l)	((l) > LAST_P2_LABEL ? (l) - (LAST_P2_LABEL+1) : (l))

static
Expand(t)
	LabelTable *t;
{
	int old_size, l;

	old_size = t->current_size;

	if (t->current_size == 0) {
		t->blocks = GetArray(s_Labels, SizeInc, BasicBlock);
	} else {
		t->blocks = Reallocate(s_Labels, t->blocks, t->current_size,
					t->current_size+SizeInc, BasicBlock);
	}
	CheckStorage(t->blocks, "storage for labels", 0);
	t->current_size += SizeInc;
	for (l = old_size; l < t->current_size; ++l)
		t->blocks[l] = NULL;
}


void
Associate(label, block)
	LabelType label;
	BasicBlock block;
{
	LabelTable *t;
	int l;

	t = ChooseTable(label);
	l = MapLabel(label);
	while (l >= t->current_size) Expand(t);
	t->blocks[l] = block;
}

BasicBlock
LookUpLabel(label)
	LabelType label;
{
	LabelTable *t;
	int l;

	t = ChooseTable(label);
	l = MapLabel(label);
	if (l >= t->current_size)
		return NULL;
	else
		return t->blocks[l];
}

void
ClearLabelTable()
{
	LabelType label;

	for (label = 0; label < p1_labels.current_size; ++label)
		p1_labels.blocks[label] = NULL;
	for (label = 0; label < opt_labels.current_size; ++label)
		opt_labels.blocks[label] = NULL;
}

void
DumpLabelTable()
{
	LabelType l;

	printf("P1 label table\n\n");
	for (l = 0; l < p1_labels.current_size; ++l)
		if (p1_labels.blocks[l] != NULL)
			printf("%d %o\n", l, p1_labels.blocks[l]);

	printf("OPT label table\n\n");
	for (l = 0; l < opt_labels.current_size; ++l)
		if (opt_labels.blocks[l] != NULL)
			printf("%d %o\n", l, opt_labels.blocks[l]);
}
