/* duchain.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Use-Definition Chain Calculation
 */

/*
 *	See: Aho and Ullman, Principles of Compiler Design, Section 14.4
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: duchain.c,v 5.5 89/05/12 12:50:26 pcc Rel-3_0 $";
/* static char ID[] = "@(#)duchain.c	15.1	of 86/10/10"; */
#endif

/*	Import
 */

# include <duchain.h>
# include <assert.h>
# include <blocks.h>
# include <dag.h>
# include <flow.h>
# include <identifier.h>
# include <dagsymbol.h>
# include <longset.h>
# include <storage.h>
# include <erroro.h>
# include <pcc.h>
# include <target.h>

# define DU_SET_INIT	1024		/* initial DU set size */
# define DU_SET_INCR	256		/* DU set size increment */

int udebug = 0;

/*	Export
 */
DAG_Node *DUDagPtrs = NULL;	/* array of pointers to DAG nodes that are
				 * definitions.  All DU information is stored
				 * as subsets of this set
				 */
int DUSetSize;			/* current size of DU Chain Sets */
int NextUseFree;		/* index in DUDagPtrs of next free def */
int DUInitSetSize = DU_SET_INIT;/* initial size of DU Chain Sets */

/*	Import
 */

/*	Private
 */

static void DUSetup();
static LongSet NonamePtrs;	/* for keeping track of pointer fetches about
				 * which we know nothing
				 */

/*
 * Someday, Solve data flow equations for DU chains.  For now, just collect the
 * necessary information
 */

/*
 * Initialization for DU Chains
 */
void
InitDUInfo()
{
	NextUseFree = 0;

	if( DUDagPtrs != NULL ) {
		free(DUDagPtrs);
		DecreaseSpace(s_DUptrs, DUSetSize * sizeof(DAG_Node));
	}

	DUSetSize = DUInitSetSize;
	DUDagPtrs = GetArray(s_DUptrs, DUSetSize, DAG_Node);
	CheckStorage(DUDagPtrs, "storage for DU chains (set size = %d).", DUSetSize);

	if( NonamePtrs != NULL )
		DestroySet(NonamePtrs);
	NonamePtrs = CreateSet(DUSetSize);
}

/*
 * The actual work of setting up the DU Chains
 */
void
DUChains()
{
	int i;

	NullSet(NonamePtrs);

	/* Someday, should make this optional - dont need it if symbol
	 * uses are already correct
	 */
	DUSetup();

	for( i = 0; i < NumReachableNodes; i++)
	{
		DUFirstWalk(FlowGraph[DFN[i]].block);
	}
}

static int
NewUse()
{
	int n;

	n = NextUseFree++;
	if( n >= DUSetSize )
	{
		DUDagPtrs = (DAG_Node *) realloc((char *)DUDagPtrs,
		     (unsigned)((DUSetSize + DU_SET_INCR) * sizeof(DAG_Node)));
		CheckStorage(DUDagPtrs, "storage for DU chains (set size = %d).", DUSetSize);
		DUSetSize += DU_SET_INCR;
		assert(n < DUSetSize);
		IncreaseSpace(s_DUptrs, DU_SET_INCR * sizeof(DAG_Node));

		/* Might be a good idea to expand set of noname pointers */
		/* ExpandSet( NonamePtrs, DUSetSize); */

	}
	return(n);
}

/*
 * DU chain initialization once the DAG has been built.  Main idea here
 * is to provide a set of uses for each name in the symbol table
 */
static void
DUSetup()
{
	Identifier id;
	LongSet suses;

	for( id=FirstId; id<=MaxIdentifier; ++id )
	switch(IdOp(id))
	{
	case REG:
	case NAME:
	case LNAME:
	case PNAME:
	case STATNAME:
		suses = GetUses(id);
		if( suses == NULL )
			(void)InitUses(id, DUSetSize);
	}
}


/*
 * First walk over DAG to collect DU information
 */
void
DUFirstWalk( b )
	BasicBlock b;
{
	DAG_Node d;
	Identifier id;
	int newuse;
	LongSet suses;

	DUNewBlock(b);

	for( d = b->Dag; d != NULL; d = d->next)
	{
		if( (d->op == UNARY MUL && d->is_fetch) || callop(d->op) )
		{
			/* Some day, may want to check d->may_fetch here,
			 * in parallel with the code in udchain.c
			 */
				/* We have no idea what may be used by this
				 * fetch/call.
				 * Create a single use, and make it a possible
				 * use for all globals and any locals or
				 * parameters whose addresses were taken.
				 * (Note that if the address of any parameter
				 * is taken, readero marks ALL parameters as
				 * having their addresses taken.)
				 * Remember the use so that it will
				 * never be killed
				 */
				newuse = NewUse();
				DUDagPtrs[newuse] = d;
				Insert(newuse,NonamePtrs);
				for( id=FirstId; id<=MaxIdentifier; id++ )
				if( IdOp(id) == NAME || WasAddressed(id))
				{
					suses = GetUses(id);
					assert(suses != NULL);
					Insert(newuse,suses);
				}
		}
		else
		switch(d->op)
		{
		case REG:
		case NAME:
		case LNAME:
		case PNAME:
		case STATNAME:
			(void) Gen1Use(d->leaf_id, d, b);
			break;
		}
	}
}

/*
 * This also called by loop invariant removal
 */
int
Gen1Use(id, d, b)
	Identifier id;
	DAG_Node d;
	BasicBlock b;
{
	LongSet suses;
	int newuse;

	suses = GetUses(id);
	assert(suses != NULL);
	newuse = NewUse();
	DUDagPtrs[newuse] = d;
	Insert(newuse,suses);
	Insert(newuse,b->du.PUse);
}

/*
 * Also called by the loop invariant code when it is
 * creating a pre-header
 */
void
DUNewBlock(b)
	BasicBlock b;
{
	if( b->du.PUse == NULL )
		b->du.PUse = CreateSet(DUSetSize);
	NullSet(b->du.PUse);
}
