/* daghash.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Hash table support
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: daghash.c,v 5.5 89/05/12 12:50:01 pcc Rel-3_0 $";
/* static char ID[] = "@(#)daghash.c	14.1	of 86/06/11"; */
#endif

# include <assert.h>
# include <daghash.h>
# include <dag.h>
# include <cmanifest.h>
# include <storage.h>
# include <erroro.h>

/*
 * Export
 */

/* default size of hash table */
int HashSize = DefaultHashSize;

/*
 * Private
 */

/*
 * Used as a multiplier in the hashing function.
 * Should be chosen to give an even distribution
 * of hash values for a typical set of DAG nodes.
 * Changing its value will only affect the speed
 * of the lookup routines, and will not affect
 * correctness.
 */
#define HASHFACTOR 42737

static DAG_Node *Hash;		/* The DAG Hash table */
static DAG_Node FHash;		/* The DAG Hash list for FCON's */

/*
 * provides an index into the hash table,
 * which is of size 'HashSize'.
 */
static int
MakeIndex(left, right)
	int left, right;
{
	return (left * HASHFACTOR + right) % HashSize;
}

/* CALLs should never be recognized as common
 * subexpressions, and hence should never be hashed.
 * Since COLON does not return a value, it is not hashed.
 * Ditto CM.
 *
 * STCALL and UNARY STCALL are handled like CALL.
 * STARG and STASG should also never be common subexpressions.
 * 
 */

static Boolean
NotHashable(op)
	Operator op;
{
	if(callop(op) || op == COLON || op == CM || op == STASG || op == STARG)
		return True;
	else
		return False;
}

void
EnterHash(n)				/* Enter n in hash table */
	DAG_Node n;
{
	register int ti;

	switch (optype(n->op)) {
		case BITYPE:
			ti = MakeIndex((int) n->u.in.left->hash,
				(int) n->u.in.right->hash);
			break;
		case UTYPE:
			ti = MakeIndex((int) n->u.in.left->hash, n->u.tn.rval);
			break;
		default:
			InternalFault ("invalid optype %d, op %d",
				optype(n->op), n->op);
	}
	n->hashable = True;
	n->chain.hash_link = Hash[ti];
	Hash[ti] = n;
}

DAG_Node
EnterFHash( n, dval )		/* Enter DAG Node n in FCON hash list	*/
	DAG_Node n;
	FCONSZ dval;
{
	n->hashable = True;
	n->u.fpn.dval = dval;
	n->chain.hash_link = FHash;
	FHash = n;
	return n;
}

/*
 * BinaryHashLook
 * attempts to find a DAG node with the operator, type
 * and left and right children specified.
 * UnaryHashLook
 * compares based on 'rval' rather than the right child.
 * Returns NULL if unsuccessful.
 */

DAG_Node
BinaryHashLook(op, ty, left, right)
	Operator op;
	TWORD ty;
	DAG_Node left, right;
{
	DAG_Node n;

	if ( NotHashable(op) )
		return NULL;

	n = Hash[MakeIndex((int) left->hash, (int) right->hash)];
	while (n != NULL && (!n->hashable || n->op != op || n->type != ty ||
		n->u.in.left->hash != left->hash ||
		n->u.in.right->hash != right->hash))
			n = n->chain.hash_link;
	return n;
}

DAG_Node
UnaryHashLook(op, ty, left, rval)
	Operator op;
	TWORD ty;
	DAG_Node left;
	int rval;
{
	DAG_Node n;

	if ( NotHashable(op) )
		return NULL;

	n = Hash[MakeIndex((int) left->hash, rval)];
	while (n != NULL && (!n->hashable || n->op != op || n->type != ty ||
		n->u.in.left->hash != left->hash || n->u.tn.rval != rval))
			n = n->chain.hash_link;
	return n;
}

DAG_Node
FconHashLook( ty, dval )	/* Look in the FCON Hash list for FCON	*/
			 	/* with value dval, and type ty		*/
	TWORD ty;
	FCONSZ dval;
{
	DAG_Node n;

	n = FHash;
	while( n != NULL && (!n->hashable || n->type != ty ||
	       n->u.fpn.dval != dval ) )
		n = n->chain.hash_link;

	return n;
}

void
InitHash()
{
	register int i;
	register DAG_Node *p;

	if( Hash == NULL )
	{
		Hash = (DAG_Node *)calloc((unsigned) HashSize, sizeof(DAG_Node));
		CheckStorage(Hash, "storage for %d hash table entries", HashSize);
	}

	p = Hash;
	for (i = 0; i < HashSize; ++i)
	{
		*p = NULL;
		++p;
	}
 	FHash = NULL;		/* Initialize the FCON hash list to NULL */
}

void
DumpHash()
{
	int i;
	DAG_Node n;

	for (i = 0; i < HashSize; ++i)
		if (Hash[i] != NULL) {
			printf("Hash[%d] ", i);
			n = Hash[i];
			while (n != NULL) {
				printf("%o(%s,", n, opst[n->op]);
				tprint(n->type);
				printf(") ");
				n = n->chain.hash_link;
			}
			putchar('\n');
		}
}
