/* dag.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Directed Acyclic Graph Representation of a Basic Block
 */

/*
 *	See: Aho and Ullman, Principles of Compiler Design, Section 12.3
 */

#ifndef DAG

#define DAG

#ifndef lint
/*	@(#) (Gould) $Header: dag.h,v 5.5 89/05/12 12:49:59 pcc Rel-3_0 $		  */
/* static char DAG_SCCSID[] = "@(#)	dag.h	15.2	of 86/09/25"; */
#endif

#include <longset.h>
#include <tree.h>
#include <bool.h>
#include <identifier.h>
#include <ops.h>

/*
 *	The DAG itself
 *
 *	The fields are ordered (unfortunately) to minimize space lost
 *	to alignment on 32 bit machines.  Changes to typedefs, additional
 *	fields or a different word length might change the appropriate
 *	ordering.  This affects performance only.  The fields can be freely
 *	ordered for that purpose.
 */

typedef struct DAID {		/* DAG Attached Identifier */
	Identifier id;		/* The attached identifier */
	DefsIndex UDIndex;	/* number of this def for UD chain purposes */
	struct DG * leaf_ref;	/* Leaf associated with this id */
	struct DG * killed_by;	/* node that killed this attachment */
	struct DG * prev_attach;/* node to which identifier was attached */
	struct DAID *next;	/* next id on this node, or next free */
	Boolean sticky;		/* should this ID be left attached to this
				 * node? */
	Boolean valid_carrier;	/* if this node ID is valid as a carrier for
				   this node */
} AID_type, *AttachedID;

/*
 *	A list of nodes
 */

typedef struct DNLE {		/* Dag Node List Element */
	struct DNLE *next;	/* Next one on list */
	struct DG *n;		/* This node */
} DagListElement, *DagNodeList;
	
typedef struct DG {		/* DAG Node */

	Operator op;		/* Node operator, same as in tree nodes */

	Boolean hashable;	/* is this node available for hashing */

	Identifier carrier;	/* Identifier that carries the value */

	Identifier leaf_id;	/* If it's a leaf */

	DagNumber order;	/* Creation order number */
	DagCount count;		/* number of assignment nodes */
	DagCount in_degree;	/* direct of references to this node */
	DagCount activity;	/* (dynamic) number of dependent nodes now */
	DagCount delay_count;	/* number of delayed stores pointing here */

	TreeNode new_tree;	/* During translation: how to compute it */
				/* Note: during construction, used to point
				 * to example tree for STxxx ops that need
				 * stn data.
				 */

	TreeNode e_tree;	/* Evaluation tree: during tree construction,
				 * how to evaluate the node.  New_tree
				 * is the tree to generate for the node,
				 * which may have assignments.
				 */

	TWORD type;		/* type, from tree node */

	struct DG *delayed;	/* node to be stored here when inactive */

	struct DG *next;	/* linked in creation order */
	union {
	    struct {
		struct DG *left;	/* Left child */
		struct DG *right;	/* right child */
	    } in;		    /* interior node */
	    struct {
		CONSZ lval;
		int rval;		/* reg # for FORCE; fld size for FLD */
	    } tn;		    /* terminal node */
	    struct {
		FCONSZ dval;		/* FCON */
	    } fpn;
	} u;

	union {				/* Used for chaining nodes together */
		struct DG *hash_link;	/* list in this hash bucket */
		struct DG *loop_invar;	/* loop invariant pointer */
		DagNodeList first_cond;  /* first node in cond'l zone with
					   side effects.  Warning: Used by
					   UpdateActivity...
					 */
	} chain;

	struct DG *av_expr_link;	/* link for avail expressions */
	AttachedID attached;	/* list of attached identifiers */
	LongSet In;		/* list of definitions reaching this node */
	FlowIndex FGindex;	/* Flow Graph index used by loop invariant
				 * code
				 */
	DefsIndex UDIndex;	/* For assign nodes, the UD number of first
				 * resulting def
				 */

	Identifier indirect;	/* For UNARY MUL nodes, the identifier
				 * that this references, if we know
				 */

	HashIndex hash;		/* For hashing algorithm */

	AvailIndex AEIndex;	/* For available expressions, magic cookie
				 * assigned to this node */
	
	char *file_name;	/* From the instruction that built this node*/
	LineNumber line_number;	/* ditto */

	CostType cost;		/* cost associated with this node */
	DagCount refs;		/* Number of references to this node (some
				   incoming edges are not computation refs */
	DagCount in_cond;	/* Which conditional group its in */

	Boolean sticky;		/* Should there always be an attached
				 * id on this node?
				 */
	Boolean invariant;	/* Does the value of this node change in
				 * a loop?
				 */
	Boolean never_invariant;/* Can this node ever be loop invariant?
				 */
	Boolean is_fetch;	/* Is this UNARY MUL a fetch or a store? */

	Boolean special_delay;	/* Delayed store cannot wait - use a temp */

	Boolean prev_valid_carrier; /* Is carrier valid prior to first visit
					to this node? */

	Boolean carrier_required;   /* a carrier is required for this node */

	Boolean evaluated;	/* Used in ActivityDag() */

	Boolean visited;	/* Used by various routines */

} DAG_type, *DAG_Node;

/*
 *	Constants
 */

#define NotConditional	0		/* Not a conditional node */

#define ForceDelete	True		/* DeleteID should always delete */
#define NoForceDelete	False

/*
 *	Exported Operations
 */

extern void	InitDagModule(); /* Initializes the module */
extern void	BuildDAGS();	/* Called to build the DAG */
extern void	ClearVisit();	/* Prepare for a traverse of the DAG */
extern void	DeleteID();	/* Remove an identifier from a DAG node */
extern AttachedID AttachID();	/* Attach an identifier to a DAG node */
extern AttachedID FindAttachedMember();	/* is an id on a list ? */
extern AttachedID MakeTemp();	/* Make a temp for a node and attach it */
extern void	PrintGraph();	/* Debug: Print a graph */
extern void	FreeDag();	/* Clean it up */
extern void	InitActivity();	/* Get DAG ready for activity count alg. */
extern void	DoneActivity();	/* Finish off activity count alg. */
extern void	UpdateActivity(); /* After evaluating a node */
extern void	DecrementActivity(); /* Recursively do tree */
extern void	IncrementActivity(); /* Inverse of DecrementActivity */
extern void	InitDAG();	/* Initialize for building a DAG */
extern DAG_Node	CreateNode();	/* create another DAG node */
extern Boolean	WillHaveCarrier();/* will this node have a valid carrier */
extern DAG_Node	FconDAG();	/* search for FCON DAG in the FCON Hash List*/

extern DAG_Node FirstNodeCreated;	/* first node created by CreateNode */

#endif
