/* config.h */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Definitions of machine or configuration dependent things
 */

#ifndef CONFIG

#define CONFIG

#ifndef lint
/*	@(#) (Gould) $Header: config.h,v 5.5 89/05/12 12:49:42 pcc Rel-3_0 $		  */
/* static char CF_SCCSID[] = "@(#)	config.h	14.3	of 86/12/16"; */
#endif

/*
 *	Configuration definitions for the optimizer
 */

/*
 *	Default value for GoodGlobals flag.
 *		1 => Globals are assumed non-volatile
 *		0 => Globals are assumed volatile.
 */

#define DefaultGoodGlobals	1

/*
 *	The following select options for the longset module.
 *	They may depend on the target machine.
 */

#undef	MDEP_CARDINALITY		/* do not use */
#define	FASTSET				/* use mem* functions for set ops */
#define	SETBITS	32			/* number of bits in unsigned long */
/*
 *	These options control how some of the set primitives are coded.
 *
 *	Option 1: How should the div and mod operations be performed?
 *
 *	   a) With / and % operators.
 *	      To select this, #undef SetPower
 *	   b) With shift and mask (SETBITS must be a power of 2)
 *	      To select this,
 *		#define SetPower log base 2 (SETBITS)
 *		#define SetMask  (2**SetPower) - 1  
 *	      
 */

/*#undef SetPower */	/* Use / and % operators */

#define SetPower 5			/* log base 2 (SETBITS) */
#define SetMask  0x1F			/* 5 bits on */

/*
 *	Set Option 2: Use variable shifts or table lookup?
 *
 *	On some machines 1 << e (e a variable) is faster than a
 *	memory reference, on others it is slower.
 *
 *	#define UseVariableShifts	-- use 1 << e
 *	#undef  UseVariableShifts	-- use a table lookup
 */

#undef UseVariableShifts		/* use a table lookup */

/*
 *	This defines constants and types that may vary depending
 *	on the machine and/or the size of the programs to be optimized.
 *	In most cases, two identifiers are defined.  One defines the
 *	largest possible value for a type, the other is the C type
 *	that is used to hold such values.
 *
 *	Many of these types are more properly exported from one of the
 *	optimizer modules.  They are defined here for convenience in
 *	moving the optimizer to a new machine.   The inclusion of
 *	subranges in C would have eliminated this problem.
 *
 *	Note: If any of these types are made larger than an int, then
 *	there may be printf() calls that need the format string changed.
 */

/*
 *	Size of the symbol table.  (Someday we'll make it grow
 *	automatically).  Should generally be larger for f77
 *	than for C, but a larger one doesn't hurt C.
 */

#define SymbolTableSize 	1200

/*
 *	Cost and Benefit computations, see cost.h
 */

#define		CostMax		0x7fffffff	/* -CostMax .. CostMax */
typedef		long		CostType;	/* Must be signed */

/*
 *	Program Size: maximum number of flow nodes and basic blocks,
 *	DAG nodes, definitions and uses (for ud-chains), program lines,
 *	program labels, and identifiers (including  optimizer generated
 *	ones).
 */

/*
 *	Maximum number of flow graph nodes (and basic blocks)
 */

#define		MaxFlowNodes	65535

typedef		unsigned short	FlowIndex;	/* 0..MaxFlowNodes (flow.h) */
typedef		unsigned short	BlockNumber;	/* 0..MaxFlowNodes (blocks.h) */

#define		MaxDagNodes	65535
#define		DagMaxNum	(MaxDagNodes-1)	/* zero origin */

typedef		unsigned short	DagCount;	/* a number of DAG nodes */
typedef		unsigned short	DagNumber;	/* a DAG node number */

#define		IdentMax	65535

typedef		unsigned short	Identifier;	/* 0..IdentMax (identifier.h) */

#define		DefsMax		65535
#define		UsesMax		65535
#define		AvailMax	65535

typedef		unsigned short	DefsIndex;	/* 0..DefsMax (udchain.h) */
typedef		unsigned short	UsesIndex;	/* 0..UsesMax (duchain.h) */
typedef		unsigned short	AvailIndex;	/* 0..AvailMax (availexpr.h) */

#define		LabelsMax	65535

typedef		unsigned short	LabelType;	/* 0..LabelsMax (labels.h) */

#define		LinesMax	65535		/* line number */

typedef		unsigned short	LineNumber;	/* 0..LinesMax (instruct.h) */

#define		HashMax		65535
typedef		unsigned short	HashIndex;	/* 0..HashMax (daghash.h) */

/*
 *	Describing the target machine.  These are not exported from any
 *	module.  Some of the actual constants are defined in PCC's
 *	manifest and are not repeated here.
 */

typedef		unsigned char	RegisterNumber;	/* 0..MaxRegisterNumber */
typedef		unsigned char	RegCount;	/* 0..MaxRegisterNumber+1 */


#define HAS_SINGLE_ARITHMETIC

#endif
