/* comsubex.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */
/*
 *	Common Subexpressions within a Basic Block
 */

/*
 *	See: Aho and Ullman, Principles of Compiler Design, Section 12.3
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: comsubex.c,v 5.5 89/05/12 12:49:38 pcc Rel-3_0 $";
/* static char ID[] = "@(#)comsubex.c	15.1	of 86/10/23"; */
#endif

/*	Import
 */

# include <assert.h>
# include <blocks.h>
# include <dag.h>
# include <ops.h>
# include <comsubex.h>
# include <refcount.h>
# include <temp.h>
# include <cost.h>
# include <pcc.h>

/*
 *	Forward
 */

/*	Export
 */

int sdebug = 0;

/*
 *	Private
 */

/*
 *	Find Common Subexpressions
 */

#define max(a, b)	((a) > (b) ? (a) : (b))

static void
DagCommon(d)			/* Find common in one DAG */
	DAG_Node d;
{
	DAG_Node n, tn;
	CostType temp_cost, re_eval_cost;
	Operator op;
	AttachedID aid;

	for (n = d; n != NULL; n = n->next) {
		DAGCost(n);
		op = n->op;
		if (n->refs > 1 && 		    /* used more than once */
		    n->carrier == NoId &&	    /* no carrier */
		    op != LNAME && op != PNAME)     /* these aren't eligible*/
		{

			/* n represents a common subexpression with
			 * no variable to hold its value.
			 */

			/* Assume temp will be in REG.  If it
			 * isn't, and the stack is too expensive,
			 * UselessTemp will zap this temp.
			 */

			temp_cost = n->refs * RefCost(REG, n->type) +
				    StoreCost(REG, n->type) +
				    n->cost;	/* one evaluation */
			re_eval_cost = n->refs * n->cost;

			if( sdebug > 1 )
			{
				printf("DAGcost #%d temp %d eval %d\n",
					n->order, temp_cost, re_eval_cost);
			}

			if( temp_cost < re_eval_cost ) {

				/*
				 * We never put OCONVLEAFs into
				 * temps.  If we want to, we put
				 * the child, which represents the
				 * actual thing.
				 */

				if (n->op == OCONVLEAF) {
					tn = n->u.in.left;
					assert(tn != NULL);
					if (tn->carrier != NoId)
						tn = NULL;
				} else
					tn = n;

				if (tn != NULL) {
					aid = MakeTemp(tn, 'c', TempType(n->type));
					tn->carrier = aid->id;
					MarkTransparent(aid->id);
				}
			}
		}
	}
}

void
FindCommon()		/* Create variables for all common sub-expressions */
{
	BasicBlock b;

	InitRefs();
	for (b = FirstBlock; b != NULL; b = b->next) {
		if( b->reachable ) {
			DagCommon(b->Dag);
			if (sdebug) {
				printf("\nAfter Common Subexpressions\n\n");
				PrintGraph(b->Dag);
			}
		}
	}
}
