/* allocvect.c */
/*
 * HCR Confidential
 *
 * These computer programs are the confidential, proprietary property
 * of HCR (Human Computing Resources Corporation, 10 St. Mary Street,
 * Toronto, Ontario, Canada), and may not be disclosed except with the
 * prior written agreement of HCR.
 *
 * Copyright (c) 1984, 1985, 1986 Human Computing Resources Corporation
 * All Rights Reserved
 */

/*
 *	Allocation Vector Module
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: allocvect.c,v 5.5 89/05/12 12:49:07 pcc Rel-3_0 $";
/* static char ID[] = "@(#)allocvect.c	14.2	of 86/06/11"; */
#endif

/*
 *	This module implements operations on allocation vectors.  See
 *	comments in allocvect.h.
 *
 *	Implementation Notes:
 *
 *		1) The set in a vector element has Identifiers as its
 *		   elements.  We always allocate these sets to have
 *		   room for MaxIdentifier+1 elements.
 *
 *		2) The vector operations implement the op= form.  The
 *		   arguments are passed by reference. The first one is
 *		   updated "in-place; the second one is destroyed.
 */

# include <assert.h>
# include <longset.h>
# include <allocvect.h>
# include <dagsymbol.h>
# include <storage.h>
# include <cost.h>
# include <erroro.h>

static AllocationVector FreeList = NULL;	/* Available */

AllocationVector
CreateVector(benefit, id)
	int benefit;
	Identifier id;
{
	AllocationVector v;

	if (FreeList != NULL) {
		v = FreeList;
		FreeList = FreeList->next;
	} else {
		v = GetStorage(s_AllocVects, AllocElement);
		CheckStorage(v, "storage for allocation vectors", 0);
	}
	v->benefit = benefit;
	v->s = CreateSet((int) (MaxIdentifier + 1));
	NullSet(v->s);
	Insert((int) id, v->s);
	v->next = NULL;
	return v;
}

static void
FreeElement(v)		/* Reclaim the storage for v */
	AllocationVector v;
{
	DestroySet(v->s);
	v->next = FreeList;
	FreeList = v;
}

void
VectorFree(v)		/* Reclaim all of v */
	AllocationVector v;
{
	AllocationVector vp;

	while (v != NULL) {
		vp = v->next;
		FreeElement(v);
		v = vp;
	}
}

void
VectorSum(va, vb)	/* Elementwise sum and union: va += vb */
	AllocationVector *va;
	AllocationVector *vb;
{
	AllocationVector va_p, va_prev, vb_p, vb_n;

	/*	Update the "a" vector with the corresponding element
	 *	of the "b" vector.  If the "b" vector is longer,
	 *	the left-over gets appended.
	 */

	vb_p = *vb;
	va_p = *va;
	va_prev = NULL;		/* previous pointer to "a" */
	while (va_p != NULL) {
		if (vb_p != NULL) {	/* Combine these two elements */
			va_p->benefit += vb_p->benefit;
			Union(va_p->s, va_p->s, vb_p->s);
			vb_n = vb_p->next;
			FreeElement(vb_p);
			vb_p = vb_n;
		}
		va_prev = va_p;
		va_p = va_p->next;
	}

	if (vb_p != NULL) {		/* b was longer */
		if (va_prev == NULL) 	/* a was empty */
			*va = vb_p;
		else
			va_prev->next = vb_p;
	}
	*vb = NULL;		/* b no longer exists */
}

void
VectorMerge(va, vb)		/* Ordered merge: va Merge= vb */
	AllocationVector *va;
	AllocationVector *vb;
{
	AllocationVector v, vl, vt, va_p, vb_p;

	v = vl = NULL;		/* the result */
	va_p = *va;
	vb_p = *vb;

	while (va_p != NULL && vb_p != NULL) {

		/* there is something on each list */

		if (va_p->benefit > vb_p -> benefit) {
			vt = va_p;
			va_p = va_p->next;	/* Advance va */
		} else {
			vt = vb_p;
			vb_p = vb_p->next;	/* Advance vb */
		}

		/* append vt to the result */

		vt->next = NULL;
		if (vl == NULL)		/* result is empty */
			v = vt;
		else
			vl->next = vt;
		vl = vt;
	}

	if (va_p != NULL) 	/* append the rest of va */
		vt = va_p;
	else
	if (vb_p != NULL)
		vt = vb_p;	/* append the rest of vb */
	else
		vt = NULL;	/* No more to append */

	if (vl == NULL)
		v = vt;
	else
		vl->next = vt;

	*va = v;
	*vb = NULL;
}

void
PrintVector(v)				/* Debug: print v */
	AllocationVector v;
{
	int i;

	i = 0;
	while (v != NULL) {
		printf("[%d]: benefit %d  Ids: ", i, v->benefit);
		DumpSet(v->s);
		putchar('\n');
		++i;
		v = v->next;
	}
}
