/************************************************************************
*									*
*		getcon.c - input a constant from the Icode file		*
*									*
************************************************************************/

#include "uccio.h"

/* read a constant from the intermediate file (stdin) */

long
getcon(){

	long		l;
	register	i;

	i = getchar();
	l = i;
	if( i >= 0 && i <= 0x7f ) goto ret;	/* one byte constant	*/
	if( !(i & 0x40) ){			/* two byte constant	*/
		l = i & 0x3f;
		l <<= 8;
		i = getchar();
		l |= i;
		goto ret;
	}
	i &= 0x3f;				/* count for multibyte	*/

	/* note: in the following, constants can be no larger
	   than can be supported by a long on the host
	   machine							*/

	l = 0;
	while( --i >= 0 ) l = (l << 8) | getchar();
ret:	return l;
}
