/* $Id: macport.hpp,v 1.5 92/08/28 09:41:38 tal Exp Locker: tal $ */

/* Copyright (C) MICA Inc. and Tal Korin 1991 */
/* All rights reserved */

/* macport.hpp - definition of class MacSerialPort */

/* FOR_ISC */

#ifdef OSMAC

#ifndef MACPORT_HPP
#define MACPORT_HPP


#include "phyport.hpp"

extern "C" {
#include <Devices.h>
#include <Serial.h>
}

class MacSerialPort;

/* Driver reference numbers */
const int MODEM_READ = ainRefNum;
const int MODEM_WRITE = aoutRefNum;
const int PRINTER_READ = binRefNum;
const int PRINTER_WRITE = boutRefNum;

class MacSerialPort : public PhysicalSerialPort {
protected:
	SPortSel portNumber;	// sPortA (modem) or sPortB (printer)
	struct {
		short in, out;
	} refnum;
	struct {
		unsigned char in [10];
		unsigned char out [10];
	} drname;
	short setCommParams ();

public:
	MacSerialPort (short i_portNumber);
	~MacSerialPort ();
	virtual short Open (enum OpenMode i_mode);
	virtual short Read (char *o_buf, short i_maxLen);
	virtual short Write (char *i_buf, short i_len);
	virtual short Close ();
	virtual short SetBaud (unsigned short i_baudRate);
	virtual short SetDataBits (char i_dataBits);
	virtual short SetStopBits (char i_stopBits);
	virtual short SetParity (char i_parity);
	virtual PhysicalSerialPortHANDLE DeepCopy ();
	virtual short ReplyPortNumber ();
	virtual void SetPortNumber (short);
};


#endif /* MACPORT_HPP */

#endif



