/*********************************************************************
*
* Routine: reduce_times
*
* Description: Reduces overlapping time (line) segments to minimum non-
*              overlapping time segments.  Routine uses implicit 
*              recursion to reduce the segments after each pass.
*
*              This routine defines 6 possible cases for any two
*              line segments. They are as follows:
*
*              contained    - where segment two is completely contained
*                             within segment one. 
*
*                             |-------------------|
*                                    |------|
*
*              span         - where segment two completely spans segment
*                             one.
*
*                                   |----------|
*                             |-----------------|
*
*              overlap low  - where segment two overlaps segment one on
*                             the low end.
*
*                                   |---------|
*                              |--------|
*
*              overlap high -  where segment two overlaps segment one on
*                              the high end.
*
*                              |------------|
*                                    |----------|
*
*              separate low -  where segment two is completely separate
*                              from and is less then segment one.
*
*                                          |----------|
*                              |-------|
*
*              separate high - where segment two is completely separate
*                              from and is greater then segment one.
*
*                              |---------|
*                                          |----------|
*
*              Given these cases, the algorithm compares the pairs of
*              line segments and adjusts either the starting point or the
*              ending point of the line segment as appropriate.   All 
*              overlaps are known to be eliminated when the algorithm
*              performs an iteration and no adjustments are made to the 
*              start/end points.
*
*              End points for the line segments are stored in two parallel 
*              arrays.
*
* Call:     None
*
* Arguments:   start -  Array of max 50 elements that contains the start
*                       points of the line segments.
*              stop  -  Array of max 50 elements that contains the end
*                       points of the line segments.
*              n     -  The number of elements actually in start and stop.
*
* Return:  The arrays start and stop with the overlapping line segments
*          reduced to the minimum number of non-overlapping line segments.
*
* Author: Amy Kraieski
*
* Date:   May 25, 1991
*
* Modification history:
* 12/10/91:  Increased the size of 'start' and 'stop' arrays from 50 to 100.
*            (Jerry Chua)
*
***********************************************************************/
#include <stdio.h>

int reduce_times (start, stop, n)
int start [100], stop[100], n;
{
int i, j, k, done;

done = 0;
do {
done = 1;
if (n == 1) break;   /* If only one element, no need to continue */
for (i = 1; i<n; i++) {
if (start[i] != stop[i]) { /* If start & stop are =, next iteration */
for (j = 0; j<= i-1; j++) {
/* separate low and high */
if (stop[i] < start [j] || start [i] > stop[j]) { 
continue;   /* requires no change to the array elements */
}
/* contained */
if (start[i] >= start[j] && stop[i] <= stop[j]) {
start[i] = 0;   /* contained elements are set zero */
stop[i] = 0;   
done = 0;
goto outer_loop;
}
/* span */
if (start[i] <= start[j] && stop[i] >= stop[j]) {
start[j] = start[i];  /* elements that are spanned take on */
stop[j] = stop[i];    /* the values of the spanning element */
done = 0;
goto outer_loop;
}
/* overlap low */
if (start[i] < start[j] && stop[i] >= start[j]) {
start[j] = start[i];  /* overlap low means the start of */
done = 0;             /* segment two needs adjusted */
goto outer_loop;
}
/* overlap high */
if (start[i] <= stop[j] && stop[i] > stop[j]) {
stop[j] = stop[i];   /* overlap high means the stop of */
done = 0;            /* segment two needs adjusted */
goto outer_loop;
}
}
}
outer_loop:;
}
}
while (!done);
}
