/***********************************************************************
*
* Function:     get_user_info
*
* Input Param:  return code
*
* Return:       dependent on return code
*
*                 0 = all:
*                     6 char user employee number,
*                     login name,
*                     group id,
*                     login directory,
*                     login shell
*
*                 1 = 6 char user employee number
*
*                 4 = user home directory
*
***********************************************************************/

#include <stdio.h>
#include <pwd.h>

get_user_info (num_args)
  int 	num_args;   /* # of arguments passed. */
{
  struct passwd *user_pwd,
                *getpwuid ();
  int  	ret_code;
  int  	uid;
  char	char_uid[7];


  if (num_args != 1)
  {
     fprintf (stderr, "get_user_info: wrong number of arguments.\n");
     exit (1);
  }
  popint (&ret_code);

  uid = getuid();
  user_pwd = getpwuid (uid);

  sprintf (char_uid, "%06d", uid);

  switch (ret_code) {

  case 0:     /* return all */
  	retquote (char_uid);
  	retquote (user_pwd->pw_name);
  	retint (user_pwd->pw_gid);
  	retquote (user_pwd->pw_dir);
  	retquote (user_pwd->pw_shell);
  	return (5);

  case 1:     /* return uid (em_num) */
  	retquote (char_uid);
  	return (1);

  case 4:     /* return user directory */
  	retquote (user_pwd->pw_dir);
  	return (1);

  default:
	fprintf (stderr, "get_user_info: Wrong Return Code Received from Calling Function.\r\n");
	return (0);
  }
}
