#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

extern struct z_to_z {
	short	from_zip, to_zip, hour_off, dst_flag;
} zip_to_zone[];

extern int	yrdays[];

extern int	days_in_month[];

/*
IN THIS FILE

conv_date_to_secs
convert_dur_to_secs
conv_secs_to_date
convert_secs_to_days_dur
convert_secs_to_dur
convert_secs_to_dec
day_of_week
check_date_4
see also date_to_secs in util_4gl
*/

/*
MOVED TO COMMON

get_cust_offset
during_dst
sunday
dysize
*/

/*
DEFUNCT OLD PROGRAMS

conv_date_2_sec
convert_sec_to_date3
check_date
check_date_new
check_date3
convert_date_to_sec
during_dst_ts
convert_sec_to_date
*/


/*********************************************************************
*
* Procedure: conv_date_to_sec (convert date to seconds).
*
* Description:
*
*            This procedure converts a date or time string into
*            seconds relative to January 1, 1970 at 0000 hours.
*            The variable conv_type,  specifies the type
*            of conversion.  The possible types are
*                a) -- convert date of format mm/dd/yy to seconds.
*                b) -- convert time of format mm/dd/yy hh:mm to
*                      seconds.
*                c) -- convert time of format mm/dd/yy hh:mm:ss to
*                      seconds.
*
* Call:  conv_date_2_sec (date_str, len (date_str), offset)
* Call:  conv_date_2_sec (str, int, int)
*
*          char  date_str [];  The input string to be converted from.
*          int   len_date_str; The length of date_str.
*          short offset;       The number of hours to adjust the time.
*
* Return:    int = 1  (Conversion was successful)
*                = -1 (Could not decipher input string)
*
* DB files used:  None.
*
* Author: Jerry Chua.
*
* Date:   Dec. 14, 1988.
*
* Modification history:
*    Tom Finger added len_date_str param.   5-3-90
*    Tom Finger deleted conv_type param.    1-3-91
*    Tom Finger added user_dst_flag param.  1-4-91
*
***********************************************************************/

conv_date_to_secs (n)
int	n;
{
	int		conv_type;
	int		len_date_str;
	char	date_str [18];
	short	offset;
	short	user_dst_flag;
	register long	seconds = 0;
	int	month, day, year,
	hour, minute, second;

	if (n != 4) {
		fprintf (stderr, "\r\n Error in conv_date_to_secs: Wrong number or args");
		fprintf (stderr, "\r\n Expected 4 ... Got %d \r\n", n);
		return (1);
	}

	popshort (&user_dst_flag);
	popshort (&offset);
	popint (&len_date_str);
	popquote (date_str, len_date_str + 1);

	switch (len_date_str) {

	case 8:
		conv_type = 1;
		break;
	case 14:
		conv_type = 2;
		break;
	case 17:
		conv_type = 3;
		break;
	default:
		printf ("conv_date_to_secs: Invalid String Length %d\r\n", len_date_str);
		retlong (-1);
		return (1);
	}

	second = 0;
	if (date_str[0] == ' ' || date_str[0] == '\0') {
		retlong (seconds);
		return (1);
	}

	if (conv_type == 1)  /* Convert date only? */ {
		if (sscanf (date_str, "%d/%d/%d", &month, &day, &year) != 3) {
			retlong (-1);
			return (1);
		} else
			strcat (date_str, " 00:00:00"); /* for use in call to during_dst */
	}
	if (conv_type == 2) {
		if (sscanf (date_str, "%d/%d/%d %d:%d",
		    &month, &day, &year, &hour, &minute) != 5) {
			retlong (-1);
			return (1);
		} else
			strcat (date_str, ":00"); /* for use in call to during_dst */
	}
	if (conv_type == 3) {
		if (sscanf (date_str, "%d/%d/%d %d:%d:%d",
		    &month, &day, &year, &hour, &minute, &second) != 6) {
			printf ("bad date format\n");
			retlong (-1);
			return (1);
		}
	}

	            /* seconds for years since 1970 */
	if ((year - 70) >= 0)
		seconds = yrdays[year-70] * 86400;
	else {
		retlong (-1);
		return (1);
	}


	            /* add seconds for days since Jan 1 */
	seconds += days_in_month[month-1] * 86400;

	            /* if this year is leap, add a day */
	if (month > 2 && year % 4 == 0)
		seconds += 86400;

	            /* add seconds since first of month */
	seconds += (day - 1) * 86400;

	            /* add any hh:mm:ss */
	if (conv_type != 1)
		seconds += (hour * 3600) + (minute * 60) + second;

	            /* seconds stored in EST (not EDT) */
	            /* Add in offset from GMT (5) and offset from EST */
	seconds -= offset * 3600;

	            /* subtract 1 hour for Daylight Savings if necessary */
	if (user_dst_flag == 1)
		/*                      this puts it at 2:00 sharp */
		/*                      VVVV VVVV VV VV VVVV VVVVV */
		seconds -= (during_dst (seconds + (offset * 3600)) * 3600);

	retlong (seconds);
	return (1);
}


convert_dur_to_secs (n)
int	n;
{
	char	dur [6];
	char	hours [3], mins [3];
	long	secs;
	int		size_of_dur;

	popint (&size_of_dur);
	popquote (dur, size_of_dur + 1);

	hours[0] = dur[0];
	hours[1] = dur[1];
	hours[2] = '\0';
	mins [0] = dur [3];
	mins [1] = dur [4];
	mins[2] = '\0';
	secs = atoi (hours) * 60.0 * 60.0 +
	    atoi (mins) * 60.0;
	retlong (secs);
	return (1);
}


conv_secs_to_date (n)
int	n;
{
	long	seconds;
	short	offset;
	short	user_dst_flag;
	char	date [18];
	struct tm *tm_p;

	popshort (&user_dst_flag);
	popshort (&offset);
	poplong (&seconds);

	if (seconds <= 0) {
		date[0] = '\0';
		retquote (date);
		return (1);
	}

	            /* seconds stored in db are EST (not EDT) */
	            /* subtract offset from GMT (5) and offset from EST */
	seconds += offset * 3600;

	            /* add 1 hour for Daylight Savings if necessary */
	if (user_dst_flag == 1)
		seconds += (during_dst (seconds) * 3600);

	tm_p = gmtime (&seconds);

	sprintf (date, "%02d/%02d/%02d %02d:%02d:%02d",
	    tm_p->tm_mon + 1, tm_p->tm_mday, tm_p->tm_year,
	    tm_p->tm_hour, tm_p->tm_min, tm_p->tm_sec);

	retquote (date);
	return (1);
}


convert_secs_to_days_dur (n)
int	n;
{
	long	secs;
	char	*itoa ();
	int		mins, hours, days;
	int		remaining_mins;
	char	dur [15];


	secs = -1;
	days = 0;
	poplong (&secs);
	if (secs < 1) {
		strcpy (dur, "         00:00");
		retquote (dur);
		return (1);
	}

	mins = 	secs / 60.0;
	hours = mins / 60;
	days = 	hours / 24;
	remaining_mins = mins - (hours * 60.0);
	hours = hours - (days * 24);

	if (days > 0)
		sprintf (dur, "%3d days ", days);
	else
		sprintf (dur, "         ");

	if (hours < 10) {
		strcat (dur, "0");
		strcat (dur, itoa (hours));
	} else
		strcat (dur, itoa (hours));
	strcat (dur, ":");
	if (remaining_mins < 10) {
		strcat (dur, "0");
	}
	strcat (dur, itoa (remaining_mins));

	retquote (dur);
	return (1);
}


convert_secs_to_dur (n)
int	n;
{
	long	secs;
	int		mins;
	int		hours;
	char	dur [9];

	secs = -1;  /* what is this for, null? */
	poplong (&secs);
	if (secs < 1) 
		strcpy (dur, "00:00");
	else {
		secs += 30;                      /* add rounding factor */
		hours = secs / 3600;
		secs = secs - (hours * 3600);    /* chop out hours */
		mins = secs / 60;
		sprintf (dur, "%02d:%02d", hours, mins);
	}
	retquote (dur);
	return (1);
}


convert_secs_to_dec (n)
int	n;
{
	long	secs;
	double	mins, hours, work;
	int		int_work, int_mins;
	short	round;

	secs = -1;
	popshort (&round);
	poplong (&secs);
	if (secs < 1) {
		hours = 0.0;
		retdub (&hours);
		return (1);
	}

	mins = secs / 60.0;
	int_mins = mins;
	hours = mins / 60.0;
	if (int_mins % 60 != 0) {
		work = hours * 10.0;
		int_work = work;
		if (work > int_work) {
			if (round == 1)   /* Round value up */

				int_work = int_work + 1;
		}
		hours = int_work / 10.0;
	}

	retdub (&hours);
	return (1);
}


day_of_week (n)
int	n;
{
	struct tm *tm_p;
	time_t 	time_stamp;
	short	wday;

	poplong (&time_stamp);
	tm_p = localtime (&time_stamp);

	wday = tm_p->tm_wday;

	retshort (wday);
	return (1);
}


check_date_4 (n)
int	n;
{
	int		len_date_time;
	char	date_time[18];

	int	good_flag;
	char	err_msg[81];

	if (n != 2) {
		fprintf (stderr, "\r\n Error in check_date_4 ... Wrong number or args");
		fprintf (stderr, "\r\n Expected 2 ... Got %d \r\n", n);
		return (1);
	}

	popint (&len_date_time);
	popquote (date_time, len_date_time + 1);

	good_flag = check_datec (date_time, err_msg);

	retquote (err_msg);
	retint (good_flag);
	return (2);
}


check_datec (date_time, err_msg)
char	*date_time;
char	*err_msg;
{
	static int	day_tab [2][13] = {
		{ 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
		{ 0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
	};	



	short	imonth;
	short	iday;
	short	ihour;
	short	iminute;
	short	isecond;
	short	iyear;
	short	leap;
	short	len_date_time;

	/* convert all date sizes to 17 chars */
	len_date_time = strlen (date_time);
	if (len_date_time == 8)
		strcat (date_time, " 00:00:00");
	else if (len_date_time == 14)
		strcat (date_time, ":00");
	else if (len_date_time != 17) {
		strcpy (err_msg,  "Invalid Date Length - Please Re-Enter!");
		return (0);
	}

	/* all entries should be digits */
	if (date_time[0]  < '0' || date_time[0]  > '9' ||
	    date_time[1]  < '0' || date_time[1]  > '9') {
		strcpy (err_msg,  "Invalid Month - Please Re-Enter!");
		return (0);
	}

	if (date_time[3]  < '0' || date_time[3]  > '9' ||
	    date_time[4]  < '0' || date_time[4]  > '9') {
		strcpy (err_msg,  "Invalid Day - Please Re-Enter!");
		return (0);
	}

	if (date_time[6]  < '0' || date_time[6]  > '9' ||
	    date_time[7]  < '0' || date_time[7]  > '9') {
		strcpy (err_msg,  "Invalid Year - Please Re-Enter!");
		return (0);
	}

	if (date_time[9]  < '0' || date_time[9]  > '9' ||
	    date_time[10] < '0' || date_time[10] > '9') {
		strcpy (err_msg,  "Invalid Hour - Please Re-Enter!");
		return (0);
	}

	if (date_time[12] < '0' || date_time[12] > '9' ||
	    date_time[13] < '0' || date_time[13] > '9') {
		strcpy (err_msg,  "Invalid Minute - Please Re-Enter!");
		return (0);
	}

	if (date_time[15] < '0' || date_time[15] > '9' ||
	    date_time[16] < '0' || date_time[16] > '9') {
		strcpy (err_msg,  "Invalid Second - Please Re-Enter!");
		return (0);
	}

	imonth = two_char_to_i (date_time[0], date_time[1]);
	iday   = two_char_to_i (date_time[3], date_time[4]);
	iyear  = two_char_to_i (date_time[6], date_time[7]);

	if (imonth < 1 || imonth > 12) {
		strcpy (err_msg,  "Invalid Month - Please Re-Enter!");
		return (0);
	}

	/* is the given year a leap year ?? */
	if (((1900 + iyear) / 4) - ((1900 + iyear - 1 ) / 4) != 0)
		leap = 1;
	else
		leap = 0;
	if (iday < 1 || iday > day_tab[leap][imonth]) {
		strcpy (err_msg,  "Invalid Day - Please Re-Enter!");
		return (0);
	}

	ihour   = two_char_to_i (date_time[9],  date_time[10]);
	iminute = two_char_to_i (date_time[12], date_time[13]);
	isecond = two_char_to_i (date_time[15], date_time[16]);

	if (ihour < 0 || ihour > 23) {
		strcpy (err_msg,  "Invalid Hour - Please Re-Enter!");
		return (0);
	}

	if (iminute < 0 || iminute > 59) {
		strcpy (err_msg,  "Invalid Minute - Please Re-Enter!");
		return (0);
	}

	if (isecond < 0 || isecond > 59) {
		strcpy (err_msg,  "Invalid Second - Please Re-Enter!");
		return (0);
	}

	strcpy (err_msg, "");
	return (1);
}


two_char_to_i (c1, c2)
char	c1;
char	c2;
{
	char	twoc[3];
	twoc[0] = c1;
	twoc[1] = c2;
	twoc[2] = '\0';
	return (atoi (twoc));
}
