/*
   test CC and CC2.
*/

#define CASSG   /*  needed for fixctrlc below (unixio.h)  */


#include <stdio.h>
#include <unixio.h>


#define    DEAD_       20
#define    none_        0
#define    off_         0
#define    two_         2
#define    zero_        0

#define CVTdef     ((struct CVTmem *)CVTpoint)
#define ERRdef      ((struct ERRmem *)ERRpoint)
#define RDAdef     ((struct RDAmem *)RDApoint)

/*
Datapool
*/

struct CVTmem
   {
   float           ra1,                ra2;
   float           ra3,                ra4;
   float           rbm1,               rbm2;
   float           rbm3,               rbm4;
   float           rbt1,               rbt2;
   float           rbt3,               rbt4;
   float           re1,                re2;
   float           re3,                re4;
   float           rlat1,              rlat2;
   float           rlat3,              rlat4;
   float           rlong1,             rlong2;
   float           rlong3,             rlong4;
   float           rroc1,              rroc2;
   float           rroc3,              rroc4;
   float           rr1,                rr2;
   float           rr3,                rr4;
   float           rsel1,              rsel2;
   float           rsel3,              rsel4;
   float           rspdf1,             rspdf2;
   float           rspdf3,             rspdf4;
   float           rspdk1,             rspdk2;
   float           rspdk3,             rspdk4;
   float           rxvel1,             rxvel2;
   float           rxvel3,             rxvel4;
   float           rx1,                rx2;
   float           rx3,                rx4;
   float           ryvel1,             ryvel2;
   float           ryvel3,             ryvel4;
   float           ry1,                ry2;
   float           ry3,                ry4;
   float           rzvel1,             rzvel2;
   float           rzvel3,             rzvel4;
   float           rz1,                rz2;
   float           rz3,                rz4;

   int             icom1,              icom2;
   int             igts1,              igts2;
   int             igts3,              igts4;
   int             igt_h1,             igt_h2;
   int             igt_h3,             igt_h4;
   int             igt_m1,             igt_m2;
   int             igt_m3,             igt_m4;
   int             igt_s1,             igt_s2;
   int             igt_s3,             igt_s4;
   int             iinp;
   int             ilatd1,             ilatd2;
   int             ilatd3,             ilatd4;
   int             ilatm1,             ilatm2;
   int             ilatm3,             ilatm4;
   int             ilats1,             ilats2;
   int             ilats3,             ilats4;
   int             ilongd1,            ilongd2;
   int             ilongd3,            ilongd4;
   int             ilongm1,            ilongm2;
   int             ilongm3,            ilongm4;
   int             ilongs1,            ilongs2;
   int             ilongs3,            ilongs4;
   int             ilro1,              ilro2;
   int             irav,               irdd;
   int             iRDIst1,            iRDIst2;
   int             iRDIst3,            iRDIst4;
   int             isid1,              isid2;
   int             isid3,              isid4;
   int             itid1,              itid2;
   int             itid3,              itid4;
   int             itm;
   int             its1,               its2;
   int             its3,               its4;
   };

/*
RADPRO data-area
*/

struct RDAmem
   {
   char                fltlab[20]; 

   double              a1c,                a1d;
   double              a2c,                a2d;
   double              a3c,                a3d;
   double              a4c,                a4d;
   double              bm1c,               bm1d;
   double              bm2c,               bm2d;
   double              bm3c,               bm3d;
   double              bm4c,               bm4d;
   double              bt1c,               bt1d;
   double              bt2c,               bt2d;
   double              bt3c,               bt3d;
   double              bt4c,               bt4d;
   double              e1c,                e1d;
   double              e2c,                e2d;
   double              e3c,                e3d;
   double              e4c,                e4d;
   double              lat1c,              lat1d;
   double              lat2c,              lat2d;
   double              lat3c,              lat3d;
   double              lat4c,              lat4d;
   double              long1c,             long1d;
   double              long2c,             long2d;
   double              long3c,             long3d;
   double              long4c,             long4d;
   double              magdec;
   double              roc1c,              roc1d;
   double              roc2c,              roc2d;
   double              roc3c,              roc3d;
   double              roc4c,              roc4d;
   double              r1c,                r1d;
   double              r2c,                r2d;
   double              r3c,                r3d;
   double              r4c,                r4d;
   double              rotmat[10][9],      tranvec[10][3];
   double              samrate;
   double              sel1c,              sel1d;
   double              sel2c,              sel2d;
   double              sel3c,              sel3d;
   double              sel4c,              sel4d;
   double              spedf1c,            spedf1d;
   double              spedf2c,            spedf2d;
   double              spedf3c,            spedf3d;
   double              spedf4c,            spedf4d;
   double              spedk1c,            spedk1d;
   double              spedk2c,            spedk2d;
   double              spedk3c,            spedk3d;
   double              spedk4c,            spedk4d;
   double              xvwgs1c,            xvwgs1d;
   double              xvwgs2c,            xvwgs2d;
   double              xvwgs3c,            xvwgs3d;
   double              xvwgs4c,            xvwgs4d;
   double              xwgs1c,             xwgs1d;
   double              xwgs2c,             xwgs2d;
   double              xwgs3c,             xwgs3d;
   double              xwgs4c,             xwgs4d;
   double              yvwgs1c,            yvwgs1d;
   double              yvwgs2c,            yvwgs2d;
   double              yvwgs3c,            yvwgs3d;
   double              yvwgs4c,            yvwgs4d;
   double              ywgs1c,             ywgs1d;
   double              ywgs2c,             ywgs2d;
   double              ywgs3c,             ywgs3d;
   double              ywgs4c,             ywgs4d;
   double              zvwgs1c,            zvwgs1d;
   double              zvwgs2c,            zvwgs2d;
   double              zvwgs3c,            zvwgs3d;
   double              zvwgs4c,            zvwgs4d;
   double              zwgs1c,             zwgs1d;
   double              zwgs2c,             zwgs2d;
   double              zwgs3c,             zwgs3d;
   double              zwgs4c,             zwgs4d;

   int                 arcshut;
   int                 az1ac,               az1ad;
   int                 az1bc,               az1bd;
   int                 az2ac,               az2ad;
   int                 az2bc,               az2bd;
   int                 az3ac,               az3ad;
   int                 az3bc,               az3bd;
   int                 az4ac,               az4ad;
   int                 az4bc,               az4bd;
   int                 bdryint,               bint[30];
   int                 caz1a,              caz1b;
   int                 caz2a,              caz2b;        
   int                 caz3a,              caz3b;        
   int                 caz4a,              caz4b;        
   int                 cel1a,              cel1b;        
   int                 cel2a,              cel2b;        
   int                 cel3a,              cel3b;        
   int                 cel4a,              cel4b;        
   int                 com1sid,          com1ur;
   int                 com2sid,          com2ur;
   int                 crge1a,             crge1b;        
   int                 crge2a,             crge2b;        
   int                 crge3a,             crge3b;        
   int                 crge4a,             crge4b;
   int                 disshut;
   int                 eint[30];
   int                 el1ac,              el1ad;
   int                 el1bc,              el1bd;
   int                 el2ac,              el2ad;
   int                 el2bc,              el2bd;
   int                 el3ac,              el3ad;
   int                 el3bc,              el3bd;
   int                 el4ac,              el4ad;
   int                 el4bc,              el4bd;
   int                 errlim,          errrep,          errshut,             filec,              filefg;
   int                 filfgx1,            filfgx2;
   int                 filfgx3,            filfgx4;
   int                 filfgy1,            filfgy2;
   int                 filfgy3,            filfgy4;
   int                 filfgz1,            filfgz2;
   int                 filfgz3,            filfgz4;
   int                 gtms1,              gtms1c,             gtms1d;
   int                 gtms2,              gtms2c,             gtms2d;
   int                 gtms3,              gtms3c,             gtms3d;
   int                 gtms4,              gtms4c,             gtms4d;
   int                 gts1,               gts1c,              gts1d;
   int                 gts2,               gts2c,              gts2d;
   int                 gts3,               gts3c,              gts3d;
   int                 gts4,               gts4c,              gts4d;
   int                 gt_h1c,             gt_h1d;
   int                 gt_h2c,             gt_h2d;
   int                 gt_h3c,             gt_h3d;
   int                 gt_h4c,             gt_h4d;
   int                 gt_ms1,             gt_ms2;
   int                 gt_ms3,             gt_ms4;
   int                 gt_m1c,             gt_m1d;
   int                 gt_m2c,             gt_m2d;
   int                 gt_m3c,             gt_m3d;
   int                 gt_m4c,             gt_m4d;
   int                 gt_s1c,             gt_s1d;
   int                 gt_s2c,             gt_s2d;
   int                 gt_s3c,             gt_s3d;
   int                 gt_s4c,             gt_s4d;
   int                 inpshut,            inpsid,            ktfg;
   int                 latd1c,             latd1d;
   int                 latd2c,             latd2d;
   int                 latd3c,             latd3d;
   int                 latd4c,             latd4d;
   int                 latm1c,             latm1d;
   int                 latm2c,             latm2d;
   int                 latm3c,             latm3d;
   int                 latm4c,             latm4d;
   int                 lats1c,             lats1d;
   int                 lats2c,             lats2d;
   int                 lats3c,             lats3d;
   int                 lats4c,             lats4d;
   int                 leadb,             leade,             leadfg;
   int                 longd1c,            longd1d;
   int                 longd2c,            longd2d;
   int                 longd3c,            longd3d;
   int                 longd4c,            longd4d;
   int                 longm1c,            longm1d;
   int                 longm2c,            longm2d;
   int                 longm3c,            longm3d;
   int                 longm4c,            longm4d;
   int                 longs1c,            longs1d;
   int                 longs2c,            longs2d;
   int                 longs3c,            longs3d;
   int                 longs4c,            longs4d;
   int                 lro1sid,          lro1ur;
   int                 lro2sid,          lro2ur;
   int                 magfg;
   int                 mathfg1,            mathfg2;
   int                 mathfg3,            mathfg4;
   int                 matshut;
   int                 mbuffg1,            mbuffg2,            mbuffg3;
   int                 mbuffg4;
   int                 mesMtR,             mrecfg;
   int                 numint,             openfg,             pedshut;
   int                 por1c,      por1ec,     por2c,      por2ec;
   int                 por3c,      por3ec,     por4c,      por4ec;
   int                 ran1ac,             ran1ad;
   int                 ran1bc,             ran1bd;
   int                 ran2ac,             ran2ad;
   int                 ran2bc,             ran2bd;
   int                 ran3ac,             ran3ad;
   int                 ran3bc,             ran3bd;
   int                 ran4ac,             ran4ad;
   int                 ran4bc,             ran4bd;
   int                 ravsid,          ravur;
   int                 rddhcur,          rddsid,          rddur;
   int                 RDIst1,             RDIst1c,            RDIst1d;
   int                 RDIst2,             RDIst2c,            RDIst2d;
   int                 RDIst3,             RDIst3c,            RDIst3d;
   int                 RDIst4,             RDIst4c,            RDIst4d;
   int                 recb[30],                 rece[30];
   int                 rinshut;
   int                 seqc1,            seqc2,            seqc3,            seqc4;
   int                 siteid1,            siteid2,            siteid3;
   int                 siteid4,            siteid5,            siteid6;
   int                 sitesta[128];
   int                 sithis1,            sithis2,            sithis3,            sithis4;
   int                 sitid1c,            sitid1d;
   int                 sitid2c,            sitid2d;
   int                 sitid3c,            sitid3d;
   int                 sitid4c,            sitid4d;
   int                 sitefg1,            sitefg2,            sitefg3,            sitefg4;
   int                 spanb1,            spanb2,            spanb3,            spanb4;
   int                 spane1,            spane2,            spane3,            spane4;
   int                 telec,            tim1,            tim2,            tim3,            tim4;
   int                 tmsid,          tmur;
   int                 ts1,                ts1c,               ts1d;
   int                 ts2,                ts2c,               ts2d;
   int                 ts3,                ts3c,               ts3d;
   int                 ts4,                ts4c,               ts4d;

   union               tarid
       {
       char            bytes[4];
       unsigned int    words;
       }
                       tid[128],
                       tid1c,              tid1d,
                       tid2c,              tid2d,
                       tid3c,              tid3d,
                       tid4c,              tid4d;

   };

struct ERRmem
   {
   int                 disd1,             disd10,             disd11,             disd12;
   int                 disd15,             disd16,             disd17;
   int                 disd20,             disd25,             disd30,             disd35;
   int                 disd40,             disd45,             disd50,             disd55;
   int                 disd60,             disd65,             disd70,             disd75;
   int                 disd80,             disd85,             disd90,             disd95;
   int                 disd100,             disd101,             disd102;
   int                 disd105,             disd106,             disd107;
   int                 disd110,             disd115;
   int                 disd120,             disd121,             disd122;
   int                 disd125,             disd126,             disd127;
   int                 disd130,             disd135,             disd140,             disd145;
   int                 disd150,             disd155,             disd160,             disd165;
   int                 disd170,             disd175,             disd180,             disd185;
   int                 disd190,             disd195,             disd200,             disd205;
   int                 disd210,             disd220,             disd230,             disd240;
   int                 disd250,             disd260;
   int                 dise1,             dise10,             dise11,             dise12;
   int                 dise15,             dise16,             dise17;
   int                 dise20,             dise25,             dise30,             dise35;
   int                 dise40,             dise45,             dise50,             dise55;
   int                 dise60,             dise65,             dise70,             dise75;
   int                 dise80,             dise85,             dise90,             dise95;
   int                 dise100,             dise101,             dise102;
   int                 dise105,             dise106,             dise107;
   int                 dise110,             dise115;
   int                 dise120,             dise121,             dise122;
   int                 dise125,             dise126,             dise127;
   int                 dise130,             dise135,             dise140,             dise145;
   int                 dise150,             dise155,             dise160,             dise165;
   int                 dise170,             dise175,             dise180,             dise185;
   int                 dise190,             dise195,             dise200,             dise205;
   int                 dise210,             dise220,             dise230,             dise240;
   int                 dise250,             dise260;
   int                 diss10,             diss20,             diss30,             diss40;
   int                 rind1,              rind2,              rind3;
   int                 rind4;        
   int                 rind10,             rind11;
   int                 rind20,             rind21;
   int                 rind30,             rind31,             rind32,             rind33,             rind34;
   int                 rind40,             rind41,             rind42,             rind43,             rind44;
   int                 rind51,             rind52,             rind53,             rind54;
   int                 rind100,            rind110;
   int                 rine1,              rine2,              rine3;
   int                 rine4;
   int                 rine10,             rine11;
   int                 rine20,             rine21;
   int                 rine30,             rine31,             rine32,             rine33,             rine34;
   int                 rine40,             rine41,             rine42,             rine43,             rine44;
   int                 rine51,             rine52,             rine53,             rine54;
   int                 rine100,            rine110;
   int                 rins10,             rins20,             rins30;
   int                 rins40,             rins41,             rins42,             rins43,             rins44;
   int                 rins50,             rins51,             rins52,             rins53,             rins54;
   int                 rins60,             rins61,             rins62,             rins63,             rins64;
   int                 rins70,             rins71,             rins72,             rins73,             rins74;
   };

   /*
   global types
   */

   char          errrif[76] = "4.     Put the parameters for task ERROR in the RADPRO Initialization File.";
   char          inputst[72];  /*  70 + LF + NULL  */
   char          magrif[71] = "5.     Put the magnetic declination in the RADPRO Initialization File.";
   char          outst[72];
   char          rddrif[73] = "6.     Put the RDD control parameters in the RADPRO Initialization File.";
   char          sourif[77] = "1.     Put pedestal and RAV Lab site id's in the RADPRO Initialization File.";
   char          sRDDhc[42] = "8.     Start Radar Data Display hardcopy.";
   char          tarrif[58] = "3.     Put target id's in the RADPRO Initialization File.";
   char          uprif[78] = "2.     Put pedestal & RAV Lab update rates in the RADPRO Initialization File.";

   float          cr1,          cr2,          cr3,          cr4;
   float          ca1,          ca2,          ca3,          ca4;
   float          ce1,          ce2,          ce3,          ce4;
   float          cx1,          cx2,          cx3,          cx4;
   float          cy1,          cy2,          cy3,          cy4;
   float          cz1,          cz2,          cz3,          cz4;
   float          csel1,          csel2,          csel3,          csel4;
   float          cxvel1,          cxvel2,          cxvel3,          cxvel4;
   float          cyvel1,          cyvel2,          cyvel3,          cyvel4;
   float          czvel1,          czvel2,          czvel3,          czvel4;
   float          croc1,          croc2,          croc3,          croc4;
   float          cspedf1,          cspedf2,          cspedf3,          cspedf4;
   float          cspedk1,          cspedk2,          cspedk3,          cspedk4;
   float          cbt1,          cbt2,          cbt3,          cbt4;
   float          cbm1,          cbm2,          cbm3,          cbm4;
   float          clat1,          clat2,          clat3,          clat4;
   float          clong1,          clong2,          clong3,          clong4;

   int          ccom1,          ccom2;
   int          cgtms1,          cgtms2,          cgtms3,          cgtms4;
   int          cgts1,          cgts2,          cgts3,          cgts4;
   int          cgt_h1,          cgt_h2,          cgt_h3,          cgt_h4;
   int          cgt_m1,          cgt_m2,          cgt_m3,          cgt_m4;
   int          cgt_s1,          cgt_s2,          cgt_s3,          cgt_s4;
   int          cinp;
   int          clatd1,          clatd2,          clatd3,          clatd4;
   int          clatm1,          clatm2,          clatm3,          clatm4;
   int          clats1,          clats2,          clats3,          clats4;
   int          clongd1,          clongd2,          clongd3,          clongd4;
   int          clongm1,          clongm2,          clongm3,          clongm4;
   int          clongs1,          clongs2,          clongs3,          clongs4;
   int          clro1,          clro2;
   int          crav;
   int          crdd;
   int          cRDIst1,          cRDIst2,          cRDIst3,          cRDIst4;
   int          csitid1,          csitid2,          csitid3,          csitid4;
   int          cts1,          cts2,          cts3,          cts4;
   int          ctm;
   int         CVTpoint,          ERRpoint,          RDApoint;


   FILE        *fp,          *fp1,          *fp2,          *fp3,          *fp4;

   union       tar
       {
       char                    byte[4];
       unsigned int            word;
       }
               tid1,           ctid1,
               tid2,           ctid2,
               tid3,           ctid3,
               tid4,           ctid4;


int CVTpart();
int RDApart();



main()
   {

   char          *askass = "Are you sure you want to use this filename? (Y or N) ";
   char          *com1ass = "Enter site id for COM1: ";
   char          *com1ur = "Enter update rate for COM1 in ms: ";
   char          *com2ass = "Enter site id for COM2: ";
   char          *com2ur = "Enter update rate for COM2 in ms: ";
   char          *erass = "Enter error message repetition rate in seconds (>= 5): ";
   char          *erlim = "Enter time limit for display of error message in seconds (>= 0): ";
   char          *fltlass = "Input flight test label (maximum 12 characters, no spaces): ";
   char          *lro1ass = "Enter site id for LRO1: ";
   char          *lro1ur = "Enter update rate for LRO1 in ms: ";
   char          *lro2ass = "Enter site id for LRO2: ";
   char          *lro2ur = "Enter update rate for LRO2 in ms: ";
   char          *magass = "Enter magnetic declination in degrees (east is positive): ";
   char          *mainstr = "Input menu selection: ";
   char          *nullstr = "";
   char          point1[14];
   char          qRDI1[32],      qRDI2[32],      qRDI3[32],      qRDI4[32];
   char          RADifn[17];
   char          *ravass = "Enter site id for RAV Lab: ";
   char          *ravur = "Enter update rate for RAV Lab in ms: ";
   char          *rddass = "Enter site id for RDD: ";
   char          *rddhur = "Enter update rate for RDD hardcopy in ms: ";
   char          *rddur = "Enter update rate for RDD in ms: ";
   char          *rdfnass = "Enter name of RADPRO Initialization File to reinitialize from: ";
   char          *rifnass = "Enter the filename you want to change the RADPRO Initialization File to: ";
   char          rifstr[25];
   char          *rotass = "Enter site id for rotation matrix display: ";
   char          *siteass = "Enter site id to be assigned a target id: ";
   char          string1[18];
   char          *tarass = "Enter four character target id (spaces are characters): ";
   char          temstr[25];
   char          *tlass = "Enter time limit for display of error message in seconds (>= 0): ";
   char          *tmass = "Enter site id for TM Dish: ";
   char          *tmur = "Enter update rate for TM Dish in ms: ";
   char          *tvass = "Enter site id for translation vector display: ";

   static char            suffix[5] = ".log";

   double      xwgs1,          ywgs1,          zwgs1;
   double      r1,             a1,             e1;
   double      sel1;
   double      xvwgs1,         yvwgs1,         zvwgs1;
   double      roc1,           speedf1,        speedk1;
   double      bt1,            bm1;
   double      lat1,           long1;
   double      xwgs2,          ywgs2,          zwgs2;
   double      r2,             a2,             e2;
   double      sel2;
   double      xvwgs2,         yvwgs2,         zvwgs2;
   double      roc2,           speedf2,        speedk2;
   double      bt2,            bm2;
   double      lat2,           long2;
   double      xwgs3,          ywgs3,          zwgs3;
   double      r3,             a3,             e3;
   double      sel3;
   double      xvwgs3,         yvwgs3,         zvwgs3;
   double      roc3,           speedf3,        speedk3;
   double      bt3,            bm3;
   double      lat3,           long3;
   double      xwgs4,          ywgs4,          zwgs4;
   double      r4,             a4,             e4;
   double      sel4;
   double      xvwgs4,         yvwgs4,         zvwgs4;
   double      roc4,           speedf4,        speedk4;
   double      bt4,            bm4;
   double      lat4,           long4;

   double          real8;

   float          raux1,          real1;

   int         reset = 0,         set = 1;

   int          ans,          auxar[20],          aux1,          consw = set;
   int          ig,         index,          inint,          inint1,          inint2;
   int          int1,         inuse = 10,          iosw = reset,         iq,          iq1,          jg;
   int          no = 0,          off = 0,          on = 1;
   int          nomess = -1,     nullres = -999999,          nullsid = -999;
   int          nulltid = 0X20202020,          nullur = -9013;
   int          numitem;
   int          present = 1,          priflg,          slen,          tagain,          tagain1,     yes = 1;

   int         caza,       cazb;
   int         cela,       celb;
   int         crgea,      crgeb;
   int         CVTstat;
   int         i;
   int         RDAstat,   regs[8];
   int         siteid;

   int         qcaz1a,     qcaz1b;
   int         qcaz2a,     qcaz2b;
   int         qcaz3a,     qcaz3b;
   int         qcaz4a,     qcaz4b;
   int         qcel1a,     qcel1b;
   int         qcel2a,     qcel2b;
   int         qcel3a,     qcel3b;
   int         qcel4a,     qcel4b;
   int         qcrge1a,    qcrge1b;
   int         qcrge2a,    qcrge2b;
   int         qcrge3a,    qcrge3b;
   int         qcrge4a,    qcrge4b;

   int         qpor1c,     qpor1ec;
   int         qpor2c,     qpor2ec;
   int         qpor3c,     qpor3ec;
   int         qpor4c,     qpor4ec;

   int         qrind1,         qrind2,         qrind3;
   int         qrind4,         qrind10,        qrind11;
   int         qrind20,        qrind21,        qrind30;
   int         qrind31,        qrind40,        qrind41;
   int         qrind100,       qrind110;
   int         qrine1,         qrine2,         qrine3;
   int         qrine4,         qrine10,        qrine11;
   int         qrine20,        qrine21,        qrine30;
   int         qrine31,        qrine40,        qrine41;
   int         qrine100,       qrine110;
   int         qrins10,        qrins20,        qrins30;
   int         qrins40;

   int         buf1;
   int         latd1,          latm1,          lats1;
   int         longd1,         longm1,         longs1;
   int         siteid1,        RDIst1,         ts1;
   int         gts1,           gtms1;
   int         gt_h1,          gt_m1,          gt_s1;
   int         buf2;
   int         latd2,          latm2,          lats2;
   int         longd2,         longm2,         longs2;
   int         siteid2,        RDIst2,         ts2;
   int         gts2,           gtms2;
   int         gt_h2,          gt_m2,          gt_s2;
   int         buf3;
   int         latd3,          latm3,          lats3;
   int         longd3,         longm3,         longs3;
   int         siteid3,        RDIst3,         ts3;
   int         gts3,           gtms3;
   int         gt_h3,          gt_m3,          gt_s3;
   int         buf4;
   int         latd4,          latm4,          lats4;
   int         longd4,         longm4,         longs4;
   int         siteid4,        RDIst4,         ts4;
   int         gts4,           gtms4;
   int         gt_h4,          gt_m4,          gt_s4;
   int         rgps,           rinp,           rrdd;
   int         rcom1,          rcom2;
   int         rlro1,          rlro2;
   int         rtm,            rrav;



       /*
       load shared memory partitions.
       */

       CVTstat = CVTpart(&CVTpoint);
       if ( CVTstat != 0 )
           {
           printf("\n\nMENU CVT partition did not load; load-status = %i . Aborting RADPRO",CVTstat);

               /*
               suspend MENU
               */

               regs[5] = -180;   /* suspend 3 seconds for other tasks to start */
               regs[6] = 0;
               regs[7] = 0;
               mpxsvc(0x1054,regs,regs);

           exit(CVTstat);
           }
       /*ENDIF*/
       RDAstat = RDApart(&RDApoint);
       if ( RDAstat != 0 )
           {
           printf("\n\nMENU's RDA partition did not load; load-status = %i . ABORTING RADPRO",RDAstat);

               /*
               suspend MENU
               */

               regs[5] = -180;   /* suspend 3 seconds for other tasks to start */
               regs[6] = 0;
               regs[7] = 0;
               mpxsvc(0x1054,regs,regs);

           exit(RDAstat);
           }
       /*ENDIF*/
   RDAstat = RDApart(&RDApoint);
   ERRpoint = RDApoint + sizeof(struct RDAmem);

/* debug only. remove. */

RDAdef->com1sid = nullsid;
RDAdef->com1ur = nullur;
RDAdef->com2sid = nullsid;
RDAdef->com2ur = nullur;
RDAdef->errrep = 15;
RDAdef->errlim = 300;
RDAdef->filefg = off;
RDAdef->ktfg = on;
RDAdef->lro1sid = nullsid;
RDAdef->lro1ur = nullur;
RDAdef->lro2sid = nullsid;
RDAdef->lro2ur = nullur;
RDAdef->magdec = 14.03333333333333;
RDAdef->magfg = on;
RDAdef->ravsid = nullsid;
RDAdef->rddhcur = nullur;
RDAdef->rddsid = nullsid;
RDAdef->rddur = nullur;
RDAdef->ravur = nullur;
for ( ig = 0 ; ig <= 127 ; ++ig )
   {
   RDAdef->tid[ig].words = nulltid;
   }
/*ENDfor*/
RDAdef->tmsid = nullsid;
RDAdef->tmur = nullur;
printf("\n\nRDAdef->magdec = %G",RDAdef->magdec);

   }
/*ENDmain*/

int CVTpart(logadx)

/*
Function to Include the DATAPOOL Partition into Task Space

Returns:
logadx is a logical pointer to datapool
returns non zero value if error occurs on include
*/

int *logadx;

{

char *pname1 = "@SYSTEM(SYSTEM)DATAPOOL";

int regs[8],
   i,
   cnp[6];

/*
   Setup CNP for DATAPOOL Memory
*/
   for (i = 0;i != 6;cnp[i++] = 0);
   cnp[2] = 0x88000000;
   cnp[4] = 0X100000;
   for (i = 0;i != 8;regs[i++] = 0);
   regs[1] = (strlen(pname1) << 24) | (int)pname1;
   regs[7] = (int)cnp;
   mpxsvc(0x2040,regs,regs);
   if((cnp[2] & 0x0000ffff) != 0){
      return(cnp[2] &= 0x0000ffff);
   } else {
      *logadx = regs[3];          /* Return Start of DATAPOOL Logical Space */
      return(cnp[2] &= 0x0000ffff);
   }
}

int RDApart(logadx)

/*
Function to Include the RDAPART Partition into Task Space

Returns:
logadx is a logical pointer to datapool
returns non zero value if error occurs on include
*/

int *logadx;

{

char *pname1 = "@SYSTEM(SYSTEM)RDAPART";

int regs[8],
   i,
   cnp[6];

/*
   Setup CNP for DATAPOOL Memory
*/
   for (i = 0;i != 6;cnp[i++] = 0);
   cnp[2] = 0x80000000;
   for (i = 0;i != 8;regs[i++] = 0);
   regs[1] = (strlen(pname1) << 24) | (int)pname1;
   regs[7] = (int)cnp;
   mpxsvc(0x2040,regs,regs);
   if((cnp[2] & 0x0000ffff) != 0){
      return(cnp[2] &= 0x0000ffff);
   } else {
      *logadx = regs[3];          /* Return Start of RDAPART Logical Space */
      return(cnp[2] &= 0x0000ffff);
   }
}



