
#ifdef MYATOF

#include <ctype.h>
#include "float.h"

/*  Note : this atof() generates an internal floating point representation
 *	   of a number.  If we are in IEEE mode, the number is translated
 *	   to IEEE format.  Otherwise it is translated to Encore format.
 */

FPN ifpn;	/* internal floating point number */

/* #define FLOATDEB */

#ifdef FLOATDEB
extern int sdump();
unsigned char ss[100];
#else
unsigned char ss[100];
#endif

FPN *
myatof(s)
register  unsigned char  *s;
{
	register int i;
	int	tz;
	int	exp;
	int	sign;
	int	esign;

#ifdef FLOATDEB
	printf("myatof entry: %s\n", s);
	strcpy(ss,s);
	s = ss;
#else
	*ss='\0';
	strcpy(ss,s);
	s = ss;
#endif
	zerof( &ifpn );		/* clear destination number */
	esign = sign = exp = tz = 0;	/* and local variables */

	i = *s++;		/* get 1st char */

#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof start: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* skip any leading white spaces */
	while( i == ' ' || i == '\t') i = *s++;
	/* see if a sign given */
	if( i == '-' ) {
		sign++;
		i = *s++;
	} else if( i == '+' )
		i = *s++;
	/* skip any more white spaces */
	while( i == ' ' || i == '\t') i = *s++;
	/* skip any leading zero's */
	while( i == '0') i = *s++;
	/* now process any number digits */
	while( i >= '0' && i <= '9' ){
		tz = dodig( &ifpn, i-'0', tz );
		i = *s++;
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 1: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	}
	/* now process a fraction, if present */
	if( i == '.' ){
		/* do the fraction */
		i = *s++;
		while( i >= '0' && i <= '9' ){
			tz = dodig( &ifpn, i-'0', tz );
			exp--;
			i = *s++;
		}
	}
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 2: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* now see if exponent */
	exp = (tz + exp);
	tz = 0;			/* zero trailing zeros count */
	/* skip any more white spaces */
	while( i == ' ' || i == '\t') i = *s++;
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 3: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* now process an exponent, if present */
	if( i == 'e' || i == 'E' ){
		/* do the exponent */
		i = *s++;
		/* see if a sign given */
		if( i == '-' ) {
			esign++;
			i = *s++;
		} else if( i == '+' )
			i = *s++;
		/* skip any leading zero's */
		while( i == '0') i = *s++;
		while( i >= '0' && i <= '9' ){
			tz = tz * 10 + i-'0';
			i = *s++;
		}
	}
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 4: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* we are done with number */
	if (esign) tz = -tz;
	/* set the exponent */
	ifpn.ne += (tz + exp);
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("myatof 5: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	/* if negative, negate the value */
	if( sign ) negf( &ifpn );
#ifdef FLOATDEB
	printf("tz = %x, exp = %x, next c = %x\n", tz, exp, i);
	printf("ret myatof: exp %d man ", ifpn.ne);
	sdump(&ifpn.nf, NF);
#endif
	return (&ifpn);
}

#endif /* MYATOF */
