/* MISC.C
 *
 * Edit History
 *
 * $Log: misc.c'v $
 * Revision 1.0  86/12/21  jbev
 *
 */

/* misc yet unresolved externals for GOULD port */

#include "@system(include)errno.h"
#include "@system(include)ctype.h"
#include "@system(include_sys)types.h"
#include "@system(include_sys)stat.h"
#include "@system(include)stdio.h"

int rdbuf[192];   /* resource descriptor buffer 2w bounded */
extern int errno;  /* error number location */
char * str2up();

kill(pid,sig)      /* kill task or test for presence */
int pid, sig;
{

    int i;
    int reg[8];
    int param[8];      /* parameter return */

    if (sig != 0)return (0);  /* if set sig, return o.k. */
    reg[5]=0;                /* ist time call */
    reg[7] = (int)param;     /* parameter block address */
     param[0]=pid;           /* search for process id */
    for (i=1; i<8; i++) param[i]=0; /* clear rest of parameter block */
    mpxsvc(0x1064,reg,reg);         /* call m.id service */
    if(reg[5] != 0)return(0);       /* return o.k. if found */
    errno=ESRCH;                    /* set error number */
    return(-1);                     /* indicate not found */
}

stat(path, sb)     /* get file status */
char *path;
struct stat *sb;  /* status buffer pointer */
{
    int reg[8];
    int modft, readt;

    str2up(path);
    reg[1] =  (int) path;     /* get pnv */
    reg[1] |= (strlen(path) << 24);       /* get pnv */
    reg[6] = (int)rdbuf;                       /* rd buffer address */
    reg [7] = 0;                      /* no cnp */
    mpxsvc (0x202c, reg, reg);        /* m.loc service */
    if (reg[7] != 0) {
        errno=ENOENT;                  /* set file not found error */
        return(-1);                    /* error return value */
    }
    sb->st_dev=0;      /* no device */
    sb->st_ino=rdbuf[6]; /* use block # for inode */
    sb->st_nlink=rdbuf[34]; /* use link count */
    sb->st_uid = sb->st_gid = sb->st_rdev = 0;  /* unused fields */
    sb->st_size = rdbuf[68] * 768;  /* eof size in bytes */
    readt = ((rdbuf[12] - 3653)*86400) + (rdbuf[13] / 10000); /* secs */
    modft = ((rdbuf[14] - 3653)*86400) + (rdbuf[15] / 10000); /* secs */
    if  (modft > readt) {
        sb->st_atime = sb->st_ctime = modft;  /* last access was mod */
    }
    else {
        sb->st_atime = sb->st_ctime = readt;  /* last access was read */
    }
    sb->st_mtime = modft;             /* last modify time */
    sb->st_mode = 0666;               /* assume r/w for everybody */
    return (0);       /* return o.k. */
}

access(path)       /* get file access */
char *path;
{
    int reg[8];

    str2up(path);
    reg[1] =  (int) path;     /* get pnv */
    reg[1] |= (strlen(path) << 24);       /* get pnv */
    reg[6] = (int)rdbuf;                       /* rd buffer address */
    reg [7] = 0;                      /* no cnp */
    mpxsvc (0x202c, reg, reg);        /* m.loc service */
    if (reg[7] != 0) {
        errno=ENOENT;                  /* set file not found error */
        return(-1);                    /* error return value */
    }
    return(7);        /* assume all accesses */
}

unlink(path)       /* delete file */
char *path;
{
    int reg[8];

    str2up(path);
    reg[1] =  (int) path;     /* get pnv */
    reg[1] |= (strlen(path) << 24);       /* get pnv */
    reg [7] = 0;                      /* no cnp */
    mpxsvc (0x2024, reg, reg);        /* m.delr service */
    if (reg[7] != 0) {
        errno=ENOENT;                  /* set file not found error */
        return(-1);                    /* error return value */
    }
    return(0);        /* return o.k. */
}

link(path1, path2) /* rename path1 to path2 */
char *path1, *path2;
{
    int reg[8];

    str2up(path1);
    str2up(path2);
    reg[1] =  (int) path1;    /* get address of path1 */
    reg[1] |= (strlen(path1) << 24);      /* get path length */
    reg[2] =  (int) path2;    /* get address of path2 */
    reg[2] |= (strlen(path2) << 24);      /* get path length */
    reg [7] = 0;                      /* no cnp */
    mpxsvc (0x202d, reg, reg);        /* m.renam service */
    if (reg[7] != 0) {
        errno=ENOENT;                  /* set file not found error */
        return(-1);                    /* error return value */
    }
    return(NULL);     /* file renamed */
}

sleep(time)        /* sleep for time */
int time;
{

    int reg[8];

    reg[5] = -time;            /* neg time val  */
    reg[6]=0;         /* our task */
    reg[7] =  0;               /* our task */
    mpxsvc(0x1054,reg,reg);         /* call m.susp service */
    return(0);                      /* indicate good return */
}

char *memchr(s, c, n)
char *s;
char c;
int n;
{
    while (n > 0) {
        if (*s == c) return (s);
        n--;
        s++;
    }
    return (0);
}

static char *Ss;

char *strtok(s1, s2)
char *s1, *s2;
{
    char *sp, *tok;
    if (s1) Ss = s1;

    /* skip separators */

    while (*Ss) {
        for (sp = s2; *sp; sp++)
            if (*sp == *Ss) break;
        if (*sp == 0) break;
        Ss++;
    }
    if (*Ss == 0) return (0);
    tok = Ss;
    while (*Ss) {
        for (sp = s2; *sp; sp++)
            if (*sp == *Ss) {
                *Ss++ = 0;
                return (tok);
            }
        Ss++;
    }
    return (tok);
}

int strnicmp (s1, s2, n)
register char *s1;
register char *s2;
unsigned n;   /* should be int */
{
    register char c1, c2;

    while (n> 0) {
        n--;
        c1 = islower(*s1) ? toupper(*s1) : *s1;
        c2 = islower(*s2) ? toupper(*s2) : *s2;
        if (c1 < c2)return (-1);
        else if (c1 > c2)return (1);
        else if (!c1) return (0);
        s1++;
        s2++;
    }
    return (0);
}

int  strtol (s, p, n)
char * s;
char **p;
int    n;
{
    int porm=1;
    int num=0;
    char base;

    base = (n == 10) ? '9' : '7';
    while (*s == ' ')s++;
    if ((*s == '+') || (*s == '-'))porm = (*s++ == '+') ? 1 : -1;
    while (*s >= '0' && *s <= base) num = n * num + (*s++ - '0');
    *p = s;
    return (porm * num);
}

char *getenv(p)
char *p;
{
    return ((char *)NULL);
}

/* fast memory copy -- handles overlapped copy */
char *memcpy(p1,p2,l)

register char *p1;
register char *p2;
register int l;

{
    if (p2<p1) /* possible overlap -- copy top down */
        for (p1+=l,p2+=l;l--;) *--p1= *--p2;
    else
        for (;l--;) *p1++= *p2++;
    return(p1);
}

/* fast memory set */

char *memset(p,c,l)

register char *p;
register char c;
register int l;

{
    char *p1 = p;
    if (l)
    {
        --p;
        do
            *++p=c;
        while (--l);
    }
    return(p1);
}

alarm()  /* dummy entry */
{
    return(NULL);
}

chmod()  /* dummy entry */
{
    return(NULL);
}

/* convert string to upper case */
char *
str2up(s)

char *s;

{
   char *orig_s = s;

   s--;
   while (*++s != '\000')
      if(islower(*s))*s = toupper(*s);

   return(orig_s);
}
