*  *********************************************************************
*
*  $Header:  003  23-JAN-91 15:22  GANN      GANN                      $
*  $Log:   @ISCSRC^(DV.UTIL.CC)ISCIO.S                                 $
*
*       Rev  003  23-JAN-91 15:22  GANN      GANN
*  Expanded PBN buffers to hoald new extended PNB's.
*
*       Rev  002  09-FEB-89 08:53  GANN      GANN
*  Took out code to remove characters greater than 127 from
*  output to files. This screws up European customers using
*  the expanded multinational character set. This fix is
*  not needed anymore anyway since it was a work around in
*  E.3A to a problem that has since been fixed.
*
*       Rev  001  09-FEB-89 08:38  GANN      GANN
*   Version control header added
*
*
*       UNIX I/O SIMULATOR FOR MPX FILES      12-DEC-86 HEADER  ISCIO.S
************************************************************************
*
*        RESTRICTED RIGHTS LEGEND
*
*        USE, DUPLICATION, OR DISCLOSURE IS SUBJECT TO THE RESTRICTIONS
*        STATED IN I.S.C.'S LICENSE AGREEMENT (FORM NO. 1218) OR, FOR
*        GOVERNMENT CUSTOMERS, DAR 7-104.9A.
*
************************************************************************
         SPACE     2
         PROGRAM   ISC.IO          FILE:  ISCIO.S
************************************************************************
*                                                                      *
*                    ISCIO  CHANGE HISTORY                             *
*                                                                      *
************************************************************************
*   VER       DATE      BY             DESCRIPTION.                    *
************************************************************************
*                                                                      *
*  E3.06   02/17/88    JCB   CHANGE BLKMAX TO 10 FROM 20 SECTORS FOR   *
*                            R/W OF FILES.  CHANGE IOCMAX TO 7 FROM 4  *
*                            FOR MAX NUM OF OPEN FILES IN RM.          *
*  E3.11   04/13/88    gc    Temp change to not output characters >    *
*                            x'7f' to files.                           *
*                            Change _writraw to do nowait io           *
*                            clear dynamically allocated memory        *
*                                                                      *
************************************************************************
         SPACE      5
         LIST      ON,NOMAC,NOREP
         SPACE     2
************************************************************************
*   UNIX I/O EMULATION ROUTINES
************************************************************************
         SPACE     2
************************************************************************
*
*   THE UNIX I/O EMULATOR ROUTINES EMULATE THE UNIX I/O ENVIRONMENT
*   NECESSARY TO RUN THE C COMPILER TO BE PROVIDED BY BELL LABS.  THE
*   CALLING CONVENTIONS ARE GUESSED.  THE ARGUMENT LIST IS COPIED FROM
*   UNIX WITH THE EXCEPTION THAT CERTAIN ARGUMENTS ARE NOT USED OR
*   ONLY PARTIALLY USED.
*
*   THESE ROUTINES MAKE IT POSSIBLE TO READ, WRITE, SEEK, AND APPEND
*   MPX-32 BLOCKED FILES.  MAXIMUM TRANSFER COUNT IS LIMITED TO 254
*   BYTES.  SEEK TO BOM OR EOF ARE SUPPORTED.  MPX-32 COMPRESSED SOURCE
*   FILES ARE NOT SUPPORTED.  A LF (X'0A') IS APPENDED TO ALL LINES
*   READ.  LF'S ARE STRIPED FROM OUTPUT BEFORE WRITING.  NULL LINES
*   ARE WRITTEN AS ONE SPACE FOR MPX-32 COMPATABILITY.  THESE ROUTINES
*   ASSUME THAT BLOCKED FILES CONTAIN TEXT.  READING OTHER NON-TEXT
*   BLOCKED FILES MAY CAUSE UNDETERMINED RESULTS.
*
************************************************************************
         SPACE     2
*                                  PACKAGE CAN ACCESS THE FILE TABLE
         DEF       _open
         DEF       _fcbadr
         DEF       _close
         DEF       _getacc
         DEF       _setacc
         DEF       _setsiz
         DEF       _creatd
         DEF       _creat
         DEF       _read
         DEF       _write
         DEF       _readraw
         DEF       _writraw
         DEF       _seek
         DEF       _isatty
         DEF       ___isblk
         DEF       RM.OPEN
         DEF       RM.CLSE
         DEF       RM.READ
         DEF       RM.WRIT
         DEF       RM.ADVF
         DEF       RM.ADVR
         DEF       RM.RWND
         DEF       RM.BACK
         SPACE     2
************************************************************************
*   PROGRAM SIZING EQUATES
************************************************************************
         SPACE     1
FILECNT  EQU       10              OPEN FILE LIMIT
FCBSIZE  EQU       16W             FCB SIZE
PARMSIZE EQU       12W             FILE PARAMETERS SIZE
PNBSIZE  EQU       30W             PATHNAME BLOCK SIZE              !003
PNBWSIZE EQU       2W              PATHNAME BLOCK VECTOR WORD SIZE
LINESIZE EQU       768             LINE BUFFER SIZE IN BYTES
FILESIZE EQU       FCBSIZE+PARMSIZE+PNBSIZE+PNBWSIZE+LINESIZE
*                                  FILE TABLE ENTRY SIZE
SIZER    SET       FILESIZE*FILECNT/4
_filtabl COMMON    >FILTABL(2400)
         SPACE     2
************************************************************************
*   REGISTER EQUATES
************************************************************************
         SPACE     1
AP       EQU       1              ARGUMENT POINTER
X1       EQU       1
X2       EQU       2              GENERAL INDEX NUMBER 1
SP       EQU       3              STACK POINTER
X3       EQU       3
         SPACE     1
R0       EQU       0              GENERAL REGISTER EQUATES
R1       EQU       1
R2       EQU       2
R3       EQU       3
R4       EQU       4
R5       EQU       5
R6       EQU       6
R7       EQU       7
         PAGE
************************************************************************
*   SYSTEM EQUATES                                                     *
************************************************************************
C.DTTA   EQU       X'00AA0'
C.DTTN   EQU       X'00CB1'
C.TSAD   EQU       X'00A80'
C.UDTA   EQU       X'00B38'
C.UDTN   EQU       X'00C38'
DFT.STB  EQU       X'00000'
DFT.ACF  EQU       X'00001'
DFT.FLGS EQU       X'00004'
RR.ACCS  EQU       X'00008'
RR.APPND EQU       X'00004'
RR.BLK   EQU       X'00004'
RR.DATE  EQU       X'00020'
RR.DENS  EQU       X'00006'
RR.DEV   EQU       X'00020'                                         3205
RR.DEVC  EQU       X'00003'
RR.DT3   EQU       X'00010'
RR.EXCL  EQU       X'00011'
RR.LFC   EQU       X'00000'
RR.LFC2  EQU       X'00004'
RR.MODFY EQU       X'00002'
RR.NAME1 EQU       X'00010'
RR.NBLKS EQU       X'00014'
RR.OPTS  EQU       X'0000C'
RR.PATH  EQU       X'00001'
RR.PLEN  EQU       X'00006'
RR.READ  EQU       X'00000'
RR.RID   EQU       X'00006'
RR.SBO   EQU       X'00003'
RR.SEP   EQU       X'0000F'                                         2129
RR.SFC   EQU       X'00008'
RR.SGO   EQU       X'00001'
RR.SHAR  EQU       X'00010'
RR.SIZE  EQU       X'00005'
RR.SLO   EQU       X'00002'
RR.SYC   EQU       X'00000'
RR.TEMP  EQU       X'00002'
RR.TYPE  EQU       X'00004'
RR.UNBLK EQU       X'00005'
RR.UNFID EQU       X'00014'
RR.UPDAT EQU       X'00003'
RR.VLNUM EQU       X'00011'
RR.WRITE EQU       X'00001'
UDT.SIZE EQU       X'00040'
UDT.STAT EQU       X'00004'
         PAGE
************************************************************************
*   DEVICE EQUATES                                                     *
************************************************************************
         SPACE     1
TERMINAL EQU       -1              FILE IS A TERMINAL
LINEPTR  EQU       1               FILE IS AN SLO FILE
NULL     EQU       2               FILE IS NULL
EOM      EQU       -2              FILE GOT EOM
         SPACE     4
************************************************************************
*   MODE EQUATES
************************************************************************
         SPACE     1
NOTUSED  EQU       55             FILE NOT IN USE
READMODE EQU       0              FILE IN READ MODE
WRITMODE EQU       1              FILE IN WRITE MODE
READWRIT EQU       2              FILE IN READ/WRITE MODE
RWE      EQU       7              FILE IN READ/WRITE/EXECUTE MODE
RD.ACC   EQU       X'80'           READ ACCESS                 A001
UPD.ACC  EQU       X'10'           UPDATE ACCESS               A001
         SPACE     2
************************************************************************
*   BLOCKED EQUATES
************************************************************************
         SPACE     1
UNBLOCK  EQU       0              FILE IS NOT BLOCKED
BLOCKED  EQU       1              FILE IS BLOCKED
         SPACE     2
************************************************************************
*   WRITTEN, EOF EQUATES
************************************************************************
         SPACE     1
FALSE    EQU       0
TRUE     EQU       1
         SPACE     2
************************************************************************
*   LOCAL MACROS
************************************************************************
         SPACE     1
ENTER    DEFM
         TRR       SP,R1           STACK PTR FOR CALLING FUNCTION
         ADI       SP,-8W          DECREMENT SP FOR CALLED ROUTINE A001
         STD       R0,2W,SP        STORE RETURN ADDR IN STACK & PREV. SP
         STF       R4,4W,SP        STORE REGS 4 THROUGH 7 IN STACK
         LA        AP,8W,R1        PUT ARG AREA ADDR IN AP
         STW       SP,SPSAVE      SAVE STACK POINTER
         STW       AP,APSAVE      SAVE COPY OF AP
         ENDM
         SPACE     1
RETURN   DEFM
         LW        SP,SPSAVE      RESTORE OLD STACK PTR FROM SPSAVE
         LF        R2,2W,SP        RESTORE REGISTERS FROM STACK
         TRR       SP,R3           RESTORE OLD STACK PTR TO R3
         TRSW      R2              RETURN TO CALLING ROUTINE
         ENDM
         SPACE     1
FIL      DEFM      UNIT,BUFFER
         DATAW     %UNIT
         REZ       7W
         DATAW     %BUFFER
         DATAW     LINESIZE
         REZ       6W
         DATAW     NOTUSED
         REZ       PARMSIZE-1W
         REZ       PNBSIZE
         REZ       PNBWSIZE
         REZ       LINESIZE
         ENDM
         SPACE     1
INDEX    DEFM      REG
         TRR       %REG,R5         SET UP FOR MULTIPLY
         MPI       R4,FILESIZE     GET OFFSET FROM START OF TABLE
         TRR       R5,%REG
         LA        R5,>FILTABL     BASE ADDRESS OF TABLE
         ADR       R5,%REG         ABSOLUTE ADDRESS OF DESIRED ENTRY
         ENDM
         PAGE
************************************************************************
*   FILE TABLE FIELD EQUATES
*
*   LINE           CONTAINS THE CURRENT DATA RECORD.
*
*   LINPTR         CONTAINS THE BYTE POSITION FOR THE NEXT BYTE TO
*                  BE TRANSFERRED TO OR FROM A LINE.
*
*   BLKPTR         CONTAINS THE CURRENT BLOCK POSITION IN THE FILE
*                  (ONLY USED IN UNBLOCKED MODE).
*
*   MODE           CONTAINS THE CURRENT ACCESS MODE OF THE FILE.  WRITE
*
*   BLOCK          CONTAINS THE INDICATION OF WHETHER THE FILE IS
*                  BLOCKED (MPX-32 SOURCE FILE) OR UNBLOCKED (UNIX
*                  STYLE FILE).
*
*   EOFPTR,EOLPTR  CONTAINS THE EOF BYTE POSITION (USED BY UNIX
*                  STYLE FILES), OR THE END OF CURRENT LINE POINTER
*                  (USED BY MPX-32 STYLE FILES).
*
*   EOF            INDICATION IF END OF FILE HAS BEEN ENCOUNTERED (USED
*                  BY MPX-32 STYLE FILES).
*
*   DEVICE         CONTAINS INDICATION IF DEVICE CANNOT BE TREATED LIKE
*                  A DISC FILE
*
*   FCB            CONTAINS A SHORT FCB.
*
************************************************************************
         SPACE     1
FCB      EQU       0W
MODE     EQU       FCBSIZE
LINPTR   EQU       FCBSIZE+1W
BLKPTR   EQU       FCBSIZE+2W
BLOCK    EQU       FCBSIZE+3W
EOFPTR   EQU       FCBSIZE+4W
EOLPTR   EQU       EOFPTR
EOF      EQU       FCBSIZE+5W
DEVICE   EQU       FCBSIZE+6W
FLAGS    EQU       FCBSIZE+7W      R.M. FLAGS FOR BLOCKED FILES
*        BIT 0     SET - THIS FCB USING RM ROUTINES
*                  RESET - USE STANDARD SVC'C
*        BIT 1     SET - THIS IS A COMPRESSED FILE
*                  RESET - STANDARD BLOCKED FILE
*
FLOC     EQU       FCBSIZE+8W      CURRENT OFFSET INTO FILE (BYTES)
CPTR     EQU       FCBSIZE+9W      POINTER INTO LINE FOR COMP FILES
SECTA    EQU       FCBSIZE+10W     CURRENT SECTOR ADDRESS FOR FILES
FREE1    EQU       FCBSIZE+11W     SPARE WORD
*                                  BOUNDING FOR THE PNB THAT FOLLOWS
PNB      EQU       FCBSIZE+PARMSIZE
PNBWORD  EQU       FCBSIZE+PARMSIZE+PNBSIZE
LINE     EQU       FCBSIZE+PARMSIZE+PNBSIZE+PNBWSIZE
         SPACE     2
************************************************************************
*    LINE FEED TCW
************************************************************************
         SPACE     1
         BOUND     1W
         CSECT
LFCHAR   DATAB     X'20'
ACMODES  DATAB     1,4,4           ACCESS MODES FOR RRS        A001
         PAGE
************************************************************************
*   VARIOUS CONTROL BLOCK EQUATES
************************************************************************
         SPACE     1
FCB.LFC  EQU       0W             LFC OFFSET IN FCB
FCB.TCW  EQU       1W             TCW LOC IN FCB
FCB.GCFG EQU       2W             GENERAL CONTROL FLAGS
FCB.CBRA EQU       5H             RANDOM ACCESS ADDRESS
FCB.SFLG EQU       3W             STATUS FLAGS
FCB.RECL EQU       4W             RECORD LENGTH
FCB.SPST EQU       6W             SPECIAL STATUS FLAGS
FCB.ERWA EQU       8W             EXPANDED DATA ADDRESS
FCB.EQTY EQU       9W             EXPANDED TRANSFER QUANTITY
FCB.IST1 EQU       11W            XIO STATUS WD 1
FCB.IST2 EQU       12W            XIO STATUS WD 2
FCB.XCT  EQU       9W             BYTE COUNT
FCB.XAD  EQU       8W             BUFFER ADDR
FCB.OPT  EQU       2W             OPTION OFFSET IN FCB
FCB.RAN  EQU       4              RANDOM ACCESS OPTION BIT
FCB.RAA  EQU       5H             RANDOM ACCESS ADDRESS OFFSET IN FCB
FCB.STAT EQU       12B            REQUEST STATUS OFFSET IN FCB
FCB.ERR  EQU       1              ERROR STATUS BIT
FCB.EOF  EQU       6              EOF STATUS BIT
FCB.EOM  EQU       7              EOM STATUS BIT
FCB.CNT  EQU       4W             TRANSFER COUNT OFFSET IN FCB
FCB.FAT  EQU       7W             FAT ADDRESS OFFSET IN FCB
FAT.BBUF EQU       10W            BLOCKING BUFFER ADDRESS OFFSET IN FAT
RD.AOWNR EQU       30W            OWNER ACCESS RIGHTS
RD.TYPE  EQU       15H            RESOURCE TYPE OFFSET IN RD
RD.PERM  EQU       10             PERMANENT FILE RESOURCE
RD.DIR   EQU       11             DIRECTORY RESOURCE
RD.FLAG  EQU       64W            RESOURCE FLAG WORD
RD.BLK   EQU       31             RESOURCE BLOCKED BIT
RD.USER  EQU       160W           USER AREA IN RD
RD.EOF   EQU       190W           EOF POINTER OFFSET IN RD
CP.OPTS  EQU       2W             OPTION FLAGS IN CNP
         SPACE     2
NEWLINE  EQU       X'0A'          NEW LINE CHARACTER (LINE FEED)
CR       EQU       X'0D'           CARRIAGE RETURN CHARACTER
         SPACE     2
************************************************************************
*   REGISTER SAVE AREA
************************************************************************
         SPACE     1
         BOUND     1D
         SPACE     2
************************************************************************
*
*   PROGRAMMING CONVENTIONS
*
*   1) THE ARGUMENT POINTER IS MAINTAINED IN REGISTER AP.  AP IS SAVED
*   AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR, SVC'S.
*
*   2) THE FILE TABLE ENTRY ADDRESS IS TYPICALLY HELD IN REGISTER X2.
*   X2 IS REGENERATED AROUND CODE THAT MAY DESTROY IT, IN PARTICULAR,
*   SVC'S.
*
*   3) ALL ENTRIES INTO THIS PACKAGE ARE FUNCTIONS, THAT IS, THEY RETURN
*   A VALUE.  THE VALUE IS RETURNED IN R0.  ERRORS ARE GENERALLY
*   INDICATED BY -1.  SUCCESS IS GENERALLY INDICATED BY 0.  CREAT AND
*   OPEN RETURN THE FILE DESCRIPTOR TO SHOW SUCCESS.  WRITE RETURNS 0
*   TO INDICATE EOF DETECTED AND N(>0) TO INDICATE THE NUMBER OF
*   CHARACTERS ACTUALLY TRANSFERRED.
*
*   4) UTILITY SUBROUTINES EXPECT AP AND X2 TO BE PROPERLY INITIALIZED.
*   RESULTS ARE RETURNED IN R7.  ERRORS ARE GENERALLY INDICATED BY -1.
*   SUCCESS IS GENERALLY INDICATED BY 0.
*
************************************************************************
         PAGE
************************************************************************
*   CLOSE FILE
************************************************************************
         SPACE     1
_close   EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R4,MODE,X2     GET FILE MODE
         CI        R4,NOTUSED     IN USE?
         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,NULL        NULL FILE?
         BEQ       CLOS.0         YES, FINISH UP
         CI        R4,READMODE    ARE WE OUTPUT ACTIVE
         BEQ       CLOS.X          NO, JUST CLOSE
         LW        R4,LINPTR,X2    ANY CHARS LEFT IN BUFFER
         BZ        CLOS.Y          NO, JUST CLOSE IT
         BL        SETTCW          YES, PURGE IT
         BL        WRITLINU        WRIT IT
CLOS.Y   LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.WEOF        WEOF FILE USING RM
         BU        $+2W           SKIP NORMAL WEOF
         SVC       1,X'38'        WRITE EOF
CLOS.X   LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.CLSE        CLSE FILE USING RM
         BU        $+2W           SKIP NORMAL CLSE
         SVC       1,X'39'         CLOSE THE FILE
         ZR        R7             NO CNB
         SVC       2,X'53'        DEASSIGN FILE
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
*        TRR       R7,R7          TEST THE RETURN VALUE
*        BNE       ERRETURN       NON ZERO, RETURN WITH ERROR
CLOS.0   LI        R4,NOTUSED
         STW       R4,MODE,X2     RETURN FILE DESCRIPTOR TO POOL
         ZR        R0             INDICATE NO ERROR
         RETURN                   RETURN TO USER
         PAGE
************************************************************************
*   GET FCB ADDRESS
************************************************************************
         SPACE     1
_fcbadr  EQU       $               get fcb addr
         ENTER                    SAVE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         LW        R4,MODE,X2     GET FILE MODE
         CI        R4,NOTUSED     IN USE?
         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR
         TRR       R2,R0           FCB ADDR TO R0 FOR RETURN
         RETURN                    RETURN ADDRESS TO CALLER
************************************************************************
*  SET CREATE FILE ACCESS RIGHTS
*  SETACC(OWNER, GROUP, OTHER)
************************************************************************
         SPACE     1
_setacc  EQU       $              SET FILE ACCESS RIGHTS
         ENTER                    SAVE REGISTERS ON STACK
         LW        R6,0W,AP       GET OWNER RIGHTS
         STW       R6,OWNER       SAVE IN RCB
         LW        R6,1W,AP       GET GROUP RIGHTS
         STW       R6,GROUP       SAVE IN RCB
         LW        R6,2W,AP       GET OTHERS RIGHTS
         STW       R6,OTHER       SAVE IN RCB
         ZR        R0             CLEAR R0 FOR RETURN
         RETURN                   RETURN ADDRESS TO CALLER
************************************************************************
*   GET ACCESS RIGHTS OF FILE
*   GETACC(PATHNAME)    POINTER TO 3W ARRAY RETURNED
************************************************************************
         SPACE     1
_getacc  EQU       $              GET FILE ACCESS RIGHTS
         ENTER                    SAVE REGISTERS ON STACK
         BL        PARSE          PARSE PATHNAME
         TRR       R7,R7          TEST THE RETURN VALUE
         BNZ       ERRETURN       NOT ZERO, RETURN WITH ERROR
         BL        EXISTS         TEST IF THE FILE ALREADY EXISTS
         TRR       R7,R7          TEST THE RETURN VALUE
         BLT       ERRETURN       ERROR RETURN IF NOT THERE
         LA        R0,RD+RD.AOWNR GET ADDRESS OF ACCESS RIGHTS
         RETURN                   RETURN TO CALLER
************************************************************************
*  SET FILE SIZE AND EXTENSION SIZE
*  SETSIZ(ORGSIZE, MINEXT, MAXEXT)
************************************************************************
         SPACE     1
_setsiz  EQU       $              SET FILE SIZING
         ENTER                    SAVE REGISTERS ON STACK
         LW        R6,0W,AP       GET STARTING SIZE
         STW       R6,ORGS        SAVE IN RCB
         LW        R6,1W,AP       GET MIXIMUM EXTENSION
         STW       R6,MINX        SAVE IN RCB
         LW        R6,2W,AP       GET MAXIMUM EXTENSION
         STW       R6,MAXX        SAVE IN RCB
         ZR        R0             CLEAR R0 FOR RETURN
         RETURN                   RETURN ADDRESS TO CALLER
************************************************************************
*   CREATE FILE
************************************************************************
         SPACE     1
_creatd  EQU       $              CREATE DIRECTORY
         SBM       0,CDF          SET CREATE DIRECTORY FLAG
         BU        CMRG           MERGE CODE
_creat   EQU       $              CREATE FILE
         ZBM       0,CDF          SHOW CREATING FILE FLAG
CMRG     ENTER                    SAVE REGISTERS ON STACK
         BL        PARSE          PARSE PATHNAME
         TRR       R7,R7          TEST THE RETURN VALUE
         BLT       ERRETURN       LESS THAN ZERO, RETURN WITH ERROR
         BGT       CREAT.2        ZERO PATHNAME LENGTH, GET FILE DESC
         BL        EXISTS         TEST IF THE FILE ALREADY EXISTS
         TRR       R7,R7          TEST THE RETURN VALUE
         BLT       CRDOF          GO CREATE DIR OR FILE
         TBM       0,CDF          CREATING DIRECTORY
         BNS       CRFILE         CREATING FILE
         CI        R6,RD.DIR      WAS DIRECTORY FOUND
         BEQ       CREAT.1        YES, GO ASSIGN
         BU        ERRETURN       NO, ERRER RETURN
CRFILE   CI        R6,RD.PERM     WAS IT A FILE
         BEQ       CREAT.1        YES, GO ASSIGN
         BU        ERRETURN       NO, ERROR
CRDOF    LW        R1,PNBWRDX     GET PNB VECTOR WORD IN REGISTER FOR
*                                   SERVICE
*        ADD CODE HERE TO CREATE DIRECTORY IF PATH END WITH DIRECTORY
*
         LA        R2,RCB         CREATE PERMANENT FILE
         ZR        R7
         TBM       0,CDF          CREATING DIR
         BNS       $+3W           BR IF NOT
         SVC       2,X'23'        CREATE DIRECTORY
         BU        $+2W           GO MERGE
         SVC       2,X'20'        CREATE FILE
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRR       R7,R7          TEST THE RETURN VALUE
         BNE       ERRETURN       NON ZERO, RETURN WITH ERROR
CREAT.1  EQU       $
         BL        GETFD          GET FILE DESCRIPTOR
         TRR       R7,X2
         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR
         STW       R7,0W,AP       SAVE THE FD AND TEST THE RETURN VALUE
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LI        R4,LINESIZE    GET FULL CHARACTER COUNT
         BL        SETTCW         INITIALIZE TCW IN FCB
         BL        PNBSAVE        TUCK PATHNAME BLOCK AWAY
         LW        R4,FCB+FCB.LFC,X2
*                                 GET LFC
         SLL       R4,8
         SRL       R4,8           CLEAR OUT LEAD BYTE
         STW       R4,RRS+RR.LFC   SET LFC IN RRS
         ZMW       RRS+RR.TYPE     CLEAR PART OF RRS
         ZMW       RRS+RR.ACCS     CLEAR ACCESS
         ZMW       RRS+RR.OPTS     CLEAR OPTIONS
         LI        R5,1            TYPE 1 RRS
         STB       R5,RRS+RR.TYPE  PUT IN RRS
         LB        R5,PNBWRDX    GET PNB VECTOR WORD BYTE COUNT
         STB       R5,RRS+RR.PLEN
*                                 SET PATHNAME BLOCK SIZE IN RRS
         SRL       R5,2           DIVIDE COUNT BY 4 (TO GET WORDS)
         ADI       R5,RR.1.SIZ    ADD LENGTH OF RRS HEADER
         STB       R5,RRS+RR.SIZE  SET RRS SIZE IN RRS
*   FIX TO MAKE creat ASSIGN THE WITH PROPER ACCESS RIGHTS.  A001
         LI        R5,UPD.ACC      SET UPDATE ACCESS BIT       A001
         STB       R5,RRS+RR.ACCS     IN THE RRS               A001
         SBM       RR.SHAR,RRS+RR.OPTS  SET SHARED ACCESS
         LA        R1,RRS           ASSIGN LFC TO RESOURCE
         ZR        R7
         SVC       2,X'52'
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         TRR       R7,R7          TEST THE RETURN VALUE
         BNE       CR.ERR3        NON ZERO, RETURN WITH ERROR
         ZMW       FCB+FCB.OPT,X2 CLEAR FCB OPTION WORD
         SBM       6,FCB+FCB.OPT,X2  SET EXPANDED FCB
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         ZMH       CNP+CP.OPTS     OPEN DEFAULT MODE
         LI        R7,X'04'        SET UPDATE ACCESS IN CNP
         STB       R7,CNP+CP.OPTS  PUT IN CNP
         SBM       11,CNP+CP.OPTS  SET OPEN BLOCKED
         SBM       0,FLAGS,X2      SET USING RM FLAG
         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET
         SBR       R1,1            SET CC1 FOR R/W MODE FOR RM
         BL        RM.OPEN         OPEN VIA REC MGR
         TRR       R7,R7           ANY RM ERROR
         BNZ       CR.ERR2         GIVE IT TO CALLER
*        LA        R7,CNP         SET UPDATE ACCESS WITH CNP
*        SVC       2,X'42'        OPEN FILE
         BL        RM.WEOF        WRITE EOF
*        SVC       1,X'38'         WRITE EOF TO FILE FOR APPEND MODE
         BL        RM.RWND         REWIND FILE
*        SVC       1,X'37'         REWIND THE FILE
         LW        AP,APSAVE      RESTORE ARGUMENT  POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       DEVICE,X2      NOT A SPECIAL DEVICE
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOFPTR,X2      SET EOF POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         ZMW       FLOC,X2        FILE POSITION IS ZERO
         ZMW       CPTR,X2        NO DECOMPRESSING POINTER
         ZMW       SECTA,X2       NO SECTORS YET
         LI        R4,READWRIT
         STW       R4,MODE,X2     SET MODE TO READ/WRITE
         LI        R4,BLOCKED
         STW       R4,BLOCK,X2    SET FILE TYPE TO BLOCKED (MPX)
         BU        CRE.RET
*
* ALLOCATE THIS FILE DESCRIPTOR TO NULL DEVICE
*
CREAT.2  EQU       $
         BL        GETFD
         TRR       R7,X2
         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR
         STW       R7,0W,AP
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         ZMW       FLAGS,X2       CLEAR FLAGS
         LI        R4,READWRIT
         STW       R4,MODE,X2     SET MODE TO READ/WRITE
         LI        R4,NULL        GET NULL DEVICE
         STW       R4,DEVICE,X2   SET FILE TO NULL FILE
         LI        R4,TRUE
         STW       R4,EOF,X2      SET END OF FILE STATUS
         LI        R4,BLOCKED
         STW       R4,BLOCK,X2    SET FILE TO BLOCKED MODE
CRE.RET  LW        R0,0W,AP       RETURN FILE DESCRIPTOR
         RETURN                   RETURN TO CALLER
CR.ERR2  LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         ZR        R7             NO CNB
         SVC       2,X'53'        DEASSIGN FILE
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
CR.ERR3  LI        R4,NOTUSED
         STW       R4,MODE,X2     RETURN FILE DESCRIPTOR TO POOL
         LI        R0,-1          INDICATE ERROR
         RETURN                   RETURN TO USER
         PAGE
************************************************************************
*   OPEN FILE
************************************************************************
         SPACE     1
_open    EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         BL        CASSG          PARSE PATHNAME AND BUILD RRS
         BL        GETFD          GET FILE DESCRIPTOR
         TRR       R7,X2          TEST THE RETURN RESULT
         BLT       ERRETURN       NO FILE DESCRIPTORS, RETURN WITH ERROR
         LW        AP,APSAVE       RESTORE ARG POINTER
         STW       R7,0W,AP       SAVE THE FD AND TEST THE RETURN VALUE
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LI        R4,LINESIZE    GET FULL CHARACTER COUNT
         BL        SETTCW         INITIALIZE TCW IN FCB
         LW        R4,FCB+FCB.LFC,X2
*                                 GET LFC
         SLL       R4,8
         SRL       R4,8           CLEAR OUT LEAD BYTE
         STW       R4,RRS+RR.LFC   SET LFC IN RRS
* FIX TO MAKE open ASSIGN FILE WITH PROPER ACCESS RIGHTS.      A001
         LW        AP,APSAVE       RESTORE ARG POINTER         A001
         LW        R5,1W,AP        GET OPEN MODE               A001
         CI        R5,READMODE     SEE IF READ                 A001
         BNE       OPEN.1          BR IF NOT                   A001
         LI        R5,RD.ACC       SET READ ACCESS BIT         A001
         LI        R4,READMODE    GET READ MODE TYPE
         BU        OPEN.2          MERGE CODE                  A001
OPEN.1   LI        R5,UPD.ACC      SET UPDATE ACCESS BIT       A001
         LI        R4,READWRIT     SET R/W MODE
OPEN.2   STB       R5,RRS+RR.ACCS  PUT IN RRS                  A001
         STW       R4,MODE,X2     SET MODE TO R/W OR R
         LB        R7,RRS+RR.TYPE  GET RRS TYPE
         CI        R7,4            SEE IF TYPE 4 (LFC=LFC)
         BNE       $+2W            BR IF NOT
         ZMB       RRS+RR.ACCS     CLEAR ACCESS BYTE
         ZR        R7              NO CNP
         LA        R1,RRS          GET ADDR OF RRS
         SVC       2,X'52'         ASSIGN RESOURCE
         LW        AP,APSAVE       RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY POINTER
         TRR       R7,R7           TEST RETURN CODE
         BNE       OPEN.ERR        RETURN WITH ERROR
         LA        R7,CNP          ASSUME FILE IF READ ONLY
         ZMH       CNP+CP.OPTS     OPEN DEFAULT MODE
         LI        R1,BLOCKED      OPENED BLOCKED
         SBM       11,CNP+CP.OPTS  SET OPEN BLOCKED
         TBM       RR.UNBLK,RRS+RR.OPTS  SEE IF UNBLOCKED SPECIFIED
         BNS       $+3W            BR IF NOT
         LI        R1,UNBLOCK      ASSUME UNBLOCKED FOR MOMENT
         ABM       11,CNP+CP.OPTS  SET UNBLOCKED OPEN
         STW       R1,BLOCK,R2     SET FOR LATER
         ZMW       FCB+FCB.OPT,X2 CLEAR FCB OPTION WORD
         SBM       6,FCB+FCB.OPT,X2  SET EXPANDED FCB
         CI        R1,UNBLOCK      IS FILE UNBLOCKED
         BEQ       OPEN.5          USE STD I/O IF YES
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
*                                 R7 SET TO CORRECT CNP ADDR
         TRR       R7,R0           SAVE CNP ADDRESS
         LW        R4,0W,R1        GET LFC
         ANMW      R4,=X'FFFFFF'   MASK IT
         LA        R1,INQ.INFO     SET UP INQUIRY INFO AREA
         ZR        R5              CLEAR R5
         ZR        R7              NO CNP
         SVC       2,X'48'         M.INQUIRY
         LW        R1,INQ.INFO+3W  GET DTT ADDRESS
         LB        R6,0,R1         GET DEV TYPE
         CI        R6,3            IS IT A DISC
         BGT       OPEN.3          BR IF NOT DISC
         LW        R1,INQ.INFO+1W  GET FAT ADDR
         TRR       R1,R5           SAVE FAT ADDRESS
         LB        R6,DFT.ACF,R1   GET ACCESS FLAGS/SYS FILE CODE
         ANMW      R6,=X'7'        MASK ALL BUT SYS FILE CODE
         CI        R6,0            IS IT SYS FILE
         BNE       OPEN.3          RET IF IT IS
         LA        R1,FCB,X2       GET FCB ADDRESS INTO R1
         SBM       0,FLAGS,X2      SET USING RM FLAG
         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET
         LW        R6,MODE,X2      GET MODE R/W
         BZ        $+2W            BR IF READ MODE
         SBR       R1,1            SET CC1 FOR R/W MODE FOR RM
         BL        RM.OPEN         OPEN VIA REC MGR
         STW       R5,FCB+FCB.FAT,X2  SAVE FAT ADDRESS
         TRR       R7,R7           ANY RM ERROR
         BNZ       OPEN.ERR        GIVE IT TO CALLER
         BU        OPEN.4          CONTINUE PROCESSING OPEN
OPEN.3   TRR       R0,R7           RESTORE CNP ADDRESS
OPEN.5   LA        R1,FCB,X2       GET FCB ADDRESS INTO R1
         ZBM       0,FLAGS,X2      NOT USING RM FOR THIS FILE
         ZBM       1,FLAGS,X2      NOT READING COMPRESSED YET
OPEN.6   SVC       2,X'42'        OPEN FILE
OPEN.4   LW        AP,APSAVE      RESTORE ARGUMENT  POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       DEVICE,X2      NOT A SPECIAL DEVICE
         LW        R3,FCB+FCB.FAT,X2  GET FAT ADDR FROM FCB
         LI        R4,NULL         SET DEVICE TYPE TO NULL
         TBM       3,DFT.FLGS,X3   SEE IF NULL DEVICE
         BS        OPEN.P          BR IF YES
         LI        R4,TERMINAL     SET DEVICE TYPE TO TERMINAL
         TBM       7,DFT.STB,X3    SEE IF TERMINAL
         BS        OPEN.P          BR IF YES
         TBM       RR.SLO,RRS+RR.OPTS  SEE IF SLO FILE
         BS        OPEN.P          TREAT AS TERMINAL IF YES
         ZR        R4              INDICATE IT'S FILE
OPEN.P   STW       R4,DEVICE,R2    SET TYPE
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         ZMW       FLOC,X2        FILE POSITION IS ZERO
         ZMW       CPTR,X2        NO DECOMPRESSING POINTER
         ZMW       SECTA,X2       NO SECTORS YET
         LI        R4,FALSE
         STW       R4,EOF,X2      SET EOF FLAG TO FALSE
         LW        R0,0W,AP       RETURN FILE DESCRIPTOR
         RETURN                   RETURN TO CALLER
*
OPEN.ERR LI        R0,-1           SET ERROR CODE
         LI        R4,NOTUSED      SET FILE DESCRIPTOR NOT USED
         STW       R4,MODE,X2      PUT IN MODE IDENTIFIER
         RETURN                    RETURN TO SENDER....
************************************************************************
*   READ A SET OF CHARACTERS FROM THE FILE
************************************************************************
         SPACE     1
_readraw EQU       $               READ UNBUFFERED RECORD
         ENTER
         SBM       0,RAW           SET RAW FLAG
         BU        READC           MERGE CODE
         SPACE     2
_read    EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         ZBM       0,RAW           SJOW STD READ, NOT RAW
READC    LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET FILE MODE
         CI        R7,NOTUSED     IN USE?
         BEQ       ERRETURN       NOT USED, RETURN WITH ERROR
         CI        R7,WRITMODE    FILE IN WRITE MODE?
         BEQ       ERRETURN       IN WRITE MODE, RETURN WITH ERROR
         TBM       0,RAW           ARE WE IN RAW MODE
         BNS       RN.RAW          BR IF NOT
         LW        R4,LINPTR,X2    MAKE SURE WE ARE AT ZERO
         BNZ       ERRETURN        ERROR IF NOT
         LW        R4,2W,AP        GET TRANSFER COUNT
         BZ        ERRETURN        ERROR IF ZERO
         STW       R4,FCB+FCB.XCT,X2 STUFF IN FCB
         LW        R7,1W,AP        GET BUFFER ADDRESS
         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,TERMINAL    IS IT A TERMINAL?
         BNE       RAW.001        BR IF NOT
         LA        R7,RAW.ERR     GET WAIT ERROR RETURN ADDRESS
         LB        R6,FCB.SPST,X1 SAVE SPECIAL STATUS FLAGS
         SLL       R7,8           POSITION FOR MERGE
         SRLD      R6,8           MERGE FLAGS AND EROR ADDRESS
         STW       R7,FCB.SPST,X1 PUT IN FCB
RAW.001  TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.READ        READ FILE USING RM
         BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'        READ RECORD
RAW.ERR  LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,TERMINAL    IS IT A TERMINAL?
         BNE       RAW.002        BR IF NOT
         LB        R6,FCB.SPST,X1 SAVE SPECIAL STATUS FLAGS
         ZMW       FCB.SPST,X1    CLEAR ERROR ADDRESS
         STB       R6,FCB.SPST,X1 PUT IN FCB
RAW.002  LI        R7,LINESIZE     GET LINE SIZE
         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB
         LA        R4,LINE,X2   GET LINE ADDRESS
         STW       R4,FCB+FCB.XAD,X2 STUFF IN FCB
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         LW        R0,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BNS       READ.15        YES, RETURN WITH EOF
         LI        R4,TRUE         SET EOF IND FOR NEXT TIME
         STW       R7,EOF,X2       DO IT
READ.15  ZMW       LINPTR,X2       SHOW NOTHING IN LINE
         ARMW      R0,FLOC,X2     UPDATE FILE LOCATION
         RETURN
*
RN.RAW   LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4
         ZR        R5             CLEAR THE TRANSFER COUNT IN R5
         LW        R6,2W,AP       GET THE REQUEST COUNT IN R6
         LA        R7,LINE,X2  GET THE LINE ADDRESS
         ADR       R4,R7          ADJUST LINE ADDRESS BY LINE POINTER
         STW       R7,LINADRS     STORE THE LINE ADDRESS LOCALLY
         LW        R7,1W,AP       GET THE BUFFER ADDRESS
         STW       R7,BUFADRS     STORE THE BUFFER ADDRESS LOCALLY
         LW        R7,EOF,X2      GET EOF FLAG
         CI        R7,FALSE       NO EOF?
         BEQ       READ.1         NO EOF, SKIP AHEAD
         ZR        R0             SET EOF IN RESULT REGISTER
         RETURN                   RETURN WITH EOF
READ.1   CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST
         BGE       READ.4         REQUEST SATISFIED, SKIP AHEAD
         TRR       R4,R4          LINE EMPTY?
         BGT       READ.3         NO, SKIP AHEAD
         LW        R7,EOF,X2
         CI        R7,TRUE        EOF REACHED?
         BEQ       READ.4         YES, FINISH UP
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.READ        READ FILE USING RM
         BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BS        READ.EOF       YES, RETURN WITH EOF
         ABM       31,SECTA,X2    SHOW RECORD READ
         LW        R7,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         LA        X3,LINE,X2  GET LINE ADDRESS IN X3
         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE
         ADR       R7,X3          OFFSET TO END OF LINE
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LW        R1,BLOCK,X2     ARE WE UNBLOCKED
         BZ        RDB.2           BR IF YES
RDB.0    TRR       R3,R1          COPY ADDR
         TRR       R7,R7          TEST IF ANY CHARS
         BLE       RDB.1          BR IF NON LEFT
         SUI       R1,1           BACK UP 1 CHAR POSITION
         LB        R1,0B,R1       GET A CHAR
         CI        R1,X'20'       IS IT A SPACE
         BNE       RDB.1          BR IF NON SPACE ENCOUNTERED
         SUI       R3,1           BACK UP END OF BUFFER POINTER
         SUI       R7,1           BACK UP TRANSFER COUNT
         BU        RDB.0          LOOP TIL FIRST NON SPACE
RDB.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LI        R7,NEWLINE     GET NEW LINE CHARACTER
         STB       R7,0B,X3       PUT AT END OF LINE
RDB.2    LW        R7,DEVICE,X2    GET DEVICE TYPE
         CI        R7,TERMINAL     TERMINAL?
         BNE       RDB.NOT         NO, BRANCH AHEAD
         LA        R7,LFCHAR       GET ADDR OF 1 SPACE
         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         LI        R7,1            BYTE CNT OF 1
         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB
         LA        R1,FCB,X2       GET FCB ADDRESS
         SVC       1,X'32'         WRITE LINE FEED
         LW        AP,APSAVE       RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE      RESTORE FILE TABLE ENTRY ADDRESS
         LI        R7,LINESIZE     GET LINE SIZE
         STW       R7,FCB+FCB.XCT,X2 STUFF IN FCB
         LA        X3,LINE,X2   GET LINE ADDRESS
         STW       R3,FCB+FCB.XAD,X2 STUFF IN FCB
RDB.NOT  LA        R7,LINE,X2  GET LINE ADDRESS
         STW       R7,LINADRS     RESET LOCAL LINE ADDRESS
READ.3   EQU       $
         LW        R3,LINADRS      GET LINE ADDRESS
         LB        R7,0B,R3       GET BYTE FROM LINE
         LW        R3,BUFADRS      GET BUFFER ADDRESS
         STB       R7,0B,R3       STORE BYTE TO USER BUFFER
         ADI       R5,1           INCREMENT TRANSFER COUNT
         ABM       31,BUFADRS     INCREMENT BUFFER ADDRESS
         ADI       R4,1           INCREMENT LINE POINTER
         ABM       31,LINADRS     INCREMENT LINE ADDRESS
         CAMW      R4,EOLPTR,X2   COMPARE LINE POINTER TO END OF LINE
         BLT       READ.1         LINE NOT EMPTY, DO NEXT CHARACTER
         ZR        R4             INITIALIZE LINE POINTER
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,TERMINAL    IS IT A TERMINAL?
         BEQ       READ.4         YES FINISH UP
         ABM       31,BLKPTR,X2   NO, UPDATE BLOCK POINTER
         BU        READ.1         DO NEXT CHARACTER
READ.EOF LI        R7,TRUE
         STW       R7,EOF,X2      SET EOF FLAG
READ.4   EQU       $
         STW       R4,LINPTR,X2   ADJUST LINE POINTER
         ARMW      R5,FLOC,X2     ADJUST CURRENT CHAR POSITION
         TRR       R5,R0          MOVE TRANSFER COUNT IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   WRITE A SET OF CHARACTERS TO THE FILE
************************************************************************
         SPACE     1
_writraw EQU       $               WRITE RAW RECORD
         ENTER
         SBM       0,RAW           SET FLAG
         BU        WRIT.1          MERGE CODE
         SPACE     1
_write   EQU       $
         ENTER                    SAVE REGISTERS ON STACK
         ZBM       0,RAW           SHOW NOT RAW I/O
WRIT.1   LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET MODE
         CI        R7,NOTUSED     FILE IN USE?
         BEQ       ERRETURN       FILE NOT USED, RETURN WITH ERROR
         CI        R7,READMODE    FILE IN READ MODE?
         BEQ       ERRETURN       IN READ MODE, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,NULL        NULL FILE?
         BEQ       WRITE.5        YES, FINISH UP
         TBM       0,RAW           ARE WE IN RAW MODE
         BNS       WR.RAW          BR IF NOT
         TRR       R1,R3          SAVE AP
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BS        $+4W           IF SO SKIP WAIT
         TBM       0,3W,X1        LAST OPERATION ALL DONE?
         BNS       $+2W           YES, CONTINUE
         SVC       1,X'3C'        NO, WAIT
         LW        R4,LINPTR,X2    MAKE SURE WE ARE AT ZERO
         BNZ       ERRETURN        ERROR IF NOT
         LW        R4,2W,X3        GET TRANSFER COUNT
         BZ        ERRETURN        ERROR IF ZERO
         STW       R4,FCB+FCB.XCT,X2 STUFF IN FCB
         LW        R7,1W,X3        GET BUFFER ADDRESS
         STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       WRITE.11           BR IF NOT
         BL        RM.WRIT        WRIT FILE USING RM
         BU        WRITE.19           SKIP NORMAL WRIT
WRITE.11 EQU       $
         LW        R2,FCB.XAD,X1  GET USER BUFFER ADDRESS
         SRL       R2,2           WORD BOUND
         SLL       R2,2
         LW        R4,0,X2        GET FIRST WORD OF USER BUFFER
         CAMW      R4,=X'1B544945'    IF IT IS TIE ESCAPE,
         BEQ       WRITE.13
         LW        R2,FCB.XAD,X1  GET USER BUFFER ADDRESS
         LNW       R4,FCB.XCT,X1  AND COUNT
         CI        R4,-256        MAKE SURE IT FITS IN MY BUFFER
         BLT       WRITE.13
         LA        R3,RAW.NWB     GET ADDRESS OF MY BUFFER
         STW       R3,FCB.XAD,X1
WRITE.LP LB        R7,0,X2        COPY OVER USER RECORDS
         STB       R7,0,X3
         ABR       R2,31
         ABR       R3,31
         BIB       R4,WRITE.LP
         SBM       0,2W,X1        SET NO WAIT
         BU        $+2W
WRITE.13 ZBM       0,2W,X1
         SVC       1,X'32'         WRITE RECORD
WRITE.19 LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         LW        R0,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         ARMW      R0,FLOC,X2     UPDATE FILE POSITION
         ABM       31,SECTA,X2    UPDATE RECORD COUNT
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BNS       WRIT.2         YES, RETURN WITH EOF
         LI        R4,TRUE         SET EOF IND FOR NEXT TIME
         STW       R4,EOF,X2       DO IT
WRIT.2   TBM       FCB.EOM,FCB+FCB.STAT,X2
*                                 WAS EOM ENCOUNTERED?
         BNS       WRIT.3         NO, RETURN TRANSFER COUNT
         LI        R0,EOM          SET EOM IND FOR RETURN
WRIT.3   ZMW       LINPTR,X2       SHOW NOTHING IN LINE
         RETURN                    GO RETURN
*
WR.RAW   LW        R4,LINPTR,X2   GET LINE POINTER
         ZR        R5             CLEAR TRANSFER COUNT
         LA        R7,LINE,X2  GET THE LINE ADDRESS
         ADR       R4,R7          ADJUST LINE ADDRESS BY LINE POINTER
         STW       R7,LINADRS     STORE THE LINE ADDRESS LOCALLY
         LW        R7,1W,AP       GET THE BUFFER ADDRESS
         STW       R7,BUFADRS     STORE THE BUFFER ADDRESS LOCALLY
WRIT.BLK TRR       R4,R4          IS LINE EMPTY?
         BNE       WRITE.6        NO, SKIP AHEAD
         LW        R7,BLOCK,X2   SEE IF FILE UNBLOCKED
         BZ        WRITE.6         BR IF YES
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         BEQ       WRITE.6        NOT SPECIAL, SKIP AHEAD
         LW        R3,BUFADRS      GET BUFFER ADDR
         LB        R7,0B,R3       GET CHARACTER OF LINE
         CI        R7,X'0C'       SEE IF FORMFEED CHAR
         BNE       WRITE.4        SKIP IF NOT
         LI        R7,G'1'        GET A 1 FOR TOF ON LP
         ABM       31,BUFADRS     SKIP OVER CHAR
         ADI       R5,1           UPDATE REQUEST COUNT
         BU        WRITE.41        MERGE CODE
WRITE.4  LW        R7,=G' '       GET BLANK FOR SLO FORMS CONTROL
WRITE.41 LW        R3,LINADRS     GET LINE ADDRESS
         STB       R7,0B,R3       STUFF FORMS CONTROL CHARACTER IN LINE
         ABM       31,LINADRS     UPDATE LINE ADDRESS
         ADI       R4,1           UPDATE TRANSFER COUNT
WRITE.6  EQU       $
         CAMW      R5,2W,AP       COMPARE TRANSFER COUNT TO REQUEST
         BGE       WRITE.9        DONE, FINISH UP
         LW        R3,BUFADRS      GET BUFFER ADDRESS
         LB        R7,0B,R3       GET CHARACTER
         ABM       31,BUFADRS     UPDATE BUFFER ADDRESS
         ADI       R5,1           UPDATE REQUEST COUNT
*002          CI        R7,X'7F'       IS IT A GOOD CHARACTER?
*002          BGT       WRITE.6        NO, GO GET ANOTHER
         LW        R0,BLOCK,X2   SEE IF FILE UNBLOCKED
         BZ        WRITE.61        BR IF YES
         CI        R7,NEWLINE     NEW LINE CHARACTER?
         BEQ       WRITE.7        YES, FLUSH LINE
WRITE.61 LW        R3,LINADRS     GET LINE ADDR
         STB       R7,0B,R3       STORE CHARACTER IN LINE
         ABM       31,LINADRS     UPDATE LINE ADDRESS
         ADI       R4,1           UPDATE TRANSFER COUNT
         LW        R7,BLOCK,X2   SEE IF FILE UNBLOCKED
         BNZ       WRITE.62        BR IF NOT
         CI        R4,LINESIZE     SEE IF BUFFER FULL
         BLT       WRITE.6         BR IF NOT
         BU        WRITE.7         GO PURGE BUFFER
WRITE.62 CI        R4,254          MAX BLOCKED RECORD LENGTH
         BLT       WRITE.6         BR IF STILL O.K.
WRITE.7  EQU       $
         BL        SETTCW         SET THE TCW IN THE FCB
         BL        WRITLINU       WRITE THE LINE
         TRR       R7,R7          TEST THE RETURN RESULT
         BNE       ACC.RET        NON ZERO, RETURN WITH ERROR
         LA        R7,LINE,X2  GET LINE ADDRESS
         STW       R7,LINADRS     RESET LOCAL LINE ADDRESS
         ZR        R4             INITIALIZE LINE POINTER
         BU        WRIT.BLK       START AGAIN
WRITE.9  EQU       $
         STW       R4,LINPTR,X2   SAVE LINE POINTER
WRITE.5  LW        R0,2W,AP       SET OD IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
ACC.RET  TRR       R7,R0           RETURN VALUE IN R0
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   SEEK TO A POSITION IN THE FILE
************************************************************************
         SPACE     1
_seek    EQU       $
         ENTER                    SAVE THE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         STW       X2,FTESAVE     SAVE FILE TABLE ENTRY ADDRESS
         LW        R4,MODE,X2     GET MODE
         CI        R4,NOTUSED     FILE DESCRIPTOR IN USE?
         BEQ       ERRETURN       NOT IN USE, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,NULL        NULL FILE?
         BEQ       SEEK.5         YES, FINISH UP
         CI        R4,READMODE    ARE WE OUTPUT ACTIVE
         BEQ       SEEK.1          NO, JUST SEEK
         LW        R4,LINPTR,X2    ANY CHARS LEFT IN BUFFER
         BZ        SEEK.1          NO, JUST CLOSE IT
         BL        SETTCW          YES, PURGE IT
         BL        WRITLINU        WRIT IT
*        OFFSET=0  OFFSET I.D.=0   ---> REWIND FILE
*        OFFSET=0  OFFSET I.D.=2   ---> SET TO EOF
*        OTHERS .EQ. ERROR RETURN
SEEK.1   CI        R7,TERMINAL     IS IT TTY
         BEQ       SEEK.5          JUST EXIT IF YES
         LW        R7,1W,AP       GET THE OFFSET
         BNE       SEEK.6         NOT ZERO, OFFSET SPECIFIED
         LW        R6,2W,AP       GET THE OFFSET IDENTIFIER
         BNE       SEEK.3         NOT ZERO, SEE IF ADV TO EOF
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         LW        R4,MODE,X2     GET MODE
         CI        R4,READMODE    ARE WE OUTPUT ACTIVE
         BEQ       SEEK.2          NO, JUST REWIND
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.WEOF        WEOF FILE USING RM
         BU        $+2W           SKIP NORMAL WEOF
         SVC       1,X'38'        WRITE EOF
SEEK.2   TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.RWND        RWND FILE USING RM
         BU        $+2W           SKIP NORMAL RWND
         SVC       1,X'37'        REWIND FILE
         ZMW       FLOC,X2        NO BYTE COUNT
         ZMW       SECTA,X2       NO RECORDS EITHER
         ZMW       CPTR,X2        NO COMPRESS POINTER
         BU        SEEK.4          MERGE CODE
SEEK.3   CI        R6,1            0 OFFSET TO CURR POSITION
         BEQ       SEEK.5          JUST RETURN O.K.
         CI        R6,2            SEE IF SEEK TO EOF
         BNE       ERRETURN        ERROR IF NOT
         LA        R1,FCB,R2       GET FCB ADDR
*        LW        R4,BLOCK,X2     SEE IF FILE BLOCKED
*        BNZ       SEEK.35         BR IF YES
SEEK.32  TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.READ        READ FILE USING RM
         BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'         READ UNBLOCKED FILE
         TBM       FCB.ERR,FCB+FCB.STAT,X2  SEE IF ERR
         BS        SEEK.37         BR IF YES
         TBM       FCB.EOF,FCB+FCB.STAT,X2  SEE IF EOF
         BS        SEEK.37         BR IF YES
         ABM       31,SECTA,X2    ANOTHER RECORD READ
         LW        R4,FCB+FCB.CNT,X2  GET BYTE COUNT
         ARMW      R4,FLOC,X2     UPDATE BYTE POSITION
         BU        SEEK.32         GO READ NEXT RECORD
SEEK.35  TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.ADVF        ADVF FILE USING RM
         BU        $+2W           SKIP NORMAL ADVF
         SVC       1,X'34'         ADVANCE FILE
SEEK.37  TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.BACK        BACK FILE USING RM
         BU        $+2W           SKIP NORMAL BACK
         SVC       1,X'35'         BACKSPACE RECORD
SEEK.4   LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         LI        R4,FALSE
         STW       R4,EOF,X2      SET EOF FLAG TO FALSE
SEEK.5   LW        R0,FLOC,X2     SET OK IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
*
*  OFFSET SPECIFIED
*
SEEK.6   BLT       SEEK.9          BACKWARK SEEK
* FORWARD SEEK SPECIFIED
         LW        R6,2W,AP        GET SEEK BASE
         BZ        SEEK.71         BR IF FROM BEGINNING OF FILE
         CI        R6,1            IS IT TO CURR POSITION
         BNE       ERRETURN        BR IF FROM EOF, ERROR
SEEK.70  ADMW      R7,FLOC,X2      ADD IN CURRENT POSITION
         BLT       ERRETURN        IF NEG, SEEK TO BEFORE BOF
         BU        SEEK.71         MERGE CODE
SEEK.9   LW        R6,2W,AP        GET SEEK BASE
         BZ        ERRETURN       NO BACKWARD FROM BOF
         CI        R6,1            CURR POSITION
         BEQ       SEEK.70         BR IF YES
         CI        R6,2            FROM EOF
         BNE       ERRETURN        BR IF NOT, ERROR
*
* MUST SEEK TO EOF FIRST
*
         LA        R1,FCB,R2       GET FCB ADDR
SEEK.92  TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.READ        READ FILE USING RM
         BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'         READ UNBLOCKED FILE
         TBM       FCB.ERR,FCB+FCB.STAT,X2  SEE IF ERR
         BS        SEEK.97         BR IF YES
         TBM       FCB.EOF,FCB+FCB.STAT,X2  SEE IF EOF
         BS        SEEK.97         BR IF YES
         ABM       31,SECTA,X2    ANOTHER RECORD READ
         LW        R4,FCB+FCB.CNT,X2  GET BYTE COUNT
         ARMW      R4,FLOC,X2     UPDATE BYTE POSITION
         BU        SEEK.92         GO READ NEXT RECORD
SEEK.97  TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.BACK        BACK FILE USING RM
         BU        $+2W           SKIP NORMAL BACK
         SVC       1,X'35'         BACKSPACE RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         ZMW       BLKPTR,X2      SET BLOCK POINTER TO FIRST BLOCK
         ZMW       EOLPTR,X2      SET EOL POINTER TO FIRST CHARACTER
         ZMW       LINPTR,X2      SET LINE POINTER TO FIRST CHARACTER
         LI        R4,FALSE
         STW       R4,EOF,X2      SET EOF FLAG TO FALSE
         LW        R7,FLOC,X2     GET CURRENT EOF POSITION
         LW        AP,APSAVE      RESTORE ARG POINTER
         ADMW      R7,1W,AP       GET ABSOLUTE OFFSET
         BU        SEEK.71         MERGE CODE
*
* R7 = ABSOLUTE OFFSET INTO FILE
*
SEEK.71  LW        R6,FLOC,X2      GET CURRENT POSITION
         TRR       R7,R5           SAVE ABSOLUTE POSITION
         SUR       R6,R7           REQ - CURR = DELTA
         BGT       SEEK.80         BR IF SEEK FORWARD IN FILE
         BZ        SEEK.5          IF THERE EXIT
*
* MUST SEEK BACKWARDS IN FILE - R7 = NEG NUM OF BYTES
*
         LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4
         ZR        R5             CLEAR THE TRANSFER COUNT IN R5
         TRN       R7,R6          GET THE REQUEST COUNT IN R6
SEEK.701 CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST
         BGE       SEEK.74        REQUEST SATISFIED, SKIP AHEAD
         TRR       R4,R4          LINE EMPTY?
         BGT       SEEK.73        NO, SKIP AHEAD
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+5W           BR IF NOT
         BL        RM.BACK        BACKSPACE TO CURR REC
         BL        RM.BACK        BACKSPACE TO PREV REC
         BL        RM.READ        READ FILE USING RM
         BU        $+4W           SKIP NORMAL READ
         SVC       1,X'35'        BACKSPACE RECORD
         SVC       1,X'35'        BACKSPACE RECORD
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         LI        R7,-1           DECR RECORD COUNT
         ARMW      R7,SECTA,X2    SHOW RECORD READ BACKWARD
         LW        R7,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         LA        X3,LINE,X2  GET LINE ADDRESS IN X3
         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE
         ADR       R7,X3          OFFSET TO END OF LINE
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LW        R1,BLOCK,X2     ARE WE UNBLOCKED
         BZ        SKA.2           BR IF YES
SKA.0    TRR       R3,R1          COPY ADDR
         TRR       R7,R7          TEST IF ANY CHARS
         BLE       SKA.1          BR IF NON LEFT
         SUI       R1,1           BACK UP 1 CHAR POSITION
         LB        R1,0B,R1       GET A CHAR
         CI        R1,X'20'       IS IT A SPACE
         BNE       SKA.1          BR IF NON SPACE ENCOUNTERED
         SUI       R3,1           BACK UP END OF BUFFER POINTER
         SUI       R7,1           BACK UP TRANSFER COUNT
         BU        SKA.0          LOOP TIL FIRST NON SPACE
SKA.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LI        R7,NEWLINE     GET NEW LINE CHARACTER
         STB       R7,0B,X3       PUT AT END OF LINE
SKA.2    LW        R4,EOLPTR,X2   GET LINE COUNT
SEEK.73  ADI       R5,1           INCREMENT TRANSFER COUNT
         SUI       R4,1           DECREMENT LINE POINTER
         BGE       SEEK.701        LINE NOT EMPTY, DO NEXT CHAR
         ZR        R4             INITIALIZE LINE POINTER
         LI        R7,-1          DECR COUNT
         ARMW      R7,BLKPTR,X2   NO, UPDATE BLOCK POINTER
         BU        SEEK.701       DO NEXT CHARACTER
SEEK.74  EQU       $
         STW       R4,LINPTR,X2   ADJUST LINE POINTER
         LW        R4,FLOC,X2     GET BYTE POSITION
         SUR       R5,R4          NEW POSITION
         TRR       R4,R0          MOVE CURRENT POSITION  RESULT REGISTER
         RETURN                   RETURN TO CALLER
*
* MUST SEEK FORWARD IN FILE - R7 = NUMBER OF BYTES
*
SEEK.80  LW        R4,LINPTR,X2   GET THE LINE POINTER IN R4
         ZR        R5             CLEAR THE TRANSFER COUNT IN R5
         TRR       R7,R6          GET THE DELTA COUNT IN R6
         LW        R7,EOF,X2      GET EOF FLAG
         CI        R7,FALSE       NO EOF?
         BEQ       SEEK.81        NO EOF, SKIP AHEAD
SEEK.84  LI        R0,-1          SET EOF IN RESULT REGISTER
         LI        R7,TRUE
         STW       R7,EOF,X2      SET EOF FLAG
         RETURN                   RETURN WITH EOF
SEEK.81  CAR       R6,R5          COMPARE TRANSFER COUNT TO REQUEST
         BGE       SEEK.90        REQUEST SATISFIED, SKIP AHEAD
         TRR       R4,R4          LINE EMPTY?
         BGT       SEEK.83        NO, SKIP AHEAD
         LW        R7,EOF,X2
         CI        R7,TRUE        EOF REACHED?
         BEQ       SEEK.84        YES, FINISH UP
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.READ        READ FILE USING RM
         BU        $+2W           SKIP NORMAL READ
         SVC       1,X'31'        READ RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        ERRETURN       YES, RETURN WITH ERROR
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BS        SEEK.84        YES, RETURN WITH EOF
         ABM       31,SECTA,X2    SHOW RECORD READ
         LW        R7,FCB+FCB.CNT,X2
*                                 GET CHARACTER COUNT
         LA        X3,LINE,X2  GET LINE ADDRESS IN X3
         STW       R3,CPTR,X2  SET DATA POINTER FOR COMPRESSED FILE
         ADR       R7,X3          OFFSET TO END OF LINE
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LW        R1,BLOCK,X2     ARE WE UNBLOCKED
         BZ        SEEK.83         BR IF YES
SKB.0    TRR       R3,R1          COPY ADDR
         TRR       R7,R7          TEST IF ANY CHARS
         BLE       SKB.1          BR IF NON LEFT
         SUI       R1,1           BACK UP 1 CHAR POSITION
         LB        R1,0B,R1       GET A CHAR
         CI        R1,X'20'       IS IT A SPACE
         BNE       SKB.1          BR IF NON SPACE ENCOUNTERED
         SUI       R3,1           BACK UP END OF BUFFER POINTER
         SUI       R7,1           BACK UP TRANSFER COUNT
         BU        SKB.0          LOOP TIL FIRST NON SPACE
SKB.1    ADI       R7,1           INCREMENT LINE CHARACTER COUNT
         STW       R7,EOLPTR,X2   SET END OF LINE POINTER IN FILE TABLE
         LI        R7,NEWLINE     GET NEW LINE CHARACTER
         STB       R7,0B,X3       PUT AT END OF LINE
SEEK.83  ADI       R5,1           INCREMENT TRANSFER COUNT
         ADI       R4,1           INCREMENT LINE POINTER
         CAMW      R4,EOLPTR,X2   COMPARE LINE POINTER TO END OF LINE
         BLT       SEEK.81        LINE NOT EMPTY, DO NEXT CHARACTER
         ZR        R4             INITIALIZE LINE POINTER
         ABM       31,BLKPTR,X2   NO, UPDATE BLOCK POINTER
         BU        SEEK.81        DO NEXT CHARACTER
*        RETURN     CURRENT POSITION TO CALLER
SEEK.90  STW       R4,LINPTR,X2   ADJUST LINE POINTER
         ARMW      R5,FLOC,X2     ADJUST CURRENT CHAR POSITION
         LW        R0,FLOC,X2     MOVE TRANSFER COUNT IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   IS THE FILE A TERMINAL?
************************************************************************
         SPACE     1
_isatty  EQU       $
         ENTER                    SAVE THE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       TTY.NO         FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       TTY.NO         FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET MODE
         CI        R7,NOTUSED     FILE DESCRIPTOR IN USE?
         BEQ       TTY.NO         NOT IN USE, RETURN WITH ERROR
         LW        R7,DEVICE,X2   GET DEVICE TYPE
         CI        R7,TERMINAL    TERMINAL?
         BEQ       TTY.YES        YES, SKIP AHEAD
TTY.NO   ZR        R0             NO, SET RETURN TO FALSE
         BU        TTY.RET
TTY.YES  LI        R0,1
TTY.RET  RETURN
         SPACE     2
************************************************************************
*   IS THE FILE BLOCKED?
************************************************************************
         SPACE     1
___isblk EQU       $
         ENTER                    SAVE THE REGISTERS ON STACK
         LW        X2,0W,AP       PICK UP FILE DESCRIPTOR
         BLT       ERRETURN       FD TOO SMALL, RETURN WITH ERROR
         CI        X2,FILECNT     COMPARE TO MAXIMUM FILE DESCRIPTOR
         BGE       ERRETURN       FD TOO LARGE, RETURN WITH ERROR
         INDEX     X2             GET FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X2     GET MODE
         CI        R7,NOTUSED     FILE DESCRIPTOR IN USE?
         BEQ       ERRETURN       NOT IN USE, RETURN WITH ERROR
         LW        R7,BLOCK,X2    IS FILE BLOCKED?
         BNZ       ISB.YES        YES, SKIP AHEAD
ISB.NO   ZR        R0             NO, SET RETURN TO FALSE
         BU        ISB.RET
ISB.YES  LI        R0,1
ISB.RET  RETURN
         SPACE     2
************************************************************************
*   RETURN WITH AN ERROR
************************************************************************
         SPACE     1
         BOUND     1W
ERRETURN EQU       $
*        SVC       1,X'63'         ATTACH DEBUGGER
         LI        R0,-1          SET ERROR CODE IN RESULT REGISTER
         RETURN                   RETURN TO CALLER
         PAGE
************************************************************************
*   GET A FILE DESCRIPTOR
*
*   SEARCH SEQUENTIALLY BEGINNING TO END
*   R7 RETURNED AS FILE TABLE ENTRY #   OR   -1 FOR NONE AVAILABLE
*
************************************************************************
         SPACE     1
GETFD    EQU       $
         LI        X2,-FILECNT    SET UP LOOP COUNT
GET.LOOP EQU       $
         TRR       X2,X3
         ADI       X3,FILECNT
         INDEX     X3             GET FILE TABLE ENTRY ADDRESS
         LW        R7,MODE,X3     GET MODE
         CI        R7,NOTUSED     IN USE?
         BEQ       GET.FND        NO, FOUND ONE
         BIB       X2,GET.LOOP    TRY NEXT FILE DESCRIPTOR
         LI        R7,-1          NONE AVAILABLE, SET ERROR CODE
         BU        GET.RET        RETURN
GET.FND  EQU       $
         TRR       X2,R7
         ADI       R7,FILECNT     RECOVER FILE DESCRIPTOR
GET.RET  EQU       $
         TRSW      R0             RETURN
         SPACE     2
************************************************************************
*   PARSE FILE NAME INTO PATHNAME BLOCK
************************************************************************
         SPACE     1
PARSE    EQU       $
         LW        X2,0W,AP       PICK UP PATHNAME ADDRESS
*                                 *** ASSUMED TO BE A WORD ADDRESS
         TRR       X2,X3          MAKE ANOTHER COPY
PAR.LOOP EQU       $
         LB        R4,0B,X3       GET PATHNAME CHARACTER
         BEQ       PAR.NULL       STRING TERMINATOR FOUND, BRANCH
         BIB       X3,PAR.LOOP    TRY NEXT CHARACTER
PAR.NULL EQU       $
         SUR       X2,X3          GET PATHNAME LENGTH
         CI        X3,0           SEE IF PATHNAME IS ZERO
         BLE       PAR.ZER
         CI        X3,PNLENGTH    COMPARE TO MAXIMUM LENGTH
         BGT       PAR.ERR        TOO BIG, RETURN WITH ERROR
         SLL       X3,24          MOVE COUNT LEFT
         ORR       X3,X2          CONSTRUCT PATHNAME VECTOR WORD
         TRR       X2,R1          PUT IN REGISTER FOR SERVICE
         LW        R4,PNBVCTOR    GET PATHNAME BLOCK VECTOR IN REGISTER
         ZR        R7             NO CNP
         SVC       2,X'2E'        CONVERT PATHNAME TO PATHNAME BLOCK
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRR       R7,R7          TEST THE RETURN RESULT
         BNE       PAR.ERR        DIDNT WORK, RETURN WITH ERROR
         STW       R4,PNBWRDX    SAVE PATHNAME BLOCK VECTOR WORD
         ZR        R7             SET OK IN RESULT REGISTER
         BU        PAR.RET        RETURN TO CALLER
PAR.ZER  EQU       $
         LI        R7,1           RETURN +1
         BU        PAR.RET
PAR.ERR  EQU       $
         LI        R7,-1          SET ERROR IN RESULT REGISTER
PAR.RET  EQU       $
         TRSW      R0             RETURN TO CALLER
         SPACE     2
************************************************************************
*   SEE IF A FILE EXISTS
************************************************************************
         SPACE     1
         BOUND     1W
EXISTS   EQU       $
         LW        R1,PNBWRDX    GET PNB VECTOR WORD IN REGISTER FOR
*                                   SERVICE
         LA        R6,RD           RETRIEVE RESOURCE DESCRIPTOR
         ZR        R7
         SVC       2,X'2C'
         TRR       R7,R7          TEST THE RETURN CODE
         BNE       EXI.ERR        NO RD, RETURN WITH ERROR
         LH        R6,RD+RD.TYPE  GET RESOURCE TYPE
         CI        R6,RD.PERM     IS IT A PERMANENT FILE?
         BEQ       EXI.FL         YES, SEE IF BLOCKED
         CI        R6,RD.DIR      IS IT A DIRECTORY
         BNE       EXI.ERR        ERROR IF NOT FILE OR DIRECTORY
         BU        EXI.UB         SHOW DIR IS UNBLOCKED
EXI.FL   TBM       RD.BLK,RD+RD.FLAG
*                                 CHECK IF FILE IS BLOCKED
         BS        EXI.BLK        BLOCKED, SKIP AHEAD
EXI.UB   LI        R7,UNBLOCK     SET UNBLOCKED IN RESULT REGISTER
         BU        EXI.RET        RETURN TO SENDER
EXI.BLK  LI        R7,BLOCKED     SET BLOCKED IN RESULT REGISTER
         BU        EXI.RET        RETURN TO SENDER
EXI.ERR  LI        R7,-1          SET ERROR IN RESULT REGISTER
EXI.RET  LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRSW      R0             RETURN TO CALLER
         SPACE     2
************************************************************************
*   SAVE PATHNAME BLOCK IN FILE TABLE ENTRY
************************************************************************
         SPACE     1
         BOUND     1W
PNBSAVE  EQU       $
         LA        X3,PNB,X2      GET PATHNAME BLOCK ADDRESS
         LI        X2,-PNBSIZE    GET PNB LENGTH IN X2              !003
PNBLOOP  EQU       $
         LW        R5,PNBX+PNBSIZE,X2 GET PART OF PNB               !003
         STW       R5,0,X3        SAVE IN FILE TABLE ENTRY
         ABR       X3,29          CHANGE FILE TABLE ENTRY POINTER
         BIW       X2,PNBLOOP     MOVE NEXT WORD
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         LA        R5,PNB,X2      GET PNB ADDRESS
         STW       R5,PNBWORD,X2  STUFF IN LAST PART OF VECTOR WORD
         LB        R5,PNBWRDX    GET PNB COUNT
         STB       R5,PNBWORD,X2  STUFF IN FIRST PART OF VECTOR WORD
         TRSW      R0
         SPACE     2
************************************************************************
*   WRITE CURRENT LINE   (BLOCKED)
************************************************************************
         SPACE     1
         BOUND     1W
WRITLINU EQU       $
         STW       R0,WRTL.RET     SAVE RETURN ADDRESS
         LW        X2,FTESAVE     RESTORE FILE TABLE ENTRY ADDRESS
         LA        R1,FCB,X2      GET FCB ADDRESS IN REGISTER FOR SERVIC
         TBM       0,FLAGS,X2     IS RM IN USE
         BNS       $+3W           BR IF NOT
         BL        RM.WRIT        WRIT FILE USING RM
         BU        $+2W           SKIP NORMAL WRIT
         SVC       1,X'32'        WRITE RECORD
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TBM       FCB.ERR,FCB+FCB.STAT,X2
*                                 WAS ERROR ENCOUNTERED?
         BS        WTU.ERR        YES, RETURN WITH ERROR
         TBM       FCB.EOF,FCB+FCB.STAT,X2
*                                 WAS EOF ENCOUNTERED?
         BS        WTU.ERR        YES, RETURN WITH ERROR
         TBM       FCB.EOM,FCB+FCB.STAT,X2                     A001
*                                 WAS EOM ENCOUNTERED?         A001
         BS        WTU.EOM        YES, RETURN WITH ERROR       A001
         ZR        R7             CLEAR RESULT REGISTER
         ABM       31,SECTA,X2    UPDATE RECORD COUNT
         LW        R0,FCB+FCB.CNT,X2  GET TRANSFER CNT
         ARMW      R0,FLOC,X2     UPDATE BYTE COUNT
         BU        WTU.RET        RETURN TO CALLER
WTU.EOM  LI        R7,-2          SET ERROR IN RESULT REGISTER A001
         ZMW       LINPTR,X2       RESET LINE POINTER          A001
*                                    THAT THE BUFFER IS EMPTY  A001
         BU        WTU.RET        RETURN TO CALLER             A001
WTU.ERR  EQU       $
         LI        R7,-1          SET ERROR IN RESULT REGISTER
WTU.RET  EQU       $
         LW        R0,WRTL.RET     RESTORE RTURN ADDRESS
         TRSW      R0             RETURN TO CALLER
         SPACE     2
************************************************************************
*   SET TCW IN FCB
************************************************************************
         SPACE     1
         BOUND     1W
SETTCW   EQU       $
         TRR       R4,R4           ANYTHING TO GO OUT
         BNZ       SET.1           BR IF YES
         LA        R7,LFCHAR       GET ADDR OF 1 BLANK
         LI        R4,1            GET CNT OF 1 BYTE
         BU        SET.2           GO PUT IN TCW
SET.1    LA        R7,LINE,X2   GET LINE ADDRESS
SET.2    STW       R7,FCB+FCB.XAD,X2 STUFF IN FCB
         STW       R4,FCB+FCB.XCT,X2 TRANSFER CNT TO FCB
         TRSW      R0              RETURN TO CALLER
************************************************************************
*   FILE TABLE
************************************************************************
         SPACE     1
         REL
         ORG       >FILTABL
         REPT      FILECNT
         FIL       G'UX0'+$$$-1,LINE
         ENDR
         SPACE     2
************************************************************************
*   RESOURCE REQUIREMENT SUMMARY AND PATHNAME BLOCK
************************************************************************
         SPACE     1
         REL
         BOUND     1D
RRS      RES       1W             LFC GOES HERE
         DATAB     1,0,0,0        TYPE 1 RRS
         DATAW     X'D0008000'    ALLOW FOR UPDATE EXPLICIT SHARED
         DATAW     0
PNBX     EQU       $               PNB FOR PATHNAME
         RES       PNBSIZE                                          !003
PNB1     EQU       $
         RES       PNBSIZE         PNB FOR 1ST  PATHNAME IF 2 ARE   !003
PNLENGTH EQU       80              MAXIMUM PATHNAME LENGTH          !003
PNBVCTOR GEN       8/PNBSIZE,24/W(PNBX)                             !003
*                                  EMPTY PNB VECTOR WORD
         SPACE     2
************************************************************************
*   CNP  FOR OPENS
************************************************************************
         SPACE     1
CNP      DATAW     0               WAIT FOR RESOURCE
         DATAW     W(ERRETURN)    ERROR RETURN ADDRESS
         DATAW     X'00000000'    OPEN FOR READ BLOCKED
         REZ       2W
         SPACE     2
************************************************************************
*   VARIOUS SCRATCH BUFFERS
************************************************************************
         SPACE     1
         BOUND     1D
RD       RES       192W           RESOURCE DESCRIPTOR BUFFER
         SPACE     2
         PAGE
************************************************************************
*   RESOURCE CREATE BLOCK
************************************************************************
         SPACE     1
         BOUND     1D
RCB      EQU       $
         REZ       4W
OWNER    DATAW     0              OWNER ACCESS RIGHTS
GROUP    DATAW     0              GROUP ACCESS RIGHT
OTHER    DATAW     0              OTHER ACCESS RIGHTS
         DATAW     X'EE000000'    ZERO FILE  WAS X'100'        A001
MAXX     DATAW     16             MAXIMUM EXTENSION            A001
MINX     DATAW     8              MINIMUM EXTENSION            A001
         REZ       1W
ORGS     DATAW     4              ORIGINAL SIZE
         REZ       4W
         SPACE     2
************************************************************************
*   RESOURCE REQUIREMENT SUMMARY AND PATHNAME BLOCK
************************************************************************
         SPACE     1
         BOUND     1D
SPSAVE   DATAW     0
APSAVE   DATAW     0
FTESAVE  DATAW     0
BLKSAVE  DATAW     0               BLOCKED STATUS SAVE AREA
FDSAVE   DATAW     0               FILE DESCRIPTOR SAVE AREA
PTRSAVE  DATAD     0               LINE AND BLOCK POINTER SAVE AREA
PNBWRD1  DATAW     0               PATHNAME WORD FOR FIRST ARG
PNBWRDX  DATAW     0               PATHNAME WORD FOR SINGLE OR 2ND ARG
LINADRS  DATAW     0               LOCAL LINE ADDRESS
BUFADRS  DATAW     0               LOCAL USER BUFFER ADDRESS
RAW      DATAW     0               BIT ZERO SET WHEN RAW I/O
CDF      DATAW     0               BIT ZERO SET CREATING DIRECTORY
*
* SIZES OF FIXED LENGTH RRS ENTRIES
*
RR.9.SIZ EQU       10              MOUNT DEVICE - 10 WORDS
RR.4.SIZ EQU       4               LFC          -  4 WORDS
RR.2.SIZ EQU       4               TEMP         -  4 WORDS (+ VOL)
RR.3.SIZ EQU       6               DEVICE       -  6 WORDS
RR.1.SIZ EQU       4               PATHNAME     -  4 WORDS (+ PATH)
RR.6.SIZ EQU       12              RID          - 12 WORDS
RR.D.SIZ EQU       10              EXTENDED SLO - 10 WORDS          3206
*
* SIZE IN WORDS OF REFORMATTED RRS ENTRIES
*
CASSA.NW EQU       4               ASSIGN 1
CASSB.NW EQU       4               ASSIGN 2
CASSC.D1 EQU       4               ASSIGN 3 (TEMP FILE ANY DEVICE)
CASSC.D2 EQU       8               ASSIGN 3 (TEMP FILE SPEC. DEV)
CASSC.DV EQU       6               ASSIGN 3 (DEVICE)
CASSD.NW EQU       4               ASSIGN 4
*
*  TERMINAL LINE BUFFER EQUATES                                     210D
*
TLB.LARG EQU       0D              ORIGIN OF LAST ARGUEMENT FOUND
TLB.BUFL EQU       4W+0B           LINE BUFFER LENGTH
TLB.CIND EQU       4W+1B           CURSOR INDEX
TLB.FDLM EQU       4W+2B           FIELD DELIMITER
TLB.FSIZ EQU       4W+3B           FIELD SIZE
RRS.SIZE DATAW     0               SIZE OF CURRENT RRS ENTRY
COPT90   RES       1F
CDEV90   RES       1F
*
*  SCRATCH DOUBLE WORD TO COUNT CHARACTERS IN DEVICE MNEMONIC  REV20100
*
CDEV.WRK DATAD     0
CDEV.CNT RES       1B              DEV MNEMONIC CHAR COUNT     REV20100
*
*  CDEV91 IS USED TO CONSTRUCT THE DEV-TYPE/CHAN/SUBCH WORD    REV20100
*
*  BYTE 0: BIT 0    = CHANNEL PRESENT
*          BITS 1-7 = DEVICE TYPE
*  BYTE 2: BIT 0    = SUBCHANNEL PRESENT
*          BITS 1-7 = CHANNEL
*  BYTE 3: BITS 0-7 = SUBCHANNEL
*
CDEV91   RES       1W
SAVER0   RES       1F
         BOUND     1W
CHARPOS  REZ       1W
BLNKS    REZ       1W              LEADING BLANKS FLAG
         PAGE
CCENT    RES       2D              LEFT JUSTIFIED FILED FROM SCANNER
CCSTRT   RES       1W              START OF CURRENT FILED
CCDLIM   RES       1B              LAST DELIMITTER ENCOUNTERED
CCHRS    RES       1B              NUMBER OF CHARACTERS IN FIELD
CCFLD    RES       1B              NUMBER OF FIELD
MDBUF    RES       1W              ADDRESS OF CURRENT INPUT RECORD
WRTL.RET RES       1W              WRITLIN RETURN ADDRESS
CAS.REGS RES       1F              REG SAVE AREA FOR ASSIGN
INQ.INFO RES       1F              8W FOR M.INQUIRY INFO
         CSECT
         TITLE  ASSIGN COMMANDS
***********************************************************************
*                                                                     *
*                  CASSG                                              *
*                                                                     *
***********************************************************************
*                                                                     *
*        PROCESS GENERAL ASSIGN DIRECTIVE                             *
*                                                                     *
***********************************************************************
CASSG    STF       R0,CAS.REGS     SAVE REGS
*
*  ZERO MAXIMUM SIZE RRS
*
         LI        R6,12           12 WORDS MAX                REV20094
         LA        R3,RRS          START OF NEXT RRS           REV20094
         TRN       R6,R6           NEGATE LOOP COUNTER         REV20094
CASSG.05 ZMW       0W,R3           CLEAR RRS WORD              REV20094
         ABR       R3,29           BUMP POINTER                REV20094
         BIB       R6,CASSG.05     DO NEXT WORD                REV20094
*
         ZMW       CHARPOS         CLEAR PARSER FLAG
*
         LA        R3,RRS          GET RRS ADDR
*
* NOW GET THE MAIN PART OF THE ASSIGN. THIS WILL ALSO DETERMINE
* THE TYPE OF RRS BEING PRODUCED AND THEREFORE THE SPACE
* REQUIREMENT IN THE RRS TABLE.
*
         BL        STRING          GET THE PRIMARY ASSIGN TYPE
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD
         LB        R4,CCDLIM       SEE IF DELIMITER IS '=' .....
         CI        R4,G'='         ..... AND IF SO GO AND  .....
         BEQ       CASSG.5         ..... IDENTIFY THE KEYWORD
*
         CAMW      R6,=C'SYC '     SEE IF SYC
         BEQ       CASS.SYC        BRANCH IF SYC
*
         CAMW      R6,=C'SGO '     SEE IF SGO
         BEQ       CASS.SGO        BRANCH IF SGO
*
         CAMW      R6,=C'SBO '     SEE IF SBO
         BEQ       CASS.SBO        BRANCH IF SBO
*
         CAMW      R6,=C'SLO '     SEE IF SLO
         BEQ       CASS.SLO        BRANCH IF SLO
*
*ISC     CAMW      R6,=C'TEMP'     SEE IF TEMP WITH NO VOLUME
*ISC     BNE       CASSG.6         BRANCH IF NOT                    2104
*ISC     CI        R5,4            4 CHARS ONLY THIS NAME           2104
*ISC     BEQ       CASS.TP5        YES.  DEFINATELY A TEMP ASSIGN   2104
*
* KEYWORD NOT RECOGNIZED SO ASSUME A PATHNAME
*
* THIS FORMS A TYPE 1 RRS WHOS LENGTH IS 4 WORDS PLUS THE NUMBER
* OF WORDS CONSTITUTING THE PATHNAME.
*
CASSG.6  EQU       $
         LW        AP,APSAVE       GET ARG POINTER
         LW        X2,0W,AP       PICK UP PATHNAME ADDRESS
*                                 *** ASSUMED TO BE A WORD ADDRESS
         TRR       X2,X3          MAKE ANOTHER COPY
         LA        R1,PNB1         GET ADDR OF TEMP AREA
PAR.L    EQU       $
         LB        R4,0B,X3       GET PATHNAME CHARACTER
         BEQ       PAR.N          STRING TERMINATOR FOUND, BRANCH
         CI        R4,X'61'        SEE IF L/C
         BLT       PAR.X           BR IF NOT
         CI        R4,X'7A'        SEE IF L/C
         BGT       PAR.X           BR IF NOT
         SUI       R4,X'20'        MAKE U/C
PAR.X    CI        R4,G' '         SEE IF SPACE
         BEQ       PAR.N           TERM IF YES
         STB       R4,0B,R1        PUT IN TEMP BUFFER
         ADI       R1,1B           BUMP ADR
         BIB       X3,PAR.L       TRY NEXT CHARACTER
PAR.N    EQU       $
         SUR       X2,X3          GET PATHNAME LENGTH
         CI        X3,0           SEE IF PATHNAME IS ZERO
         BLE       ERRETURN
         CI        X3,PNLENGTH    COMPARE TO MAXIMUM LENGTH
         BGT       ERRETURN       TOO BIG, RETURN WITH ERROR
         STW       R3,CHARPOS     SET STRING POINTER PAST PATHNAME
         SLL       X3,24          MOVE COUNT LEFT
         LA        R1,PNB1        CONSTRUCT PATHNAME VECTOR WORD
         ORR       X3,R1          PUT IN REGISTER FOR SERVICE
         LW        R4,PNBVCTOR    GET PATHNAME BLOCK VECTOR IN REGISTER
         ZR        R7             NO CNP
         SVC       2,X'2E'        CONVERT PATHNAME TO PATHNAME BLOCK
         LW        AP,APSAVE      RESTORE ARGUMENT POINTER
         TRR       R7,R7          TEST THE RETURN RESULT
         BNE       ERRETURN       DIDNT WORK, RETURN WITH ERROR
         STW       R4,PNBWRDX    SAVE PATHNAME BLOCK VECTOR WORD
         LB        R4,PNBWRDX      GET PATHNAME LENGTH
         TRR       R4,R7           SETUP FOR WORD ADJUSTMENT
         SRL       R7,2            EVALUATE NUMBER OF WORDS
CASS.PA1 ADI       R7,RR.1.SIZ     IN PATHNAME PLUS OVERHEAD
         STW       R7,RRS.SIZE     SAVE FOR RRS POINTER UPDATE LATER
*
* BUILD THE RRS ENTRY
*
         LA        R3,RRS          GET ADDR OF RRS
         LI        R6,RR.PATH      RRS TYPE .....
         STB       R6,RR.TYPE,R3   ..... INTO RRS
*
         STB       R4,RR.PLEN,R3   PATHNAME LENGTH
*
         TRN       R4,R4           LOOP COPYING NAME TO RRS
         TRR       R3,R1           START OF RRS ENTRY
         LA        R2,PNBX         START OF PATHNAME BLOCK
CASS.PA2 LB        R7,0B,R2        NEXT PATHNAME BYTE .....
         STB       R7,RR.NAME1,R1  ..... INTO RRS
         ABR       R1,31           NEXT RRS ENTRY
         ABR       R2,31           NEXT INPUT BYTE
         BIB       R4,CASS.PA2     AND LOOP
*
* ALL DONE, GET ANY OPTIONS AND THEN FINALLY UPDATE THE RRS POINTERS
*
* THE OPTIONS ARE THE SAME AS FOR ASSIGNING TO A TEMPORARY FILE
* SO UTILISE THE SAME CODE
*
         BU        CASS.TP2
*
* CHECK TO SEE IF A VALID KEYWORD.
* IF NOT FOUND IN THE KEYWORD TABLE ASSUME WE ARE ASSIGNING
* TO A PATHNAME BECAUSE '=' COULD APPEAR IN A PATHNAME IN QUOTES.
*
CASSG.5  ZR        R1              INDEX INTO LOCAL KEYWORD TABLE
         LI        R2,-CASSNK1     NUMBER OF KEYWORDS IN TABLE
CASSG.1  CAMD      R6,CASSKEY1,R1  CHECK FOR A MATCH
         BEQ       CASSG.2         BRANCH IF ONE FOUND
         ABR       R1,28           MOVE TO NEXT ENTRY IN TABLE
         BIB       R2,CASSG.1      AND LOOP FOR NEXT
         BU        CASSG.6         NOT THERE, GO TREAT AS PATHNAME
*
* KEYWORD FOUND SO SPLIT TO A SEPARATE ACTION ROUTINE FOR EACH
*
CASSG.2  SRL       R1,1            FORM WORD INDE TO ADDRESS TABLE
         BU        *CASSACT1,R1    AND GO TO EACH ACTION ROUTINE
*
* ASSIGNMENT TO SYC.
*
* BUILD A TYPE 2 RRS WITH BIT 0 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS THE SAME AS FOR ASSIGNMENT TO SGO
* SO UTILISE COMMON CODE.
*
CASS.SYC ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SYC       ..... IN R7
         BU        CASS.SG1        COMMON WITH SGO
*
* ASSIGNMENT TO SGO.
*
* BUILD A TYPE 2 RRS WITH BIT 1 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC.
*
CASS.SGO ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SGO       ..... IN R7
         BU        CASS.SG1        COMMON MERGE POINT
*
* ASSIGNMENT TO SBO.
*
* BUILD A TYPE 2 RRS WITH BIT 3 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC.
*
CASS.SBO ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SBO       ..... IN R7
         BU        CASS.SG1        COMMON MERGE POINT
*
* ASSIGNMENT TO SLO.
*
* BUILD A TYPE 2 RRS WITH BIT 2 SET IN THE OPTION WORD.
* THE CODE FOR THIS IS COMMON WITH ASSIGNMENT TO SYC.
*
CASS.SLO ZR        R7              SET UP OPTION WORD .....
         SBR       R7,RR.SLO       ..... IN R7
CASS.SG1 EQU       $               COMMON SLO/SYC CODE
         LI        R6,RR.2.SIZ     MAKE SURE THERE IS .....
         STB       R6,RR.SIZE,R3   RRS SIZE
         STW       R7,RR.OPTS,R3   OPTION WORD TO RRS
         LI        R6,RR.TEMP      RRS TYPE
         STB       R6,RR.TYPE,R3
*
*        CHECK FOR 'DEVICE=' DIRECTIVE FOR SLO FILES                3206
*
         TBR       R7,RR.SLO       IS IT SLO ?                      3206
         BNS       CASS.SG2        NO, CONTINUE                     3206
         BL        STRING          YES, IS THERE A DEVICE DIRECTIVE 3206
         LB        R4,CCHRS                                         3206
         BZ        CASS.SG2        NO, CONTINUE                     3206
         LB        R4,CCDLIM       GET DELIMITER                    3206
         CI        R4,G'='         IS IT '=' ?                      3206
         BNE       ERRETURN        NO, THEN ERROR                   3206
         CAMW      R6,=C'DEVI'     IS IT DEVICE= ?                  3206
         BNE       ERRETURN        NO, THEN ERROR                   3206
         BL        STRING          GET MNEMONIC                     3206
         LI        R5,29           ERROR CODE                       3206
         CAMW      R7,=C'    '     CHANNEL SPECIFIED ?              3206
         BEQ       ERRETURN        NO, THEN ERROR                   3206
         TRR       R6,R4           SAVE IN R4,R5                    3206
         TRR       R7,R5                                            3206
         BL        CDEV            VALIDATE MNEMONIC                3206
         BS        ERRETURN        BRANCH IF ERROR                  3206
         LI        R6,RR.D.SIZ     GET EXTENDED RRS SIZE            3206
         STB       R6,RR.SIZE,R3   SAVE NEW SIZE IN RRS     3206
         STD       R4,RR.DEV,R3    YES, THEN SAVE DEVICE MNEMONIC   3206
         BU        CASSG.8                                          3206
*
* UPDATE THE RRS TABLE POINTERS
*
* FINALLY MAKE SURE THERE ARE NO OPTIONS ON THE LINE
*
CASS.SG2 LI        R6,RR.2.SIZ     SIZE OF ENTRY (FIXED PART ONLY US3206
*
CASSG.8  BL        STRING          GET OPTION FIELD (IF ANY)
         LB        R5,CCHRS        ANY OPTIONS??
         BNZ       ERRETURN        BRANCH TO ERROR IF ANY OPTIONS
         BU        CASSG.7         COMMON EXIT
         PAGE
*
* ASSIGNMENT TO ANOTHER LFC RECOGNIZED
*
* THE LFC MUST BE BETWEEN 1 AND 3 CHARACTERS.
*
* FORM A TYPE 4 RRS.
*
CASS.LFC EQU       $
         BL        STRING          GET LFC NAME
         LB        R5,CCHRS        NUMBER OF CHARS IN LFC
         BZ        ERRETURN        BRANCH TO ERROR IF NO LFC
         CI        R5,3            CHECK IF < 3 CHARS
         BGT       ERRETURN        BRANCH TO ERROR IF > 3 CHARS
         SRL       R6,8            FORM FIRST WORD OF RRS
*
         LI        R4,RR.4.SIZ     MAKE SURETHERE IS ROOM .....
*
         STW       R6,RR.SFC,R3    LFC INTO RRS
         STB       R4,RR.SIZE,R3   RRS SIZE
         LI        R6,RR.LFC2      RRS TYPE
         STB       R6,RR.TYPE,R3
         LI        R6,RR.4.SIZ     SIZE OF ENTRY IN WORDS
         BU        CASSG.8         UPDATE RRS PTRS AND CHECK NO OPTIONS
         PAGE
*
* ASSIGNMENT TO RID
*
CASS.RID EQU       $
         LI        R4,RR.6.SIZ     MAKE SURE THERE IS ROOM .....
         STW       R4,RRS.SIZE     SAVE FOR COMMON UPDATE LATER
*
         LI        R4,RR.RID       SET UP RRS .....
         STB       R4,RR.TYPE,R3   ..... TYPE
*
         BL        STRING          GET VOLUME NAME
         LB        R5,CCHRS        CHECK BETWEEN 1 AND 16 CHARS .....
         BZ        ERRETURN        ..... ELSE ERROR
         CI        R5,16           .....
         BGT       ERRETURN        ..... AND AGAIN
*
         STD       R6,RR.NAME1,R3  STORE 16 CHAR NAME .....
         LD        R6,CCENT+1D          .....
         STD       R6,RR.NAME1+1D,R3    ..... INTO RRS
*
* LOOP OF 4 OBTAINING BINARY DATE, TIME, BLOCK NUMBER AND RES TYPE
*
         TRR       R3,R2           RRS PTR (GETS UPDATED IN THE LOOP)
         LI        R4,-4           LOOP COUNT
CASS.RD1 BL        STRING          GET NEXT FIELD
         LB        R5,CCHRS        CHECK BETWEEN 1 AND 8 CHARS .....
         BZ        ERRETURN        ..... ELSE ERROR .....
         CI        R5,8            .....
         BGT       ERRETURN        ..... AND AGAIN
         SVC       1,X'29'         CONVERT HEX TO BINARY
         CI        R6,0            CHECK FOR ILLEGAL CHARACTERS .....
         BZ        ERRETURN        ..... AND BRANCH IF FOUND
         STW       R7,RR.DATE,R2   SAVE FIELD IN RRS .....
         ABR       R2,29           ..... AND UPDATE RRS PTR
         BIB       R4,CASS.RD1     LOOP FOR NEXT FIELD
*
* ALL DONE, GO GET OPTIONS
*
         BU        CASS.TP2
         PAGE
*
* ASSIGNMENT TO TEMP
*
* BUILD A TYPE 2 RRS WITH OPTIONAL VOLUME NAME IN PARENTHESES
*
* FORMAT IS:       TEMP[=(VOL)] OPTIONS
*             OR
*                  TEMP OPTIONS
*
* ENTRY POINT CASS.TMP IS USED FOR THE FIRST AND CASS.TP5 FOR
* THE SECOND.
*
CASS.TP5 EQU       $               TEMP [OPTIONS] ENTRY POINT
         LI        R6,RR.2.SIZ     SET UP DEFAULT SIZE .....
         STW       R6,RRS.SIZE     ..... FOR RRS POINTER UPDATES
         BU        CASS.TP3        GO PROCESS OPTIONS
*
CASS.TMP EQU       $               TEMP=(VOL) OPTIONS ENTRY POINT
*
         BL        STRING          GET OPTIONAL VOLUME FIELD
         LB        R5,CCHRS        MUST BE 0 WITH '(' DELIMITER
         BNZ       ERRETURN        BRANCH IF FIELD PRESENT
*
         LB        R4,CCDLIM       MAKE SURE DELIMITER IS '('
         CI        R4,G'('
         BNE       ERRETURN        BRANCH IF FORMAT ERROR
*
         BL        STRING          GET VOLUME NAME
         LB        R5,CCHRS        CHECK FOR VOLUME PRESENT
         BZ        CASS.TP4        BRANCH IF NOT PRESENT
         CI        R5,16
         BGT       ERRETURN        BRANCH IF TOO LARGE
*
         LI        R4,RR.2.SIZ+4   MAKE SURE THERE IS ROOM .....
         BGT       ERRETURN        ..... BRANCH TO ERROR IF NOT
*
         STW       R4,RRS.SIZE     SAVE RRS SIZE FOR UPDATE LATER
*
         STW       R6,RR.NAME1,R3  PUT NAME .....
         STW       R7,RR.NAME1+1W,R3    .....
         LD        R6,CCENT+1D
         STW       R6,RR.NAME1+2W,R3    .....
         STW       R7,RR.NAME1+3W,R3    ..... INTO RRS
*
CASS.TP4 LB        R4,CCDLIM       MAKE SURE DELIMITER .....
         CI        R4,G')'         ..... WAS ')'
         BNE       ERRETURN        BRANCH IF NOT ')'
*
* NOW GO AND SEE IF THERE WERE ANY OPTIONS
*
* SET UP RRS TYPE FIRST OF ALL BECAUSE THE OPTION HANDLING IS
* USED BY OTHER TYPES OF ASSIGN ALSO
*
CASS.TP3 LI        R6,RR.TEMP      RRS TYPE .....
         STB       R6,RR.TYPE,R3   ..... INTO RRS
*
CASS.TP2 BL        STRING          GET ANY OPTIONS
         LB        R5,CCHRS        CHECK FOR NONE .....
         BNZ       CASS.TP1        ..... AND BRANCH IF SOME
*
CASS.TP6 LW        R6,RRS.SIZE     SIZE OF RRS ENTRY
         STB       R6,RR.SIZE,R3   INTO RRS
*
         BU        CASSG.7         COMMON EXIT
*
* THERE IS AN OPTION, CHECK FOR VALIDITY ON THIS ASSIGN
* CC1 IS SET IF IF OPTION IS DETECTED.
* THE RRS WILL HAVE BEEN UPDATED ALREADY.
* NO RETURN IS MADE IF AN ERROR IS DETECTED.
*
CASS.TP1 BL        CAS.OPT1        SEE IF SHARED/ACCESS/BLOCKED .....
         BS        CASS.TP2        ..... BRANCH IF SO
         BL        CAS.OPT2        SEE IF SLO/SBO .....
         BS        CASS.TP2        ..... BRANCH IF SO
         BU        ERRETURN        ELSE ILLEGAL OPTION - ERROR
         PAGE
*
* ASSIGNMENT TO DEVICE
*
CASS.DEV EQU       $
         LI        R4,RR.3.SIZ     MAKE SURE THERE IS .....
         BL        STRING          GET DEVICE ASSIGNMENT .....
         BL        CDEV            ..... AND VALIDATE IT
         BS        ERRETURN        BRANCH IF ERROR             REV20100
*
* ALL IS O.K. SO SET UP RRS ENTRY
*
         STW       R7,RR.DT3,R3    DEVICE TYPE/CHAN/SUB-CHAN WORD
         STB       R4,RR.SIZE,R3   RRS SIZE
*
         LI        R6,RR.DEVC      RRS TYPE .....
         STB       R6,RR.TYPE,R3   ..... INTO RRS
*
* SEE IF ANY OPTIONS
*
CASSG.10 BL        STRING          GET FIRST OPTION STRING
         LB        R5,CCHRS        CHECK FOR NONE .....
         BNZ       CASSG.9         ..... AND BRANCH IF SOME
*
CASSG.11 LI        R6,RR.3.SIZ     UPDATE RRS POINTERS .....
         BU        CASSG.7         AND EXIT
*
* THERE IS AN OPTION, CHECK FOR VALIDITY ON THIS ASSIGN.
* CC1 IS SET IF OPTION IS DETECTED.
* THE RRS WILL HAVE BEEN UPDATED ALREADY.
* NO RETURN IS MADE IF AN ERROR IS DETECTED.
*
CASSG.9  BL        CAS.OPT1        SEE IF SHARED/ACCESS/BLOCKED .....
         BS        CASSG.10        ..... BRANCH IF SO
         BL        CAS.OPT3        SEE IF DENSITY/MULTIVOL/ID .....
         BS        CASSG.10        ..... BRANCH IF SO
         BU        ERRETURN        ELSE AN ILLEGAL OPTION - ERROR
         PAGE
*
* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7
* IS ONE OF THE SET:
*
*                  SIZE   = DECIMAL VALUE
*                  SHARED = Y/N
*                  ACCESS = (R,W,M,U,A)
*                  BLOCKED= Y/N
*
* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY
* AND CC1 IS SET ON EXIT.
*
* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT.
*
* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN
* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER.
*
CAS.OPT1 ZBR       R0,1            CLEAR CC1
         STF       R0,COPT90       SAVE CONTEXT
         LB        R4,CCDLIM       SEE IF '=' WAS DELIMITER
         CI        R4,G'='
         BNE       CAS.1.6         BRANCH TO OPTION NOT FOUND EXIT
*
         CAMW      R6,=C'SIZE'     SEE IF SIZE SPECIFICATION
         BNE       CAS.1.0         BRANCH IF NOT 'SIZE'
*
         BL        STRING          GET SIZE
         SVC       1,X'28'         CONVERT TO BINARY
         TRR       R6,R6           NON DECIMAL CHARACTERS?
         BZ        ERRETURN        YES, ILLEGAL FORMAT
         LB        R6,RR.TYPE,R3   CHECK RRS TYPE
         CI        R6,RR.TEMP      IS THIS A TEMP FILE
         BNE       ERRETURN        NO, ILLEGAL OPTION
         STH       R7,RR.PLEN,R3   ELSE, SAVE THE SIZE
         BU        CAS.1.3         COMMON EXIT
CAS.1.0  EQU       $
         CAMW      R6,=C'SHAR'     SEE IF SHARED OPTION
         BNE       CAS.1.1         BRANCH IF NOT 'SHARED'
*
         BL        STRING          GET 'Y' OR 'N'
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD TO ERROR
         LB        R4,CCENT        GET FIRST CHAR OF FIELD
         CI        R4,G'Y'         'YES' ??
         BNE       CAS.1.2         BRANCH IF NOT 'Y'
         SBM       RR.SHAR,RR.ACCS,R3      SET SHARED BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
CAS.1.2  CI        R4,G'N'         'NO' ??
         BNE       ERRETURN        BRANCH IF NOT 'Y' OR 'N' TO ERROR
         SBM       RR.EXCL,RR.ACCS,R3      SET EXCLUSIVE BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR 'BLOCKED' OPTION
*
CAS.1.1  CAMW      R6,=C'BLOC'     SEE IF BLOCKED OPTION
         BNE       CAS.1.4         BRANCH IF NOT 'BLOCKED'
*
         BL        STRING          GET 'Y' OR 'N'
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD TO ERROR
         LB        R4,CCENT        GET FIRST CHAR OF FIELD
         CI        R4,G'Y'         'YES' ??
         BNE       CAS.1.5         BRANCH IF NOT 'Y'
         SBM       RR.BLK,RR.OPTS,R3       SET BLOCKED BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
CAS.1.5  CI        R4,G'N'         'NO' ??
         BNE       ERRETURN        BRANCH IF NOT 'Y' OR 'N' TO ERROR
         SBM       RR.UNBLK,RR.OPTS,R3     SET UNBLOCKED BIT IN RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR ACCESS OPTION
*
CAS.1.4  CAMW      R6,=C'ACCE'
         BNE       CAS.1.6         OPTION NOT RECOGNIZED EXIT
*
         BL        STRING          GET '('
         LB        R5,CCHRS        SHOULD BE A ZERO COUNT
         BNZ       ERRETURN        BRANCH IF FIELD NOT EMPTY TO ERROR
         LB        R4,CCDLIM       CHECK FOR DELIMITER '('
         CI        R4,G'('
         BNE       ERRETURN        BRANCH IF NOT '(' TO ERROR
*
CAS.1.10 BL        STRING          GET NEXT ACCESS OPTION
         LB        R5,CCHRS        CHECK IF LAST ONE
         BNZ       CAS.1.7         BRANCH IF A FIELD TO LOOK FOR
         LB        R4,CCDLIM       MAKE SURE DELIMITER WAS ')'
         CI        R4,G')'
         BNZ       ERRETURN        BRANCH TO ERROR IF NOT ')'
         BU        CAS.1.3         COMMON EXIT
*
CAS.1.7  ZR        R1              SCAN ACCESS OPTION TABLE
         LI        R2,-CASSNK2     NUMBER OF ENTRIES IN TABLE
         LB        R6,CCENT        GET FIRST CHAR OF OPTION
CAS.1.8  CAMB      R6,CASSKEY2,R1  CHECK FOR A MATCH
         BEQ       CAS.1.9         BRANCH IF A MATCH
         ABR       R1,31           NEXT ENTRY IN TABLE
         BIB       R2,CAS.1.8      ANDLOOP
         BU        ERRETURN        OPTION NOT LEGAL
*
CAS.1.9  SLL       R1,2            WORD INDEX
         EXM       CASSACT2,R1     SET THE APPROPRIATE BIT IN RRS
         LB        R4,CCDLIM       IF DELIMETER WAS ')' .....
         CI        R4,G')'         .....
         BEQ       CAS.1.3         ..... THE EXIT, OPTION FINISHED
         BU        CAS.1.10        ..... LOOP FOR NEXT FIELD
*
* COMMON EXIT TO CALLER WHEN ALL IS O.K.
*
CAS.1.3  SBM       1,COPT90        SET CC1
*
* COMMON EXIT WHEN KEYWORD NOT RECOGNIZED.
*
CAS.1.6  LF        R0,COPT90
         TRSW      R0
         PAGE
*
* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7
* IS ONE OF THE SET:
*
*                  PRINT
*                  PUNCH
*
* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY
* AND CC1 IS SET ON EXIT.
*
* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT.
*
* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN
* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER.
*
CAS.OPT2 ZBR       R0,1            CLEAR CC1
         STF       R0,COPT90       SAVE CONTEXT
         CAMW      R6,=C'PRIN'     SLO ??
         BNE       CAS.2.1         BRANCH IF NOT SLO
         SBM       RR.SLO,RR.OPTS,R3    SET SLO BIT IN RRS
         SBM       RR.SEP,RR.OPTS,R3    SET SEP BIT IN RRS          2111
         BU        CAS.1.3         COMMON EXIT
*
CAS.2.1  CAMW      R6,=C'PUNC'     SBO ??
         BNE       CAS.1.6         KEYWORD NOT RECOGNIZED EXIT
         SBM       RR.SBO,RR.OPTS,R3    SET SBO BIT IN RRS
         SBM       RR.SEP,RR.OPTS,R3    SET SEP BIT IN RRS          2111
         BU        CAS.1.3         COMMON EXIT
         PAGE
*
* THIS ROUTINE CHECKS TO SEE IF THE OPTION KEYWORD IN R6/R7
* IS ONE OF THE SET:
*
*                  DENSITY = N/P/G/800/1600/6250
*                  MULTIV  = NUMBER
*                  ID      = ID
*
* IF SO, THE APPROPRIATE BITS ARE SET IN THE CURRENT RRS ENTRY
* AND CC1 IS SET ON EXIT.
*
* IF A MATCH IS NOT FOUND, CC1 IS RESET ON EXIT.
*
* IF AN ERROR IN FORMAT IS DETECTED, AN ERROR EXIT IS TAKEN
* DIRECTLY, AND NO RETURN IS MADE TO THE CALLER.
*
CAS.OPT3 ZBR       R0,1            CLEAR CC1
         STF       R0,COPT90       SAVE CONTEXT
         LB        R4,CCDLIM       SEE IF '=' WAS DELIMITER
         CI        R4,G'='
         BNE       CAS.1.6         BRANCH TO OPTION NOT FOUND EXIT
*
* CHECK FOR 'DENSITY' OPTION
*
         CAMW      R6,=C'DENS'     SEE IF DENSITY OPTION
         BNE       CAS.3.1         BRANCH IF NOT 'DENSITY'
*
         BL        STRING          GET DENSITY VALUE
         LB        R5,CCHRS        CHECK FOR BLANK FIELD
         BZ        ERRETURN        BRANCH IF BLANK TO ERROR
*
         ZR        R1              SCAN DENSITY OPTION TABLE
         LI        R2,-CASSNK3     NUMBER OF ENTRIES IN TABLE
CAS.3.3  CAMW      R6,CASSKEY3,R1  CHECK FOR A MATCH
         BEQ       CAS.3.4         BRANCH IF A MATCH
         ABR       R1,29           NEXT ENTRY IN TABLE
         BIB       R2,CAS.3.3      AND LOOP
         BU        ERRETURN        OPTION NOT LEGAL
*
CAS.3.4  SRL       R1,2            FORM BYTE INDEX
         LB        R7,CASSACT3,R1  GET DENSITY BIT VALUE AND .....
         STB       R7,RR.DENS,R3   ..... STORE INTO RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR 'MULTIVOL' OPTION
*
CAS.3.1  CAMW      R6,=C'MULT'     SEE IF MULTIVOL OPTION
         BNE       CAS.3.2         BRANCH IF NOT 'MULTIVOL'
*
         BL        STRING          GET VOLUME NUMBER
         LB        R5,CCHRS        CHECK FOR NO FIELD
         BZ        ERRETURN        BRANCH IF BLANK FIELD
         SVC       1,X'28'         CONVERT ASCII DEC TO BINARY
         TRR       R6,R6           CHECK FOR ERROR
         BEQ       ERRETURN        BRANCH IF CONVERSION ERROR
         CI        R7,255          MAKE SURE IT FITS IN A BYTE
         BGT       ERRETURN        BRANCH IF TOO LARGE
         STB       R7,RR.VLNUM,R3  INTO RRS
         BU        CAS.1.3         COMMON EXIT
*
* CHECK FOR 'ID' OPTION
*
CAS.3.2  CAMW      R6,=C'ID  '     SEE IF ID OPTION
         BNE       CAS.1.6         OPTION NOT RECOGNIZED EXIT
*
         BL        STRING          GET ID
         LB        R5,CCHRS        MAKE SURE BETWEEN 1 AND 4 CHAR
         BZ        ERRETURN        BRANC IF BLANK FIELD
         CI        R5,4
         BGT       ERRETURN        BRANCH IF >4 CHARS
         STW       R6,RR.UNFID,R3  ID INTO RRS ENTRY
         BU        CAS.1.3         COMMON EXIT
*
* COMMON EXIT FOR END OF ASSIGN COMMAND
*
CASSG.7  LF        R0,CAS.REGS     GET REGS
         TRSW      R0              RETURN
*
* TABLE FOR RECOGNIZING PRIMARY ASSIGN KEYWORDS
*
CASSKEY1 DATAD     C'LFC     '
         DATAD     C'DEV     '
         DATAD     C'TEMP    '
         DATAD     C'RID     '
CASSNK1  EQU       $-CASSKEY1/1D   NUMBER OF ENTRIES
*
* TABLE OF ACTION ROUTINES FOR PRIMARY KEYWORDS
*
CASSACT1 EQU       $
         ACH       CASS.LFC        LFC=
         ACH       CASS.DEV        DEV=
         ACH       CASS.TMP        TEMP=
         ACH       CASS.RID        RID=
*
* TABLE FOR RECOGNIZING ACCESS RIGHTS KEYBYTES
*
CASSKEY2 DATAB     C'RWMUA'        READ/WRITE/MOD/UPDATE/APPEND
CASSNK2  EQU       $-CASSKEY2      NUMBER OF ENTRIES
         BOUND     1W
CASSACT2 SBM       RR.READ,RR.ACCS,R3
         SBM       RR.WRITE,RR.ACCS,R3
         SBM       RR.MODFY,RR.ACCS,R3
         SBM       RR.UPDAT,RR.ACCS,R3
         SBM       RR.APPND,RR.ACCS,R3
*
* TABLE FOR RECOGNIZING DENSITY KEYWORDS
*
CASSKEY3 DATAW     C'N   '         800
         DATAW     C'P   '         1600
         DATAW     C'G   '         6250
         DATAW     C'800 '         800
         DATAW     C'1600'         1600
         DATAW     C'6250'         6250
CASSNK3  EQU       $-CASSKEY3/1W   NUMBER OF ENTRIES
CASSACT3 DATAB     X'80'           800
         DATAB     X'40'           1600
         DATAB     X'02'           6250
         DATAB     X'80'           800
         DATAB     X'40'           1600
         DATAB     X'02'           6250
         BOUND     1W
*
         PAGE
************************************************************************
*                                                                      *
*                  CDEV                                                *
*                                                                      *
************************************************************************
*                                                                      *
*        PRODUCE A DEVICE-TYPE/CHANNEL/SUB-CHANNEL WORD                *
*        FROM AN INPUT DEVICE MNEMONIC (DEVMNC)                        *
*                                                                      *
*        INPUT:    R6/R7 = DEVMNC GIVEN BY USER                        *
*                                                                      *
*        OUTPUT:   R2 = ADDRESS OF DTT ENTRY FOR DEVICE                *
*                  R7 = DEVICE-TYPE/CHANNEL/SUB-CHANNEL WORD           *
*                                                                      *
*        ERRORS:   RETURN TO USER WITH CC1 SET AND R5 = CCERR          *
*                  MESSAGE ID FOR THE FOLLOWING ERRORS:                *
*                                                              (R5)    *
*                  (1) INPUT DEVMNC IS NOT 2/4/6 CHARS LONG    (29)    *
*                  (2) DEVICE IS NOT IN DTT TABLE              (06)    *
*                  (3) NON HEX CHANNEL/SUB-CHANNEL SPECIFIED   (29)    *
*                  (4) DEVICE NOT CONFIGURED IN SYSTEM         (28)    *
*                                                                      *
*        A RETURN IS NOT MADE TO THE CALLER IF ERROR DETECTED          *
*                                                                      *
************************************************************************
CDEV     STF       R0,CDEV90
         ZBM       1,CDEV90        CLEAR CC1 (ERROR RETURN FLAG)REV20100
         ZMW       CDEV91          TO BUILD OUTPUT R7 IN
*
*  COUNT THE CHARACTERS IN THE DEVICE MNEMONIC                 REV20100
*
         STD       R6,CDEV.WRK     SAVE MNEMONIC               REV20100
         LI        R5,-8           LOOP COUNTER                REV20100
         LA        R3,CDEV.WRK+7B  SCAN FROM END OF MNEMONIC   REV20100
         LI        R4,G' '         SCAN FOR FIRST NON-BLANK    REV20100
CDEV.05  CAMB      R4,0B,R3        BLANK?                      REV20100
         BNE       CDEV.06         NO.  EXIT.                  REV20100
         SUI       R3,1B           BACK TO PREVIOUS CHARACTER  REV20100
         BIB       R5,CDEV.05      CHECK IT.                   REV20100
*
CDEV.06  TRN       R5,R5           R5 HOLDS NON BLANK COUNT    REV20100
         STB       R5,CDEV.CNT     SAVE LOCALLY                REV20100
         LD        R6,CDEV.WRK     RESTORE MNEMONIC TO REGS    REV20100
         CI        R5,2
         BEQ       CDEV.0
         CI        R5,4
         BEQ       CDEV.0
         CI        R5,6
         BEQ       CDEV.0                                      REV20100
         LI        R5,29           INVALID DEVICE SPECIFIED    REV20100
         BU        CDEV.ERR        TAKE ERROR EXIT             REV20100
*
* PROCESS DEVICE MNEMONIC FIRST
*
CDEV.0   TRR       R6,R4
         SRL       R4,16           DEVICE MNEMONIC IN BOTTOM OF R4
         LW        R2,C.DTTA       DEVICE TABLE ADDRESS
         LNB       R5,C.DTTN       TOTAL ENTRIES IN TABLE
CDEV.1   CAMH      R4,3H,R2        LOOK FOR MNEMONIC
         BEQ       CDEV.2          BRANCH IF FOUND
         ABR       R2,28           MOVE TO NEXT ENTRY (2 WORDS)
         BIB       R5,CDEV.1       LOOP FOR NEXT ENTRY
         LI        R5,6            ERROR - INVALID MNEMONIC
         BU        CDEV.ERR        TAKE ERROR RETURN.          REV20100
*
* MNEMONIC FOUND, PROCESS CHANNEL/SUB-CHANNEL IF ANY
*
CDEV.2   STW       R2,CDEV90+2W    RETURN ENTRY ADDRESS TO CALLER
         LB        R5,0B,R2        GET DEVICE TYPE FROM TABLE
         STB       R5,CDEV91       INTO RESULT WORD
         LB        R5,CDEV.CNT     SEE IF ANY CHANNEL/SUB-CHANNEL
         CI        R5,2
         BEQ       CDEV.3          BRANCH IF NO CHAN/SUB-CHAN
         SBM       0,CDEV91        INDICATE CHANNEL PRESENT
*
         SLLD      R6,16           CHANNEL/SUB-CHANNEL INTO R6
         ADI       R7,G'  '        ALL SPACES IN R7
         SVC       1,X'29'         CONVERT CHAN/SUB-CHAN TO HEX
         TRR       R6,R6           CHECK FOR NON HEX DATA
         BNZ       CDEV.25         BRANCH IF CONVERSION OK.    REV20100
         LI        R5,29           INVALID DEVICE SPECIFIED.   REV20100
         BU        CDEV.ERR        TAKE ERROR RETURN           REV20100
*
* SET UP THE LOW HALFWORD OF RESULT TO CONTAIN THE CHANNEL
* NUMBER AND THE SUB-CHANNEL NUMBER, IF ANY.
* THE TOP BIT OF THE CHANNEL NUMBER FIELD IS SET IF A SUB-CHANNEL
* EXISTS.
*
CDEV.25  LB        R5,CDEV.CNT     CHECK FOR SUB-CHANNEL
         CI        R5,6
         BNE       CDEV.4          BRANCH IF CHANNEL ONLY
         SBR       R7,16           SET SUB-CHANNEL PRESENT BIT
         BU        CDEV.5          COMMON EXIT
CDEV.4   SLL       R7,8            CHANNEL NUMBER TO TOP BYTE OF .....
*                                  ..... HALFWORD
CDEV.5   STH       R7,CDEV91+1H    STORE IN RESULT
*
*  VERIFY DEVICE CONFIGURED ON SYSTEM                          REV20091
*
CDEV.3   ZR        R4              CLEAR COMPARE MASK REGISTER REV20100
*
*  IF DEVICE TYPE CODE IS A GENERIC (DC, MT, CD) THEN COMPARE
*  MASK WILL BE BUILT TO IGNORE DTC IN UDT.
*
         LB        R7,CDEV91       CHECK THE DTC FOR GENERIC   REV20100
         ZBR       R7,24           REMOVE CHAN FLAG IF PRESENT REV20100
         CI        R7,X'01'        DC?                         REV20100
         BEQ       CDEV.302        YES.  MASK = 0              REV20100
         CI        R7,X'04'        MT?                         REV20100
         BEQ       CDEV.302        YES.                        REV20100
         CI        R7,X'07'        CD?                         REV20100
         BEQ       CDEV.302        YES.                        REV20100
         LW        R4,=X'007F0000' SET MASK TO CHECK DTC       REV20100
*
*  MASK IS NOW SET FOR DTC.  PROCEED WITH CHAN AND SUBCH
*
CDEV.302 TBM       0,CDEV91        CHANNEL SPECIFIED?          REV20100
         BNS       CDEV.31         NO.  CHECK DTC ONLY.        REV20100
         ADI       R4,X'7F00'      ADD MASK FOR CHANNEL        REV20100
         TBM       16,CDEV91       SUB CHAN SPECIFIED?         REV20091
         BNS       CDEV.31         NO.  VERIFY CHAN ONLY       REV20091
         ADI       R4,X'00FF'      ADD MASK FOR SUBCHANNEL     REV20100
*
*  LOOP THRU UDT'S FOR SPECIFIED DEVICE                        REV20091
*
CDEV.31  LW        R1,C.UDTA       START OF UDT'S              REV20091
         LNH       R5,C.UDTN       NEG NUMBER OF UDT'S         REV20091
         LB        R7,CDEV91       DTC TO R7                   REV20100
         SLL       R7,16           TO BYTE 1 FOR UDT COMPARE   REV20100
         ORMH      R7,CDEV91+1H    OR IN CHANNEL AND SUBCH     REV20100
*
CDEV.32  CMMW      R7,UDT.STAT,X1  DEVICE MATCH?               REV20091
         BEQ       CDEV.33         YES.                        REV20091
         ADI       R1,UDT.SIZE     BUMP X1 TO NEXT UDT         REV20091
         BIB       R5,CDEV.32      AND COMPARE IF MORE         REV20091
*
         LI        R5,28           DEVICE NOT CONFIGURED       REV20091
*
*  CDEV.ERR - TAKE ERROR RETURN TO CALLER.
*  SET CC1, RETURN WITH R5 = CCERR MESSAGE INDEX               REV20100
*
CDEV.ERR SBM       1,CDEV90        SET CC1 BIT IN R0           REV20100
         STW       R5,CDEV90+5W    SAVE R5 FOR LOAD FILE       REV20100
*
CDEV.33  LF        R0,CDEV90
         LW        R7,CDEV91       RETURN TYPE/CHAN/SUB-CHAN WORD
         TRSW      R0
         PAGE
************************************************************************
*                                                                      *
*        STRING  - SYNTAX SCANNER FOR CATALOGER COMPATABILITY          *
*                                                                      *
************************************************************************
*
STRING   EQU       $
         STF       R0,SAVER0       SAVE GPRS
         LW        AP,APSAVE       GET ARG POINTER
         LD        R6,BLANKS       GET SOME BLANKS
         STD       R6,CCENT        CLEAR TOKEN AREA
         STD       R6,CCENT+1D
         LI        R7,16B          TOKEN BUFFER LENGTH
         LW        R1,0W,AP        GET LINE BUFFER ADDR
         LA        R6,CCENT        PICK UP TOKEN BUFFER ADDRESS
SCANNER  TRR       R1,R0           SAVE LINEBUFFER ADDRESS
         LI        R4,CR           DUMMY TERMINATOR FOR E.O.B   24OCT80A
         ZR        R5              STRING COUNTER FLAG
         TRR       R1,R2           SET UP BUFFER INDEX
         BZ        STR.3           DO NOTHING
         ZBM       31,BLNKS        CLEAR BLANKS ACTIVE FLAG
         TRR       R6,R3           SET UP OUTPUT ADDRESS
         ZBR       R3,12           CLEAR F BIT
         LW        R6,CHARPOS      GET CHARPOS
         BNE       STRING0         INITIALIZED, SKIP AHEAD
         ZMW       CHARPOS         INITIALIZE CHAR POINTER
STRING0  LI        R6,-2047        GET NEGATIVE LENGTH OF LBUF  01JAN81A
         ADMW      R6,CHARPOS      COMPUTE NEG REMAINING BYTE COUNT
         BGE       STRING4         DONE ...
         ADMW      R2,CHARPOS      ADD CURSOR POSITION
STRING1  LI        R1,0
         LB        R4,0B,R2        GET BYTE FROM LINE BUFFER
         BZ        STRING4         IF EOL, DONE
         CI        R4,X'61'        SEE IF L/C
         BLT       STRING1A        BR IF NOT
         CI        R4,X'7A'        SEE IF L/C
         BGT       STRING1A        BR IF NOT
         SUI       R4,X'20'        MAKE U/C
STRING1A EQU       $
         CAMB      R4,DELIMS,R1    CHECK AGAINST KNOWN DELIMS
         BNE       STRING1B        OK
         SLL       R1,2            WORD ALIGN INDEX
         BU        *ACTIONS,R1     DISPATCH ROUTINE
STRING1B EQU       $
         ADI       R1,1
         CI        R1,DELIM#       AT END
         BLT       STRING1A        NOT YET
STRING1C CAR       R7,R5           AMASSED ENTIRE STRING YET
         BGE       NEXTCHAR        YES
         STB       R4,0B,R3        MOVE TO WORK BUFFER
         SBM       31,BLNKS        SET BLANKS NO LONGER ACTIVE FLAG
         ABR       R2,31           INPUT STRING BYTE ADDRESS
         ABR       R3,31           OUTPUT STRING BYTE ADDRESS
         ABR       R5,31           BUMP THIS STRING COUNTER
NEXTCHAR BIB       R6,STRING1      SCAN TILL E.O.B.
STRING2  EQU       $
         TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER
         ADI       R2,1B           BUMP PAST DELIMITER
         SUR       R1,R2           DISTANCE TRAVELED
STR.2    STW       R2,CHARPOS      AND SAVE AS CURSOR NOW
STR.3    STB       R4,CCDLIM       REMEMBER CURRENT DELIMITTER
         STB       R5,CCHRS        REMEMBER FIELD SIZE
         LD        R6,CCENT        GET FIRST 8 CHAR OF TOKEN
         LD        R0,SAVER0       RESTORE R0, R1
         LD        R2,SAVER0+1D    RESTORE R2, R3
         LW        R4,SAVER0+2D    POP R4
         TRSW      R0              RETURN
*
*
*        SKIP LEADING BLANKS
*
STRING3  EQU       $
         TBM       31,BLNKS        ARE WE TRAVELING ACROSS LEAD BLANKS ?
         BS        STRING2         NOPE-> THATS A DELIMITER
         ADI       R2,1B           YES--> BUMP OVER THEM
         BIB       R6,STRING1      KEEP SCANNING TIL EOB
         BU        STRING2         DONE AT EOB
*
STRING4  TRR       R0,R1           RESTORE ADDRESS OF LINEBUFFER
         LI        R2,2047         FORCE END OF MEDIUM FOR NEXT CALL
         BU        STR.2           TAKE NORMAL RETURN
*
STRING6  EQU       $
         TRR       R0,R1           RESTORE LINEBUFFER ADDRESS
         LB        R1,CHARPOS      GET INITIAL CURSOR POSITION
         CI        R1,5W           IS THIS THE FIRST FIELD
         BEQ       STRING5         IF SO, TREAT LIKE DOLLAR SIGN
         BU        STRING4         ELSE, TREAT AS END OF LINE
*
STRING5  CI        R5,0            FIRST CHARACTER IN FIELD
         BNZ       STRING1C        NO
         STB       R4,0B,R3        SAVE THIS CHARACTER
         ABR       R5,31           BUMP CHARACTERS IN FIELD
         BU        STRING2         COMMON EXIT
         PAGE
*
BLANKS   DATAD     C'        '     BLANKS
*
*        DELIMITER WIDGETS
*
         BOUND     1W
DELIMS   EQU       $
         DATAB     X'20'           00 - BLANK CHAR
         DATAB     C','            02 - COMMAN CHAR
         DATAB     CR              04 - CARRAIGE RETURN
         DATAB     C'='            03 - EQUAL SIGN
         DATAB     NEWLINE         05 - NEW LINE
         DATAB     C'('            06 - LEFT PAREN
         DATAB     C')'            07 - RIGHT PAREN
         DATAB     C'";'           08 - SEMI-COLON
         DATAB     C'!'            09 - EXCLAMATION POINT
         DATAB     C'"%'           10 - PERCENT
         DATAB     C'$'            11 - DOLLAR SIGN
DELIM#   EQU       $-DELIMS        COUNT IN TABLE
         BOUND     1W
*
*        ROUTINES TO HANDLER ABOVE DELIMITERS
*
ACTIONS  EQU       $
         ACH       STRING3         00 - BLANKS
         ACH       STRING2         02 - COMMAS
         ACH       STRING4         04 - CARRAIGE RETURNS
         ACH       STRING2         03 - EQUAL SIGNS
         ACH       STRING2         05 - NEW LINES
         ACH       STRING2         06 - LEFT PAREN
         ACH       STRING2         07 - RIGHT PAREN
         ACH       STRING2         08 - SEMI-COLON
         ACH       STRING6         09 - EXCLAMATION POINT
         ACH       STRING2         10 - PERCENT
         ACH       STRING5         11 - DOLLAR SIGN
************************************************************************
         TITLE     RECORD MANAGER
         LIST      ON,MAC,NODATA
         SPACE     2
************************************************************************
*
*  RECORD MANAGER PROVIDES MULTIPLE BLOCK BUFFERING IN AN EFFORT TO
*  REDUCE I/O OVERHEAD AND IMPROVE CPU UTILIZATION.
*
*  RECORD MANAGER PROVIDES SIMULATION OF THE IOCS SUPEVISOR CALLS AT THE
*  USER LEVEL.  THE SVC SPECIFICATIONS MAY BE TAKEN AS A SPECIFICATION
*  FOR THE CORRESPONDING RECORD MANAGER ENTRY.
*
*  THE SIMULATED BLOCKED I/O SERVICES INCLUDE:
*        MACRO               SVC                 RECORD MANAGER ENTRY
*        M.FILE              SVC 1,X'30'         BL  RM.OPEN
*        M.CLSE              SVC 1,X'39'         BL  RM.CLSE
*        M.READ              SVC 1,X'31'         BL  RM.READ
*        M.WRIT              SVC 1,X'32'         BL  RM.WRIT
*        M.RWND              SVC 1,X'37'         BL  RM.RWND
*        M.BACK              SVC 1,X'35'         BL  RM.BACK
*        M.ADVF              SVC 1,X'34'         BL  RM.ADVF
*        M.ADVR              SVC 1,X'33'         BL  RM.ADVR
*        M.WEOF              SVC 1,X'38'         BL  RM.WEOF
*
*
*  CODING CONVENTIONS:
*  RECORD MANAGER ROUTINES ARE CODED WITH TWO LETTER IDENTIFIERS
*  WHICH PREFIX THE ROUTINE NAME.  THEY ARE:
*
*        RM.NAME             USER ENTRY POINTS
*        BF.NAME             BUFFER MANAGEMENT
*        PL.NAME             POOL MANAGEMENT
*        FL.NAME             FILE MANAGEMENT
*        IT.NAME             INTERNAL UTILITIES
*
*  THROUGHOUT THE ENTIRE BODY OF CODE IT IS ASSUMED THAT ALL REGISTERS
*  MAY BE DESTROYED IN A CALLING SEQUENCE EXCEPT REGISTERS R1 AND R2.
*  THESE REGISTERS CONTAIN:
*        R1 = ADDRESS OF THE USER'S FCB
*        R2 = ADDRESS OF THE CURRENT INPUT / OUTPUT CONTEXT BLOCK
*
*  THE DESCRIPTION OF THE REMAINDER OF THE CODE IS LEFT TO THE COMMENTS
*  WITHIN THE CODE BODY WHICH ARE NEVER ENOUGH BUT HOPEFULLY SUFFICENT.
*
************************************************************************
         SPACE     2
************************************************************************
*  PROGRAM ENTRY POINTS
************************************************************************
*        DEF       RM.OPEN
*        DEF       RM.CLSE
*        DEF       RM.READ
*        DEF       RM.WRIT
*        DEF       RM.ADVF
*        DEF       RM.ADVR
*        DEF       RM.RWND
*        DEF       RM.BACK
*        M.REQS
************************************************************************
*  PROGRAM LIMIT EQUATES
************************************************************************
         SPACE     2
BLKMAX   EQU       10              # BUFFERED BLOCKS PER LFC  JBJB
IOCMAX   EQU       7               # I/O CONTEXT BLOCKS ASSEMBLED
WPB      EQU       192             # WORDS PER BLOCK
BLKSIZ   EQU       WPB*4           # BYTES PER BLOCK
         SPACE     2
************************************************************************
*  INPUT OUTPUT CONTEXT BLOCK EQUATES
************************************************************************
IOC.FCB  EQU       0               FILE CONTROL BLOCK
IOC.CBN  EQU       IOC.FCB+16W     CURRENT BUFFER NUMBER
IOC.CBA  EQU       IOC.CBN+1W      CURRENT BUFFER ADDRESS
IOC.NAB  EQU       IOC.CBA+1W      NUMBER OF ACTIVE BUFFERS
IOC.RCBA EQU       IOC.NAB+1W      RECORD CONTROL BLOCK POINTER
IOC.CPP  EQU       IOC.RCBA+1W     CURRENT POOL POSITION
IOC.CFP  EQU       IOC.CPP+1W      CURRENT FILE POSITION
IOC.FLAG EQU       IOC.CFP+1W      IOC BIT FLAGS
IOC.BCNT EQU       IOC.FLAG+1W     COMPRESSED RECORD CURRENT COUNT
IOC.BPTR EQU       IOC.BCNT+1W     COMPRESSED RECORD POINTER
IOC.BUF  EQU       IOC.BPTR+1W     START OF CONTIGUOUS BUFFERS
IOC.CNP  EQU       IOC.BUF         CNP USES BUF AREA AT OPEN
IOC.SIZE EQU       BLKSIZ*BLKMAX+IOC.BUF  SIZE OF IOC BLOCK
         SPACE     2
************************************************************************
*  RECORD CONTROL BYTE EQUATES
************************************************************************
RCB.EOF  EQU       0               END OF FILE
RCB.BOB  EQU       1               BEGINNING OF BLOCK
RCB.EOB  EQU       2               END OF BLOCK
*
RCB.SBLR EQU       0B              STATUS BYTE LAST RECORD
RCB.BCLR EQU       1B              BYTE COUNT LAST RECORD
RCB.SBTR EQU       2B              STATUS BYTE THIS RECORD
RCB.BCTR EQU       3B              BYTE COUNT THIS RECORD
         PAGE
************************************************************************
*  RECORD MANAGER LAST OPERATION FLAG BYTE EQUATES
************************************************************************
OPENOP   EQU       0               OPEN FLAG
WRITOP   EQU       1               LAST OPERATION WRITE
OUTAOP   EQU       2               OUTPUT ACTIVE FLAG
COMPOP   EQU       3               IF SET, TESTED FOR COMPRESSED FILE
CMPFLG   EQU       4               IF SET, COMPRESSED FILE BEING READ
************************************************************************
*  INPUT OUTPUT CONTEXT BLOCKS
************************************************************************
         DSECT
IOCTOTL  DATAW     IOC.SIZE*IOCMAX CONTIGUOUS IOC BLOCK SIZE TOTAL
IOCBASE  DATAW     0               BASE ADDR OF BUFFERS
         SPACE     2
************************************************************************
*  REGISTER SAVE AREA
************************************************************************
REGS     RES       1F
ERR.CODE EQU       REGS+7W         ERROR RETURN CODE
RAW.NWB  RES       256
         CSECT
         PAGE
*
*  RECORD MANAGER MACROS
*
EQTY     DEFM      EREG,FREG       GET TRANSFER QUANITY FROM FCB
         TBM       6,FCB.GCFG,%FREG
         BNS       %SHORT          BRANCH IF SHORT FCB
         LW        %EREG,FCB.EQTY,%FREG
         BU        %OUT
*
%SHORT   LW        %EREG,FCB.TCW,%FREG
         SRL       %EREG,20
%OUT     EQU       $
         ENDM
*
ERWA     DEFM      EREG,FREG       GET TRANSFER QUANITY FROM FCB
         TBM       6,FCB.GCFG,%FREG
         BNS       %SHORT          BRANCH IF SHORT FCB
         LW        %EREG,FCB.ERWA,%FREG
         BU        %OUT
*
%SHORT   LW        %EREG,FCB.TCW,%FREG
         SLL       %EREG,13
         SRL       %EREG,13        STRIP OFF COUNT AND F BIT
%OUT     EQU       $
         ENDM
         PAGE
************************************************************************
*  RM.OPEN
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.OPEN  STF       R0,REGS         SAVE USER REGISTERS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         EXTABLISH IOC FOR THIS LFC
         TBM       OPENOP,IOC.FLAG,X2   FLAG OPENED
         BS        RM.OPXIT        EXIT IF OPENED ALREADY
         BL        OPEN            GO OPEN
RM.OPXIT LF        R0,REGS         RESTORE REGISTERS
         TRSW      R0              RETURN
         SPACE     2
OPEN     STW       R0,OPENXIT      SAVE RETURN ADDR
         SBM       OPENOP,IOC.FLAG,X2  TAG IOC AS OPENED
         ZMW       IOC.CNP,X2      ZERO THE CNP
         ZMW       IOC.CNP+1W,X2
         ZMW       IOC.CNP+2W,X2
         ZMW       IOC.CNP+3W,X2
         ZMW       IOC.CNP+4W,X2
         ZMW       IOC.CNP+5W,X2
         LI        R7,1            READ MODE
         TBR       R1,1            R/W OPEN?
         BNS       OPEN.01         NO
*        LI        R7,2            WRITE MODE          AS17
         LI        R7,4            MODIFY MODE
OPEN.01  STB       R7,IOC.CNP+2W,X2  SET ACCESS MODE
         SBM       2,IOC.CNP+2W+1B,X2  SET OPEN UNBLOCKED
         SBM       4,IOC.CNP+2W+1B,R2  SET RESOURCE DATA BLOCKED AS17
         LA        R7,IOC.CNP,X2   R7 = A(CNP)
         XCR       R1,R2           R1 = A(IOC FCB)
         SVC       2,X'42'         OPEN RESOURCE
         BS        OPEN.ER         ERROR ON OPEN
         XCR       R1,R2
         BU        *OPENXIT
OPEN.ER  XCR       R1,R2           R2 = A(IOC)
         BU        ABRT13          ERROR ON OPEN
         DSECT
OPENXIT  RES       1W              RETURN ADDRESS
         CSECT
*
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
*
         SPACE     3
************************************************************************
*  RM.CLSE
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.CLSE  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         TBM       OPENOP,IOC.FLAG,X2  OPENED?
         BNS       RM.CL02         NO.
         ZBM       WRITOP,IOC.FLAG,X2  LAST OPERATION WRITE?
         BNS       RM.CL01         NO.
************************************************************************
*  WRITE EOF BEFORE REWIND
************************************************************************
         BL        IR.WEOF         WRITE END OF FILE
RM.CL01  ZBM       OUTAOP,IOC.FLAG,X2  POOL OUTPUT ACTIVE?
         BNS       RM.CL02         NO.
         BL        PL.WRIT         PURGE POOL BEFORE CLOSE
RM.CL02  TRR       R2,R1           R1 = A(IOC FCB)
         SVC       1,X'39'         CLOSE THE FILE
         ZMW       FCB.LFC,X2      DEACTIVATE IOC BLOCK
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.RWND - LOGICALLY REWIND FILE
************************************************************************
RM.RWND  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT
         TBM       OPENOP,IOC.FLAG,X2  OPENED?
         BS        RM.RW01         YES.
         BL        OPEN            IMPLICIT OPEN
         BU        RM.RW03
RM.RW01  ZBM       WRITOP,IOC.FLAG,X2  WAS LAST OPERATION WRITE?
         BNS       RM.RW02         NO.
************************************************************************
*  WRITE END OF FILE AFTER LAST WRITE OPERATION BEFORE REWIND
************************************************************************
         BL        IR.WEOF
RM.RW02  BL        BF.RWND
         LW        R3,IOC.CPP,X2   BUFFER POOL FILLED ?
         BZ        RM.RW03         NO.  ALL GONE.
         LW        R3,IOC.CBA,X2   SET A (RCB) TO BEG OF FILE
         LA        R3,1W,X3
         STW       R3,IOC.RCBA,X2
RM.RW03  ZBM       6,FCB.SFLG,X1   CLEAR POSSIBLE EOF IN FCB
         LF        R0,REGS
         TRSW      R0
         SPACE     2
************************************************************************
*  RM.WEOF - WRITE END OF FILE
************************************************************************
RM.WEOF  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         ESTABLISH IOC
         TBM       OPENOP,IOC.FLAG,X2  OPENED?
         BS        RM.WE01         YES.
         BL        OPEN            IMPLICIT OPEN
RM.WE01  BL        IR.WEOF         WRITE END OF FILE.
         SBM       WRITOP,IOC.FLAG,X2  FLAG WRITE LAST OP
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.BKKSP - BACKSPACE RECORD
************************************************************************
RM.BACK  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT
         TBM       OPENOP,IOC.FLAG,X2
         BS        RM.BK00         NOT OPENED YET.
         BL        OPEN
         BU        RM.BKXIT        RETURN
*
RM.BK00  TBM       WRITOP,IOC.FLAGS,X2  WAS WRITE LAST OP?
         BNS       RM.BK01         NO.  DON'T WORRY ABOUT IT.
*
         BL        IR.WEOF         WRITE EOF BEFORE BACKSPACE
         LW        R3,IOC.RCBA,X2  BACK OVER
         SUI       R3,4B           THE
         STW       R3,IOC.RCBA,X2  EOF.
*
RM.BK01  LW        R3,IOC.CPP,X2   POOL EMPTY?
         BZ        RM.BKXIT        YES.  RETURN.  (BOF ALREADY)
*
         LW        R3,IOC.RCBA,X2
         TBM       RCB.EOF,RCB.SBLR,X3  HAVE WE A EOF TO BACKSPACE OVER?
         BS        RM.BKXIT        NO-OP IF EOF.
         TBM       RCB.BOB,RCB.SBLR,X3  IS THIS A BOB?
         BNS       RM.BK03         NO.  PREV RECRD IN THIS BLK.
*
         LI        R3,1
         CAMW      R3,IOC.CBN,X2   FIRST BLOCK IN POOL?
         BLT       RM.BK02         NO.
         CAMW      R3,IOC.CPP,X2   FIRST POOL IN FILE?
         BGE       RM.BKXIT        NO - OP IF BOF
*
RM.BK02  BL        BF.REDB         READ PREVIOUS BUFFER
         LW        R3,IOC.CBA,X2
         ADMW      R3,0W,X3        CALCULATE A(RCB)
*
*  NOW BACKSPACE TO PREVIOUS RECORD IN THIS BLOCK
*
RM.BK03  SUMB      R3,RCB.BCLR,X3  SUBTRACT PREVIOUS RECORD LENGTH
         SUI       R3,4B           SUBTRACT PREVIOUS RCB LENGTH
         STW       R3,IOC.RCBA,X2
RM.BKXIT ZBM       WRITOP,IOC.FLAG,X2 WRITE ISN'T LAST OP
         ZBM       6,FCB.SFLG,X1   NOT EOF ANYMORE FOR USER
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.READ
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.READ  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         STW       R2,IOCA         SAVE IOCA
         TBM       WRITOP,IOC.FLAG,X2   WAS LAST OPERATION WRITE?
         BS        ABRT9           READ NOT ALLOWED AFTER WRITE.
         TBM       OPENOP,IOC.FLAGS,X2  FILE OPENED YET
         BS        RM.RE00         YES
************************************************************************
*  DO IMPLICIT OPEN ON FILE
************************************************************************
         BL        OPEN            GO OPEN
*
RM.RE00  LW        R3,IOC.CPP,X2   ANY DATA IN POOL?
         BNZ       RM.RE01         YES.
************************************************************************
*  READ FROM FILE
************************************************************************
         BL        BF.REDF         READ IN A BLOCK
         LW        R3,IOC.CBA,X2   GET BUFFER ADDRESS
         LA        R3,1W,X3        CALCULATE RCB ADDRESS
         STW       R3,IOC.RCBA,X2  UPDATE RCB POINTER
         SBM       COMPOP,IOC.FLAG,X2  TESTED FOR COMPR FILE YET?
         BS        RM.RE01         BR IF WE HAVE
         LB        R7,4B,X3        GET FIRST DATA BYTE
         CI        R7,X'BF'        IS IT COMPRESSED
         BNE       RM.RE01         BR IF NOT
         SBM       CMPFLG,IOC.FLAG,X2  SET COMPRESSED FILE HERE
         ZMW       IOC.BCNT,X2         NO CHARS LEFT
RM.RE01  ERWA      R5,X1           GET USERS BUFFER ADDRESS
         STW       R5,BUFFER       SAVE LOCALLY
         ZMW       BYTECNT         COUNT OF BYTES TO CALLER
         TBM       CMPFLG,IOC.FLAG,X2 ARE WE READING COMPRESSED FILE
         BNS       RM.RE18         BR IF WE ARE NOT
         LW        R4,IOC.BCNT,X2  ANY COUNT LEFT
         BNZ       RM.RE07         BR IF NOT FINISHED
RM.RE18  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         TBM       RCB.EOB,RCB.SBLR,X3   IS THIS THE END OF THIS BLOCK?
         BNS       RM.RE02  NOT END OF BLOCK
************************************************************************
*  END OF BLOCK.  GET NEXT BLOCK
************************************************************************
         BL        BF.REDF         GO GET NEXT BLOCK
         LW        R3,IOC.CBA,X2  R3 = CURRENT BUFFER ADDR
         ADI       R3,1W           R3 = A(RCB)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDR
************************************************************************
*  TEST FOR END OF FILE
************************************************************************
RM.RE02  TBM       RCB.EOF,RCB.SBTR,X3  IS THIS END OF FILE?
         BS        RM.RE05         YES.  GO TELL THE FCB.
         TBM       CMPFLG,IOC.FLAG,X2   READING COMPRESSED
         BNS       RM.RE09         BR IF NOT
RM.RE11  LB        R4,4B,X3        GET FIRST DATA BYTE
         ZBR       R4,26           CLEAR BIT FOR TEST
         CI        R4,X'9F'        IS THIS COMPRESSED RECORD
         BNE       RM.RE05         ASSUME EOF IF NOT, ERROR
         TRR       R3,R4           COPY BUFFER ADDR
         ADI       R4,10B          POINT TO START OF DATA
         STW       R4,IOC.BPTR,X2  SAVE CURRENT DATA POINTER
         LNB       R4,5B,X3        GET NEGATIVE BYTES THIS RECORD
         STW       R4,IOC.BCNT,X2  SAVE REMAINING COUNT
RM.RE06  LW        R4,IOC.BCNT,X2  GET REMAINING COUNT
         BNZ       RM.RE07         CONTINUE WITH LINE
RM.RE10  LW        R2,IOCA         ADDR OF IOC
         LW        R3,IOC.RCBA,X2  ADDR OF RCB
         ADMB      R3,RCB.BCTR,X3  ADD RECORD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         BU        RM.RE18         GO GET NEXT RECORD
RM.RE07  LW        R3,IOC.BPTR,X2  GET CURRENT POINTER
         LW        R2,BUFFER       GET CALLERS BUFFER ADDRESS
RM.RE20  LB        R6,0B,X3        GET NUMBER OF BLANKS
         BZ        RM.RE22         BR IF NON
         CI        R6,X'FF'        EOL RECORD?
         BEQ       RM.RE60         TRANSFER DONE, EXIT
         TRN       R6,R6           SET BLANK COUNT
         LI        R7,X'20'        GET A BLANK
RM.RE19  STB       R7,0B,X2        PUT IN CALLERS BUFFER
         ABM       31,BYTECNT      BUMP NUM OF BYTES OUT
         ADI       R2,1B           NEXT OUTPUT LOC
         BIB       R6,RM.RE19      PUT OUT BLANKS
RM.RE22  ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         BZ        RM.RE40         IF NON LEFT GET NEXT RECORD
         LB        R6,0B,X3        GET NUMBER OF DATA BYTES
         BZ        RM.RE24         BR IF NON
         ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         TRN       R6,R6           MAKE LOOP COUNTER
RM.RE21  LB        R7,0B,X3        GET DATA BYTE
         STB       R7,0B,X2        PUT IN USER BUFFER
         ABM       31,BYTECNT      BUMP NUM OF BYTES OUT
         ADI       R2,1B           NEXT OUTPUT LOC
         ADI       R3,1B           NEXT RECORD BYTE
         ADI       R4,1B           REDUCE COUNT
         BIB       R6,RM.RE21      LOOP FOR ALL DATA
         TRR       R4,R4           SEE IF DATA LEFT
         BNZ       RM.RE20         GO DO NEXT COMPRESSED RECORD
RM.RE40  STW       R2,BUFFER       SAVE CURRENT OUTPUT BUFFER
         BU        RM.RE10         GO READ NEXT RECORD
RM.RE24  ADI       R3,1B           NEXT RECORD LOC
         ADI       R4,1B           REDICE COUNT
         BZ        RM.RE40         GO GET NEXT RECORD
         BU        RM.RE20         GO DO NEXT RECORD
RM.RE60  ADI       R3,1B           NEXT RECORD BYTE
         LW        R2,IOCA         ADDR OF IOC
         ADI       R4,1B           REDUCE COUNT
         BNZ       RM.RE61         BR IF STILL SOME LEFT
         LW        R3,IOC.RCBA,X2  ADDR OF RCB
         ADMB      R3,RCB.BCTR,X3  ADD RECORD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         ADI       R3,10B          POINT TO START OF DATA
RM.RE61  LW        R6,BYTECNT      GET NUMBER OF BYTES COPIED
         STW       R6,FCB.RECL,X1  TELL USER WHAT HE GOT
         STW       R4,IOC.BCNT,X2  SAVE COUNTER
         STW       R3,IOC.BPTR,X2  SAVE CURRENT POINTER
         LF        R0,REGS
         TRSW      R0              EXIT
************************************************************************
*  TRANSFER RECORD TO USER
************************************************************************
RM.RE09  LB        R6,RCB.BCTR,X3  R6 = SOURCE BYTE COUNT
         EQTY      R5,X1           R5 = TARGET COUNT
         TRR       R5,R7           R7 = TARGET COUNT
         SUR       R6,R7           R7 = TAR CNT - SOR CNT = FILL COUNT
         BLE       RM.RE03         NO FILL NEEDED.  USE TARGET COUNT.
         TRR       R6,R5           R5 = SOURCE COUNT
RM.RE03  STW       R5,FCB.RECL,X1  TELL USER WHAT HE GOT
         ADI       R3,1W           R3 = A(SOURCE)
         ERWA      R2,X1           R2 = A(TARGET)
         BL        IR.CPPY
         TRR       R7,R5           R5 = FILL COUNT
         BLE       RM.RE04         NO FILL NEEDED
         LI        R6,C' '         R6 = FILL CHARACTER
*JCB*    BL        IR.FILL
************************************************************************
*  POST TRANSFER UPDATE TO NEXT RECORD
************************************************************************
RM.RE04  LW        R2,IOCA         R2 = A(IOC)
         LW        R3,IOC.RCBA,X2  R2 = A(RCB)
         ADMB      R3,RCB.BCTR,X3  ADD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         LF        R0,REGS
         TRSW      R0
         DSECT
IOCA     RES       1W
BUFFER   RES       1W
BYTECNT  RES       1W              TRANSFER CNT TO CALLER
         CSECT
************************************************************************
*  RM.RE05
*  ENTER:  R1 = A(FCB)
*  RETURN END OF FILE STATUS IN FCB
************************************************************************
RM.RE05  SBM       6,FCB.SFLG,X1   SET EOF
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.ADVR
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.ADVR  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         STW       R2,IOCA         SAVE IOCA
         TBM       WRITOP,IOC.FLAG,X2   WAS LAST OPERATION WRITE?
         BS        ABRT9           ADVR NOT ALLOWED AFTER WRITE.
         TBM       OPENOP,IOC.FLAGS,X2  FILE OPENED YET
         BS        RM.AD00         YES
************************************************************************
*  DO IMPLICIT OPEN ON FILE
************************************************************************
         BL        OPEN            GO OPEN
         BL        BF.REDF         READ IN A BLOCK
         LW        R3,IOC.CBA,X2   GET BUFFER ADDRESS
         LA        R3,1W,X3        CALCULATE RCB ADDRESS
         STW       R3,IOC.RCBA,X2  UPDATE RCB POINTER
         BU        RM.AD02
*
RM.AD00  LW        R3,IOC.CPP,X2   ANY DATA IN POOL?
         BNZ       RM.AD01         YES.
************************************************************************
*  READ FROM FILE
************************************************************************
         BL        BF.REDF
         LW        R3,IOC.CBA,X2   UPDATE A(RCB)
         LA        R3,1W,X3
         STW       R3,IOC.RCBA,X2
RM.AD01  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         TBM       RCB.EOB,RCB.SBLR,X3   IS THIS THE END OF THIS BLOCK?
         BNS       RM.AD02  NOT END OF BLOCK
************************************************************************
*  END OF BLOCK.  GET NEXT BLOCK
************************************************************************
         BL        BF.REDF         GO GET NEXT BLOCK
         LW        R3,IOC.CBA,X2  R3 = CURRENT BUFFER ADDR
         ADI       R3,1W           R3 = A(RCB)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDR
************************************************************************
*  TEST FOR END OF FILE
************************************************************************
RM.AD02  TBM       RCB.EOF,RCB.SBTR,X3  IS THIS END OF FILE?
         BS        RM.AD05         YES.  GO TELL THE FCB.
************************************************************************
*  POST TRANSFER UPDATE TO NEXT RECORD
************************************************************************
RM.AD04  LW        R2,IOCA         R2 = A(IOC)
         LW        R3,IOC.RCBA,X2  R2 = A(RCB)
         ADMB      R3,RCB.BCTR,X3  ADD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         LF        R0,REGS
         TRSW      R0
************************************************************************
*  RM.AD05
*  ENTER:  R1 = A(FCB)
*  RETURN END OF FILE STATUS IN FCB
************************************************************************
RM.AD05  SBM       6,FCB.SFLG,X1   SET EOF
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.ADVF
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.ADVF  STF       R0,REGS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         R2 = A(IOC)
         STW       R2,IOCA         SAVE IOCA
         TBM       WRITOP,IOC.FLAG,X2   WAS LAST OPERATION WRITE?
         BS        ABRT9           ADVF NOT ALLOWED AFTER WRITE.
         TBM       OPENOP,IOC.FLAGS,X2  FILE OPENED YET
         BS        RM.AF00         YES
************************************************************************
*  DO IMPLICIT OPEN ON FILE
************************************************************************
         BL        OPEN            GO OPEN
         BL        BF.REDF         READ IN A BLOCK
         LW        R3,IOC.CBA,X2   GET BUFFER ADDRESS
         LA        R3,1W,X3        CALCULATE RCB ADDRESS
         STW       R3,IOC.RCBA,X2  UPDATE RCB POINTER
         BU        RM.AF02
*
RM.AF00  LW        R3,IOC.CPP,X2   ANY DATA IN POOL?
         BNZ       RM.AF01         YES.
************************************************************************
*  READ FROM FILE
************************************************************************
         BL        BF.REDF
         LW        R3,IOC.CBA,X2   UPDATE A(RCB)
         LA        R3,1W,X3
         STW       R3,IOC.RCBA,X2
RM.AF01  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         TBM       RCB.EOB,RCB.SBLR,X3   IS THIS THE END OF THIS BLOCK?
         BNS       RM.AF02  NOT END OF BLOCK
************************************************************************
*  END OF BLOCK.  GET NEXT BLOCK
************************************************************************
         BL        BF.REDF         GO GET NEXT BLOCK
         LW        R3,IOC.CBA,X2  R3 = CURRENT BUFFER ADDR
         ADI       R3,1W           R3 = A(RCB)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDR
************************************************************************
*  TEST FOR END OF FILE
************************************************************************
RM.AF02  TBM       RCB.EOF,RCB.SBTR,X3  IS THIS END OF FILE?
         BS        RM.AF05         YES.  GO TELL THE FCB.
************************************************************************
*  POST TRANSFER UPDATE TO NEXT RECORD
************************************************************************
RM.AF04  LW        R2,IOCA         R2 = A(IOC)
         LW        R3,IOC.RCBA,X2  R2 = A(RCB)
         ADMB      R3,RCB.BCTR,X3  ADD BYTE COUNT
         ADI       R3,4B           ADD RCB LENGTH
         STW       R3,IOC.RCBA,X2  UPDATE RCBA
         BU        RM.AF00         READ UNTIL EOF
************************************************************************
*  RM.AF05
*  ENTER:  R1 = A(FCB)
*  RETURN END OF FILE STATUS IN FCB
************************************************************************
RM.AF05  SBM       6,FCB.SFLG,X1   SET EOF
         LF        R0,REGS
         TRSW      R0
         PAGE
************************************************************************
*  RM.WRIT
*  ENTER:  R1 = A(FCB)
************************************************************************
RM.WRIT  STF       R0,REGS         SAVE REGISTERS
         ZMW       ERR.CODE        GOOD RETURN
         BL        IR.CONT         ESTABLISH CONTEXT BLOCK
         STW       R2,IOCA         SAVE A(IOC)
         SBM       WRITOP,IOC.FLAG,X2  FLAG WRITE OPERATION
         SBM       OUTAOP,IOC.FLAG,X2  FLAG POOL OUTPUT ACTIVE
         TBM       OPENOP,IOC.FLAG,X2  FILE OPENED?
         BS        WRIT.00         YES.
************************************************************************
*  DO IMPLICIT OPEN ON FILE_
************************************************************************
         BL        OPEN
WRIT.00  LW        R7,IOC.CPP,X2   POOL INITIALIZED?
         BNZ       WRIT.01         YES.
         LA        R3,IOC.BUF,X2   INITIALIZE BUFFER
         STW       R3,IOC.CBA,X2
         LI        R3,1
         STW       R3,IOC.NAB,X2
         STW       R3,IOC.CBN,X2
         STW       R3,IOC.CPP,X2
         BL        IR.BINIT
************************************************************************
*  CALCULATE BLOCK SPACE NEEDED FOR THIS RECORD
************************************************************************
WRIT.01  EQTY      R7,X1           # BYTES IN USER RECORD
         CI        R7,X'00FF'      COMPARE TO MAXIMUM RECORD SIZE
         BGT       ABRT8           TOO BIG
         ADI       R7,1W           ADD RCB SIZE
************************************************************************
*  CALCULATE AVAILABLE SPACE IN CURRENT BLOCK
************************************************************************
         LW        R3,IOC.CBA,X2   CALCULATE END ADDRESS OF BLOCK
         LA        R6,BLKSIZ,X3    BY ADDING LENGTH TO ORIGIN.
         SUMW      R6,IOC.RCBA,X2  SUBTRACT RCB ADDR
         SUI       R6,1H           AND LAST RCB HALFWORD
         CAR       R7,R6           ENOUGH ROOM?
         BGE       WRIT.02         YES.
************************************************************************
*  WRITE OUT THIS BLOCK
************************************************************************
         BL        IR.FINIS        FINIS BLOCK WITH ZERO FILL
         BL        BF.WRIT         WRITE OUT THIS BUFFER TO POOL
         BL        IR.BINIT        INITIALIZE NEW BUFFER FOR WRITE
************************************************************************
*  TRANSFER USER RECORD TO BUFFER
************************************************************************
WRIT.02  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         EQTY      R5,X1           RECORD BYTE COUNT
         STB       R5,RCB.BCTR,X3  SAVE IN RCB
         ZMB       RCB.SBTR,X3     ZERO STATUS BYTE
         LA        R2,2H,X3        R2 = A(TARGET)
         ERWA      R3,X1           R3 = A(SOURCE)
         BL        IR.CPPY         TRANSFER
         TRR       R2,R3           R3 = TARGET NEXT BYTE ADDR
         ZMB       RCB.SBLR,X3     CLEAR STATUS BYTE
         EQTY      R5,X1           RECORD LEN
         STB       R5,RCB.BCLR,X3  STORE IN RCB BYTE COUNT
************************************************************************
*  UPDATE BLOCKING BUFFER CONTROL WORD
************************************************************************
         LW        R2,IOCA         R2 = A(IOC)
         STW       R3,IOC.RCBA,X2  UPDATE RCB ADDRESS
         SUMW      R3,IOC.CBA,X2   SUBTRACT BUFFER STARTING ADDRESS
         LW        R1,IOC.CBA,X2   GET CURRENT BUFFER ADDRESS
         STW       R3,0W,X1        STORE REL
         LF        R0,REGS         RESTORE REGISTERS
         TRSW      R0
         PAGE
*
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
*
************************************************************************
*  BF.REDF - GET NEXT BUFFER THIS LFC
*  ENTER:  R1 = A(FCB), R2 = A(IOC)
*  EXIT :  R3 = A(RCB) = IOC.RCBA
*          IOC.CBN = A(BUFFER)
************************************************************************
BF.REDF  STW       R0,BF.RFXIT     SAVE RETURN ADDRESS
         LW        R3,IOC.CBN,X2   DO WE HAVE THE NEXT
         CAMW      R3,IOC.NAB,X2   BUFFER IN MEMORY?
         BLT       BF.RF01         YES.
************************************************************************
*  READ IN NEXT POOL
************************************************************************
         BL        PL.REDF         READ NEXT POOL
         LI        R3,1            INITIALIZE THE
         STW       R3,IOC.CBN,X2   BUFFER STATUS
         LA        R3,IOC.BUF,X2   FOR THIS POOL
         BU        BF.RF02         RETURN
************************************************************************
*  RETURN POINTER TO NEXT BUFFER IN POOL
************************************************************************
BF.RF01  ABM       31,IOC.CBN,X2   INCRIMENT CURRENT BUFFER NUMBER
         LW        R3,IOC.CBA,X2   BUMP ADDRESS
         LA        R3,BLKSIZ,X3    NO NEXT BUFFER
BF.RF02  EQU       $
         STW       R3,IOC.CBA,X2
         LW        R4,0W,X3        GET FIRST WORD OF BLOCK
         CI        R4,X'300'       BETTER BE LESS THAN 192W
         BGE       BF.RF03         ERROR IF NOT
         LH        R4,2H,X3        GET FIRST RCB
         ANMW      R4,=X'E000'     JUST US CONTROL BITS
         CI        R4,X'4000'      JUST BOB ON
         BEQ       *BF.RFXIT       EXIT IF O.K.
BF.RF03  BU        ABRT5           GO SET EOF IN USERS FCB
*
         DSECT
BF.RFXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  BF.REDB - READ PREVIOUS BUFFER FROM POOL
************************************************************************
BF.REDB  STW       R0,BF.RBXIT
         LW        R3,IOC.CBN,X2
         CI        R3,1            IS PREVIOUS BUFFER IN POOL?
         BGT       BF.RB01         YES.
*
*  GET BUFFER FROM PREVIOUS POOL
*
         BL        PL.REDB
         LI        R3,BLKMAX
         STW       R3,IOC.CBN,X2
         LA        R3,BLKSIZ*BLKMAX-BLKSIZ+IOC.BUF,X2 LAST BUF ADDRESS
         STW       R3,IOC.CBA,X2   UPDATE CURRENT BUFFER ADDRESS
         BU        *BF.RBXIT       RETURN
*
*  GET BUFFER FROM CURRENT POOL
*
BF.RB01  LW        R3,IOC.CBN,X2   DECRIMENT
         SUI       R3,1            CURRENT
         STW       R3,IOC.CBN,X2   BUFFER NUMBER.
         LW        R3,IOC.CBA,X2   CALCULATE
         SUI       R3,BLKSIZ       BUFFER
         STW       R3,IOC.CBA,X2   ADDRESS
         BU        *BF.RBXIT       RETURN
         DSECT
BF.RBXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  BF.WRIT - WRITE THIS BUFFER INTO POOL
************************************************************************
BF.WRIT  STW       R0,BF.WRXIT     SAVE RETURN ADDRESS
         LW        R3,IOC.CBN,X2   DO WE HAVE MORE FREE
         CI        R3,BLKMAX       BUFFERS?
         BLT       BF.WR01         YES
************************************************************************
*  WRITE THIS POOL TO FILE
************************************************************************
         BL        PL.WRIT
         LW        R3,IOC.CPP,X2
         ADI       R3,BLKMAX       INCRIMENT CURRENT POOL POSITION
         STW       R3,IOC.CPP,X2
         LI        R3,1
         STW       R3,IOC.NAB,X2   USER MUST BE MAKING THIS ACTIVE
         STW       R3,IOC.CBN,X2   SET BUFFER POINTERS
         LA        R3,IOC.BUF,X2
         STW       R3,IOC.CBA,X2
         BU        *BF.WRXIT       RETURN
************************************************************************
*RETURN POINTER TO NEXT FREE BUFFER
************************************************************************
BF.WR01  ABM       31,IOC.CBN,X2   INCRIMENT CURRENT BUFFER NUMBER
         LW        R3,IOC.CBN,X2
         STW       R3,IOC.NAB,X2   SET NUMBER OF ACTIVE BUFFERS
         LW        R3,IOC.CBA,X2   BUMP CURRENT BUFFER ADDRESS
         LA        R3,BLKSIZ,X3
         STW       R3,IOC.CBA,X2
         BU        *BF.WRXIT       RETURN
         DSECT
BF.WRXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  BF.RWND - SET BUFFER TABLES FOR REWIND
************************************************************************
BF.RWND  STW       R0,BF.RWXIT
         BL        PL.RWND         REWIND POOL
         LW        R7,IOC.CPP,X2   POOL  # 1 IN MEM?
         BNZ       BF.RW01
         ZMW       IOC.CBN,X2
         BU        *BF.RWXIT
*
BF.RW01  LI        R7,1            BUFFER TABLES TO FIRST BLOCK
         STW       R7,IOC.CBN,X2
         LA        R7,IOC.BUF,X2
         STW       R7,IOC.CBA,X2
         BU        *BF.RWXIT         RETURN
         DSECT
BF.RWXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
* PL.REDF - READ NEXT POOL
*  EXIT :  R7 = # BLOCKS READ
************************************************************************
PL.REDF  LI        R7,BLKMAX       NUMBER OF BLOCKS TO FILL
         MPI       R6,BLKSIZ       SIZE OF BLOCK
         STW       R7,FCB.EQTY,X2  SAVE IN FCB
         XCR       R1,R2           R1 = A(FCB)
         SVC       1,X'31'         READ REQUEST
         XCR       R1,R2           RESTORE REGS
         TBM       1,FCB.SFLG,X2   ERROR CONDITION?
         BS        ABRT4
         TBM       6,FCB.SFLG,X2   EOF?
         BS        ABRT5
         TBM       7,FCB.SFLG,X2   EOM?
         BS        ABRT6
         ZR        R6              ZERO FOR DIVIDE
         LW        R7,FCB.RECL,X2  ACTUAL READ LENGTH
         DVI       R6,BLKSIZ       COMPUTE # BLOCKS
         BZ        ABRT1
         TRR       R6,R6           CHECK FOR INTEGRAL BLOCK READ
         BNZ       ABRT2
         STW       R7,IOC.NAB,X2   UPDATE NUMBER OF ACTIVE BUFFERS
         LW        R6,IOC.CFP,X2   R6 = CURRENT FILE POSITION
         STW       R6,IOC.CPP,X2   UPDATE CURRENT POOL POSITION
         ADMW      R7,IOC.CFP,X2   UPDATE CFP
         STW       R7,IOC.CFP,X2   WITH NEW READ POSITION
         TRSW      R0
         PAGE
************************************************************************
*  PL.WRIT - WRITE THIS POOL TO FILE
************************************************************************
PL.WRIT  STW       R0,PL.WRXIT     SAVE RETURN ADDRESS
         LW        R3,IOC.CPP,X2   COMPARE POOL POSITION
         CAMW      R3,IOC.CFP,X2   TO FILE POSITION
         BGT       ABRT12          SHOULD NEVER BE
         BEQ       PL.WR01         NO POSITIONING NEEDED
         LW        R3,IOC.CPP,X2   R3 = DESIRED FILE POSITION
         BL        FL.POSS         POSITION FILE
PL.WR01  LW        R7,IOC.NAB,X2   NUMBER OF ACTIVE BLOCKS IN POOL
         MPI       R6,BLKSIZ       TRANSFER BYTE COUNT
         STW       R7,FCB.EQTY,X2  INTO FCB
         XCR       R1,R2           R1 = A(FCB)
         SVC       1,X'32'         WRITE REQUEST
         XCR       R1,R2           RESTORE REGISTERS
         TBM       1,FCB.SFLG,X2   ERROR CONDITION?
         BS        ABRT10
         TBM       7,FCB.SFLG,X2   EOM?
         BS        ABRT11
         LW        R3,IOC.NAB,X2   GET NUMBER OF BLOCKS WRITTEN
         ADMW      R3,IOC.CFP,X2   UPDATE CURRENT FILE POSITION
         STW       R3,IOC.CFP,X2
         BU        *PL.WRXIT       RETURN
         DSECT
PL.WRXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  PL.RWND - SET POOL TABLES TO REWIND AND REWIND FILE
************************************************************************
PL.RWND  STW       R0,PL.RWXIT
         LI        R7,1
         CAMW      R7,IOC.CPP,X2   POOL # 1 IN MEMORY?
         BEQ       PL.RW02         YES.  SAVE THIS GOOD STUFF.
         ZBM       OUTAOP,IOC.FLAG,X2  OUTPUT ACTIVE?
         BNS       PL.RW01         NO.
         BL        PL.WRIT         OUTPUT THIS POOL TO FILE
PL.RW01  ZMW       IOC.CPP,X2      INDICATE NO DATA IN POOL
         ZMW       IOC.NAB,X2      NO ACTIVE BUFFERS
PL.RW02  LI        R7,1            SHOULD FILE BE REWOUND?
         CAMW      R7,IOC.CFP,X2
         BEQ       *PL.RWXIT       NOT NEEDED.
         LI        R3,1            R3 = FILE POSITION FOR FL.POSS
         BL        FL.POSS         POSITION THE FILE
         BU        *PL.RWXIT
         DSECT
PL.RWXIT RES       1W              RETURN ADDRESS
         CSECT
         SPACE     3
************************************************************************
*  PL.REDB - READ PREVIOUS POOL FROM FILE
************************************************************************
PL.REDB  STW       R0,PL.RBXIT
         LW        R3,IOC.CPP,X2   R3 = CURRENT POOL POSITION
         SUI       R3,BLKMAX       R3 = PREVIOUS POOL POSITION
         BLE       ABRT14          SHOULD NEVER BE
         BL        FL.POSS         POSITION FILE
         BL        PL.REDF         GO READ
         BU        *PL.RBXIT       RETURN
         DSECT
PL.RBXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  FL.POSS - POSITION FILE
*  ENTER:  R2 = A(IOC)
*          IOC.CFP = CURRENT FILE POSITION
*  EXIT :  R2,R3 DESTROYED
*          IOC.CFP = NEW FILE POSITION
************************************************************************
FL.POSS  TRR       R3,R4           R4 = DESIRED POSITION
         SUMW      R4,IOC.CFP,X2   R4 = BACKSPACE/SKIP COUNT
         STW       R3,IOC.CFP,X2   UPDATE CURRENT FILE POSITION
         BEQ       FL.PO04         ALREADY THERE.  RETURN
         BGT       FL.PO02         GO ADVANCE TO POSITION
         CI        R3,1            IS THIS POSITION THE BEGINNING OF FIL
         BGT       FL.PO00         NO.  JUST BACKSPACE.
*
*  REWIND WILL QUICKLY GET US THERE
*
         XCR       R1,R2
         SVC       1,X'37'         REWIND FILE
         XCR       R1,R2
         TRSW      R0
*
*  BACKSPACE NUMBER IN R4
*
FL.PO00  XCR       R1,R2           R1 = A(IOCFCB)
FL.PO01  SVC       1,X'35'         BACKSPACE 1 BLOCK
         BIB       R4,FL.PO01      DO ANOTHER.
         XCR       R1,R2           RESTORE REGISTERS
         TRSW      R0              RETURN
*
*  SKIP TO POSITION
*
FL.PO02  TRN       R4,R4           NEGATE COUNT FOR LOOP
         XCR       R1,R2           R1 = A(IOCFCB)
FL.PO03  SVC       1,X'33'         ADVANCE 1 RECORD
         BIB       R4,FL.PO03      DO ANOTHER.
         XCR       R1,R2           RESTORE REGISTERS
FL.PO04  TRSW      R0              RETURN
         PAGE
************************************************************************
*  INTERNAL ROUTINES
************************************************************************
         SPACE     2
************************************************************************
*  IR.CONT  - ESTABLISH THE ADDRESS OF THE IOC FOR THIS LFC
*  ENTER:  R1  = A(FCB)
*  EXIT :  R2  = A(IOC)
************************************************************************
IR.CONT  STW       R0,IR.COXIT     SAVE RETURN ADDR
         LW        R4,=X'00FFFFFF' LFC MASK
         LW        R6,FCB.LFC,X1   USER LFC
         LW        R2,IOCBASE      R2 = START OF IOC'S
         BNZ       IR.CO10         BR IF BUFFERS ALLOCATED
         LW        R7,IOCTOTL      GET NUMBER OF BYTES REQ'D
         SVC       1,X'69'         GET AN EXTENDED MAP
         STW       R3,IOCBASE      SAVE STARTING ADDR
IR.CO11  ADI       R4,1W           FULL MAP SIZE
         SUR       R3,R4           SIZE OF MAP
         SUR       R4,R7           SUBT FROM REQUIRED
         SRL       R4,3            BYTES TO DOUBLEWORDS
         TRN       R4,R4           NEGATE FOR LOOP
IR.CO12  ZMD       0,X3            ZERO THE ALLOCATED MEMORY
         ADI       R3,1D           POINT TO NEXT DW
         BIB       R4,IR.CO12      DO WHOLE MAPBLOCK
         TRR       R7,R7           RESTORE FOR TEST
         BLE       IR.CO10         BR IF WE HAVE ENOUGH
         SVC       1,X'69'         GET ANOTHER EXTENDED MAP
         BU        IR.CO11         LOOP TILL ENOUGH
IR.CO10  LI        R7,IOC.SIZE     R7 = BUMP COUNT
         LW        R2,IOCBASE      R2 = START OF IOC'S
         LW        R5,IOCNUM       R5 = NUMBER OF CURRENTLY USED IOC'S
         TRN       R5,R5           NEGATE COUNT
         BZ        IR.CO03         NONE ALLOCATED YET
************************************************************************
*  LOOP THRU IOC'S SEARCHING FOR LFC IN R6
************************************************************************
IR.CO01  CMMW      R6,FCB.LFC,X2   MATCH?
         BEQ       IR.CO05         YES.
         ADR       R7,R2           BUMP TO THE NEXT IOC
         BIB       R5,IR.CO01      CHECK IT IF ANY MORE
************************************************************************
*  SEARCH FOR DEALLOCATED SPACE
**********************************************************************:*
         LW        R2,IOCBASE      GET BASE ADDRESS
         LW        R5,IOCNUM
         TRN       R5,R5           NEGATE COUNT
         ZR        R6              LOOKING FOR ZERO LFC
IR.CO02  CMMW      R6,FCB.LFC,X2   DEACTIVATED?  (LFC=0?)
         BEQ       IR.CO04         YES.  R2 = A(DEALOCATED IOC)
         ADR       R7,R2           BUMP TO NEXT IOC
         BIB       R5,IR.CO02      TRY ANOTHER
************************************************************************
*  NO MATCH FOUND ALLOCATE A NEW ONE
************************************************************************
IR.CO03  LW        R7,IOCNUM       R7 = NUM ALLOCATED IOC'S
         CI        R7,IOCMAX       HOW DOES IT COMPARE TO TOTAL IOC'S?
         BGE       IR.CO06         NOT SO GOOD
         ABM       31,IOCNUM       INCRIMENT USED IOC COUNT
IR.CO04  BL        IR.INCB         INITIALIZE NEW IOC
IR.CO05  BL        IR.FCBINT       INITIALIZE USER'S FCB
         BU        *IR.COXIT       RETURN
IR.CO06  LI        R7,3            OUT OF IOC'S ERROR
         STW       R7,ERR.CODE     SAVE FOR CALLER
         BU        RM.OPXIT        RESTORE REGS & EXIT
         DSECT
IOCNUM   DATAW     0               # IOC'S ALLOCATED (FOR IR.CONT ONLY)
IR.COXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  IR.FCBIN  INITIALIZE FCB
************************************************************************
IR.FCBIN ZMW       FCB.SFLG,X1     32 FLAG BITS
         ZMB       FCB.SPST,X1     8 FLAG BITS
         ZMW       FCB.RECL,X1     ZERO TRANSFER LENGTH (BYTES)
         TBM       6,FCB.GCFG,X1   EXPANDED FCB?
         BNS       INIT.ST2        NO
         ZMW       FCB.IST1,X1     EXPANDED STATUS WORD 1
         ZMW       FCB.IST2,X1     EXPANDED STATUS WORD 2
INIT.ST2 EQU       $
         TRSW      R0
*
* (C) COPYRIGHT 1983 GOULD INC., COMPUTER SYSTEMS DIVISION
*     ALL RIGHTS RESERVED
*
         PAGE
************************************************************************
*  IR.INCB - INITIALIZE NEW IOC BLOCK
*  ENTER: R1 = A(FCB), R2 = A(IOC), R5 DESTROYED
************************************************************************
IR.INCB  LW        R5,FCB.LFC,X1   GET LFC
         STW       R5,FCB.LFC,X2   SAVE IN IOC FCB
         LW        R5,=X'02000000' GCFG'S
         STW       R5,FCB.GCFG,X2
         LA        R5,IOC.BUF,X2
         STW       R5,FCB.ERWA,X2
*
*  INITIALIZE RECORD AND BUFFER POINTERS
*
         ZMW       IOC.CBN,X2      NO CURRENT BUFFER NUMBER
         ZMW       IOC.NAB,X2      NO ACTIVE BUFFERS
         ZMW       IOC.FLAG,X2     CLEAR FLAGS
         ZMW       IOC.CPP,X2      CURRENT POOL EMPTY
         ZMW       IOC.BCNT,X2     NO COMPRESS COUNT
         ZMW       IOC.BPTR,X2     NO POINTER
         LI        R5,1
         STW       R5,IOC.CFP,X2   CURRENT FILE POSITION  = 1ST BLOCK
         TRSW      R0
         PAGE
************************************************************************
*  IR.CPPY
*  ENTER:  R2 = A(TARGET), R3 = A(SOURCE), R5 = BYTE COUNT
*  EXIT :  R2 = A(NEXT BYTE AFTER TARGET)
*          R3 = LIKEWISE FOR SOURCE
*          R5 = 0
*          R6 = DESTROYED
************************************************************************
IR.CPPY  TRN       R5,R5           NEGATE COUNT
         BGE       IR.CP02
IR.CP01  LB        R6,0,X3         GET SOURCE BYTE
         STB       R6,0,X2         STUFF INTO TARGET BYTE
         ABR       R2,31           INC TARGET ADDR
         ABR       R3,31           INC SOURCE ADDR
         BIB       R5,IR.CP01
IR.CP02  TRSW      R0
         SPACE     2
************************************************************************
*  FILL - FILL TARGET WITH CHAR IN R6
*  ENTER:  R2 = A(TARGET), R5 = FILL COUNT, R6 = FILL CHARACTER
*  EXIT :  R2 = A(NEXT BYTE AFTER TARGET)
*          R5 = 0
*          R6 = DESTROYED
************************************************************************
IR.FILL  TRN       R5,R5           NEGATE COUNT
         BGE       IR.FI02
IR.FI01  STB       R6,0,X2         SAVE A BLANK
         ABR       R2,31
         BIB       R5,IR.FI01
IR.FI02  TRSW      R0
         PAGE
************************************************************************
*  IR.FINIS - FINISH BUFFER BY PADDING UNUSED SPACE WITH ZERO'S
************************************************************************
IR.FINIS STW       R0,IR.FIXIT     SAVE RETURN ADDRESS
         STW       R2,IOCA         SAVE CONTEXT ADDR
         LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         SBM       RCB.EOB,RCB.SBLR,X3  MARK END OF BLOCK
         LI        R5,BLKSIZ       TOTAL BLOCKSIZE
         TRR       R3,R6           SAVE R6
         LW        R3,IOC.CBA,X2   CURRENT BUFFER ADDRESS
         SUMW      R5,0W,X3        SUBTRACT USED BLOCK SPACE
         TRR       R6,R3           RESTORE R3
         SUI       R5,1H           SUBTRACT LAST RCB HALFWORD
         ZR        R6              FILL CHARACTER = 0
         LA        R2,1H,X3        ADDRESS OF TARGET BYTE
         BL        IR.FILL         FILL ANY CHAR SPACES
         LW        R2,IOCA         RESTORE A (IOC)
         BU        *IR.FIXIT       RETURN
         DSECT
IR.FIXIT RES       1W              RETURN ADDRESS
         CSECT
         SPACE     2
************************************************************************
*  INITIALIZE CURRENT BUFFER FOR WRITE
*  ENTER:  R2 = A(IOC)
*  EXIT :  R3 DESTROYED, IOC.RCBA DEFINED, BOB SET, REL BLK R/W SET
************************************************************************
IR.BINIT LW        R3,IOC.CBA,X2   R3 = ADDRESS OF CURRENT BUFFER
         ZMW       0W,X3           ZERO RCB'S
         SBM       29,0W,X3        INIT TO 1W
         ADI       R3,1W           ADD RELATIVE OFFSET TO GET RCB ADDR
         STW       R3,IOC.RCBA,X2  UPDATE A(RCB)
         ZMW       0W,X3           ZERO RCB'S
         SBM       RCB.BOB,RCB.SBLR,X3  TAG AS BEGINNING OF BLOCK
         TRSW      R0
         SPACE     2
************************************************************************
*  IR.WEOF - WRITE END OF FILE TO BLOCK
************************************************************************
IR.WEOF  STW       R0,IR.WEXIT
         LW        R7,IOC.CPP,X2   POOL INITIALIZED?
         BNZ       IR.WE00         YES.
         LA        R3,IOC.BUF,X2   INITIALIZE BUFFER
         STW       R3,IOC.CBA,X2
         LI        R3,1
         STW       R3,IOC.NAB,X2
         STW       R3,IOC.CBN,X2
         STW       R3,IOC.CPP,X2
         BL        IR.BINIT
IR.WE00  LI        R6,BLKSIZ       CALCULATE
         LW        R3,IOC.CBA,X2   GET CURR BUFF ADDR
         SUMW      R6,0W,X3        SPACE AVALIABLE IN BLOCK
         CI        R6,3H           ENOUGH FOR EOF?
         BGE       IR.WE01         YES
************************************************************************
*  COMPLETE THIS BLOCK.  EOF GOES IN NEXT BLOCK
************************************************************************
         BL        IR.FINIS        COMPLETE BLOCK
         BL        BF.WRIT         WRITE AND GET NEXT BUFFER
         BL        IR.BINIT        INITIALIZE FOR WRITE
IR.WE01  LW        R3,IOC.RCBA,X2  R3 = A(RCB)
         ZMB       RCB.SBTR,X3
         ZMB       RCB.BCTR,X3
         SBM       RCB.EOF,RCB.SBTR,X3   SET EOF.
         SBM       RCB.EOB,RCB.SBTR,X3   SET EOB.
         LA        R3,1W,X3
         ZMB       RCB.SBLR,X3
         ZMB       RCB.BCLR,X3
         SBM       RCB.EOF,RCB.SBLR,X3   SET EOF ALSO AT END OF RECORD
         SBM       RCB.EOB,RCB.SBLR,X3   SET EOB TOO.
         STW       R3,IOC.RCBA,X2  UPDATE THE RCB ADDRESS
         TRR       R3,R5           R5 = A(RCB)
         SUMW      R5,IOC.CBA,X2   SUBTRACT BLK ORIGIN FOR REL END
         LW        R3,IOC.CBA,X2   CURR BUFF ADDR
         STW       R5,0W,X3        UPDATE BLOCKING BUFFER CONTROL WORD
*
*  EOF IS ALWAYS LAST RECORD IN A BLOCK.
*  NOW WE PURGE THIS BLOCK AND READY NEW BLOCK
*
         BL        IR.FINIS        COMPLETE BLOCK
         BL        BF.WRIT         WRITE BLOCK
         BL        IR.BINIT        INITIALIZE NEW BLOCK
         BU        *IR.WEXIT
         DSECT
IR.WEXIT RES       1W              RETURN ADDRESS
         CSECT
         PAGE
************************************************************************
*  RECORD MANAGER ABORT EXITS
*  R2 = A(IOC)
************************************************************************
ABRT14   LI        R5,14           INTERNAL FILE POSITION ERROR
ABRT.ER  SBM       1,FCB.SFLG,X1   SET ERROR IN USER FCB
         BU        RM.AB           GO SET ERROR CODE & CLOSE FCB
ABRT12   LI        R5,12           INTERNAL FILE POSITION ERROR
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT11   LI        R5,11           END OF MEDIUM
         BU        ABRT.EM         GO SET EOM IN FCB
ABRT10   LI        R5,10           ERROR ON WRITE
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT9    LI        R5,9            READ NOT ALLOWED AFTER WRITE
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT8    LI        R5,8            USER RECORD SIZE TOO LARGE
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT7    LI        R5,7            WRITE ATTEMPTED ON UNOPENED FILE
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT6    LI        R5,6            END OF MEDIUM
ABRT.EM  SBM       7,FCB.SFLG,X1   SET EOM IN USER FCB
         BU        RM.AB           GO SET ERROR CODE & CLOSE FCB
ABRT5    LI        R5,5            PREMATURE EOF
ABRT.EF  SBM       6,FCB.SFLG,X1   SET EOF IN USER FCB
         BU        RM.AB           GO SET ERROR CODE & CLOSE FCB
ABRT4    LI        R5,4            ERROR CONDITION ON READ
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT3    LI        R5,3            NO MORE IOC'S AVAILABLE
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT2    LI        R5,2            NOT A MULTIPLE # BLOCKS READ
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT1    LI        R5,1            LESS THAN 1 BLOCK ON READ
         BU        ABRT.ER         GO SET ERR IN FCB
ABRT13   LI        R5,13           OPEN RESOURCE ERROR
RM.AB    STW       R5,ERR.CODE     SET ABORT CODE FOR CALLER
         ZMW       ABCODE          CLEAR FOR LATER
         BU        RM.CL02         CLOSE THIS FILE & DEALLOCATE
         SPACE     2
         DSECT
ABCODE   DATAW     0               ABORT CODE
         CSECT
         END
