/* *********************************************************************
 *
 * $Header:  002  20-DEC-90 10:11  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)SCIOLIB.C                                   $
 * 
 *      Rev  002  20-DEC-90 10:11  GANN      GANN                       
 * Changed a call to doclock.                                           
 *
 *      Rev  001  11-OCT-88 14:10  GANN      GANN
 *  Version control header added
 */
/*
 *
 * Description:
 *       Shared screen routines.
 *
 * Revision 3.14  87/03/15  23:06:52  user
 * In scprintf, use scputs to determine if should be an ERAEOL for rows
 * greater than scrowmax.  Also speed up scputs and spccol for Rainbow.
 *
 * Revision 3.13  87/02/20  22:13:35  user
 * Out the door.
 *
 * Revision 3.12  87/02/15  22:50:46  user
 * Compatibility changes.  Make sure current row is in memory using chkshft.
 * Don't try to get whole screen into memory if noscreen in chkscreen
 * (from Jim Bevier).  Use setrowcol routines in cprintf and scprintf.
 *
 * Revision 1.6  86/10/21  19:47:44  user
 * Changes for >255 lines, XENIX, and Lint.  Change for new stropen().
 * Use scerrrow whereever possible instead of MAXSCROW.
 *
 * Revision 1.5  86/09/11  23:30:15  user
 * Clean up scSetCur and (especially) tstcur a little.  Handle absrow
 * positioned before sctopl.  Rewrite scputs.  It was incredibly murky and
 * didn't work right for "set screen".  Add NOBUF option to scsave and
 * change logic around stack boundary conditions.
 *
 * Revision 1.4  86/08/17  23:19:56  user
 * Add NOBUF option to scsave to short circuit buffer checking.  Fixes some
 * bugs?  Used in several routines.
 *
 * Revision 1.3  86/07/12  22:48:13  user
 * Use DOPUTC to control whether old method of displaying lines is used.
 *
 * Revision 1.2  86/07/07  00:55:43  user
 * Use chkshft() return value in tstcur() and scsave()
 *
 * Revision 1.1  86/06/29  23:21:31  user
 * First RCS Revision
 */
#include "edt.h"
#include "scio.h"
# ifdef ISC
extern int         eralinmax[];
extern short       scmovcur();
# else
extern unsigned    eralinmax[];
# endif ISC
extern int         coloff;
extern int         colpreserve;
void     scputs();
#ifdef BUFSTDOUT
void     bufstdout();
#endif
Line     *chkscreen();
/*----------------------------------------------------------------------------
 * scdoref -       Do the actual screen refresh.  Repaints lines in the given
 *                 range.
 *
 * Parameters:
 *       repeat    - < 0 - marking select range (not used)
 *                   > 0 - regular refresh (e.g. insert/delete lines/chars)
 *       toprow,
 *       topcol    - Screen address at which to begin the refresh
 *       botrow,
 *       botcol    - Screen address at which to end refresh
 *
 * Gotchas:
 *       If more than one line is specified, the toprow is assumed to be one.
 *       botrow will be scrowmax.
 *
 * Return:
 *       Always returns YES.
 *
 *----------------------------------------------------------------------------
 */
/*ARGSUSED*/
int scdoref(repeat, toprow, topcol, botrow, botcol)
int                repeat;
int                toprow;
int                topcol;
register int       botrow;
int                botcol;
{
	register Line      *here1;
	int                inbotrow;
	long               scr = absrow;
	short              scc = sccol;
	long               scmaxline;
	scsave(NOBUF), scsetcur(NOBUF, botrow, botcol);
	inbotrow = botrow = scrow;
	botcol = sccol;
	scsave(NO);
	scsave(NOBUF), here1 = scsetcur(NOBUF, toprow, topcol);
	toprow = scrow;
	topcol = sccol;
#ifdef BUFSTDOUT
	bufstdout(YES);
#endif
	if ((scmaxline = 1 + current->totlines - current->sctopl) <= (long)scrowmax)
	{
		if (botrow > (int)scmaxline)
			botrow = scmaxline;
	}
	else if (botrow > scrowmax)
		botrow = scrowmax;
	if (botrow != inbotrow)
		botcol = sccolmax;
	if (scrow <= botrow)
	{
		if (here1 != LNULL)
			scputs(here1->lin,
			((botrow == toprow) && (botcol < here1->len)) ? botcol : here1->len,
			marking, scr, scc);
		while (++scrow < botrow)
			if ((here1 = scsetcur(NOBUF, scrow, 1)) != LNULL)
				scputs(here1->lin, here1->len, marking, scr, scc);
		if ((here1 = scsetcur(NOBUF, botrow, 1)) == NULL)
			scputs(qtxtend, strlen(qtxtend), 0);
		else if (botrow != toprow)
			scputs(here1->lin, min(botcol, here1->len), marking, scr, scc);
		if (inbotrow > botrow)
			scdoscr(0, ++botrow, 1, inbotrow, MAXSCCOL);
	}
	scsave(NO);
#ifdef BUFSTDOUT
	bufstdout(NO);
#endif
	return(YES);
}
/*----------------------------------------------------------------------------
 * scdoscr -       Do the actual scroll/clear operation
 *
 * Parameters:
 *       nlines    - Number of lines to scroll (0 means clear region)
 *       toprow,
 *       topcol    - Beginning screen address at which to begin scroll/clear
 *       botrow,
 *       botcol    - Ending screen address at which to begin scroll/clear
 *
 * Gotchas:
 *       Only whole lines may be scrolled
 *
 * Return:
 *       Always returns YES.
 *----------------------------------------------------------------------------
 */
int scdoscr(nlines, toprow, topcol, botrow, botcol)
register int       nlines;
register int       toprow;
int                topcol, botrow, botcol;
{
	int                colmax = sccolmax - coloff;
	byte               isbuff = current != NULL;
	int                remaining, sigh;
	int				*scrolltop;
	scsave(NOBUF);
	scsetcur(NOBUF, toprow, topcol);
	toprow = scrow, topcol = sccol;
	scsave(NO);
	scsave(NOBUF);
	scsetcur(NOBUF, botrow, botcol);
	botrow = scrow, botcol = sccol;
	/* Perform calculations for top row/col */
	if (toprow > scerrrow)
		toprow = scerrrow;
	else if (toprow < 1)
		toprow = 1;
	topcol = spccol(toprow, topcol, NULL) -
	    ((isbuff && (toprow <= scrowmax)) ? coloff : 1);
	if (topcol < 0)
		topcol = 0;                      /* Too small? Make it zero */
	else if (topcol > colmax)
		topcol = colmax; /* Too big? Make it colmax (80?) */
	/* Do the same stuff for bottom row/col */
	if (botrow < toprow)
		goto byebye;
	if (botrow > scerrrow)
		botrow = scerrrow;
	botcol = spccol(botrow, botcol, NULL) -
	    ((isbuff && (botrow <= scrowmax)) ? coloff : 1);
	if (botcol < 0)
		botcol = 0;
	else if (botcol > colmax)
		botcol = colmax;
	/* Do the scroll */
	sigh = sign(nlines);
	if ((remaining = 1 + (botrow - toprow)) < (nlines *= sigh))
		nlines = remaining;
	SCSCR((nlines *= sigh), toprow, ++topcol, botrow, ++botcol);
	if (EOBonscr && (nlines != 0) && (botrow <= scrowmax))
		EOBonscr = (botrow != scrowmax); /* Wasn't touching last screen line */
	scrolltop = (int *)(eralinmax + toprow);
	if (nlines < 0)
	{
		botrow = (toprow - nlines) - 1;
		if ((remaining += nlines) > 0)
			MEMCPY(scrolltop - nlines, scrolltop, remaining*sizeof(int));
	}
	else if (nlines > 0)
	{
		if ((remaining -= nlines) > 0)
			MEMCPY(scrolltop, scrolltop + nlines, remaining*sizeof(int));
		toprow = (botrow - nlines) + 1;
	}
	if ((toprow == botrow) && (topcol != 1))
/* do nothing */ ;
	else
		do
		    eralinmax[toprow] = 0;
	while (++toprow < botrow);
byebye:
	scsave(NO);
	return(YES);
}
/*----------------------------------------------------------------------------
 * scSetCur -      Set the cursor variables to the specified position
 *
 * Parameters:
 *       bufstuff - Flag:           1 - check buffer for relative motion and
 *                                      BOB, EOB boundaries
 *                                  2 - disregard buffer information
 *                                  -1 - Interpret arguments as relative to
 *                                      BOB, not BOS
 *                                  -2 - Do not move top of screen.
 *       inrow      - row at which to set scrow
 *       incol      - column at which to set sccol
 *
 * Gotchas:
 *       - If inrow or incol is negative or has ADDFLAG set, then they are
 *         interpreted relative to the current cursor position.
 *       - scSetCur is intended to be called via the MACRO "scsetcur" which
 *         assures that the inrow/incol arguments are passed as long types.
 *       - inrow may take the value EOB or BOB to indicate movement to the
 *         End Of Buffer or Beginning Of Buffer.
 *
 * Return:
 *       Currently always returns NO.  Someday should return error if
 *       movement beyond buffer boundaries was attempted.
 *----------------------------------------------------------------------------
 */
long chars_rel, lines_rel;
static long nscrow;
static long nsccol;
Line *scSetCur(bufstuff, inrow, incol)
int      bufstuff;
long     inrow, incol;
{
	long               rowmask, colmask;
	register Bufctl    *bp = current;
	register int       row_relative, col_relative;
	byte               setcolpre;
	byte               looped = NO;
	if (bp == NULL)
		bufstuff = NOBUF;
	if (bufstuff == ABSADDR)
		nscrow = absrow;
	else
		nscrow = (long)scrow;
	nsccol = (long)sccol;
	/* The following loop allows poor-man's recursion for a limited
	 * stack machine.  I guess it is a little faster, too.
	 */
	do
	    {
		rowmask = ((inrow > 0) ? (inrow & ADDFLAG) : 0);
		if (!(row_relative = ((inrow <= 0) || (rowmask != 0))))
			nscrow = 0;
		else if (nscrow <= 0)
		{
			inrow += nscrow;
			nscrow = 0;
		}
		colmask = ((incol > 0) ? (incol & ADDFLAG) : 0);
		if (!(col_relative = ((incol <= 0) || (colmask != 0))))
			nsccol = 0;
		nscrow += (inrow ^= rowmask);
		nsccol += (incol ^= colmask);
		if (bufstuff == NOBUF)
		{
			setcolpre = NO;
			if ((bp != NULL) && (nscrow <= scrowmax) &&
			    (nscrow <= (1 + bp->totlines - bp->sctopl)))
			{
				here = (screen == NULL) ? LNULL : screen[nscrow-1];
				absrow = nscrow + bp->sctopl;
				col = nsccol;
				row = (int)(absrow - bp->line1is);
			}
			break;
		}
		else if (!looped)
		{
			lines_rel = row_relative ? inrow : 0;
			chars_rel = col_relative ? incol : 0;
			setcolpre = incol != 0;
		}
	}
	while (looped = tstcur(bufstuff, row_relative, col_relative, &inrow, &incol));
	scrow = nscrow;
	sccol = nsccol;
	if (setcolpre)
		colpreserve = spccol(scrow, sccol, LNULL);
	if (bufstuff != NOBUF)
		col = sccol;
	return(here);
}
/*----------------------------------------------------------------------------
 * tstcur -        Do the "meat" of the operations on cursor movement as
 *                 it relates to the data in the buffer.
 *
 * Parameters:
 *       bufstuff  - As described above (always non-zero)
 *       row_relative              - YES if positioning row relative to current position
 *       col_relative              - YES if positioning column relative to blah blah
 *       inrow, incol              - Same as above with ADDFLAG stripped, if on
 *
 * Gotchas:
 *       Cryptic.  Colpreserve stuff should really be in entmov (q.v.)
 *       movV or something.
 *
 * Return:
 *       NO if cursor position has been completely resolved.
 *       YES if must check more lines (i.e. user typed 1000C)
 *----------------------------------------------------------------------------
 */
int tstcur(bufstuff, row_relative, col_relative, inrow, incol)
int      bufstuff, row_relative, col_relative;
long     *inrow, *incol;
{
	register Bufctl    *bp = current;
	long               maxline;
# ifdef ISC
	long               maxsctop;
# endif ISC
	long               absbot;         /* Absolute line number of bot of scr */
	long               abstop;         /* Absolute line number of top of scr */
	register int       linelen;
	int                prelinelen;
	register int       absaddr = bufstuff == ABSADDR;
	extern char        toofarback[], pastend[];
	extern long        lasttopl;
	if (absaddr)
		absrow = nscrow;
	else
		absrow = nscrow + bp->sctopl;
	chkshft(bp, absrow);       /* Make sure current row is in memory */
	if (((maxline = bp->totlines + 1) > MAXBUFLINES) &&
	    (absrow >= MAXBUFLINES))
	{
		lines_rel -= MAXBUFLINES - bp->totlines;                     /* This was WAY off */
		absrow = bp->curlin + bp->line1is;                           /* Recalculate absrow */
		maxline = 1 + bp->totlines;      /* The REAL thing */
	}
	else if (absrow > maxline)
	{
		lines_rel -= absrow - maxline; /* Adjust */
		absrow = maxline;
		if (!(*inrow & EOB))
			errorout(pastend);
	}
	else if (absrow < 1)
	{
		lines_rel -= absrow - 1;
		absrow = 1;
		if (*inrow != BOB)
			errorout(toofarback);
	}
	abstop = bp->sctopl + qtop;
# ifdef ISC
    maxsctop = maxline - scrowmax;
	absbot = bp->sctopl + ((maxsctop <= bp->sctopl) ? scrowmax : qbottom);
# else
	absbot = bp->sctopl + qbottom;
# endif ISC
	if (noscreen || (bufstuff == NOSCR))
	{
		/* If before the beginning of screen, or way beyond the end, reset top */
		if ((absrow > (bp->sctopl + 0x3fff)) || (absrow <= bp->sctopl))
			bp->sctopl = (absrow - qbottom);
	}
	else
	{
		long             tmp, t1, t2;
		if ((absrow > absbot) && (((*inrow > 0) && row_relative) || absaddr))
			bp->sctopl = absrow - qbottom;
		else if ((absrow < abstop) && ((*inrow < 0) || absaddr))
			bp->sctopl = absrow - qtop;
		else if (((tmp = lasttopl - bp->sctopl) == 0) ||
		    ((t1 = absbot - absrow) <= 0) ||
		    ((t2 = absrow - abstop) <= 0))
			/* Nothing */;
		else if (tmp < 0)
			if ((tmp = bp->sctopl - t1) < lasttopl)
				bp->sctopl = lasttopl;
			else
				bp->sctopl = tmp;
		else if ((tmp = bp->sctopl + t2) > lasttopl)
			bp->sctopl = lasttopl;
		else
			bp->sctopl = tmp;
# ifdef ISC
		if (maxsctop < bp->sctopl)
			bp->sctopl = maxsctop;
# else
		if ((tmp = maxline - (long)scrowmax) < bp->sctopl)
			bp->sctopl = tmp;
# endif ISC
	}
	if (bp->sctopl < 0)
		bp->sctopl = 0;
	nscrow = absrow - bp->sctopl;
	here   = chkscreen(bp, absrow);                                /* Make sure we're in memory */
	screen = bp->buf + bp->sctopl - bp->line1is;                   /* Set up screen "array" */
	linelen = (here != LNULL) ? here->len + 1 : 1;
	prelinelen = (absrow > 1) ? (screen[nscrow - 2]->len + 1) : 1;
	/* Determine if cursor column is beyond bounds */
	if (!col_relative || ((*inrow == 0) && (*incol == 0)))
		return(NO);
	*inrow = 0;                                                    /* Assume all ok */
	if (*incol == 0)                   /* Probably vertical motion */
	{
		nsccol = matchcol((int)nscrow, colpreserve, here->lin, linelen);
		return(NO);
	}
	else if (nsccol > linelen)          /* Probably horizontal motion */
		if (absrow >= maxline)
		{
			chars_rel -= nsccol - 1;
			nsccol = 1;
			errorout(pastend);
			return(NO);
		}
		else
		{
			*inrow = ADDREL(1);
			*incol = -linelen;
			lines_rel++;
		}
	else if (nsccol >= 1)
		return(NO);
	else if (absrow > 1)
	{
		*inrow = -1;
		*incol = ADDREL(prelinelen);
		lines_rel--;
	}
	else
	{
		chars_rel -= nsccol - 1;
		nsccol = 1;
		errorout(toofarback);
		return(NO);
	}
	if (absaddr)
		nscrow = absrow;
	return(YES);
}
/* VARARGS */
# ifdef ISC
void cprintf(fmt, arg1, arg2, arg3, arg4)
# else
void cprintf(fmt, args)
# endif
register Pchar     fmt;
# ifdef ISC
Pchar		arg1, arg2, arg3, arg4;
# else
Pchar              args;
# endif
{
	register Pchar     p = fmt;
	char               spchar = *fmt;
# ifdef ISC
extern long lines_typed;
# endif ISC

	tstcc();           /* Maybe time to go home */
         BKGRND;                                                 /*002*/
	while (p != NULL)
	{
		*p = spchar;
		fmt= --p;
		while ((*++fmt == '\r') || (*fmt == '\n') || (*fmt == '\b'))
			putch(*fmt);
		if ((p = strpbrk(fmt, "\r\n\b")) != NULL)
		{
			spchar = *p;
			*p = '\000';
		}
# ifdef ISC
		scprintf(-1, -1, qdcolor, fmt, arg1, arg2, arg3, arg4);
                lines_typed++;  /* jcb ??? */
# else
		scprintf(-1, -1, qdcolor, fmt, &args);
# endif
	}
# ifdef ISC
    truecol = (truerow = scmovcur(-1, -1)) & 0xff;
    truerow >>= 8;
# else
	setrowcol(&truerow, &truecol);
# endif ISC
	return;
}
/*----------------------------------------------------------------------------
 * scprintf -      Do a "printf at the given position.
 *
 * Parameters:
 *       inrow, incol              - The screen address
 *       hue                       - The color to print the message in
 *       fmt                       - A "printf" type format
 *       args                      - The arguments to print
 *
 * Gotchas:
 *       Not real portable.
 *
 * Return:
 *       None.
 *----------------------------------------------------------------------------
 */
/*VARARGS*/
# ifdef ISC
void scprintf(inrow, incol, hue, fmt, arg1, arg2, arg3, arg4)
# else
void scprintf(inrow, incol, hue, fmt, arg1)
# endif
int      inrow, incol, hue;
Pchar    fmt;
# ifdef ISC
Pchar    arg1, arg2, arg3, arg4;
# else
Pchar    arg1;
# endif
{
	Pchar              *args;
	register int       len;
	static char        pline[MAXSCCOL];
# ifndef ISC
#ifndef VARGS
	register FILE      *goo;
#endif
# endif ISC
	scsave(NOBUF);
	if ((scrow = inrow) >= 0)
	{
		sccol = incol;
		args = &arg1;
	}
	else
	{
# ifdef ISC
        sccol = (scrow = scmovcur(inrow, inrow)) & 0xff;
        scrow >>= 8;
# else
		setrowcol(&scrow, &sccol);
# endif ISC
		args = (Pchar *)arg1;
	}
# ifdef ISC
/*	realcur = sccol; */
# else
	realcol = sccol;
# endif ISC
	clrlines |= (scrow > scrowmax);
	/* Set up formatted string */
# ifdef ISC
	sprintf(pline, fmt, arg1, arg2, arg3, arg4);
	len = strlen(pline);
# else
#ifdef VARGS
	vsprintf(pline, fmt, args);
	len = strlen(pline);
#else
	_output(goo = stropen(pline, writebin, MAXSCCOL), fmt, args);
	len = goo->_ptr - goo->_base;
	fclose(goo);			/* Close the string */
#endif
# endif ISC
# ifdef ISC
        if (len == 0)
            scposcur(scrow, sccol); /* Just position cursor */
        else
            scputs(pline, len, hue);           /* Send to screen */
        ERAEOL(scrow, truecol);
# else
	scputs(pline, len, hue);           /* Send to screen */
# endif ISC
	scsave(NO);
	return;
}
/*-----------------------------------------------------------------------------
 * scputs -        Put a string at the given cursor position.
 *
 * Arguments:
 *       char *str - The string
 *       int  len  - The length of the string
 *       int  hue  - Color to print in (-1 if marking)
 *       long rowpoint             - Row of current point
 *       short colpoint            - Column of current point
 *
 * Return:
 *       Nothing
 *-----------------------------------------------------------------------------
 */

/* VARARGS3 */
void scputs(str, len, hue, rowpoint, colpoint)
Pchar    str;
int      len;
int      hue;
long     rowpoint;
short    colpoint;
{
# ifdef ISC
    static   char     obuf[2*MAXLINE] = { '\000' };
    register Pchar    b;
    int         ch, ch_hue;
# else
	static Word        obuf[MAXLINE];
	register Word      *b;
	Word               chattr;
# endif ISC
	register int       pcol = sccol;
	register Pchar     p;
	int                n;
	int                next_truecol;
	int                inbuf;
	int                diamond;
	int                here2sel, here2last, last2sel, here2pt, pt2sel;
	extern long        lastmrow;
	extern short       lastmcol;
	dowork(NO);
	if ((inbuf = (scrow <= scrowmax) && (current != NULL)) && (str != qtxtend))
		p = str + pcol - 1;
	else
	{
# ifdef ISC
        if(scrow <= scrowmax)
# endif ISC
	   		pcol += coloff - 1;
		len += pcol - 1;
		p = str;
	}
	truerow = scrow;
# ifdef ISC
	if (hue > 0)
		ch_hue = hue;
	else if (hue == 0)
		ch_hue = qcolor;
# else
	if (hue > 0)
		chattr.b[1] = hue;
	else if (hue == 0)
		chattr.b[1] = qcolor;
# endif ISC
	/* Skip over beginning part which may not be on screen */
# ifdef ISC
    truecol = sccol;
    if (scrow <= scrowmax) {
# endif ISC
	pcol--;
	while ((truecol = spccol(scrow, ++pcol, str)) < coloff)
		p++;
	/* See if should redraw because diamond may have gone away */
# ifdef ISC
    }
    if (scrow <= scrowmax) {
    	if ((realcur = truecol - coloff) != realcolmax)
    		realcur++;
# else
	if ((realcol = truecol - coloff) != realcolmax)
		realcol++;
# endif ISC
	else     /* Could be. */
	{
		p--;
		pcol--;
		truecol--;
	}
# ifdef ISC
    } else realcur = truecol;
# endif ISC

# ifdef ISC
    for (b = obuf - 1; (pcol <= len) && (truecol <= sccolmax); p++)
# else
    for (b = obuf - 1; (pcol <= len) && (truecol < sccolmax); p++)
# endif ISC
	{
		if (hue < 0)
		{
			here2pt        = VECCMP(absrow, pcol, rowpoint, colpoint);
			pt2sel         = VECCMP(rowpoint, colpoint, rowsel, colsel);
			here2last      = VECCMP(absrow, pcol, lastmrow, lastmcol);
			last2sel       = VECCMP(lastmrow, lastmcol, rowsel, colsel);
			here2sel       = VECCMP(absrow, pcol, rowsel, colsel);
			if (((pt2sel < 0) || here2pt) &&
			    ((!here2sel && (pt2sel > 0)) ||
			    ((here2pt != pt2sel) && (pt2sel == here2sel))) &&
			    ((here2last == last2sel) || !last2sel || (here2sel != here2last) ||
			    (pt2sel != last2sel)))
# ifdef ISC
				ch_hue = qscolor;
			else
				ch_hue = qcolor;
# else
				chattr.b[1] = qscolor;
			else
				chattr.b[1] = qcolor;
# endif ISC
		}
		if ((next_truecol = spccol(scrow, ++pcol, str)) > sccolmax)
			next_truecol = sccolmax + 1;
# ifdef ISC
		if ((ch = *p) == '\t')
			ch = ' ';
#else
		if ((chattr.b[0] = *p) == '\t')
			chattr.b[0] = ' ';
# endif ISC

		for ( ; truecol < next_truecol; truecol++)
# ifdef ISC
			{
			*++b = ch;
			*++b = ch_hue;
			}
# else
			(++b)->w = chattr.w;
# endif ISC
	}
# ifdef ISC
	if ((realcur <= realcolmax) && (b > obuf))
# else
	if ((realcol <= realcolmax) && (b >= obuf))
# endif ISC
	{
# ifdef ISC
		n = (b - obuf) >> 1;
		if ((realcur + n) >= realcolmax)
			n = realcolmax - realcur;
		realcur = _scputs(scrow, realcur, obuf, ++n);
# else
		n = b - obuf;
		if ((realcol + n) >= realcolmax)
			n = realcolmax - realcol;
		realcol = _scputs(scrow, realcol, obuf, ++n);
# endif ISC
	}
	/* If didn't display the whole string, put a diamond at realcolmax */
	if (diamond = pcol <= len)
# ifdef ISC
		SCPUTC(scrow, realcolmax, 260, ch_hue);
# else
		SCPUTC(scrow, realcolmax, 260, chattr.b[1]);
# endif ISC
	/* See if need to erase to end of line */
	if ((!inbuf) || diamond || (str == qtxtend) || (len == here->len))
	{
# ifdef ISC
        /* next line is old code.....might still need it */
#ifdef JUNK
        if (!diamond && /* (realcur <= eralinmax[scrow]) && */
#else
        if (!diamond && (realcur <= eralinmax[scrow]) &&
#endif JUNK
                (realcur <= realcolmax) && (len != sccolmax))

/*		if (!diamond && (realcur <= eralinmax[scrow])) */
 		SCSCR(0, scrow, realcur, scrow, realcolmax);
		eralinmax[scrow] = realcur;      /* Reset max erased column */
# else
		if (!diamond && (realcol < eralinmax[scrow]))
			SCSCR(0, scrow, realcol, scrow, realcolmax);
		eralinmax[scrow] = realcol;      /* Reset max erased column */
# endif ISC
	}
	if (str == qtxtend)
		EOBonscr = (scrow == scrowmax);
	else if (scrow == scrowmax)
		EOBonscr = NO;
	dowork(YES);
	return;
}

/*-----------------------------------------------------------------------------
 * scsave
 *       Save/Restore all appropriate screen parameters.
 *
 * Arguments:
 *       save      - YES if parameters should be "pushed" on the screen stack.
 *                   NO if they should be "popped" from the screen stack.
 *
 * Gotchas:
 *       scsave(NO) calls chkshft to assure that current row/col is in memory.
 *
 * Return:
 *       None
 *-----------------------------------------------------------------------------
 */
typedef struct
{
	long st, scr, slr, ar, br;
	int sc, sr, sp, bc;
}
Scrstk;
void scsave(save)
int                save;
{
	static int         p = -1;
	register Bufctl    *bp = current;
	register Scrstk    *sp;
	static Scrstk      savestack[30] = { 0 };
	if (current == NULL)
		return;
	if (save == -1)
	{
		if (p < 0)
			return;
		p = save = 0;
	}
	if (save)
	{
		if (p < 30)
		{
			sp = &savestack[++p];
			sp->st  = bp->sctopl;
			sp->sc  = sccol;
			sp->sr  = scrow;
			sp->ar  = absrow;
			sp->sp  = colpreserve;
			sp->scr = chars_rel;
			sp->slr = lines_rel;
			if (save == NOBUF)
				sp->br = -1;
			else
			{
				sp->br  = bp->line1is + row;
				sp->bc  = col;
			}
		}
	}
	else if (p >= 0)
	{
		sp = &savestack[p];
		sccol            = sp->sc;
		scrow            = sp->sr;
		colpreserve      = sp->sp;
		chars_rel        = sp->scr;
		lines_rel        = sp->slr;
		absrow = sp->ar;
		/* Attempt to get whole screen into buffer (if we really have a buffer) */
		if (bp == NULL)
			screen = (LINE **)NULL, here = LNULL;                      /* Oops.  No buffer */
		else if (sp->br > 0)
		{
			bp->curchr     = sp->bc;
			bp->sctopl     = sp->st;
			(void)chkscreen(bp, sp->br);   /* Make sure screen is in memory */
			here = (screen = bp->buf + bp->sctopl - bp->line1is)[scrow - 1];
		}
		/* Finish up */
		p--;
	}
	return;
}
int newscreen(bp)
register Bufctl    *bp;
{
	if (bp != current)
		return(NO);
	screen = bp->buf + (bp->sctopl - bp->line1is);
	here = screen[scrow - 1];
	return(YES);
}
Line *chkscreen(bp, absrow)
register Bufctl    *bp;
long               absrow;
{
	if (!noscreen)
	{
		(void)chkshft(bp, bp->sctopl + 1);                         /* Make sure top of screen in memory */
		(void)chkshft(bp, bp->sctopl + scrowmax); /*  and bottom of screen */
	}
	return(chkshft(bp, absrow));                                   /* Make sure current row in memory */
}
/*----------------------------------------------------------------------------
 * spccol -        Calculate actual cursor position using the given screen
 *                 address and string.
 *
 * Parameters:
 *       inrow, incol              - The screen position
 *       str                       - The character string being displayed.  If NULL
 *                                   the current line from the buffer is used.
 *
 * Gotchas:
 *       Currently only converts based on tab columns.  Eventually should
 *       be fixed to allow VAX EDT constructs like "<ESC>" to be used.
 *
 * Return:
 *       The actual screen column
 *----------------------------------------------------------------------------
 */
int spccol(inrow, incol, str)
int                inrow, incol;
register Pchar str;
{
	register int       c;
	Pchar              lin_ix, lst_ix;
	int                i = 0;
    int                j;
# ifdef ISC
    Pchar   l;
    int     rem_chars;
# endif ISC

	if ((c = incol - 1) == 0)
		return(incol);
	/* Forget about tabs if no current screen, or not in "screen" */
	if (str != NULL)
# ifdef ISC
        l = str;
# else
		/* Do nothing */;
# endif ISC
	else if ((inrow > scrowmax) || (current == NULL) ||
	    (screen[--inrow] == LNULL) || (incol > screen[inrow]->len + 1))
		return(incol);
	else
# ifdef ISC
		l = (Pchar)screen[inrow]->lin; /* Start of screen */
	lst_ix = &l[c];   /* Where to stop looking */
	/* Count number of tab stops preceding current position in line */
	while ((c > 0) && ((lin_ix = (Pchar)MEMCHR(l, '\t', c)) != NULL))
	{
# else
		str = (Pchar)screen[inrow]->lin; /* Start of screen */
	lst_ix = str + c;   /* Where to stop looking */
	/* Count number of tab stops preceding current position in line */
	while ((c > 0) && ((lin_ix = MEMCHR(str, '\t', c)) != NULL))
	{
# endif ISC
# ifdef ISC
        j = (qtab ? qtab : 8);
        rem_chars = lin_ix - l;
		i += (rem_chars >= j) ? (1 + rem_chars / j) * j : j;  /* Move to next tab stop */
		l = lin_ix + 1;
		c = lst_ix - l;
# else
		i += ((lin_ix - str) + 8) & -8;  /* Move to next tab stop */
		str = lin_ix + 1;
		c = lst_ix - str;
# endif ISC
	}
	if (i != 0)
# ifdef ISC
		i += ++lst_ix - l;  /* Add in remainder */
# else
		i += 1 + lst_ix - str;  /* Add in remainder */
# endif ISC
	else
		i = incol;
	/* Return adjusted, real cursor position */
	return(i);
}
/*----------------------------------------------------------------------------
 * matchcol -      Perform the converse of spccol: Given an actual screen
 *                 address (i.e. including tabs) return index into the
 *                 display string.
 *
 * Parameters:
 *       inrow, incol              - Screen position
 *       instr                     - The display string in question
 *       len                       - The length of the display string
 *
 * Gotchas:
 *       None?
 *
 * Return:
 *       The index into the string corresponding to the displayed data.
 *----------------------------------------------------------------------------
 */
int matchcol(inrow, incol, instr, len)
int inrow, incol, len;
Pchar instr;
{
	register int       c, tc;
	for (c = 0, tc = 1; (tc < incol) && (c < len);)
		tc = spccol(inrow, ++c, instr);
	if (tc > incol)
		--c;
	return(max(c,1));
}
