/* *********************************************************************
 * 
 * $Header:  001  11-OCT-88 14:10  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)SCIO2.C                                     $
 * 
 *      Rev  001  11-OCT-88 14:10  GANN      GANN     
 *  Version control header added                                        
 */
/* 
 *
 * Description:
 *      Perform pass-2 screen I/O (i.e. actually put stuff on the screen)
 *
 * Revision 3.13  87/02/20  22:13:19  user
 * Out the door.
 *
 * Revision 3.12  87/02/15  22:43:20  user
 * *** empty log message ***
 *
 * Revision 1.4  86/10/21  21:14:44  user
 * Use scerrrow instead of MAXSCROW
 *
 * Revision 1.3  86/09/11  23:26:30  user
 * Change schar's to int's.  Reorder scque so that next gets zeroed(??).
 *
 * Revision 1.2  86/08/17  23:21:25  user
 * Use "NOBUF" instead of YES in scsave.
 *
 * Revision 1.1  86/06/29  23:21:07  user
 * First RCS Revision
 */

#include "edt.h"
#include "scio.h"

#define CLIP(w,l x) l=rclip(w,pscq->l,&(pscq->x)),x = cclip(pscq->x)

typedef struct scque
  {
  int             what;        /* What happened? */
  int             repeat;      /* How many? */
  long            lin1;        /* Where did */
  int             ix1;         /*  it happen? */
  long            lin2;        /* Where did */
  int             ix2;         /*  it end? */
  BUFCTRL         *bp;         /* This is the city */
  struct scque    *next;       /* You mean there's more??? */
  } SCQUE;

extern long lasttopl;

#ifdef BLOCKSTDIN
int     just_testing = NO;
int     maybe_dontblock = 0;
#endif

SCQUE scqbeg = {NULL, NULL, -1, -1, -1, -1, 0, 0};
SCQUE *scqend = &scqbeg;

SCQUE *scqdel();
int scdoscr();
int scdoref();
int scsctop();
static void scOPCfix();
void scqscr();
void scqref();

#define NOTDANGER      /*C.F.*/

#ifndef NOTDANGER
/*-------------------------------------------------------------------
 * scqadd
 *      Add or update entry on the queue
 *
 * Arguments:
 *      int what2        - Indicates kind of operation
 *      int repeat       - Number of times to do it
 *      int inlin1, ix1  - Starting lin/column of operation
 *      int inlin2, ix2  - Ending lin/column of operation
 *-------------------------------------------------------------------
 */

scqadd(test)

SCQUE   test;

{
long lin1, lin2;

if (!qmode || noscreen)
  return;       /* No need to do anything with screen */

#ifdef BLOCKSTDIN
dontblock++;

if (just_testing)
    {
    maybe_dontblock++;
    return;
    }
#endif

if (test.lin1 < 0)
  lin1 = (long)test.lin1;
else
  lin1 = current->sctopl + test.lin1 - 1;

if (test.lin2 >= 0)
  lin2 = current->sctopl + test.lin2 - 1;
else if ((lin2 = current->totlines + 1) < (long)scrowmax)
  lin2 = scrowmax;

test.ix1--;
test.ix2--;
test.lin1 = lin1;
test.lin2 = lin2;
test.bp = current;

scqend->next = &test;

scqmash();

if (scqend->next == &test)
  {
  scqend->next = (SCQUE *)reallmem(sizeof(SCQUE));
  *(scqend = scqend->next) = test;
  }

return;
}

#else /* NOTDANGER */
/*-------------------------------------------------------------------
 * scqadd
 *      Add or update entry on the queue
 *
 * Arguments:
 *      int what2       - Indicates kind of operation
 *      int repeat      - Number of times to do it
 *      int inlin1, ix1 - Starting lin/column of operation
 *      int inlin2, ix2 - Ending lin/column of operation
 *-------------------------------------------------------------------
 */

scqadd(what, repeat, inlin1, ix1, inlin2, ix2)

int what, repeat, inlin1, ix1, inlin2, ix2;

{
register SCQUE *pscq, *lstpscq;
long lin1, lin2;

if (!qmode || noscreen)
  return;          /* No need to do anything with screen */

#ifdef BLOCKSTDIN
dontblock++;

if (just_testing)
    {
    maybe_dontblock++;
    return;
    }
#endif

if (inlin1 < 0)
  lin1 = (long)inlin1;
else
  lin1 = current->sctopl + inlin1 - 1;
ix1--;

if (inlin2 >= 0)
  lin2 = current->sctopl + inlin2 - 1;
else if ((lin2 = current->totlines + 1) < (long)scrowmax)
  lin2 = scrowmax;

ix2--;

scqend->next = pscq = (SCQUE *)reallmem(sizeof(SCQUE));
scqend = pscq;

pscq->bp = current;
pscq->what = what;
pscq->repeat = repeat;
pscq->lin1 = lin1;
pscq->ix1 = ix1;
pscq->lin2 = lin2;
pscq->ix2 = ix2;
pscq->next = NULL;

scqmash();

return;
}
#endif /* NOTDANGER */

/*-------------------------------------------------------------------
 * scqeat
 *      Eat entries from screen queue, one at a time
 *
 * Arguments:
 *      int n0    - Max number of times to eat (burp)
 *
 *-------------------------------------------------------------------
 */
int scqeat(n0)

int n0;

{
register int      n = n0;
register int      what;
int               didsomething = NO;
void              marksalot();

if (!qmode)
  return(0);      /* No need to do anything with screen */

#ifdef BLOCKSTDIN
just_testing = !n0;
if (!just_testing)
    {
    dontblock -= maybe_dontblock;
    maybe_dontblock = 0;
    }
#endif

if (current->totlines < (long)(scrowmax - 1))
  EOBonscr = NO;

if (EOBonscr)
  n = scqchomp(SC_OPC, n);

scsctop();      /* Position screen, if necessary */

if (marking)
  marksalot();

#ifdef BLOCKSTDIN
if (just_testing)
  goto testing;
#endif

for (what = SC_START; (n != 0) && (what < SC_END); what++)
  n = scqchomp(what, n);

#ifdef BLOCKSTDIN
testing:
if (just_testing)
    {
    just_testing = NO;
    return(NO);
    }
#endif

if (n == n0)
  return(NO);

scposcur(scrow, sccol);

#ifdef BUFSTDOUT
bufstdout(NO);
#endif

return(YES);
}

/*-------------------------------------------------------------------
 * inrange
 *      Returns YES if given arguments are encompassed by scque guy
 *
 * Arguments:
 *      SCQUE *who                - element in the scque
 *      int tstrep                - repeat count of operation
 *      tst*1                     - beginning position
 *      tst*2                     - ending position
 *-------------------------------------------------------------------
 */

static int inrange(who, lstwho, tst, lsttst)

register SCQUE    *who, *tst;

{
register int      isin;
int               t1_w1, t1_w2;
int               t2_w1, t2_w2;
int               t1_w2nr, t2_w1pr;
int               t1_w2nc, t2_w1pc;
long              wholin1 = who->lin1;
int               whoix1 = who->ix1;
long              wholin2 = who->lin2;
int               whoix2 = who->ix2;
long              tstlin1 = tst->lin1;
long              tstlin2 = tst->lin2;
int               tstrep = tst->repeat;
int               tstix1 = tst->ix1;
int               tstix2 = tst->ix2;

t1_w1 = VECCMP(tstlin1, tstix1, wholin1, whoix1);
t2_w2 = VECCMP(tstlin2, tstix2, wholin2, whoix2);

switch (who->what)
  {
  case SC_REF:
    t2_w1 = VECCMP(tstlin2, tstix2, wholin1, whoix1);

    t1_w2 = VECCMP(tstlin1, tstix1, wholin2, whoix2);

    t1_w2nr = !(tstlin1 == (wholin2 + 1));
    t1_w2nc = VECCMP(tstlin1, tstix1, wholin2, whoix2 + 1);
    t2_w1pr = !(tstlin2 == (wholin1 - 1));
    t2_w1pc = VECCMP(tstlin2, tstix2, wholin1, whoix1 - 1);

    isin = ((t1_w1 >= 0) && (t1_w2 <= 0))             ||
            ((t2_w1 >= 0) && (t2_w2 <= 0))            ||
            ((t1_w1 < 0)  && (t2_w2 > 0))             ||
            (t1_w2nr == 0) || (t2_w1pr == 0)          ||
            (t1_w2nc == 0) || (t2_w1pc == 0);
    break;

  case SC_OPC:
    if (isin = ((t1_w1 == 0) || (tstlin1 == (wholin1 - who->repeat))))
      who->repeat += tstrep;
    break;

  case SC_SCR:
    if (/*(tstrep >= 0) ? (t1_w1 != 0) :*/ (t2_w2 != 0))
      return(NO);
    else
      {
      who->repeat += tstrep;
      return(YES);
      }
  }

/* If in range: reset maximums, minimums */

if (isin)
  {
  scqdel(lsttst);
  if (tstlin1 < wholin1)
    who->lin1 = tstlin1;
  if (tstix1 < whoix1)
    who->ix1 = tstix1;
  if (tstlin2 > wholin2)
    who->lin2 = tstlin2;
  if (tstix2 > whoix2)
    who->ix2 = tstix2;
  }

if (who->repeat == 0)
  scqdel(lstwho);

return(isin);
}

/*-------------------------------------------------------------------
 * scsctop
 *      Set new top of screen
 *
 * Arguments:
 *
 * Returns:
 *      YES if EOB was on screen (special case)
 *
 *-------------------------------------------------------------------
 */

int scsctop()

{
register long     nscroll;
long              lscrowmax = scrowmax;

if ((nscroll = current->sctopl - lasttopl) == 0)
  return;

if ((nscroll > 0) && (nscroll < lscrowmax))
  {
  scqscr((int)nscroll);
  scqref((int)(1 + lscrowmax - nscroll), 1, -1, MAXLINE);
  }
else if ((nscroll < 0) && ((nscroll = -nscroll) < lscrowmax))
  {
  scqscr(-(int)nscroll);
  scqref(1, 1, (int)nscroll, MAXLINE);
  }
else
  scqref(1, 1, -1, MAXLINE);

#ifndef BLOCKSTDIN
lasttopl = current->sctopl;
#else
if (!just_testing)
    lasttopl = current->sctopl;
#endif

return;
}

/*-------------------------------------------------------------------
 * scqdel
 *      Delete entry from the screen queue
 *
 * Arguments:
 *      prevptr - Pointer to previous entry in queue
 *
 * Returns:
 *      prevptr
 *-------------------------------------------------------------------
 */

SCQUE *scqdel(prevptr)

register SCQUE    *prevptr;

{
register SCQUE    *pscq = prevptr->next;

if (pscq == NULL)
  {
  errorout("Queue messed up in scqdel");/* !!! Error !!! */
  return(NULL);
  }

prevptr->next = pscq->next;

FREE(pscq);

if (pscq == scqend)
  scqend = prevptr;

#ifdef BLOCKSTDIN
dontblock--;   /* One less thing in queue.  Maybe we can block. */
#endif

return(prevptr);
}

static void marksalot()

{
long              sclastrow;
register int      last2here;
extern long       lastmrow;
extern short      lastmcol;

/* See if should be highlighting the select range */

if ((sclastrow = (lastmrow - current->sctopl)) < 1)
  sclastrow = 1;
else if (sclastrow > scrowmax)
  sclastrow = scerrrow;

if ((last2here = VECCMP((int)sclastrow, lastmcol, scrow, sccol)) < 0)
  scqref((int)sclastrow, lastmcol, scrow, sccol);
else if (last2here > 0)
  scqref(scrow, sccol, (int)sclastrow, lastmcol);

#ifndef BLOCKSTDIN
lastmrow = absrow;
lastmcol = sccol;
#else
if (!just_testing)
    {
    lastmrow = absrow;
    lastmcol = sccol;
    }
#endif

return;
}

/*-------------------------------------------------------------------
 * rclip
 *      Take an absolute buffer row and return a valid screen row
 *
 * Arguments:
 *      int  what - What kind of operation
 *      long inrow                - The absolute line
 *      int  *ix  - Index into the row
 *
 * Returns:
 *      The screen address
 *-------------------------------------------------------------------
 */

int rclip(what, inrow, ix)

int               what;
long              inrow;
register int      *ix;

{
long              outrow = 1 + inrow - current->sctopl;

if (((what != SC_REF) && (outrow > (long)scrowmax)) ||
    (outrow > (long)scerrrow))
  {
  outrow = scrowmax;
  *ix = MAXSCCOL - 1;
  }
else if (outrow < 1)
  {
  outrow = 1;
  *ix = 0;
  }

return((int)outrow);
}

int cclip(cwhat)

register int      cwhat;

{
cwhat++;

if (cwhat < 1)
  cwhat = 1;
else if (cwhat > sccolmax)
  cwhat = sccolmax + 1;

return(cwhat);
}

#ifdef NEEDED
static void scOPCfix(repeat, lin1, lin2)

register int      repeat;
long              lin1, lin2;

{
register SCQUE    *pscq;

if (lin1 < current->totlines)
  for (pscq = scqbeg.next; pscq != NULL; pscq = pscq->next)
    {
    if (pscq->lin1 > lin1)
      if ((pscq->lin1 -= repeat) < lin1)
        pscq->lin1 = lin1;
    if ((pscq->lin2 < (MAXBUFLINES - 1)) && (pscq->lin2 >= lin1))
      if ((pscq->lin2 -= repeat) < lin1)
        pscq->lin2 = lin1;
    }

return;
}
#endif

void callscr(pscq, lin1, ix1, lin2, ix2)

register SCQUE    *pscq;
int               lin1, ix1, lin2, ix2;

{
register Bufctl   *bp = current;
register int      repeat = pscq->repeat;
static (*scqfuncs[])() = {NULL, scdoscr, scdoscr, scdoref};

#ifdef BLOCKSTDIN
if (just_testing)
  return;
#endif

if ((pscq->what == SC_OPC))
  if (EOBonscr)
    {
    /* Turn it around */

    if (repeat > 0)
      {
      lin2 = lin1 - 1;
      lasttopl = bp->sctopl;
      scqref(1, 1, repeat, MAXLINE);
      }
    else
      {
      lasttopl = bp->sctopl -= repeat;
      scsetcur(ABSADDR, 0, 0);
      lin2 = (pscq->lin1 - (lasttopl = bp->sctopl)) - repeat;
      }

    repeat = -repeat;
    lin1 = 1;
    }

(*scqfuncs[pscq->what])(repeat, lin1, ix1, lin2, ix2);

return;
}

int scqchomp(what, n)

int               what;
int               n;

{
int               doit;
register int      going;
int               isREF = what == SC_REF;
int               l1_top_cmp, l2_bot_cmp;
int               l1_bot_cmp, l2_top_cmp;
int               lin1, ix1, lin2, ix2, minlin1, maxlin2;
long              lastlin = current->sctopl + scrowmax - 1;
SCQUE             *lstpscq;
register SCQUE    *pscq;

minlin1 = scmsgrow;
maxlin2 = -1;

for (pscq = scqbeg.next, lstpscq = &scqbeg;
     (pscq != NULL) && ((n != 0) || isREF);
     lstpscq = pscq, pscq = pscq->next)
  if (pscq->what == what)
    {
    going = n != 0;

    l1_top_cmp = VECCMP(pscq->lin1, 0, current->sctopl, 0);
    l1_bot_cmp = VECCMP(pscq->lin1, 0, lastlin, 0);
    l2_top_cmp = VECCMP(pscq->lin2, 0, current->sctopl, 0);
    l2_bot_cmp = VECCMP(pscq->lin2, 0, lastlin, 0);

    if (doit = ((l1_top_cmp >= 0) && (l1_bot_cmp <= 0)) ||
               ((l2_top_cmp >= 0) && (l2_bot_cmp <= 0)) ||
               ((what != SC_OPC) && ((l1_top_cmp <= 0) &&
               (l2_bot_cmp >= 0))))
      {
      CLIP(what, lin1, ix1);
      CLIP(what, lin2, ix2);
      if (isREF)
        {
        if ((doit = (lin1 < minlin1)) && going)
          minlin1 = lin1;
        if ((lin2 > maxlin2) && (doit = YES) && going)
          maxlin2 = lin2;
        }

      if (doit && going && (isREF || (pscq->repeat != 0)))
        {
#ifdef BUFSTDOUT
        if (lin2 > lin1)
          bufstdout(YES);
#endif
        callscr(pscq, lin1, ix1, lin2, ix2);
        n--;
        }
      }

#ifdef BLOCKSTDIN
    if (!just_testing && (going || !doit))
      pscq = scqdel(lstpscq);
#else
    if (going || !doit)
      pscq = scqdel(lstpscq);
#endif
    }

return(n);
}

scqmash()

{
register SCQUE    *who, *pscq;
register SCQUE    *lstwho, *lstpscq;

for (lstwho = &scqbeg, who = scqbeg.next;
     who != NULL;
     lstwho = lstwho->next, who = lstwho->next)
  for (lstpscq = who, pscq = who->next;
       pscq != NULL;
       lstpscq= lstpscq->next, pscq = lstpscq->next)
    if (pscq->bp != current)
      pscq = scqdel(lstpscq);
    else if ((pscq == who) || (pscq->what != who->what))
      continue;
    else if (inrange(who, lstwho, pscq, lstpscq))
      break;

return;
}

void scqopc(lines, lin1)

register int      lines;
int               lin1;

{
scqadd(SC_OPC, lines, (long)lin1, 1, -1L, 1, NULL, NULL);
if (lines > 0)
  scqref(scrowmax - lines, 1, -1, MAXLINE);
else
  scqref(lin1, 1, lin1, MAXLINE);

return;
}

void scqscr(lines)

int     lines;

{
scqadd(SC_SCR, lines, 1L, 1, -1L, MAXLINE, NULL, NULL);

return;
}

void scqref(lin1, ix1, lin2, ix2)

int     lin1, ix1, lin2, ix2;

{
scqadd(SC_REF, 1, (long)lin1, ix1, (long)lin2, ix2, NULL, NULL);

return;
}
