/* *********************************************************************
 * 
 * $Header:  001  11-OCT-88 14:09  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)RANGE.C                                     $
 * 
 *      Rev  001  11-OCT-88 14:09  GANN      GANN     
 *  Version control header added                                        
 */
/* 
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"

static byte rangeok;
static byte sawcolon;

extern byte *sea_buf;

long isnum();

/*---------------------------------------------------------------------
 * ISRANGE looks to see if text to be parsed in the command line
 *    is a valid range.
 *    If true the range values are placed in ranges and a true
 *    value is returned
 *
 * Argument;
 * Range *rp;
 * int newok;  (* ok to create new buffer *)
 */

int isrange(rp, newok)

register Range *rp;
int newok;

{
    register int cddelta;
    byte  nobufspec;

    rangeok = rp->c0 = rp->c1 = 1;
    rp->str = NULL;

    if(nobufspec = (rp->bp = getbufn(newok)) == NULL)
        rp->bp = current;

    stpblkcd();
    cddelta = cmndptr;

    if (morecmnd())
        getrange(rp);

    if (!(cddelta -= cmndptr)) /* Did pointer change? */
        if (nobufspec)  /* No. Was a buffer specified? */
            rgsetcur(rp);  /* No. Use current line */
        else   /* Yes */
    {   /* Whole buffer */
        rp->l0 = 1L;
        rp->l1 = EOB;
        rp->c0 = rp->c1 = 1;
    }

    return(rangeok & (cddelta || !nobufspec));
}

/*---------------------------------------------------------------------
 * GETRANGE tries to used the current postion in the cmndbuf as a range
 *   no or invalid ranges are shown thru a character used return of 0
 *
 * Arguments;
 *
 * char *p;  - pointer to command string
 * Range *rp; - range value to be determined
 */

getrange(rp)

register Range *rp; /* range value to be determined */

{
    register Bufctl *bp = rp->bp;
    long  absrow;

    absrow = bp->line1is + bp->curlin;

    if (cmndbuf[cmndptr] == '%')
        cmndptr++; /* skip over range indictor */

    if (isword(lw[S_WHOLE].kw, 1))
    {
        rp->l0 = 1L;
        rp->l1 = EOB;
    }
    else if (isword(lw[S_BEFORE].kw, 3))
    {
        rp->l0 = 1L;
        rp->l1 = absrow;
    }
    else if (isword(lw[S_REST].kw, 1))
    {
        rp->l0 = absrow;
        rp->l1 = EOB;
    }
    else if (isword(lw[S_SELECT].kw, 1))
        rangeok = rangeselect(rp);
    else
    {
        if (getsr1  (rp, 0))
            getsr2  (rp);
        if (rp->l1 <= rp->l0)
            rp->l1 = rp->l0 + 1;
    }

    return;
} /* end getrange */

/*---------------------------------------------------------------------
 * GETSRAN1 selects first half of a possible range
 *
 * Arguments;
 * Range *rp; - range pointer
 * int ind; - 0 = start of range, 1 = end
 */

int getsr1  (rp, ind)

register Range *rp;
int  ind;

{
    register Range *bt = bbctemp;
    register Bufctl *bp = rp->bp;
    long  rplin, temp;
    Pchar  q;
    register int dir;
    int  rpchr;
    int  oldcmndptr;
    extern char stringnotfound[];

    rpchr = 1;
    q = stpblkcd();
    oldcmndptr = cmndptr;
    rplin = bp->curlin + bp->line1is;

    if (isword( ".", 1 ))
        rpchr = bp->curchr;
    else if (isword(lw[S_BEGIN].kw, 3))
        rplin = 1;
    else if (isword(lw[S_END].kw, 1))
        {
        if (bp->totlines)rplin = bp->totlines;
        else rplin = EOB;
        }
    else if (isword(lw[S_LAST].kw, 1))
    {
        bp = rp->bp = lastbuf;
        rplin = bp->line1is + bp->curlin;
    }
    else if ((*q == '\'') || (*q == '"') ||
        (strnicmp(q, "-'", 2) == 0) ||
        (strnicmp(q, "-\"", 2) == 0))
    {
        if( *q != '-' )
            dir = '+';
        else
        {
            dir = '-';
            q++;
        }

        if (isentity(&q) != E_SEA)
            return(NO);

        incptr(q);

        bt->bp = current;
        bt->c0 = bt->c1 = 0;
        bt->l0 = bt->l1 = 0;

        if (!findstr(bt, sea_buf, dir))
            rangeok = cmnderr(stringnotfound);
        else
        {
            rplin = bt->l0;
            rpchr = bt->c0;
        }
    }

    if (!(sawcolon = isword(":", 1)))
    {
        stpblkcd();
        if ((cmndbuf[cmndptr] == '+') || (cmndbuf[cmndptr] == '-'))
            rplin += isnum();
        else if ((temp = isnum()) != 0L)
            rplin = temp;
        sawcolon = isword(":", 1);
    }

    if (ind)
    {
        rp->c1 = 1;
        rp->l1 = rplin + 1;
    }
    else
    {
        rp->c0 = rpchr;
        rp->l0 = rplin;
    }

    return(cmndptr != oldcmndptr);
} /* end of getsr1   */

/*---------------------------------------------------------------------
 * GETSRAN2 selects second half of a possible range
 *
 * Arguments;
 * Range *rp; - range pointer
 * int ind;  - 1 = end of range
 */

getsr2  (rp)

register Range *rp; /* range pointer */

{
    if (sawcolon || isword("THRU", 4))
    {
        if (!getsr1  (rp, 1))
            rp->l1--;
    }
    else if ((isword("#", 1)) || (isword("FOR", 3)))
        rp->l1 = isnum() + rp->l0;
    else
        rp->l1 = rp->l0 + 1;

    return;
} /* end of getsr2   */

int rangeselect(rp)

register Range *rp;

{
    register Bufctl *bp = rp->bp;
    extern char noselrangeact[];

    if (bp->selrow < 0)
        return(cmnderr(noselrangeact));

    if (noscreen)
        redraw = YES;

    if (absrow < bp->selrow)
    {
        rp->l0 = absrow;
        rp->l1 = bp->selrow + (bp->selcol > 1);
    }
    else
    {
        rp->l0 = bp->selrow;
        rp->l1 = absrow + (bp->curchr > 1);
    }

    qqdesel();  /* Get rid of select range */
    return(1);
}

/* getbname - Get a buffer name from the given string.
 *
 * p - A pointer to the string pointer (updated beyond name
 *    on exit)
 * newbuf - A flag to indicate what kind of parsing to do.
 *      -2 - Don't look for '=' or "BUFFER", but create new buffer
 *           if appropriate
 *      -1 - Same as above, but never create new buffer
 *       0 - Look for '=', or "BUFFER", but don't create new buffer
 *       1 - Look for '=', or "BUFFER", create new buffer if needed
 *       2  - Look for '=', create new if appropriate
 *
 * Returns
 * p is updated to point beyond buffer string
 *    (or at least beyond leading space)
 * Return value is a pointer to buffer found, NULL if doesn't work.
 */

BUFCTRL *getbname(p, newbuf)

Pchar  *p;
int  newbuf;

{
    register Bufctl **u;
    register Pchar p1;
    register byte *a;
    extern byte nkerr;

    p1 = *p = stpblk(*p);
    if (newbuf < 0)
        /* Don't look for buffer signifier, "=", or "BUFFER" */;
    else if (*p1 == '=')
        p1++;
    else if (newbuf == 2)
        return(nkerr ? NULL : paste); /* Nokey call */
    else if ((strnicmp(lw[S_BUFFER].kw, p1, lw[S_BUFFER].kl) != 0) ||
        ((p1 = strpbrk(p1, " \t")) == NULL))
        return((Bufctl *)NULL);
    p1 = stpblk(p1);

    for (a = tmplin; MEMCHR(" \t;", *p1, 4) == NULL; a++, p1++)
        *a = *p1;

    if (nkerr || (a == tmplin))
        return(NULL);

    if (a[-1] == '.')
        a--;

    *a = '\000';

    for (u = user; *u != NULL; u++)
        if ((*u)->bufnam == NULL)break;
        else
            if (strnicmp((*u)->bufnam, tmplin, MAXLINE) == 0)
                goto byebye;

    if ((newbuf == -1) || (newbuf == 0))
        return(NULL);
    else
        /* initbuf will add on end of list */
        initbuf(NEWIT, LNULL, tmplin);

byebye:
    *p = p1;
    return(*u);
}

Bufctl *getbufn(flag)

int flag;

{
    Pchar  p = cmndbuf + cmndptr;
    register Bufctl *bp;

    bp = getbname(&p, flag);
    incptr(p);

    return(bp);
}
