/* *********************************************************************
 *
 * $Header:  004  02-JUL-91 19:04  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)LIBRARY.C                                   $
 * 
 *      Rev  004  02-JUL-91 19:04  GANN      GANN                       
 * Changed summary message to not append a semi-colon if the            
 * output filename already has a semi-colon in it.                      
 * This is for the VNUMBER option.                                      
 *
 *      Rev  003  09-APR-91 14:03  GANN      GANN
 * Changed show buffer command so that it tells you whether the buffer
 * has been modified or not.
 *
 *      Rev  002  20-DEC-90 10:08  GANN      GANN
 * Changed TSTCC to not call doclock.  This was not needed and
 * causes some additional overhead when edt it looking through
 * buffers.
 *
 *      Rev  001  11-OCT-88 14:08  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"
#include "errno.h"

extern byte eraworking;
extern long lines_typed;
extern byte nkerr;
extern int lrow, lcol;
extern int * infcb;
extern Pchar dclfile();

/*---------------------------------------------------------
 *
 * add the extension (2nd argument) to file name (1st agr)
 */

addext(fname, fext, ret)

Pchar  fname, fext, *ret;

{
#ifndef UNIX
    register Pchar p;

    if (((p = strrchr(fname, '.')) != NULL) && (p[1] != *dir_sep))
        *p = '\000';
#endif

    mest2cpy(ret, fname, fext);
    strupr(*ret);

    return;
}

/* BAILOUT is used to write a journal and stop execution right now!! */
bailout(p)

Pchar p;

{
    extern int errno;

    offshift();        /* reset terminal */
    cprintf("\r\n\n");
    showmem();
    cprintf("\r\n%s\r\n", p);

    perror("System Error");

    cprintf("\rThe /RECOVER option may reclaim your edits (%d)\r\n",
    errno);

    qqbell();
    writejou(YES);
    exit(0);   /* no error for MPX */
}

/* ERROUT is used to write a journal and stop execution right now!! */
errout()

{

    offshift();        /* reset terminal */
    cprintf("\r\n\n");
    cprintf("\rSYSTEM ERROR\n");
    cprintf("\rThe /RECOVER option may reclaim your edits\r\n");
    qqbell();
    writejou(YES);
    exit(0);   /* no error for MPX */
}

bbcsys(p)

char *p;

{
    register int i;
    register int flag = 0;
    char *args[20];
    extern Pchar shell;

    strcpy(tmplin, p);

    for (i = 0; (args[i] = (char *)strtok(i ? NULL : tmplin, " \t"))
	    != NULL; i++) ;

    dowork(NO);

    lrow = lcol = 1;
    scmovcur(scmsgrow, 1);
    *infcb ^= 0x20500000;

        if (spawnvp(0, args[0], args) < 0)
            {
                flag = 1;
                cmnderr("Bad command or file name");
            }

    lrow = lcol = 1;
    scmovcur(scmsgrow, 1);
    *infcb |= 0x20500000;

    dowork(YES);

    return(flag);
}

/*------------------------------------------------------------------
 * CLEARBOT clears the bottom two lines on the screen, possibly
 *     displaying any expository message set by the FC.EXE
 *     program.
 * Argument:
 * int clrerr - YES if error row should be erased
 */

void clearbot(clrerr)

int  clrerr;

{
    extern Pchar qqmore;  /* More messages after qqserial */

    scprintf(scmsgrow, 1, qscolor, "%s", qqmore);

    if (clrerr)
        clrlines = !ERAEOL(scerrrow, 1);

    scposcur(0, 0);

    return;
}

/*------------------------------------------------------------------
 * CMNDERR handles error output for line mode commands
 *
 * Arguments
 *
 *   astr = the text string to be output
 *------------------------------------------------------------------
 */

int cmnderr(astr)

Pchar astr;

{
    dowork(NO);

    cprintf("\r\n%*c\n", 1 + comprom + cmndptr, '^');
    scprintf(scerrrow, 1, qecolor, "%s", astr);
	if (qterm == 1)
		scmovcur (scmsgrow, 1);
    cmndptr = cmndend;
    qhit = YES;
    clearlrn(0);  /* Clear any EXECUTING learn command */

    dowork(YES);
    return(NO);
} /* end cmnderr */

void dispvers()

{
    cprintf("\r\n%s; %s", qqserial, qversion);
    lines_typed++;
    return;
}

/*  Write the error in the command line and return to current postion
 */

/*VARARGS*/
int errorout(cmnd, arg1, arg2)

Pchar cmnd, arg1, arg2;

{
    if (!nkerr)
    {
        /* eraworking = NO; */
        dowork(NO);
        scprintf(scerrrow, 1, qecolor, cmnd, arg1, arg2);
        nkerr = YES;
        qqbell();
    }

    clearlrn(0);  /* Clear any EXECUTING learn */
    return(0);
}

char *filecmnd()

{
    register Pchar p;
    Pchar  filename, ptr;
    register int len;
    extern Pchar mpxfile();
    extern Pchar getpath();
    char c;

    if (!morecmnd())
    {
        cmnderr("File name must be specified");
        return(NULL);
    }

    p = stpblkcd();
    if ((ptr = strpbrk(p, " \t")) != NULL)
            len = ptr - p;
        else
            len = strlen(p);

    c = p[len];
    p[len] = 0;
    ptr = filename = mpxfile(p);
    if (strrchr(filename, ')') == NULL) {
        filename = getpath(filename);
        FREE (ptr);
    }

    p[len] = c;
    cmndptr += len;

    return(filename);
}

int fndntok(p, delim, n)

register Pchar  p, delim;
int  n;

{
    Pchar  endp;
    Pchar  inip = p;
    int  i;
    static byte glump[256];

    if (n == 0)
        return 0;

    MEMSET(glump, '\000', 256);

    while (*delim)
        glump[*delim++] = YES;

    i = sign(n);
    endp = p + n;

    while (!(glump[*p] || (p == endp)))
        p += i;

    return(p - inip);
}

void foerr(module, fname)

Pchar module, fname;

{
    sprintf(actlin, "Error in module %s opening file(%u) \"%s\"",
       module, dclfile(fname), dclfile(fname));
    bailout(actlin);
}

void fwerr(what)

Pchar what;

{
    sprintf(actlin, "Error writing %s file", dclfile(what));
    bailout(actlin);
}

int getbufl(bp)

BUFCTRL  *bp;

{
    register BUFCTRL **u;

    for (u = user; *u != NULL; u++)
        if (*u == bp)
            return(u - user);

    return(-1);
}

/*---------------------------------------------------------------------
 * Allocates (and possibly copies old line to) a new line.
 *
 * Arguments:
 * LINE  *frline - the old line (if any)
 * int   flag - 0 - Free memory
 *     1 - Reallocate
 *     2 - Duplicate old
 *     3 - Allocate new
 * int   newlen - the new length
 *
 * Returns:
 * Returns the pointer to the new line.
 * Frees up memory if reallocation necessary, and sets length.
 *---------------------------------------------------------------------
 */

#define LSIZEOF(n) (1 + (n) + sizeof(LINE) - MAXLINE)

LINE *getline(flag, newlen)

int flag;
int newlen;

{
    register LINE *toline;
    register LINE **cline;

    for (;;)
    {
        switch (flag)
        {
        case NEWIT:
            if ((toline = (LINE *)MALLOC(LSIZEOF(newlen))) == LNULL)
                break;

            toline->len = newlen;
            return(toline);

        case REALIT:
            cline = current->buf + (int)(absrow - current->line1is) - 1;
            if ((toline = (LINE *)REALLOC(*cline, LSIZEOF(newlen)))
                == LNULL)
            {
                if ((*cline = (LINE *)HEYrealloc(*cline,
                        LSIZEOF((*cline)->len))) == NULL)
                    memerr("getline", LSIZEOF((*cline)->len));
                break;
            }

            *cline = toline;
            toline->len = newlen;
            toline->lin[newlen] = '\000';
            return(toline);
        }

        if (loadflag)
            return(LNULL);


        FREE(reallmem(LSIZEOF(newlen)+10));
    }
}

char *getstr()

{
    int  marker;
    register Pchar p, q;

    p = stpblkcd();
    if ((*p == '\'') || (*p == '"'))
        marker = *p;
    else
        return(NULL);

    if ((q = strchr(++p, marker)) == NULL)
        return(NULL);

    *q = 0;
    incptr(++q);

    return(p);
}

int helpscreen()

{
    scmovcur(0, 0);  /* Reset internal row/col variables */
    if (!helpmain(NULL))
            return(0);

    errorout("Help file \"%s\" could not be found", dclfile(helpfile));
    return(1);
}

long isnum()

{
    long  retval;
    Pchar  p;
    register Pchar q;

    (isword(":", 1) || isword("=", 1)); /* Step over delimiter, if any */
    q = cmndbuf + cmndptr;
    retval = strtol(q, &p, 10);  /* Convert to long int, update p */
    cmndptr += p - q;   /* Point beyond number */

    return(retval);
}

isoption(o1, v1, o2, v2, o3, v3)

byte o1, o2, o3;
int *v1, *v2, *v3;

{
    register int i = 0;
    int  *v[3];
    byte  o[3];

    if ((v[0] = v1) != NULL)
        *v1 = 0;

    if ((v[1] = v2) != NULL)
        *v2 = 0;

    if ((v[2] = v3) != NULL)
        *v3 = 0;

    o[0] = o1;
    o[1] = o2;
    o[2] = o3;

    while (morecmnd() && i < 3)
        for (i = 0; i < 3; i++)
            if (o[i] && isword(lw[o[i]].kw, lw[o[i]].kl))
            {
                *v[i] = (isword(":", 1) || isword("=", 1))
                                ? (int)isnum() : YES;
                break;
            }

    return;
} /* isoption end */

/*------------------------------------------------------------------
 * ISWORD compares astr to cmndbuf[cmndptr] if match increment cmndptr
 *
 * Arguments
 *
 *    astr = pointer to word that is to be compared to command line
 *    slen = length of minimum comparision
 */
isword(astr, slen)

Pchar astr;
int slen;

{
    int      ichk;
    register Pchar spa, don;

    don = spa = stpblkcd();

    if (isalpha(*spa))
        while (isalnum(*don) || (*don == '_'))
            don++;
    else if (isdigit(*spa))
        while (isdigit(*++don))
            continue;
    else if ((*spa == '/') || (*spa == '.'))
        while (isalpha(*++don))
            continue;
    else if (ispunct(*spa))
        don++;
    else
        return(0);

    if ((ichk = don - spa) < slen)
        ichk = slen;

    if (strnicmp(spa, astr, ichk) == 0)
    {
        incptr(don);
        return(YES);
    }

    return(NO);
} /* end isword */

/*---------------------------------------------------------------------
 * linelen - Determine length of arbitrary line in file.  Positions
 *      using chkshft to assure line is in memory.
 *
 * Argument:
 * inrow - The row (line) in question
 *
 * Output:
 * The length of the line.  Current position is (should be?) unchanged.
 *
 *---------------------------------------------------------------------
 */
int linelen(inrow)

long inrow;

{
    register int len;

    len = chkshft(current, inrow)->len;
    scsetcur(USEBUF, 0, 0);

    return(len);
}

/*VARARGS */
lmprintf(fmt, arg1, arg2, arg3, arg4)

Pchar fmt, arg1, arg2, arg3, arg4;

{
    cprintf("\r\n");
    /*scmovcur(scerrrow, 1);*/
    scprintf(-1, -1, qcolor, fmt, arg1, arg2, arg3, arg4);
    lines_typed++;
}

void memerr(module, size)

Pchar  module;
unsigned size;

{
    sprintf(actlin, "Memory allocation error in %s, %u bytes",
       module, size);
    bailout(actlin);
}

/*---------------------------------------------------------
 * MEST2CPY releases memory space taken by dest. allocates
 * new space then copy source into it
 * Returns pointer to new dest.
 */
mest2cpy(d, s1, s2)

register Pchar *d;
Pchar  s1, s2;

{
    int      l1 = 0;
    Pchar    e = *d;

    if (s1 != NULL)l1 = strlen(s1);
    *d = (char *)HEYzeromem(l1 + strlen(s2) + 1);
    if (*d == NULL)
        memerr("mest2cpy", l1 + strlen(s2));

    if (l1 != 0)
        strcpy(*d, s1);

    strcpy(*d + l1, s2);

    if (e != NULL)
        FREE(e);

    return;
} /* end of MEST2CPY */

/*---------------------------------------------------------
 * MESTRCPY releases memory space taken by dest. allocates
 * new space then copy source into it
 */
mestrcpy(d, s)

register Pchar *d;
Pchar  s;

{
    if (*d != NULL)
        FREE(*d);

    if ((*d = strdup(s)) == NULL)
        memerr("mestrcpy", strlen(s));

    return;
} /* end of MESTRCPY */

/* Check for more characters to process on the line */

morecmnd()
{
    stpblkcd();
    return((cmndptr < cmndend) && (cmndbuf[cmndptr] != ';'));
}

/*---------------------------------------------------------------------
 * outlin write to device given range of lines
 *
 * Arguments:
 *      FILE    *fp             - file to be written
 *      struct  rangestr *rp    - range to to written
 *      int     beg, inc        - if true line numbers at BEGin and
 *                                   INCrecment
 *      int     outl            - brief qualifier
 * int priflag  - if true form feed every 60 lines
 */
outlin(fp, rp, beg, inc, outl, priflag)

FILE    *fp;
register RANGESTR *rp;
long    beg;
int     inc, outl, priflag;

{
    byte  doeob;
    long  i;
    long  begoff;
    int  numlen = (beg && qnumber) ? 12 : 0;
    int  thislen;
    register LINE   *lp;
    BUFCTRL  *bp;

    begoff = beg - rp->l0;
    i = rp->l0;
    bp = rp->bp;
    doeob = YES;

    if (fp == stderr)
        dowork(NO);

    if (bp->totlines > 0)
        while (i < rp->l1)
        {
            BKGRND;

            if (doeob = ((lp = chkshft(bp, i)) == LNULL))
                break;
            thislen = outl ? min(outl, lp->len) : lp->len;

            if (fp == stderr)
                lines_typed += 1 + ((numlen + thislen) >= realcolmax);

            if (numlen != 0)
                fprintf(fp, "%8ld    ", i * ((long)inc) + begoff);

            fwrite(lp->lin, 1, thislen, fp);
/*          fwrite("\r\n", 1, 2, fp);  */
            fwrite("\n", 1, 1, fp);

            i++;

            if (priflag && ((i % 60) == 0))
                fprintf(fp, "\014\n\n");
        }

    if (fp == stderr)
    {
        if (doeob && !qmacro)
            fprintf(fp, "%s\r\n", qtxtend), lines_typed++;
        scmovcur(0, 0);    /* Unset internal flags */
		if (qterm == 1)
	        scmovcur(truerow = scmsgrow, truecol = 1);
		else
	        scmovcur(truerow = scerrrow, truecol = 1);
        dowork(YES);
    }

    return;
} /* end of outlin */

void qqgoto(inrang)

register Range *inrang;

{
    register Bufctl *bpcur;
    Bufctl  *savebuf = current;

    bpcur = current = inrang->bp;

    if (bpcur == NULL)
        current = maine;

    if (savebuf != bpcur)
        lastbuf = savebuf;

    chkshft(bpcur, inrang->l0);
    inrang->l0 = bpcur->line1is + bpcur->curlin;
    inrang->l1 = inrang->l0 + 1;
    bpcur->curchr = inrang->c0;
    return;
}

void rgsetcur(inrang)

register RANGESTR *inrang;

{
    inrang->bp = current;
    inrang->l0 = current->line1is + row;
    inrang->l1 = inrang->l0 + 1;
    inrang->c0 = col;
}

/* rst_all - Pop all the way back to the command loop,
 *      setting all necessary stuff to a known (cleared) state.
 */

void rst_all()

{
    extern jmp_buf cmd_loop;
    extern char *repcount, repstore[];

    dowork(NO);   /* Turn off "Working" indicator */
    keep_alive = NO;  /* Don't even THINK of working */
    holdit = 1;   /* Virgin state */

    gold = noscreen = clrlines = NO; /* eraworking = NO; */
    qdcolor = qcolor;

    cmndbuf[0] = *(repcount = repstore) = '\000';

    scsave(-1); /* Pop entire stack */
    if (current != NULL)
        frccur(current, 0, 0);

    if (qmode)
        clearbot(YES);  /* Clear bottom two lines */

    longjmp(cmd_loop, 1);  /* Back to input loop */
}

void setlinmax()
{
    extern int eralinmax[];
    int *p;
    int i;

    for (p = eralinmax, i=0; i < MAXSCROW; i++)*p++ = 0xff;
    return;
}

void setrowcol(therow, thecol)

int    *therow, *thecol;

{
register Byte2 rowcol;

rowcol = scmovcur(-1, -1);     /* get combined row/column info */

*therow = rowcol & 0xff;       /* Low order byte is column */
*thecol = rowcol >> 8;         /* High order byte is row */

return;
}

showlin(t, c1, c2)

long t;
Pchar c1, c2;

{
    if (c1 != NULL)
        if (strrchr(c1, ';') == NULL)                            /*004*/
           lmprintf("%s; ", c1);                                 /*004*/
        else                                                     /*004*/
           lmprintf("%s ", c1);                                  /*004*/
    else
    {
        lines_typed++;
        cprintf("\r\n");
    }

    showln1(t);

    if (c2 != NULL)
        cprintf("%s", c2);

    return;
}

showln1(t)

register long t;

{
    if (t != MAXBUFLINES)
        if (t != 0)
            cprintf("%ld line%s", t, t != 1 ? "s ":" ");
        else
            cprintf("No lines ");
    else
        cprintf("? lines ");

    return;
}

/* SHOWMEM clears the screen displays memory usage stats
*  waits for input, then redraws the test screen
*/
showmem()

{
    register BUFCTRL **u;

    for (u = user; *u != NULL; u++)
    {
        lmprintf("%c%-12s ", (current == *u) ? '=' : ' ', (*u)->bufnam);
        showln1 ((*u)->totlines);
        if ((*u)->modified)                                      /*003*/
            cprintf (" Modified");                               /*003*/
        else                                                     /*003*/
            cprintf (" Unmodified");                             /*003*/
    }

    return;
}

Pchar Stpblk(p)

Pchar p;

{
    extern char whitesp[];

    return(p + strspn(p, whitesp));
}

/* Step cmndptr beyond any whitespace characters */

Pchar stpblkcd()

{
    register Pchar p;

    incptr(p = stpblk(cmndbuf + cmndptr));
    return(p);
}

Pchar Strnzcpy(d, s, n)

register Pchar d;
Pchar  s;
register unsigned n;

{
    if (n != 0)
        MEMCPY(d, s, n);
    d[n] = '\000';
    return(d);
}

#ifndef ISC
FILE *stropen(buf, type, len)

Pchar buf;
Pchar type;
int len;

{
    register FILE *g;
    extern Pchar nulldev;

    if ((g = fopen(nulldev, type)) == NULL)
        return(NULL);

    setbuf(g, buf);
    g->_cnt = len;

    return(g);
}
#endif

void tstcc()
{
    jmp_buf tmp;

/*002     BKGRND;*/
    if (!ctrlc_hit || (to_here[0] == 0))
        return;

    noscreen = ctrlc_hit = nkerr = NO;
    nkerr = errorout("Operation Aborted");
    redraw = YES;
    MEMCPY(tmp, to_here, sizeof(jmp_buf));
    *to_here = 0;

    longjmp(tmp, -1);
}

#define r1hold r1
#undef r1
int veccmp(r1, c1, r2, c2)

long r1, r2;
int c1, c2;

{
    register int retval;

    if (r1 < r2)
        retval = -1;
    else if (r1 > r2)
        retval = 1;
    else if (c1 < c2)
        retval = -1;
    else if (c1 > c2)
        retval = 1;
    else
        retval = 0;

    return(retval);
}
#define r1 r1hold
#undef r1hold

writejou(doeof)

int doeof;

{
	int	i;

    if ((stdwhat != jfp) && (qjournal > 0))
    {
        mpxwrite(jfp, (char *)jourbuf, (journext + 1) * 2, YES);
	    for (i = 0; i <= 256; i++)jourbuf[i] = -1;
        mpxwrite(jfp, (char *)jourbuf, 4, NO);

        if (doeof)
        {
            mpxclose (jfp);
            qjournal = 0;
        }
    }

    journext = 0;
    return;
}
/* Convert a character to uppercase */
int toupper (i_chr)
int i_chr;
{
	if ((i_chr >= 'a') && (i_chr <= 'z'))
		return (i_chr-'a'+'A');
	else
		return (i_chr);
}
/* Convert a character to lowercase */
int tolower (i_chr)
int i_chr;
{
	if ((i_chr >= 'A') && (i_chr <= 'Z'))
		return (i_chr-'A'+'a');
	else
		return (i_chr);
}
