/* *********************************************************************
 *
 * $Header:  005  09-APR-91 13:41  GANN      GANN                      $
 * $Log:   @ISCSRC^(DV.EDT)KEYLIB.C                                    $
 *
 *      Rev  005  09-APR-91 13:41  GANN      GANN
 * Fixed journalling of lines read with a formatted read so that
 * TIE-64 works in line mode.  Now lines read via TIE are written
 * to the journal file.
 *
 *      Rev  004  20-DEC-90 10:08  GANN      GANN
 * Removed two useless calls from doclock.
 *
 *      Rev  003  09-MAY-90 12:43  GANN      GANN
 * Changed getcmnd to do formatted reads when EOL (carriage return)
 * is specified as the terminating character.  This is only when we
 * are in line mode.  getcmnd calls GETCH directly requesting a
 * formatted read.
 *
 *      Rev  002  16-NOV-88 08:56  GANN      GANN
 * Corrected display of the golded count at the bottom
 * of the screen.
 *
 *      Rev  001  11-OCT-88 14:08  GANN      GANN
 *  Version control header added
 */
/*
 */

#include "edt.h"
#include "scio.h"
#include "tokens.h"
#include "signal.h"

#define KEYBUFLEN 128

static int lrn_cnt;

extern byte no_key_buf;
extern char repstore[];
extern char *repcount;
extern Pchar lrn_key;
extern int lrn_rep;
extern Pchar lrn_fp;
char  wscantt();
short fkeyin(), stepjou(), closejou();
int		ignore_learn = 0;

/*---------------------------------------------------------------------
 * getcmnd - Reads the keyboard and fills the command string (cmndbuf)
 *      until either the ASCII xor scan terminator has been read
 *
 * Parameters:
 * asciitrm - The ASCII value to terminate entry on (0 if none)
 * fkey  - Flag: YES if should terminate on function key hit
 *
 * Return:
 * Size of input string
 *---------------------------------------------------------------------
 */

int getcmnd(term)

int  term;

{
    register int siz;
    register int ind;
    static char p[3] = {
        0, 0, 0 };

    siz = 0;
    dowork(NO);

    for (;;)
    {
        if ((stdwhat == stdin) && (term == EOL)) {               /*003*/
/*005             siz = GETCH (YES);                                   */
            siz = linein ();                                     /*005*/
            break;                                               /*003*/
        }                                                        /*003*/

        if ((ind = winkey(term)) == term)
            break;

        cmndbuf[siz++] = ind;

        if ((ind == CTRLZ) && (term > 0)  && !qmode)
            break;

        if (qmacro)
            /* Do nothing */;
        else if (ind == '\025')
            if (qmode)
                rst_all();
            else
                siz = wipe(siz, siz);
        else if (ind == DEL)
            siz = wipe(siz, 2);
        else if (funs[asciival]) {
            siz += xlate(cmndbuf, &asciival, siz);
            ind = asciival;
        }
        else {
            if (ind >= ' ')
                p[0] = ind, p[1] = '\000';
            else
                p[0] = '^', p[1] = ind + ('A' - 1);
            cprintf("%s", p);
        }

        if (siz > MAXLINE)
        {
            cmnderr("Command line exceeded 255 characters");
            break;
        }
    }

/* If televideo, clear the error line	*/

	if (qterm == 1) {
		cputs ("\033h\033f \015");
	}

    cmndbuf[siz] = '\000';

    /*if (!qmacro)
        putch('\r');*/

    dowork(YES);

    return(siz);
}

/*---------------------------------------------------------------------
 * winkey - wait for a keystroke
 *
 * Parameters:
 *  term
 *	        - -2 	return any scancode
 *          - -1	return any non-gold key
 *          - 0		return any scan code < 0X80
 *			- 15	read terminator is  <CR> or ENTER
 *			- 280   read terminator is  ENTER (don't return GOLD)
 *
 * Return:
 * Translated "ind" from keytran
 *---------------------------------------------------------------------
 */

int winkey(term)

register int term;

{
    register int ind;
    Pchar   p;

    dowork(NO);
    ind = keyin();

    if ((p = funs[ind]) == NULL)
        p = "";
	
	switch (term) {

	case -1:

		if (strnicmp (p, lw[S_GOLD].kw, 4) == 0) {
			if ((ind = goldin ()) == -1) /* no scancode found, get one */
				ind = winkey (term);
		}
		break;

	case 0:

        if (strnicmp(funs[ind], "ADV", 3) == 0)
            qdir = 1;
        else if (strnicmp(funs[ind], "BACK", 4) == 0)
            qdir = -1;
		if (ind > 0x7f)
			ind = term;
		break;

	case EOL:

		if ((ind == 13) || (*p == '.')) {
			ind = term;
		}
		break;

	case ENTER:

		if (*p == '.') {
			ind = term;
		}
		else if (strnicmp (funs[ind], lw[S_GOLD].kw, 4) == 0) {
			ind = keyin ();
			if (strnicmp (funs[ind], lw[S_GOLD].kw, 4) != 0) {
				ind += GOLD_OFF;
			}
		}
		break;

	default:

		break;

	}

    dowork(YES);
    return(asciival = ind);
}

/*---------------------------------------------------------------------
 * keyin - Get a character from the keyboard buffer.
 *
 * Parameters:
 * None
 *
 * Return:
 * scanval of key pressed, asciival and scanval set.
 * 0 if no keystrokes in queue
 *---------------------------------------------------------------------
 */

int keyin()

{
    register int ind;

    if (stdwhat != stdin) {
        ind = fkeyin(stdwhat); /* Journal file or learn mode */
		if (ind == 0)
			ind = scantt ();
	}
	else
		ind = scantt();

    /* save to journal file */
          addjrnl (ind);                                         /*005*/

/*005     if (ind) {*/
/*005         jourbuf[journext++] = ind;*/
/*005 	    if (stdwhat != jfp) {*/
/*005 			jourbuf[journext] = -1;*/
/*005 	        if (journext >= 256)*/
/*005 	            writejou(NO);*/
/*005 	        else if (((journext % qjournal) == 0) && (qjournal > 0))*/
/*005 	            mpxwrite(jfp, (char *)jourbuf, 256 * 2, NO);*/
/*005 		}*/
/*005         if (lrn_fp != NULL) {*/
/*005            if ((lrn_fp[1] + 2) > LRNBUFSIZ)*/
/*005  			 errorout("No more room in LEARN buffer - please terminate LEARN");*/
/*005            else {*/
/*005                lrn_fp[lrn_fp[1]++] = (ind >> 8) & 0xff;*/
/*005                lrn_fp[lrn_fp[1]++] = ind & 0xff;*/
/*005            }*/
/*005         }*/
/*005     }*/

    return(ind);
}

/*---------------------------------------------------------------------
 * linein - Get a command line from keyboard                        !005
 *          (Does an unformatted read so TIE-64 works)              !005
 *                                                                  !005
 * Parameters:                                                      !005
 * None                                                             !005
 *                                                                  !005
 * Return:                                                          !005
 * Length of line input.                                            !005
 * 0 if no keystrokes in queue                                      !005
 *---------------------------------------------------------------------
 */

int linein()                                                     /*005*/
                                                                 /*005*/
{                                                                /*005*/
    register int sz, is;                                         /*005*/

    sz = GETCH (YES);                                            /*005*/

    /* save to journal file */

    for (is=0; is<sz;) {                                         /*005*/
       addjrnl (cmndbuf[is++]);                                  /*005*/
    }                                                            /*005*/
    is = 13;      /* carriage return */                          /*005*/
    addjrnl (is);                                                /*005*/
                                                                 /*005*/
    return(sz);                                                  /*005*/
}
/*-----------------------------------------------------------------------
 *  addjrnl        - Add a character to the journal file            !005
 *-----------------------------------------------------------------------
 */
int addjrnl (ind)                                                /*005*/
register int ind;                                                /*005*/
{                                                                /*005*/

    if (ind) {                                                   /*005*/
        jourbuf[journext++] = ind;                               /*005*/
        if (stdwhat != jfp) {                                    /*005*/
            jourbuf[journext] = -1;                              /*005*/
            if (journext >= 256)                                 /*005*/
                writejou(NO);                                    /*005*/
            else if (((journext % qjournal) == 0) &&             /*005*/
                      (qjournal > 0))                            /*005*/
                mpxwrite(jfp, (char *)jourbuf, 256 * 2, NO);     /*005*/
        }                                                        /*005*/
        if (lrn_fp != NULL) {                                    /*005*/
           if ((lrn_fp[1] + 2) > LRNBUFSIZ)                      /*005*/
              errorout("No more room in LEARN buffer - please terminate LEARN");
           else {                                                /*005*/
               lrn_fp[lrn_fp[1]++] = (ind >> 8) & 0xff;          /*005*/
               lrn_fp[lrn_fp[1]++] = ind & 0xff;                 /*005*/
           }                                                     /*005*/
        }                                                        /*005*/
    }                                                            /*005*/

    return;                                                      /*005*/
}                                                                /*005*/
/*---------------------------------------------------------------------
 * keyact - Take action based on a keystroke.  Calls qqnokey with key
 *     translation, or sets gold, or resets if RESET key hit
 *
 * Parameters:
 * None
 *
 * Return:
 * None
 *---------------------------------------------------------------------
 */

int keyact()
{
    register int ind = asciival;
    register Pchar p = funs[ind];
    static char q[2] = {'\0', '\0'  };

    if ((p != NULL) && (*p == 0xff)) {
        lrn_rep = abs(getcount(&repcount, qdir));

/* if not already doing some special key, process a learned key 	*/

        if (stdwhat == stdin) {
	        *(repcount = repstore) = '\000';
	        stdwhat = p;
	        p[2] = 3;      /* reset count */
		}

/* if reading journal, tell qqlrn there is a learn key to ignore	*/

		else if (stdwhat == jfp) {
			if (lrn_rep < 1)
				ignore_learn = 1;
			else
				ignore_learn = lrn_rep;
		}
        return(NO);
    }

    if ((p != NULL) && (strnicmp(p, "RESET", 5) == 0))
        qqreset();
    else if (p != NULL)
        qqnokey(p, YES);
    else {
        q[0] = ind;
        qqnokey(q, NO);
    }

    return(YES);
}

#ifdef MSDOS
/*---------------------------------------------------------------------
 * keybuf - Called by interrupt routine to put keystrokes on the queue.
 *
 * Parameters:
 * None
 *
 * Return:
 * None.  Updates queue if character hit.
 *---------------------------------------------------------------------
 */

void keybuf(keyval)

int keyval;

{
    register int ns = numstate;

    if (keyval == 0x4500)
        setnumlock((ns & 0x8000) ? (ns ^ 0x8020) : ns);

    return;
}
#endif

/*---------------------------------------------------------------------
 * wipe - Erase characters from the screen and from cmndbuf
 *
 * Parameters:
 * siz - The current size of the command string
 * chars - The number of characters to erase
 *
 * Return:
 * The adjusted size of the string
 *---------------------------------------------------------------------
 */

static int wipe(siz, chars)

register int siz, chars;

{
    static Pchar bsstr = (char *)"\b";

    siz--, chars--; /* Step back over character causing this */

    while ((chars > 0) && (siz > 0))
    {
        siz--, chars--;
        cprintf(bsstr);
        if (cmndbuf[siz] < ' ')
            cprintf(bsstr);
    }

    return(siz);
}

/*---------------------------------------------------------------------
 * xlate - Translate function key or gold <key> combination in cmndbuf
 *    to its mapped representation.  Adjusts size.
 *
 * Parameters:
 * cmndbuf - The command string being built
 * ind - The character value
 * siz - The current size of the command string
 *
 * Return:
 * The adjusted size of the string
 *---------------------------------------------------------------------
 */

static int xlate(p, ind, siz)

Pchar  p;
register int *ind, siz;

{
    static int funslen;

    if (!qmode || (ind == 0))
        return(-1);  /* Insert nothing */

    if (strnicmp(funs[*ind], "RESET", 5) == 0)
    {
        ERAEDSP(scerrrow, 1);
        scposcur(scerrrow, 1);
        *ind = 0;
        return(-siz);
    }

    siz--;
    funslen = strlen(funs[*ind]);
    if ((funslen + siz) > MAXLINE)
        funslen = 1 + MAXLINE - siz;

	if ((funslen == 2) && (*funs[*ind] == 'E') && (*(funs[*ind]+1) == 'X'))
		strnzcpy (p += siz, "\032", (funslen=1));
	else if ((funslen == 3) && (*funs[*ind] == 'T')
          && (*(funs[*ind]+1) == 'A')&& (*(funs[*ind]+2) == 'B'))
		strnzcpy (p += siz, "\011", (funslen=1));
	else
	    strnzcpy(p += siz, funs[*ind], funslen);

    for ( ; *p; p++)
        if (*p < ' ')
            cprintf("^%c", *p + ('A' - 1));
        else
            putch(*p);

    return(funslen - 1);
}

/*---------------------------------------------------------------------
 * goldin - Do bottom line repeat count stuff
 *
 * Parameters:
 * asciival - The asciival of key just hit
 *
 * Return:
 * Translated key index.  -1 if doing repeat count.
 *---------------------------------------------------------------------
 */

int goldin ()
{
    register int ind = 0;
	int gotCount = 0, done = 0;

	truecol = 1;
	ERAEDSP (scmsgrow, 1);

	while (!done) {
		ind = keyin ();
		if (ind == DEL) {
			if (repcount > repstore)
				*(--repcount) = '\000';
			if (repcount == repstore) {
				ind = -1;		/* Indicate operation aborted, try again */
				done = 1;
				rst_all();
			}
			else {
    			SCPUTC(scmsgrow, --truecol, ' ', 1, qecolor);
			    SCPUTC(scmsgrow, (truecol-1), *(repcount-1), 1, qecolor); /*002*/
			}
		}
		else if (ind == '\025') {			/* CTRL U */
			*(repcount = repstore) = '\000';
			ind = -1;		/* Indicate operation aborted, try again */
			done = 1;
			rst_all();
		}
		else if (strnicmp (funs[ind], lw[S_GOLD].kw, 4) == 0) {
			ind = goldin ();	/* gold key pressed, start over */
			done = 1;
		}
		else if ((truecol < 9) && (ind >= '0') && (ind <= '9')) {
			if (truecol == 1)
				repcount = repstore;
			*repcount++ = ind;
			*repcount = '\000';
			SCPUTC (scmsgrow, truecol++, ind, 1, qecolor);                /*002*/
			gotCount = 1;
		}
		else if ((truecol == 1) && ((ind == '-') || (ind == '+'))) {
			repcount = repstore;
			*repcount++ = ind;
			*repcount = '\000';
			SCPUTC (scmsgrow, truecol++, ind, 1, qecolor);                /*002*/
			gotCount = 1;
        }
		else {
			if (!gotCount) {				/* Count not entered		*/
				ind += GOLD_OFF;			/* return golded key		*/
			}
			done = 1;
		}
	}

	ERAEDSP(scmsgrow, 1);
	scmovcur (0, 0);
	repcount = repstore;
	return (ind);

} /* end of goldin */

/*---------------------------------------------------------------------
 * fkeyin - Get keystrokes from a (journal) file
 *
 * Parameters:
 * stdwhat - FILE pointer to input file/buffer
 *
 * Return:
 * ASCII value
 *---------------------------------------------------------------------
 */

static firstime=NULL;

short fkeyin()

{
    register FILE *fp = stdwhat;
    Pchar p = (char *)stdwhat;
    short ind;
    extern int firstime;

    if (fp == jfp) {
       if (firstime == NULL) {
            jourbuf[0] = -1;
            firstime++;
            journext = 256 + sizeof(short);
       }
       if (journext >= 256) {
            mpxread (fp, (char *)jourbuf, 256 * 2);
            journext = 0;
       }
       if ((ind = jourbuf[journext]) < 0)
            ind = closejou(fp);

		if (qrecover < 0)
	        /* Do nothing */;
	    else if (--qrecover == 0)
	        ind = stepjou(fp, ind);
    }
	else {
           ind = p[p[2]++];
		   ind = (ind << 8) + p[p[2]++];
    }

    return(ind);
}

short stepjou(fp, ind)

FILE  *fp;
short ind;

{
    char ch;
    int num;
    int point = scmovcur(-1, -1);

    SCPUTC(scerrrow, realcolmax, 260, 1, qcolor);

    qrecover++;

    ch = wscantt();
    if (ch == CTRLZ)
        ind = closejou(fp);
    else if (isdigit(ch))
    {
        num = ch - '0';
        while (isdigit(ch = wscantt()))
            num = (num * 10) + (ch - '0');
        if ((qrecover = num) == 0)
            qrecover = -1;
    }

    SCPUTC(scerrrow, realcolmax , ' ', 1, qcolor);
    scmovcur(point >> 8, (byte)point);

    return(ind);
}

char wscantt()

{
    char ch;

    while ((ch = scantt()) == 0)
        continue;

    return(ch);
}

short closejou(fp)

register FILE *fp;

{
    Pchar p = (char *)fp;

    jourbuf[journext] = -1;
    mpxback (fp);      /* back up to last block read */
    mpxwrite (fp, (char *)jourbuf, (journext + 1) * 2, NO);

    redraw = YES;

    stdwhat = stdin;

    return(gold = qrecover = 0);
}

static int count = 0;
static int * cintc = (int *)0x80c; /* c.intc int count */
static int * cmtim = (int *)0xadc; /* c.mtim ints/sec */
byte eraworking;
static int lastcnt=0;

void dowork(onwork)

byte  onwork;

{
    extern byte working;
    extern int lastcnt;
    extern int *cintc;
    int  doclock();

    if (!working || !keep_alive)
        return;   /* No working wanted */

    if (!onwork)
    {
        holdit = 1;
/*004         alarm(0);*/
        if (eraworking)
               ERAEOL(scerrrow, WORKCOL);
        count = eraworking = 0;
    }
    else
    {
        if (--holdit < 0)
            holdit = 0;
/*004         alarm(1);*/
        lastcnt = *cintc;
        doclock();
    }

    return;
}

/*---------------------------------------------------------------------
 * doclock - Display the handy-dandy working msg at the bottom of the
 *      screen, if appropriate
 *
 * Parameters:
 * None
 *
 * Return:
 *
 *---------------------------------------------------------------------
 */

int doclock()

{
    extern int *cintc;
    extern int *cmtim;
    int seconds, currcnt;

/*004     signal(SIGALRM, doclock);*/
/*004     alarm(1);*/
    if (holdit)
        return;

    currcnt = *cintc;
    if (lastcnt > currcnt)lastcnt = currcnt;
    if ((currcnt - lastcnt) < *cmtim)return;

    lastcnt = currcnt;

    if (eraworking)
        SCSCR(0, scerrrow, WORKCOL, scerrrow, WORKCOL + 7);
    else
    {
        scmovcur(scerrrow, WORKCOL);
        cputs("Working");
    }

    scmovcur(truerow, 1);

    eraworking = !eraworking;

    return;
}
