  @  /*~!malloc.c*/  */* Name:  malloc.c Part No.: _______-____r *  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:malloc.c	1.1"                @  #include "values.h"     #define NDEBUG  #ifdef debug  
#undef NDEBUG 
 #endif     #include <assert.h>     
#undef malloc 
 #undef free  #undef realloc     /*	avoid break bug */  #define GRANULE 0     ;/* this make the assumption that MAXINT is one less than an ;    even block */  !#define MAXALLOC (MAXINT-BLOCK+1) !    /*      C storage allocator   *	circular first-fit strategy  < *	works with noncontiguous, but monotonically linked, arena < 6 *	each block is preceded by a ptr to the (pointer of) 6  *	the next following block  ( *	blocks are exact number of words long ( 1 *	aligned to the data type requirements of ALIGN 1 * *	pointers to blocks must have BUSY bit 0 * ' *	bit in ptr is 1 for busy, 0 for idle '       @  0 *	gaps in arena are merely noted as busy blocks 0 : *	last block of arena (pointed to by alloct) is empty and :  *	has a pointer to first  0 *	idle blocks are coalesced during space search 0  *  2 *	a different implementation may need to redefine 2 " *	ALIGN, NALIGN, BLOCK, BUSY, INT " ; *	where INT is integer type to which a pointer can be cast ; */     #define INT int     #ifdef gould  #define ALIGN double  #else  #define ALIGN int  #endif     #define NALIGN 1   #define WORD sizeof(union store)      *#define BLOCK 1024	/* a multiple of WORD*/ *    4#define MAXUNINT	0xf80000	/* max memory int value	*/ 4 /*  < * MAXNBYTES is the maximum value that nbytes can be and not <                                                  @  @ * have overflow during the execution of the malloc calculations @  */  E#define MAXNBYTES	(int)(((MAXUNINT/BLOCK) * (BLOCK/WORD) - 2) * WORD) E #define BUSY 1  #define NULL 0  ##define testbusy(p) ((INT)(p)&BUSY) # 1#define setbusy(p) (union store *)((INT)(p)|BUSY) 1 4#define clearbusy(p) (union store *)((INT)(p)&~BUSY) 4    
union store { 
 	union store *ptr;  	ALIGN dummy[NALIGN];  4	int calloc;		/*calloc clears an array of integers*/ 4 };     extern char *sbrk(), *memcpy();     /static union store allocs[2];	/*initial arena*/ / *static union store *allocp;	/*search ptr*/ * )static union store *alloct;	/*arena top*/ ) 6static union store *allocx;	/*for benefit of realloc*/ 6                                                        @  Astatic union store *allocend;	/*the last block, if it is free, or A 				  *alloct */     char *  malloc(nbytes)  int nbytes;  {  	register union store *p, *q;  	register int nw;  	register int temp;  	register int incr = 0;  	int sav_temp;  
	int one = 1; 
 	int maxalloc = MAXALLOC;     	if (nbytes > MAXNBYTES)  		return (NULL);     )	if(allocs[0].ptr == 0) {		/*first time*/ ) &		allocs[0].ptr = setbusy(&allocs[1]); & &		allocs[1].ptr = setbusy(&allocs[0]); & 		alloct = &allocs[1];  		allocp = &allocs[0];  		allocend = alloct;  	}   	nw = (nbytes+WORD+WORD-1)/WORD;   .	assert(allocp >= allocs && allocp <= alloct); . 	assert(allock());  	for(p=allocp; ; ) {  		for(temp=0; ; ) {                               @  			if(!testbusy(p->ptr)) {  '				while(!testbusy((q=p->ptr)->ptr)) { ' !					assert(q > p && q < alloct); ! 					allocp = p;  					p->ptr = q->ptr;  %					if (allocend == q) allocend = p; % 				}  				if(q >= p+nw && p+nw >= p)  					goto found;  			}  				q = p; 	 			p = clearbusy(p->ptr);  			if(p > q)  				assert(p <= alloct);  (			else if(q != alloct || p != allocs) { ( '				assert(q == alloct && p == allocs); ' 				return(NULL);  			} else if(++temp > one)  
				break; 
 		}   		/* set block to search next */   		p = allocend;  		q = (union store *)sbrk(0);  		if (q != alloct+1)  {  +			/* the addition must be done in words to + /			   prevent overflow.  Also, use temporaries, /                                       @  /			   since order of operations may be changed, / 			   otherwise. */  -			temp = ((nw+BLOCK/WORD - 1)/(BLOCK/WORD)); - 			temp = temp * BLOCK;  			if (((INT)q%WORD) != 0)  {  				incr = (WORD-(INT)q%WORD);  *				q = (union store *)((char *)q + incr); * 				temp += incr;  			}  		}  else  {  #			temp = nw - (alloct - allocend); # +			temp = ((temp+BLOCK/WORD)/(BLOCK/WORD)); + 			temp = temp * BLOCK;  		}  &		if(((int)q)+temp+GRANULE < (int)q) { & 			return(NULL);  		}  		  		sav_temp = temp;  		if (temp > maxalloc)  {  $			if ((INT)sbrk(maxalloc) == -1)  { $ 				return NULL;  			}  			temp -= maxalloc;  		}  #		if((INT)sbrk((int) temp) == -1) { # 3			brk((char *)q - incr);   	/* move brkval back */ 3                 @  			return(NULL);  		}  		allocend = q;  		assert(q > alloct);  		alloct->ptr = q;  2		/* must subtract incr, since both q and temp had 2 		   incr added */  		q->ptr = (union store *)  (			   ((char *)q + sav_temp - incr) - 1; ( 		if(q != alloct+1)  &			alloct->ptr = setbusy(alloct->ptr); & 		alloct = q->ptr;   		alloct->ptr = setbusy(allocs);   		q = p;  	}  found:  	allocp = p + nw;  	assert(allocp <= alloct);  	if(q > allocp) {  		allocx = allocp->ptr;  		allocp->ptr = p->ptr;  	}  	p->ptr = setbusy(allocp);  (	/* move last block ptr, if necessary */ ( '	if (allocend == p)  allocend = allocp; ' 	return((char*)(p+1));  }     5/*      freeing strategy tuned for LIFO allocation */ 5    void  free(ap)    @  register char *ap;  {  4    extern char *bufrsio;	/* start of i/o buffers */ 4 0    register union store *p = (union store *)ap; 0    1    if (ap < bufrsio)		/* see where pointer is */ 1 +    	return;			/* not valid, just return */ + 8    assert(p > clearbusy(allocs[1].ptr) && p <= alloct); 8     assert(allock());      allocp = --p;      assert(testbusy(p->ptr));  +    /* if just freed last block in arena */ +     p->ptr = clearbusy(p->ptr);  (    if (p->ptr == alloct)  allocend = p; ( 0    assert(p->ptr > allocp && p->ptr <= alloct); 0     assert(allocend <= alloct);  }     /*  @ *	realloc(p, nbytes) reallocates a block obtained from malloc() @ ( *	and freed since last call of malloc() (                                            @  + *	to have new size nbytes, and old content + ( *	returns new location, or 0 on failure (  */     char *  realloc(p, nbytes)  char	*p;  int nbytes;  {  	register char *q;  	register union store *ap, *aq;  	register int nw;  		int onw; 	    	ap = (union store *)p;  	if(testbusy(ap[-1].ptr))  
		free(p); 
 	onw = ap[-1].ptr - ap;  	q = malloc(nbytes);  	if(q == NULL || q == p)  		return(q);  	nw = (nbytes+WORD-1)/WORD;  
	if(nw < onw) 
 		onw = nw;  /	aq = (union store *) memcpy(q, p, onw * WORD); / 	if(aq < ap && aq+nw >= ap)   		(aq+(aq+nw-ap))->ptr = allocx;   	return(q);  }     #ifdef debug  allock()  {  #ifdef longdebug  	register union store *p;  	int x;  	x = 0;                           p@  A	for(p= &allocs[0]; clearbusy(p->ptr) > p; p=clearbusy(p->ptr)) { A 		if(p == allocp)  			x++;  	}  	assert(p == alloct);  	return(x == 1 || p == allocp);  #else  	return(1);  #endif  }  #endif     /*	For debugging purposes only  /*rstalloc()  /*{  /*	  /*	allocs[0].ptr = 0;  !/*	brk(clearbusy(allocs[1].ptr)); ! /*}  */                                                                                                                                                                                                                                                                                                                                                                                                                 