  @  
/*~!ldexp.c*/ 
 )/* Name:  ldexp.c Part No.: _______-____r )  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ident	"@(#)nbclib:ldexp.c	1.1"     /*         @   *	double ldexp (value, exp)   *		double value;   *		int exp;   *  < *	Ldexp returns value * 2**exp, if that result is in range. < = *	If underflow occurs, it returns zero.  If overflow occurs, = = *	it returns a value of appropriate sign and largest single- = : *	precision magnitude.  In case of underflow or overflow, : A *	the external int "errno" is set to ERANGE.  Note that errno is A ? *	not modified if no error occurs, so if you intend to test it ? : *	after you use ldexp, you had better set it to something : ? *	other than ERANGE first (zero is a reasonable value to use). ?  */     #include <values.h>  #include <errno.h>  (/* Largest signed long int power of 2 */ ( 1#define MAXSHIFT	(BITSPERBYTE * sizeof(long) - 2) 1            @  extern double frexp();     double  ldexp(value, exp)  register double value;  register int exp;  {  
	int old_exp; 
    ;	if (exp == 0 || value == 0.0) /* nothing to do for zero */ ; 		return (value);  	(void) frexp(value, &old_exp);  	if (exp > 0) {  /		if (exp + old_exp > MAXBEXP) { /* overflow */ / 			errno = ERANGE;  -			return (value < 0 ? -MAXFLOAT : MAXFLOAT); - 		}  *		for ( ; exp > MAXSHIFT; exp -= MAXSHIFT) * 			value *= (1L << MAXSHIFT);  		return (value * (1L << exp));  	}  /	if (exp + old_exp < MINBEXP) { /* underflow */ / 		errno = ERANGE;  		return (0.0);  	}  *	for ( ; exp < -MAXSHIFT; exp += MAXSHIFT) * ;		value *= 1.0/(1L << MAXSHIFT); /* mult faster than div */ ;                                    0@  	return (value / (1L << -exp));  }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 